/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.extension;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.config.ui.DefaultPosGiftCardConfigurationView;
import com.floreantpos.extension.GiftCardPaymentPlugin;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.ui.views.payment.GiftCardProcessor;
import com.floreantpos.ui.views.payment.PosGiftCardProcessor;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import java.awt.Component;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;

@PluginImplementation
public class PosGiftCardPlugin
extends GiftCardPaymentPlugin {
    public static final String ID = String.valueOf("OroGiftCard".hashCode());
    protected DefaultPosGiftCardConfigurationView giftCardView;

    @Override
    public boolean requireLicense() {
        return false;
    }

    @Override
    public boolean isActivated() {
        return true;
    }

    @Override
    public String getProductName() {
        return "OroGiftCard";
    }

    @Override
    public String getName() {
        return this.getProductName();
    }

    @Override
    public ConfigurationView getConfigurationPane() throws Exception {
        if (this.giftCardView == null) {
            this.giftCardView = new DefaultPosGiftCardConfigurationView();
            this.giftCardView.setMerchantDefaultValue("admin", "123456");
            this.giftCardView.initialize();
        }
        return this.giftCardView;
    }

    public String toString() {
        return this.getProductName();
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public GiftCardProcessor getProcessor() {
        return new PosGiftCardProcessor();
    }

    @Override
    public boolean shouldShowCardInputProcessor() {
        return true;
    }

    @Override
    public boolean hasValidLicense() {
        return true;
    }

    @Override
    public String getProductVersion() {
        return "1.0";
    }

    @Override
    public void pay(Ticket ticket, double d, SettleTicketProcessor settleTicketProcessor) throws Exception {
    }

    @Override
    public void voidPayment(PosTransaction posTransaction, Session session) {
        String string = posTransaction.getGiftCertNumber();
        if (StringUtils.isEmpty((String)string)) {
            throw new PosException(Messages.getString("PosGiftCardPlugin.1"));
        }
        GiftCard giftCard = GiftCardDAO.getInstance().get(string);
        giftCard.setBalance(giftCard.getBalance() + posTransaction.getAmount());
        GiftCardDAO.getInstance().saveOrUpdate(giftCard, session);
    }

    @Override
    public Component getParent() {
        return null;
    }
}

