/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.DuplicateDataException;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao._RootDAO;
import com.floreantpos.model.util.DateUtil;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.PropertyExpression;
import org.hibernate.criterion.Restrictions;

public class GenericDAO
extends _RootDAO {
    private static final GenericDAO instance = new GenericDAO();

    public static GenericDAO getInstance() {
        return instance;
    }

    @Override
    protected Class getReferenceClass() {
        return null;
    }

    @Override
    public Serializable save(Object object) {
        return super.save(object);
    }

    @Override
    public void saveOrUpdate(Object object) {
        super.saveOrUpdate(object);
    }

    @Override
    public Serializable save(Object object, Session session) {
        return super.save(object, session);
    }

    @Override
    public void saveOrUpdate(Object object, Session session) {
        super.saveOrUpdate(object, session);
    }

    @Override
    public Session getSession(String string, boolean bl) {
        return super.getSession(string, bl);
    }

    public List findAll(Class clazz, Session session) {
        Criteria criteria = session.createCriteria(clazz);
        return criteria.list();
    }

    public void saveAll(List list, Session session) {
        Transaction transaction = session.beginTransaction();
        for (Object e : list) {
            session.saveOrUpdate(e);
        }
        transaction.commit();
    }

    @Override
    public void closeSession(Session session) {
        try {
            super.closeSession(session);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List findAllUnSyncItem(Class clazz) {
        return this.findAllUnSyncItem(clazz, false, null);
    }

    public List findAllUnSyncItem(Class<?> clazz, boolean bl, Date date) {
        List list = this.getAllUnSyncItems(clazz, bl, date);
        if (list == null || list.size() == 0) {
            return list;
        }
        if (!(list.get(0) instanceof TimedModel)) {
            return list;
        }
        for (TimedModel timedModel : list) {
            timedModel.setLastUpdateTime(date);
        }
        return list;
    }

    private List getAllUnSyncItems(Class<?> clazz, boolean bl, Date date) {
        try (Session session = this.createNewSession();){
            Criterion criterion;
            Object object;
            Criteria criteria = session.createCriteria(clazz);
            if (!bl) {
                object = Restrictions.isNull((String)InventoryStock.PROP_LAST_UPDATE_TIME);
                criterion = Restrictions.isNull((String)InventoryStock.PROP_LAST_SYNC_TIME);
                PropertyExpression propertyExpression = Restrictions.gtProperty((String)InventoryStock.PROP_LAST_UPDATE_TIME, (String)InventoryStock.PROP_LAST_SYNC_TIME);
                criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{object, criterion, propertyExpression}));
            }
            if (bl && date != null) {
                object = Restrictions.isNull((String)InventoryStock.PROP_LAST_SYNC_TIME);
                criterion = Restrictions.lt((String)InventoryStock.PROP_LAST_SYNC_TIME, (Object)date);
                criteria.add((Criterion)Restrictions.or((Criterion)object, (Criterion)criterion));
            }
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            object = criteria.list();
            return object;
        }
    }

    public void updateItemsLastSyncTime(List<String> list, String string) {
        this.updateItemsLastSyncTime(null, list, string);
    }

    public void updateItemsLastSyncTime(Date date, List<String> list, String string) {
        String string2;
        if (list == null || list.isEmpty()) {
            return;
        }
        if (date == null) {
            date = new Date();
        }
        String string3 = "(";
        Transaction transaction = list.iterator();
        while (transaction.hasNext()) {
            string2 = transaction.next();
            string3 = string3 + "'" + string2 + "'";
            if (!transaction.hasNext()) continue;
            string3 = string3 + ",";
        }
        string3 = string3 + ")";
        transaction = null;
        try {
            string2 = this.createNewSession();
            Throwable throwable = null;
            try {
                transaction = string2.beginTransaction();
                String string4 = "update " + string + " set %s=:lastUpdateTime, %s=:lastSyncTime where %s in %s";
                string4 = String.format(string4, InventoryStock.PROP_LAST_UPDATE_TIME, InventoryStock.PROP_LAST_SYNC_TIME, InventoryStock.PROP_ID, string3);
                Query query = string2.createQuery(string4);
                query.setParameter("lastUpdateTime", (Object)date);
                query.setParameter("lastSyncTime", (Object)date);
                query.executeUpdate();
                transaction.commit();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (string2 != null) {
                    if (throwable != null) {
                        try {
                            string2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        string2.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
    }

    public void updateItemsLastSyncTimeByInt(Date date, List<Integer> list, String string) {
        if (list == null || list.isEmpty()) {
            return;
        }
        if (date == null) {
            date = new Date();
        }
        String string2 = "(";
        Transaction transaction = list.iterator();
        while (transaction.hasNext()) {
            int n = transaction.next();
            string2 = string2 + n;
            if (!transaction.hasNext()) continue;
            string2 = string2 + ",";
        }
        string2 = string2 + ")";
        transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            String string3 = "update " + string + " set %s=:lastUpdateTime, %s=:lastSyncTime where %s in" + string2;
            string3 = String.format(string3, InventoryStock.PROP_LAST_UPDATE_TIME, InventoryStock.PROP_LAST_SYNC_TIME, InventoryStock.PROP_ID);
            Query query = session.createQuery(string3);
            query.setParameter("lastUpdateTime", (Object)date);
            query.setParameter("lastSyncTime", (Object)date);
            query.executeUpdate();
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
    }

    public void updateLastUpdateTimeIfNull(String string) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(14, calendar.get(14));
        this.updateLastUpdateTimeIfNull(string, calendar.getTime());
    }

    public void updateLastUpdateTimeIfNull(String string, Date date) {
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            String string2 = "update " + string + " set %s=:lastUpdateTime where %s is null";
            string2 = String.format(string2, Terminal.PROP_LAST_UPDATE_TIME, Terminal.PROP_LAST_UPDATE_TIME);
            Query query = session.createQuery(string2);
            query.setParameter("lastUpdateTime", (Object)date);
            query.executeUpdate();
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            PosLog.error(this.getClass(), Messages.getString("GenericDAO.19"));
        }
    }

    public void checkIdOrNameExists(String string, String string2, Class clazz) {
        try (Session session = this.createNewSession();){
            this.checkIdOrNameExists(string, string2, clazz, session);
        }
    }

    public void checkIdOrNameExists(String string, String string2, Class clazz, Session session) {
        if (StringUtils.isBlank((String)string2)) {
            throw new PosException(POSConstants.NAME_IS_EMPTY);
        }
        this.checkDifferentObjectExists(string, string2, clazz, "name", session);
    }

    public void checkDifferentObjectExists(String string, String string2, Class clazz, String string3) {
        try (Session session = this.createNewSession();){
            this.checkDifferentObjectExists(string, string2, clazz, string3, session);
        }
    }

    public void checkDifferentObjectExists(String string, String string2, Class clazz, String string3, Session session) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.setProjection(Projections.rowCount());
        criteria.add((Criterion)Restrictions.eq((String)string3, (Object)string2).ignoreCase());
        if (StringUtils.isNotEmpty((String)string)) {
            criteria.add((Criterion)Restrictions.ne((String)"id", (Object)string));
        }
        this.addDeletedFilter(criteria);
        Number number = (Number)criteria.uniqueResult();
        if (number != null && number.intValue() > 0) {
            throw new DuplicateDataException(String.format(Messages.getString("GenericDAO.20") + " %s " + Messages.getString("GenericDAO.22"), string2));
        }
    }

    public Object findObjectByFieldValue(String string, Class clazz, String string2, String ... stringArray) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(clazz);
            Disjunction disjunction = Restrictions.disjunction();
            for (String string3 : stringArray) {
                disjunction.add((Criterion)Restrictions.eq((String)string3, (Object)string).ignoreCase());
            }
            criteria.add((Criterion)disjunction);
            if (StringUtils.isNotEmpty((String)string2)) {
                criteria.add((Criterion)Restrictions.ne((String)"id", (Object)string2));
            }
            criteria.setMaxResults(1);
            this.addDeletedFilter(criteria);
            Object object = criteria.uniqueResult();
            return object;
        }
    }

    public void updateLastUpdateTimeProperty(Class clazz, Date date) {
        Store store = StoreDAO.getRestaurant();
        this.updateLastUpdateTimeProperty(store, clazz, date);
        StoreDAO.getInstance().saveOrUpdate(store);
    }

    public void updateLastUpdateTimeProperty(Store store, Class clazz, Date date) {
        this.updateLastUpdateTimeProperty(store, clazz.getSimpleName(), date);
    }

    public void updateLastUpdateTimeProperty(Store store, String string, Date date) {
        store.addProperty(string + "." + Store.PROP_LAST_UPDATE_TIME, DateUtil.formatDateWithDefaultTimeAndSec(date));
    }

    public List<String> getForeignDataListNames(Session session, Class<?> clazz, String string, String string2) {
        return this.getForeignDataList(session, clazz, string, string2, "name");
    }

    public List getForeignDataList(Session session, Class<?> clazz, String string, String string2, String string3) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.setProjection((Projection)Projections.property((String)string3));
        criteria.add((Criterion)Restrictions.eq((String)string, (Object)string2));
        this.addDeletedFilter(criteria, clazz);
        return criteria.list();
    }

    public List<String> getForeignDataListNames(Session session, Class<?> clazz, String string, String string2, String string3) {
        return this.getForeignDataList(session, clazz, string, string2, string3, "name");
    }

    public List getForeignDataList(Session session, Class<?> clazz, String string, String string2, String string3, String string4) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.createAlias(string, "c");
        criteria.setProjection((Projection)Projections.property((String)string4));
        criteria.add((Criterion)Restrictions.eq((String)("c." + string2), (Object)string3));
        this.addDeletedFilter(criteria, clazz);
        return criteria.list();
    }
}

