/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.PizzaCrust;
import com.floreantpos.model.dao.BasePizzaCrustDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.PizzaPriceDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class PizzaCrustDAO
extends BasePizzaCrustDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Override
    public List<PizzaCrust> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    @Override
    protected void delete(Object object, Session session) {
        PizzaCrust pizzaCrust;
        if (object instanceof PizzaCrust) {
            pizzaCrust = (PizzaCrust)object;
            session.refresh((Object)pizzaCrust);
            List<String> list = PizzaPriceDAO.getInstance().findByPizzaCrust(pizzaCrust, session);
            if (list != null && !list.isEmpty()) {
                MenuItemDAO.getInstance().removePizzaPrices(list, session);
            }
        } else {
            throw new PosException(Messages.getString("PizzaCrustDAO.0"));
        }
        pizzaCrust.setDeleted(Boolean.TRUE);
        super.update(pizzaCrust, session);
    }

    @Override
    public Order getDefaultOrder() {
        return Order.asc((String)PizzaCrust.PROP_SORT_ORDER);
    }

    public void saveOrUpdateList(List<PizzaCrust> list) {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.saveOrUpdateCrustList(list, session);
            transaction.commit();
        }
    }

    public void saveOrUpdateCrustList(List<PizzaCrust> list, Session session) {
        for (PizzaCrust pizzaCrust : list) {
            session.saveOrUpdate((Object)pizzaCrust);
        }
    }

    public void saveOrUpdatePizzaCrustList(List<PizzaCrust> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (PizzaCrust pizzaCrust : list) {
                PizzaCrust pizzaCrust2 = this.get(pizzaCrust.getId());
                if (pizzaCrust2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(pizzaCrust.getLastUpdateTime(), pizzaCrust2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), pizzaCrust.getName() + " already updated");
                        continue;
                    }
                    long l = pizzaCrust2.getVersion();
                    PropertyUtils.copyProperties((Object)pizzaCrust2, (Object)pizzaCrust);
                    pizzaCrust2.setVersion(l);
                    pizzaCrust2.setUpdateLastUpdateTime(bl);
                    pizzaCrust2.setUpdateSyncTime(bl2);
                    this.update(pizzaCrust2, session);
                    continue;
                }
                pizzaCrust.setUpdateLastUpdateTime(bl);
                pizzaCrust.setUpdateSyncTime(bl2);
                this.save(pizzaCrust, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nameExists(String string, String string2) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            if (StringUtils.isNotEmpty((String)string2)) {
                criteria.add((Criterion)Restrictions.ne((String)PizzaCrust.PROP_ID, (Object)string2));
            }
            criteria.add((Criterion)Restrictions.eq((String)PizzaCrust.PROP_NAME, (Object)string).ignoreCase());
            this.addDeletedFilter(criteria);
            Number number = (Number)criteria.uniqueResult();
            boolean bl = number != null && number.intValue() > 0;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }
}

