/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.main.Application;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.base.BaseMenuCategory;
import com.floreantpos.model.base.BaseShift;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao._RootDAO;
import com.floreantpos.report.SalesStatistics;
import com.floreantpos.report.ShiftwiseSalesSummaryReportModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class SalesSummaryDAO
extends _RootDAO {
    @Override
    protected Class getReferenceClass() {
        return null;
    }

    @Override
    public Serializable save(Object object) {
        return super.save(object);
    }

    @Override
    public void saveOrUpdate(Object object) {
        super.saveOrUpdate(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData> findSalesAnalysis(Date date, Date date2, UserType userType, Terminal terminal) {
        Session session = null;
        try {
            Object object;
            Object[] objectArray;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            session = this.getSession();
            Criteria criteria = session.createCriteria(Shift.class);
            List list = criteria.list();
            criteria = session.createCriteria(MenuCategory.class);
            List list2 = criteria.list();
            MenuCategory menuCategory = new MenuCategory();
            menuCategory.setName(Messages.getString("SalesSummaryDAO.3"));
            list2.add(menuCategory);
            for (Comparable comparable : list) {
                for (Object object2 : list2) {
                    criteria = session.createCriteria(TicketItem.class, "item");
                    criteria.createCriteria("ticket", "t");
                    objectArray = Projections.projectionList();
                    objectArray.add((Projection)Projections.sum((String)TicketItem.PROP_QUANTITY));
                    objectArray.add((Projection)Projections.sum((String)TicketItem.PROP_SUBTOTAL_AMOUNT));
                    objectArray.add((Projection)Projections.sum((String)TicketItem.PROP_DISCOUNT_AMOUNT));
                    objectArray.add((Projection)Projections.sum((String)TicketItem.PROP_TAX_AMOUNT));
                    objectArray.add((Projection)Projections.sum((String)TicketItem.PROP_TOTAL_AMOUNT));
                    criteria.setProjection((Projection)objectArray);
                    this.doHandleMenuCategorySearch(criteria, (MenuCategory)object2);
                    criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_SHIFT_ID), (Object)((BaseShift)comparable).getId()));
                    criteria.add((Criterion)Restrictions.ge((String)("t." + Ticket.PROP_ACTIVE_DATE), (Object)date));
                    criteria.add((Criterion)Restrictions.le((String)("t." + Ticket.PROP_ACTIVE_DATE), (Object)date2));
                    if (userType != null) {
                        criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_OWNER_TYPE_ID), (Object)userType.getId()));
                    }
                    if (terminal != null) {
                        criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_TERMINAL_ID), (Object)terminal.getId()));
                    }
                    if ((object = criteria.list()).size() <= 0) continue;
                    Object[] objectArray2 = (Object[])object.get(0);
                    ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData shiftwiseSalesSummaryData = new ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData();
                    shiftwiseSalesSummaryData.setShiftName(((BaseShift)comparable).getName());
                    shiftwiseSalesSummaryData.setCategoryName(((BaseMenuCategory)object2).getName());
                    if (objectArray2.length > 0 && objectArray2[0] != null) {
                        shiftwiseSalesSummaryData.setCount(((Number)objectArray2[0]).intValue());
                    }
                    if (objectArray2.length > 1 && objectArray2[1] != null) {
                        shiftwiseSalesSummaryData.setGross(((Number)objectArray2[1]).doubleValue());
                    }
                    if (objectArray2.length > 2 && objectArray2[2] != null) {
                        shiftwiseSalesSummaryData.setDiscount(((Number)objectArray2[2]).doubleValue());
                    }
                    if (objectArray2.length > 3 && objectArray2[3] != null) {
                        shiftwiseSalesSummaryData.setTaxAmount(((Number)objectArray2[3]).doubleValue());
                    }
                    if (objectArray2.length > 4 && objectArray2[4] != null) {
                        shiftwiseSalesSummaryData.setNetSales(((Number)objectArray2[4]).doubleValue());
                    }
                    arrayList.add(shiftwiseSalesSummaryData);
                }
            }
            for (Comparable comparable : list2) {
                Object object2;
                criteria = session.createCriteria(TicketItem.class, "item");
                criteria.createCriteria("ticket", "t");
                ProjectionList projectionList = Projections.projectionList();
                projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_QUANTITY));
                projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_SUBTOTAL_AMOUNT));
                projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_DISCOUNT_AMOUNT));
                projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_TAX_AMOUNT));
                projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_TOTAL_AMOUNT));
                criteria.setProjection((Projection)projectionList);
                this.doHandleMenuCategorySearch(criteria, (MenuCategory)comparable);
                criteria.add((Criterion)Restrictions.ge((String)("t." + Ticket.PROP_ACTIVE_DATE), (Object)date));
                criteria.add((Criterion)Restrictions.le((String)("t." + Ticket.PROP_ACTIVE_DATE), (Object)date2));
                if (userType != null) {
                    criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_OWNER_TYPE_ID), (Object)userType.getId()));
                }
                if (terminal != null) {
                    criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_TERMINAL_ID), (Object)terminal.getId()));
                }
                if ((object2 = criteria.list()).size() <= 0) continue;
                objectArray = (Object[])object2.get(0);
                object = new ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData();
                ((ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData)object).setShiftName("ALL DAY");
                ((ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData)object).setCategoryName(((BaseMenuCategory)comparable).getName());
                if (objectArray.length > 0 && objectArray[0] != null) {
                    ((ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData)object).setCount(((Number)objectArray[0]).intValue());
                }
                if (objectArray.length > 1 && objectArray[1] != null) {
                    ((ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData)object).setGross(((Number)objectArray[1]).doubleValue());
                }
                if (objectArray.length > 2 && objectArray[2] != null) {
                    ((ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData)object).setDiscount(((Number)objectArray[2]).doubleValue());
                }
                if (objectArray.length > 3 && objectArray[3] != null) {
                    ((ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData)object).setTaxAmount(((Number)objectArray[3]).doubleValue());
                }
                if (objectArray.length > 4 && objectArray[4] != null) {
                    ((ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData)object).setNetSales(((Number)objectArray[4]).doubleValue());
                }
                arrayList.add(object);
            }
            ArrayList<Object> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    private void doHandleMenuCategorySearch(Criteria criteria, MenuCategory menuCategory) {
        if (menuCategory.getId() == null) {
            if (menuCategory.getName() != null && menuCategory.getName().equals(Messages.getString("SalesSummaryDAO.3"))) {
                criteria.add(Restrictions.isNull((String)("item." + TicketItem.PROP_CATEGORY_ID)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)("item." + TicketItem.PROP_CATEGORY_NAME), (Object)menuCategory.getName()));
            }
        } else {
            criteria.add((Criterion)Restrictions.eq((String)("item." + TicketItem.PROP_CATEGORY_ID), (Object)menuCategory.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SalesStatistics findKeyStatistics(Date date, Date date2, UserType userType, Terminal terminal) {
        Session session = null;
        try {
            Object object;
            List list;
            SalesStatistics salesStatistics = new SalesStatistics();
            session = this.createNewSession();
            Store store = (Store)this.get(Store.class, (Serializable)((Object)"1"), session);
            if (store != null) {
                salesStatistics.setCapacity(store.getCapacity() != null ? store.getCapacity() : 0);
                salesStatistics.setTables(store.getTables() != null ? store.getTables() : 0);
            }
            Object object2 = session.createCriteria(Ticket.class, "ticket");
            Object object3 = Projections.projectionList();
            object3.add(Projections.rowCount());
            object3.add((Projection)Projections.sum((String)Ticket.PROP_SUBTOTAL_AMOUNT));
            object3.add((Projection)Projections.sum((String)Ticket.PROP_DISCOUNT_AMOUNT));
            object3.add((Projection)Projections.sum((String)Ticket.PROP_TAX_AMOUNT));
            object2.setProjection((Projection)object3);
            object2.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
            object2.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
            object2.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
            object2.add((Criterion)Restrictions.eq((String)Ticket.PROP_REFUNDED, (Object)Boolean.FALSE));
            if (userType != null) {
                object2.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_TYPE_ID, (Object)userType.getId()));
            }
            if (terminal != null) {
                object2.add((Criterion)Restrictions.eq((String)Ticket.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            if ((list = object2.list()).size() > 0) {
                object = (Object[])list.get(0);
                if (((Object[])object).length > 1 && object[1] != null) {
                    salesStatistics.setGrossSale(((Number)object[1]).doubleValue());
                }
                if (((Object[])object).length > 2 && object[2] != null) {
                    salesStatistics.setDiscount(((Number)object[2]).intValue());
                }
                if (((Object[])object).length > 3 && object[3] != null) {
                    salesStatistics.setTax(((Number)object[3]).intValue());
                }
            }
            object2 = session.createCriteria(Ticket.class, "ticket");
            object3 = Projections.projectionList();
            object3.add(Projections.rowCount());
            object3.add((Projection)Projections.sum((String)Ticket.PROP_NUMBER_OF_GUESTS));
            object2.setProjection((Projection)object3);
            object2.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
            object2.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
            if (userType != null) {
                object2.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_TYPE_ID, (Object)userType.getId()));
            }
            if (terminal != null) {
                object2.add((Criterion)Restrictions.eq((String)Ticket.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            if ((list = object2.list()).size() > 0) {
                object = (Object[])list.get(0);
                salesStatistics.setCheckCount(((Number)object[0]).intValue());
                if (((Object[])object).length > 1 && object[1] != null) {
                    salesStatistics.setGuestCount(((Number)object[1]).intValue());
                }
            }
            object2 = session.createCriteria(Ticket.class, "ticket");
            object3 = Projections.projectionList();
            object3.add(Projections.rowCount());
            object3.add((Projection)Projections.sum((String)Ticket.PROP_TOTAL_AMOUNT));
            object2.setProjection((Projection)object3);
            object2.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
            object2.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
            object2.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            if (userType != null) {
                object2.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_TYPE_ID, (Object)userType.getId()));
            }
            if (terminal != null) {
                object2.add((Criterion)Restrictions.eq((String)Ticket.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            if ((list = object2.list()).size() > 0) {
                object = (Object[])list.get(0);
                salesStatistics.setOpenChecks(((Number)object[0]).intValue());
                if (((Object[])object).length > 1 && object[1] != null) {
                    salesStatistics.setOpenAmount(((Number)object[1]).doubleValue());
                }
            }
            object2 = session.createCriteria(Ticket.class, "ticket");
            object3 = Projections.projectionList();
            object3.add(Projections.rowCount());
            object3.add((Projection)Projections.sum((String)Ticket.PROP_TOTAL_AMOUNT));
            object2.setProjection((Projection)object3);
            object2.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
            object2.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
            object2.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.TRUE));
            object2.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.TRUE));
            if (userType != null) {
                object2.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_TYPE_ID, (Object)userType.getId()));
            }
            if (terminal != null) {
                object2.add((Criterion)Restrictions.eq((String)Ticket.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            if ((list = object2.list()).size() > 0) {
                object = (Object[])list.get(0);
                salesStatistics.setVoidChecks(((Number)object[0]).intValue());
                if (((Object[])object).length > 1 && object[1] != null) {
                    salesStatistics.setVoidAmount(((Number)object[1]).doubleValue());
                }
            }
            object2 = session.createCriteria(Ticket.class, "ticket");
            object3 = Projections.projectionList();
            object3.add(Projections.rowCount());
            object3.add((Projection)Projections.sum((String)Ticket.PROP_TOTAL_AMOUNT));
            object2.setProjection((Projection)object3);
            object2.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
            object2.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
            object2.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
            object2.add((Criterion)Restrictions.eq((String)Ticket.PROP_REFUNDED, (Object)Boolean.FALSE));
            object2.add((Criterion)Restrictions.eq((String)Ticket.PROP_TAX_EXEMPT, (Object)Boolean.TRUE));
            if (userType != null) {
                object2.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_TYPE_ID, (Object)userType.getId()));
            }
            if (terminal != null) {
                object2.add((Criterion)Restrictions.eq((String)Ticket.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            if ((list = object2.list()).size() > 0) {
                object = (Object[])list.get(0);
                salesStatistics.setNtaxChecks(((Number)object[0]).intValue());
                if (((Object[])object).length > 1 && object[1] != null) {
                    salesStatistics.setNtaxAmount(((Number)object[1]).doubleValue());
                }
            }
            object2 = session.createCriteria(Ticket.class, "ticket");
            object3 = Projections.projectionList();
            object3.add(Projections.rowCount());
            object3.add((Projection)Projections.sum((String)Ticket.PROP_TOTAL_AMOUNT));
            object2.setProjection((Projection)object3);
            object2.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
            object2.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
            object2.add((Criterion)Restrictions.eq((String)Ticket.PROP_RE_OPENED, (Object)Boolean.TRUE));
            if (userType != null) {
                object2.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_TYPE_ID, (Object)userType.getId()));
            }
            if (terminal != null) {
                object2.add((Criterion)Restrictions.eq((String)Ticket.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            if ((list = object2.list()).size() > 0) {
                object = (Object[])list.get(0);
                salesStatistics.setRopnChecks(((Number)object[0]).intValue());
                if (((Object[])object).length > 1 && object[1] != null) {
                    salesStatistics.setRopnAmount(((Number)object[1]).doubleValue());
                }
            }
            object2 = session.createCriteria(AttendenceHistory.class, "history");
            object2.add((Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)date));
            object2.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)date2));
            if (userType != null) {
                object3 = UserDAO.getInstance().getIdListForType(userType, session);
                object2.add(object3 != null && object3.size() > 0 ? Restrictions.in((String)AttendenceHistory.PROP_USER_ID, (Collection)object3) : Restrictions.isNull((String)AttendenceHistory.PROP_USER_ID));
            }
            if (terminal != null) {
                object2.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            object3 = object2.list();
            double d = 0.0;
            double d2 = 0.0;
            Iterator<Object> iterator = object3.iterator();
            while (iterator.hasNext()) {
                Object object4 = iterator.next();
                AttendenceHistory attendenceHistory = (AttendenceHistory)object4;
                double d3 = 0.0;
                if (!attendenceHistory.isClockedOut().booleanValue() || attendenceHistory.getClockOutTime() == null) {
                    Shift shift = attendenceHistory.getShift();
                    d3 = Math.abs(date2.getTime() - attendenceHistory.getClockInTime().getTime());
                    d3 = shift != null && d3 > (double)shift.getShiftLength().longValue() ? (double)shift.getShiftLength().longValue() : 0.0;
                } else {
                    d3 = Math.abs(attendenceHistory.getClockOutTime().getTime() - attendenceHistory.getClockInTime().getTime());
                }
                double d4 = d3 * (2.77777778 * Math.pow(10.0, -7.0));
                d += d4;
                User user = attendenceHistory.getUser();
                double d5 = 0.0;
                if (user != null) {
                    d5 = user.getCostPerHour() == null ? 0.0 : user.getCostPerHour();
                }
                d2 += d4 * d5;
            }
            salesStatistics.setLaborHour(d);
            salesStatistics.setLaborCost(d2);
            object2 = session.createCriteria(Shift.class);
            object3 = object2.list();
            Iterator iterator2 = object3.iterator();
            while (iterator2.hasNext()) {
                object = iterator2.next();
                Shift shift = (Shift)object;
                List<OrderType> list2 = Application.getInstance().getOrderTypes();
                for (OrderType orderType : list2) {
                    this.findRecordByProfitCenter(date, date2, userType, terminal, session, salesStatistics, shift, orderType);
                }
            }
            salesStatistics.calculateOthers();
            object2 = salesStatistics;
            return object2;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    private void findRecordByProfitCenter(Date date, Date date2, UserType userType, Terminal terminal, Session session, SalesStatistics salesStatistics, Shift shift, OrderType orderType) {
        List list;
        Criteria criteria = session.createCriteria(Ticket.class, "ticket");
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add(Projections.rowCount());
        projectionList.add((Projection)Projections.sum((String)Ticket.PROP_NUMBER_OF_GUESTS));
        projectionList.add((Projection)Projections.sum((String)Ticket.PROP_SUBTOTAL_AMOUNT));
        criteria.setProjection((Projection)projectionList);
        criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
        criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_SHIFT_ID, (Object)shift.getId()));
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ORDER_TYPE_ID, (Object)(orderType == null ? null : orderType.getId())));
        if (userType != null) {
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_TYPE_ID, (Object)userType.getId()));
        }
        if (terminal != null) {
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_TERMINAL_ID, (Object)terminal.getId()));
        }
        if ((list = criteria.list()).size() > 0) {
            SalesStatistics.ShiftwiseSalesTableData shiftwiseSalesTableData = new SalesStatistics.ShiftwiseSalesTableData();
            shiftwiseSalesTableData.setProfitCenter(orderType.toString());
            Object[] objectArray = (Object[])list.get(0);
            shiftwiseSalesTableData.setShiftName(shift.getName());
            shiftwiseSalesTableData.setCheckCount(((Number)objectArray[0]).intValue());
            if (objectArray.length > 1 && objectArray[1] != null) {
                shiftwiseSalesTableData.setGuestCount(((Number)objectArray[1]).intValue());
            }
            if (objectArray.length > 2 && objectArray[2] != null) {
                shiftwiseSalesTableData.setTotalSales(((Number)objectArray[2]).doubleValue());
            }
            shiftwiseSalesTableData.setPercentage(shiftwiseSalesTableData.getTotalSales() * 100.0 / salesStatistics.getGrossSale());
            shiftwiseSalesTableData.calculateOthers();
            salesStatistics.addSalesTableData(shiftwiseSalesTableData);
        }
    }
}

