/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.config.CardConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.Customer;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.DeletedData;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PackagingUnit;
import com.floreantpos.model.PaymentStatusFilter;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketType;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.base.BaseInventoryTransaction;
import com.floreantpos.model.base.BaseKitchenTicketItem;
import com.floreantpos.model.base.BaseStoreSession;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.BaseTicketDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.DeletedDataDAO;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.KitchenTicketDAO;
import com.floreantpos.model.dao.KitchenTicketItemDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.RecepieDAO;
import com.floreantpos.model.dao.SequenceNumberDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.ShopTableStatusDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.VoidItemDAO;
import com.floreantpos.model.ext.DeletedDataType;
import com.floreantpos.model.ext.InvMapKey;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.payment.PaymentPlugin;
import com.floreantpos.report.DeliverySummaryReportData;
import com.floreantpos.report.EndOfDayReportData;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.swing.PaginatedTableModel;
import com.floreantpos.swing.PaginationSupport;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.payment.CardProcessor;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.NumericGlobalIdGenerator;
import com.floreantpos.util.POSUtil;
import com.floreantpos.webservice.CloudDataUploader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.PropertyExpression;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.json.JSONArray;
import org.json.JSONObject;

public class TicketDAO
extends BaseTicketDAO {
    private static final TicketDAO instance = new TicketDAO();

    @Override
    public Order getDefaultOrder() {
        return Order.desc((String)Ticket.PROP_CREATE_DATE);
    }

    @Override
    protected Serializable save(Object object, Session session) {
        Ticket ticket = (Ticket)object;
        this.performPreSaveOperations(ticket);
        Serializable serializable = super.save(object, session);
        this.performPostSaveOperations(session, ticket);
        return serializable;
    }

    @Override
    protected void update(Object object, Session session) {
        Ticket ticket = (Ticket)object;
        this.performPreSaveOperations(ticket);
        super.update(object, session);
        this.performPostSaveOperations(session, ticket);
    }

    @Override
    public synchronized void saveOrUpdate(Ticket ticket) {
        this.performPreSaveOperations(ticket);
        boolean bl = ticket.getId() == null;
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            this.saveOrUpdate(ticket, session);
            transaction.commit();
            try {
                ActionHistoryDAO.getInstance().performActionHistorySaveOperation(ticket, bl);
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw exception;
        }
    }

    @Override
    public void saveOrUpdate(Ticket ticket, Session session) {
        this.updateTime(ticket);
        this.saveOrUpdate(ticket, session, true);
    }

    public void saveOrUpdate(Ticket ticket, Session session, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = StringUtils.isEmpty((String)ticket.getId()) ? true : this.isNewTicket(ticket.getId());
        if (bl2) {
            if (StringUtils.isEmpty((String)ticket.getId())) {
                ticket.setId(NumericGlobalIdGenerator.generateGlobalId());
            }
            if (StringUtils.isEmpty((String)ticket.getShortId())) {
                ticket.setShortId(RandomStringUtils.randomNumeric((int)7));
            }
            if (ticket.getTokenNo() == 0) {
                ticket.setTokenNo(SequenceNumberDAO.getInstance().getNextSequenceNumber("TICKET_TOKEN_NUMBER", session));
            }
        }
        ticket.setActiveDate(StoreDAO.getServerTimestamp());
        ticket.updateGratuityInfo();
        if (ticket.isPaid().booleanValue() && ticket.getDueAmount() > 0.0) {
            ticket.setPaid(false);
        }
        if (bl2) {
            this.save(ticket, session);
        } else {
            this.update(ticket, session);
        }
        if (bl) {
            this.updateShopTableStatus(ticket, session, bl2);
        }
    }

    @Override
    protected void delete(Object object, Session session) {
        super.delete(object, session);
        if (object instanceof Ticket) {
            Ticket ticket = (Ticket)object;
            DeletedData deletedData = new DeletedData();
            Date date = StoreDAO.getServerTimestamp();
            deletedData.setLastUpdateTime(date);
            deletedData.setDeleteDate(date);
            deletedData.setDataId(ticket.getId());
            deletedData.setDeletedDataType(DeletedDataType.TICKET);
            deletedData.setDeleteByUserId(Application.getCurrentUser().getId());
            DeletedDataDAO.getInstance().save(deletedData, session);
        }
    }

    public void saveOrUpdateTemporaryTicket(Ticket ticket) {
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            boolean bl;
            transaction = session.beginTransaction();
            ticket.setActiveDate(StoreDAO.getServerTimestamp());
            boolean bl2 = bl = StringUtils.isEmpty((String)ticket.getId()) ? true : this.isNewTicket(ticket.getId());
            if (bl) {
                if (StringUtils.isEmpty((String)ticket.getId())) {
                    ticket.setId(NumericGlobalIdGenerator.generateGlobalId());
                }
                if (StringUtils.isEmpty((String)ticket.getShortId())) {
                    ticket.setShortId(RandomStringUtils.randomNumeric((int)7));
                }
                if (ticket.getTokenNo() == 0) {
                    ticket.setTokenNo(SequenceNumberDAO.getInstance().getNextSequenceNumber("TICKET_TOKEN_NUMBER", session));
                }
                this.updateTime(ticket);
                session.save((Object)ticket);
            } else {
                this.updateTime(ticket);
                session.update((Object)ticket);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw exception;
        }
    }

    private void performPreSaveOperations(Ticket ticket) {
        Comparable<Calendar> comparable;
        if (ticket.getCreateDate() == null) {
            comparable = DateUtil.getServerTimeCalendar();
            ticket.setCreateDate(((Calendar)comparable).getTime());
            ticket.setCreationHour(((Calendar)comparable).get(11));
        }
        if (StringUtils.isEmpty((String)ticket.getStoreSessionId()) && (comparable = DataProvider.get().getStoreSession()) != null) {
            ticket.setStoreSessionId(((BaseStoreSession)comparable).getId());
        }
    }

    private void performPostSaveOperations(Session session, Ticket ticket) {
        this.updateStock(ticket, session);
        ticket.setShouldUpdateStock(false);
        ticket.clearDeletedItems();
    }

    public synchronized void saveOrUpdateSplitTickets(List<Ticket> list, List<Integer> list2) {
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            for (Ticket ticket : list) {
                this.saveOrUpdate(ticket, session, false);
            }
            ShopTableStatusDAO.getInstance().addTicketsToShopTableStatus(list2, list, session);
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNewTicket(String string) {
        Session session = null;
        try {
            session = this.createNewSession();
            boolean bl = this.isNewTicket(string, session);
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    private boolean isNewTicket(String string, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.setProjection(Projections.rowCount());
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ID, (Object)string));
        Number number = (Number)criteria.uniqueResult();
        return number == null || number.intValue() == 0;
    }

    private void clearVoidedItems(Ticket ticket) {
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            ticketItem.setVoidItem(null);
        }
    }

    public synchronized void saveKitchenPrintStatus(Ticket ticket, KitchenTicket kitchenTicket) throws Exception {
        Session session = null;
        Transaction transaction = null;
        try {
            String string;
            KitchenTicketItem kitchenTicketItem;
            session = this.createNewSession();
            transaction = session.beginTransaction();
            List<KitchenTicketItem> list = kitchenTicket.getTicketItems();
            BaseKitchenTicketItem baseKitchenTicketItem = null;
            Iterator<KitchenTicketItem> iterator = list.iterator();
            while (iterator.hasNext()) {
                kitchenTicketItem = iterator.next();
                if (kitchenTicketItem.isModifierItem().booleanValue() || kitchenTicketItem.isCookingInstruction().booleanValue()) {
                    if (baseKitchenTicketItem == null) continue;
                    string = baseKitchenTicketItem.getMenuItemName().concat("\n" + kitchenTicketItem.getMenuItemName());
                    baseKitchenTicketItem.setMenuItemName(string);
                    iterator.remove();
                    continue;
                }
                baseKitchenTicketItem = kitchenTicketItem;
            }
            iterator = list.iterator();
            while (iterator.hasNext()) {
                kitchenTicketItem = iterator.next();
                if (!kitchenTicketItem.isVoided().booleanValue()) continue;
                string = kitchenTicketItem.getVoidedItemId();
                KitchenTicketItemDAO.getInstance().markVoided(string, kitchenTicketItem.getQuantity(), session);
                iterator.remove();
            }
            if (list.size() > 0) {
                KitchenTicketDAO.getInstance().saveOrUpdate(kitchenTicket, session);
            }
            ticket.clearDeletedItems();
            if (ticket.getTokenNo() == 0) {
                ticket.setTokenNo(SequenceNumberDAO.getInstance().getNextSequenceNumber("TICKET_TOKEN_NUMBER", session));
            }
            this.saveOrUpdate(ticket, session);
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    private void updateShopTableStatus(Ticket ticket, Session session, boolean bl) {
        List<Integer> list = ticket.getTableNumbers();
        if (list == null || list.isEmpty()) {
            return;
        }
        if (ticket.isClosed().booleanValue()) {
            ShopTableStatusDAO.getInstance().removeTicketFromShopTableStatus(ticket, session);
        } else if (bl || ticket.isShouldUpdateTableStatus()) {
            ShopTableDAO.getInstance().occupyTables(ticket, session);
            ticket.setShouldUpdateTableStatus(false);
        }
    }

    public void voidTicket(Ticket ticket) throws Exception {
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            ticket.setShouldUpdateStock(true);
            ticket.setDiscounts(null);
            for (TicketItem comparable2 : ticket.getTicketItems()) {
                boolean iterator;
                if (comparable2.isTreatAsSeat().booleanValue()) continue;
                boolean bl = iterator = comparable2.getInventoryAdjustQty() >= comparable2.getQuantity();
                if (!comparable2.isVoided().booleanValue()) {
                    ticket.voidItem(comparable2, ticket.getVoidReason(), ticket.isWasted(), Math.abs(comparable2.getQuantity()));
                    if (iterator) continue;
                    comparable2.setInventoryAdjustQty(comparable2.getQuantity());
                    continue;
                }
                if (!comparable2.isReturned() || comparable2.isReturnedItemVoided()) continue;
                ticket.voidReturnedItem(comparable2, ticket.getVoidReason(), ticket.isWasted());
                if (iterator) continue;
                comparable2.setInventoryAdjustQty(comparable2.getQuantity());
            }
            ticket.calculatePrice();
            transaction = session.beginTransaction();
            List<KitchenTicket> list = KitchenTicketDAO.getInstance().findByParentId(ticket.getId());
            Date date = StoreDAO.getServerTimestamp();
            if (list != null) {
                Iterator string = list.iterator();
                while (string.hasNext()) {
                    KitchenTicket kitchenTicket = (KitchenTicket)string.next();
                    kitchenTicket.setCreateDate(date);
                    kitchenTicket.setVoided(true);
                    session.saveOrUpdate((Object)kitchenTicket);
                }
            }
            ticket.setVoided(true);
            ticket.setClosed(true);
            ticket.setClosingDate(StoreDAO.getServerTimestamp());
            TicketDAO.getInstance().saveOrUpdate(ticket, session);
            transaction.commit();
            String string = "Ticket is voided. Total: " + NumberUtil.formatNumber(ticket.getTotalAmountWithTips());
            ActionHistoryDAO.saveHistory(ticket, "Void check", string);
        }
        catch (Exception exception) {
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        finally {
            ticket.setShouldUpdateStock(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    private void populateVoidItems(Ticket ticket) {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        for (TicketItem object22 : ticket.getTicketItems()) {
            void var5_7;
            if (!object22.isVoided().booleanValue()) continue;
            Double d = (Double)hashMap.get(object22.getMenuItemId());
            if (d == null) {
                Double d2 = 0.0;
            }
            double d3 = 0.0;
            d3 = Math.abs(object22.getQuantity());
            if ((d3 += var5_7.doubleValue()) == 0.0) continue;
            hashMap.put(object22.getMenuItemId(), d3);
        }
        HashMap hashMap2 = new HashMap();
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            if (ticketItem.getId() == null || ticketItem.isVoided().booleanValue() || ticketItem.getVoidItem() != null || ticketItem.isTreatAsSeat().booleanValue()) continue;
            Double d = (Double)hashMap.get(ticketItem.getMenuItemId());
            double d4 = ticketItem.getQuantity();
            if (d != null && d > 0.0) {
                if (d >= d4) {
                    hashMap.put(ticketItem.getMenuItemId(), d - d4);
                    continue;
                }
                d4 -= d.doubleValue();
            }
            hashMap2.put(ticketItem, new VoidItem(ticket.getVoidReason(), ticket.isWasted(), d4));
        }
        Set set = hashMap2.keySet();
        for (TicketItem ticketItem : set) {
            if (ticketItem.isTreatAsSeat().booleanValue()) continue;
            VoidItem voidItem = (VoidItem)hashMap2.get(ticketItem);
            ticket.voidItem(ticketItem, voidItem.getVoidReason(), voidItem.isItemWasted(), voidItem.getQuantity());
        }
    }

    public void loadFullTicket(Ticket ticket) {
        if (ticket.getId() == null) {
            return;
        }
        if (Hibernate.isInitialized(ticket.getTicketItems()) && Hibernate.isInitialized(ticket.getTransactions())) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)ticket);
            Hibernate.initialize(ticket.getTicketItems());
            Hibernate.initialize(ticket.getTransactions());
        }
        finally {
            this.closeSession(session);
        }
    }

    public Ticket loadFullTicket(String string) {
        try (Session session = this.createNewSession();){
            Ticket ticket = (Ticket)session.get(this.getReferenceClass(), (Serializable)((Object)string));
            if (ticket == null) {
                Ticket ticket2 = null;
                return ticket2;
            }
            Hibernate.initialize(ticket.getTicketItems());
            Hibernate.initialize(ticket.getTransactions());
            Ticket ticket3 = ticket;
            return ticket3;
        }
    }

    public Ticket loadCouponsAndTransactions(String string) {
        try (Session session = this.createNewSession();){
            Ticket ticket = (Ticket)session.get(this.getReferenceClass(), (Serializable)((Object)string));
            if (ticket == null) {
                Ticket ticket2 = null;
                return ticket2;
            }
            Hibernate.initialize(ticket.getTransactions());
            Ticket ticket3 = ticket;
            return ticket3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findOpenTickets() {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            criteria.addOrder(this.getDefaultOrder());
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findOpenTickets(Integer n) {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_PAID, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)n));
            criteria.addOrder(this.getDefaultOrder());
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Ticket> findOpenTickets(Terminal terminal, UserType userType) {
        return this.findOpenTickets(terminal, userType, null, null, null);
    }

    public List<Ticket> findOpenTickets(Terminal terminal, UserType userType, String string, Date date, Date date2) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            if (date != null && date2 != null) {
                criteria.add(Restrictions.between((String)Ticket.PROP_CREATE_DATE, (Object)date, (Object)date2));
            }
            if (userType != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_TYPE_ID, (Object)userType.getId()));
            }
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            if (StringUtils.isNotBlank((String)string) && string != POSConstants.ALL) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ORDER_TYPE_ID, (Object)string));
            }
            criteria.addOrder(this.getDefaultOrder());
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int getNumTickets() {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            this.updateCriteriaFilters(criteria);
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                int n = number.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void loadTickets(PaginatedTableModel paginatedTableModel) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.updateCriteriaFilters(criteria);
            paginatedTableModel.setNumRows(this.rowCount(criteria));
            criteria.addOrder(this.getDefaultOrder());
            criteria.setFirstResult(paginatedTableModel.getCurrentRowIndex());
            criteria.setMaxResults(paginatedTableModel.getPageSize());
            paginatedTableModel.setRows(criteria.list());
        }
    }

    public void loadDeliveryTickets(PaginatedTableModel paginatedTableModel, String string, Date date, Date date2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        block23: {
            try (Session session = this.createNewSession();){
                List<String> list;
                Criteria criteria = session.createCriteria(this.getReferenceClass());
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
                if (StringUtils.isNotEmpty((String)string)) {
                    criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)string));
                }
                if (date != null && date2 != null) {
                    criteria.add(Restrictions.between((String)Ticket.PROP_DELIVERY_DATE, (Object)date, (Object)date2));
                }
                if (bl2) {
                    criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_WILL_PICKUP, (Object)Boolean.TRUE));
                }
                if (bl3) {
                    criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_WILL_PICKUP, (Object)Boolean.FALSE));
                }
                if (bl4) {
                    criteria.add(Restrictions.isNull((String)Ticket.PROP_ASSIGNED_DRIVER_ID));
                }
                if ((list = OrderTypeDAO.getInstance().getHomeDeliveryOrderTypeIds(session)) != null && !list.isEmpty()) {
                    criteria.add(Restrictions.in((String)Ticket.PROP_ORDER_TYPE_ID, list));
                    paginatedTableModel.setNumRows(this.rowCount(criteria));
                    criteria.setFirstResult(paginatedTableModel.getCurrentRowIndex());
                    criteria.setMaxResults(paginatedTableModel.getPageSize());
                    criteria.addOrder(this.getDefaultOrder());
                    List list2 = criteria.list();
                    if (bl) {
                        Iterator iterator = list2.iterator();
                        while (iterator.hasNext()) {
                            Ticket ticket = (Ticket)iterator.next();
                            if (ticket.isSourceOnline()) continue;
                            iterator.remove();
                        }
                    }
                    paginatedTableModel.setRows(list2);
                    break block23;
                }
                if (paginatedTableModel.getRows() != null) {
                    paginatedTableModel.getRows().clear();
                }
                paginatedTableModel.setNumRows(0);
                return;
            }
        }
    }

    public List<Ticket> findCustomerTickets(String string, PaginationSupport paginationSupport) {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)string));
            paginationSupport.setNumRows(this.rowCount(criteria));
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            criteria.addOrder(this.getDefaultOrder());
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findNextCustomerTickets(Integer n, PaginatedTableModel paginatedTableModel, String string) {
        List list;
        Session session = null;
        Criteria criteria = null;
        PaymentStatusFilter paymentStatusFilter = PaymentStatusFilter.fromString(string);
        try {
            int n2 = paginatedTableModel.getNextRowIndex();
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)n));
            if (paymentStatusFilter == PaymentStatusFilter.OPEN) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_PAID, (Object)Boolean.FALSE));
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            }
            criteria.setFirstResult(n2);
            criteria.setMaxResults(paginatedTableModel.getPageSize());
            List list2 = criteria.list();
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                paginatedTableModel.setNumRows(number.intValue());
            }
            paginatedTableModel.setCurrentRowIndex(n2);
            list = list2;
        }
        catch (Throwable throwable) {
            this.closeSession(session);
            throw throwable;
        }
        this.closeSession(session);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findPreviousCustomerTickets(Integer n, PaginatedTableModel paginatedTableModel, String string) {
        List list;
        Session session = null;
        Criteria criteria = null;
        PaymentStatusFilter paymentStatusFilter = PaymentStatusFilter.fromString(string);
        try {
            int n2 = paginatedTableModel.getPreviousRowIndex();
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)n));
            if (paymentStatusFilter == PaymentStatusFilter.OPEN) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_PAID, (Object)Boolean.FALSE));
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            }
            criteria.setFirstResult(n2);
            criteria.setMaxResults(paginatedTableModel.getPageSize());
            List list2 = criteria.list();
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                paginatedTableModel.setNumRows(number.intValue());
            }
            paginatedTableModel.setCurrentRowIndex(n2);
            list = list2;
        }
        catch (Throwable throwable) {
            this.closeSession(session);
            throw throwable;
        }
        this.closeSession(session);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findTicketByCustomer(Integer n) {
        Session session = null;
        Criteria criteria = null;
        try {
            List list;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)n));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Ticket> findTickets(PaymentStatusFilter paymentStatusFilter, OrderType orderType) {
        return this.findTicketsForUser(paymentStatusFilter, orderType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findTicketsForUser(PaymentStatusFilter paymentStatusFilter, OrderType orderType, User user) {
        Session session = null;
        try {
            Object object;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (paymentStatusFilter == PaymentStatusFilter.OPEN) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_PAID, (Object)Boolean.FALSE));
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            } else if (paymentStatusFilter == PaymentStatusFilter.PAID) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_PAID, (Object)Boolean.TRUE));
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            } else if (paymentStatusFilter == PaymentStatusFilter.CLOSED) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.TRUE));
                object = Calendar.getInstance();
                ((Calendar)object).add(11, -24);
                criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CLOSING_DATE, (Object)((Calendar)object).getTime()));
            }
            if (orderType != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ORDER_TYPE_ID, (Object)orderType.getId()));
            }
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
            }
            Object object2 = object = criteria.list();
            return object2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasOpenTickets(User user) {
        Session session = null;
        try {
            Number number;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
            }
            if ((number = (Number)criteria.uniqueResult()) != null) {
                boolean bl = number.intValue() > 0;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findOpenTicketsForUser(User user) {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)(user == null ? null : user.getId())));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findTicketsByOutletId(Date date, String string, boolean bl) {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OUTLET_ID, (Object)string));
            if (!bl) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            }
            criteria.add((Criterion)Restrictions.ne((String)Ticket.PROP_STATUS, (Object)"Pending"));
            if (date != null) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"lastUpdateTime"), (Criterion)Restrictions.gt((String)"lastUpdateTime", (Object)date)));
            }
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findClosedTicketsByOpenTicketIds(Date date, List<String> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        Session session = null;
        try {
            List list2;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.TRUE));
            criteria.add(Restrictions.in((String)Ticket.PROP_ID, list));
            if (date != null) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"lastUpdateTime"), (Criterion)Restrictions.gt((String)"lastUpdateTime", (Object)date)));
            }
            List list3 = list2 = criteria.list();
            return list3;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findOpenTickets(Date date, Date date2) {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findClosedTickets(Date date, Date date2) {
        Session session = null;
        try {
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.TRUE));
            if (date != null && date2 != null) {
                criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
                criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
            }
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void closeOrder(Ticket ticket) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.saveOrUpdate(ticket);
            User user = ticket.getAssignedDriver();
            if (user != null) {
                user.setAvailableForDelivery(true);
                UserDAO.getInstance().saveOrUpdate(user);
            }
            ShopTableDAO.getInstance().releaseTables(ticket);
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            LogFactory.getLog(TicketDAO.class).error((Object)exception);
            throw new RuntimeException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findTickets(Date date, Date date2, boolean bl, Terminal terminal) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_REFUNDED, (Object)Boolean.FALSE));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findTicketsForLaborHour(Date date, Date date2, int n, Terminal terminal) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_ACTIVE_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_ACTIVE_DATE, (Object)date2));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CREATION_HOUR, (Object)n));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findTicketsForShift(Date date, Date date2, Shift shift, Terminal terminal) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_SHIFT_ID, (Object)(shift == null ? null : shift.getId())));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_REFUNDED, (Object)Boolean.FALSE));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public static TicketDAO getInstance() {
        return instance;
    }

    private void updateCriteriaFilters(Criteria criteria) {
        User user = Application.getCurrentUser();
        PaymentStatusFilter paymentStatusFilter = TerminalConfig.getPaymentStatusFilter();
        String string = TerminalConfig.getOrderTypeFilter();
        boolean bl = TerminalConfig.isFilterByOwner();
        OrderType orderType = null;
        if (!POSConstants.ALL.equals(string)) {
            orderType = DataProvider.get().getOrderType(string);
        }
        if (paymentStatusFilter == PaymentStatusFilter.OPEN) {
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            if (!user.canViewAllOpenTickets() || bl) {
                criteria.add(Restrictions.in((String)Ticket.PROP_OWNER_ID, user.getRoleIds()));
            }
        } else if (paymentStatusFilter == PaymentStatusFilter.CLOSED) {
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.TRUE));
            if (!user.canViewAllCloseTickets() || bl) {
                criteria.add(Restrictions.in((String)Ticket.PROP_OWNER_ID, user.getRoleIds()));
            }
        }
        if (!string.equals(POSConstants.ALL) && orderType != null) {
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ORDER_TYPE_ID, (Object)orderType.getId()));
        }
    }

    public void deleteTickets(List<Ticket> list) {
        this.deleteTickets(list, false);
    }

    public void deleteTickets(List<Ticket> list, boolean bl) {
        this.deleteTickets(list, bl, false);
    }

    public void deleteTickets(List<Ticket> list, boolean bl, boolean bl2) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.deleteTickets(session, list, bl, bl2);
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            LogFactory.getLog(TicketDAO.class).error((Object)exception);
            throw new RuntimeException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void deleteTickets(Session session, List<Ticket> list, boolean bl) throws Exception {
        this.deleteTickets(session, list, bl, false);
    }

    public void deleteTickets(Session session, List<Ticket> list, boolean bl, boolean bl2) throws Exception {
        for (Ticket ticket : list) {
            if (!(ticket = (Ticket)session.merge((Object)ticket)).isClosed().booleanValue()) {
                ArrayList<TicketItem> arrayList = new ArrayList<TicketItem>();
                arrayList.addAll(ticket.getTicketItems());
                for (TicketItem ticketItem : arrayList) {
                    ticket.addDeletedItems(ticketItem);
                }
                if (bl2 && ticket.getPaidAmount() > 0.0) {
                    TicketDAO.getInstance().updateStock(ticket, session);
                }
            }
            super.delete(ticket, session);
            if (!bl) continue;
            ShopTableDAO.getInstance().freeTicketTables(ticket, session);
        }
    }

    protected void updateStock(Ticket ticket, Session session) {
        try {
            if (!this.shouldUpdateStock(ticket)) {
                return;
            }
            InventoryLocation inventoryLocation = null;
            InventoryLocation inventoryLocation2 = null;
            inventoryLocation = DataProvider.get().getDefaultOutLocation();
            HashMap<InvMapKey, Double> hashMap = this.buildItemMapForInventoryAdjustment(ticket);
            HashMap<InvMapKey, Double> hashMap2 = this.buildItemMapForVoidItems(ticket, session);
            HashMap<InvMapKey, Double> hashMap3 = this.buildItemMapForReturnedVoidItems(ticket, session);
            this.adjustInventory(ticket, hashMap, InventoryTransactionType.OUT, "TICKET SALES", inventoryLocation, session);
            if (hashMap2 != null && hashMap2.size() > 0) {
                inventoryLocation2 = DataProvider.get().getDefaultInLocation();
                this.adjustInventory(ticket, hashMap2, InventoryTransactionType.IN, "VOID", inventoryLocation2, session);
            }
            if (hashMap3 != null && hashMap3.size() > 0) {
                this.adjustInventory(ticket, hashMap3, InventoryTransactionType.OUT, "VOID", inventoryLocation, session);
            }
            this.clearVoidedItems(ticket);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), "Failed to update stock balance for ticket: " + ticket.getId(), exception);
        }
    }

    private void adjustInventory(Ticket ticket, HashMap<InvMapKey, Double> hashMap, InventoryTransactionType inventoryTransactionType, String string, InventoryLocation inventoryLocation, Session session) throws Exception {
        Store store = DataProvider.get().getStore();
        boolean bl = store.isUpdateOnHandBlncForSale();
        boolean bl2 = store.isUpdateAvlBlncForSale();
        for (InvMapKey invMapKey : hashMap.keySet()) {
            Comparable comparable;
            Double d = hashMap.get(invMapKey);
            MenuItem menuItem = MenuItemDAO.getInstance().getMenuItemWithFields(session, invMapKey.getMenuItemId(), MenuItem.PROP_NAME, MenuItem.PROP_PRICE, MenuItem.PROP_SKU, MenuItem.PROP_BARCODE, MenuItem.PROP_UNIT_ID, MenuItem.PROP_COST, MenuItem.PROP_AVERAGE_UNIT_PURCHASE_PRICE, MenuItem.PROP_AVG_COST, MenuItem.PROP_DEFAULT_RECIPE_ID, MenuItem.PROP_INVENTORY_ITEM);
            if (menuItem == null) continue;
            if (menuItem.isInventoryItem().booleanValue()) {
                comparable = new InventoryTransaction();
                ((BaseInventoryTransaction)comparable).setReason(string);
                ((BaseInventoryTransaction)comparable).setTransactionDate(new Date());
                ((BaseInventoryTransaction)comparable).setMenuItem(menuItem);
                ((BaseInventoryTransaction)comparable).setType(inventoryTransactionType.getType());
                ((BaseInventoryTransaction)comparable).setTicketId(ticket.getId());
                ((InventoryTransaction)comparable).setUser(ticket.getOwner());
                IUnit iUnit = DataProvider.get().getUnitByCode(invMapKey.getUnitCode());
                if (iUnit instanceof PackagingUnit) {
                    session.refresh((Object)menuItem);
                    if (!Hibernate.isInitialized(menuItem.getStockUnits())) {
                        Hibernate.initialize(menuItem.getStockUnits());
                    }
                }
                double d2 = menuItem.getBaseUnitQuantity(invMapKey.getUnitCode());
                ((BaseInventoryTransaction)comparable).setUnitPrice(menuItem.getPrice() * d2);
                ((BaseInventoryTransaction)comparable).setQuantity(d);
                ((BaseInventoryTransaction)comparable).setUnit(invMapKey.getUnitCode());
                ((BaseInventoryTransaction)comparable).setUnitCost(menuItem.getCost());
                if (inventoryTransactionType == InventoryTransactionType.IN) {
                    ((InventoryTransaction)comparable).setToInventoryLocation(inventoryLocation);
                } else {
                    ((InventoryTransaction)comparable).setFromInventoryLocation(inventoryLocation);
                }
                ((InventoryTransaction)comparable).calculateTotal();
                InventoryTransactionDAO.getInstance().adjustInventoryStock((InventoryTransaction)comparable, session, bl2, bl);
            }
            if (!StringUtils.isNotEmpty((String)menuItem.getDefaultRecipeId())) continue;
            comparable = RecepieDAO.getInstance().get(menuItem.getDefaultRecipeId(), session);
            RecepieDAO.getInstance().adjustRecipeItemsFromInventory(d, Arrays.asList(comparable), session);
        }
    }

    private HashMap<InvMapKey, Double> buildItemMapForInventoryAdjustment(Ticket ticket) {
        List<TicketItem> list = ticket.getTicketItems();
        HashMap<InvMapKey, Double> hashMap = new HashMap<InvMapKey, Double>();
        this.populateItemToMap(list, hashMap);
        return hashMap;
    }

    private void populateItemToMap(List<TicketItem> list, HashMap<InvMapKey, Double> hashMap) {
        for (TicketItem ticketItem : list) {
            if (ticketItem.getMenuItemId() == null || ticketItem.isVoided().booleanValue() || ticketItem.isInventoryAdjusted()) continue;
            InvMapKey invMapKey = new InvMapKey(ticketItem.getMenuItemId(), ticketItem.getUnitName());
            Double d = hashMap.get(invMapKey);
            if (d == null) {
                d = 0.0;
            }
            Double d2 = ticketItem.getQuantity();
            d2 = d2 - ticketItem.getInventoryAdjustQty();
            if ((d2 = Double.valueOf(d2 + d)) <= 0.0) continue;
            hashMap.put(invMapKey, d2);
            ticketItem.setInventoryAdjustQty(ticketItem.getQuantity());
            if (!ticketItem.isComboItem().booleanValue()) continue;
            this.populateItemToMap(ticketItem.getComboItems(), hashMap);
        }
    }

    private HashMap<InvMapKey, Double> buildItemMapForVoidItems(Ticket ticket, Session session) {
        List<TicketItem> list = ticket.getTicketItems();
        HashMap<InvMapKey, Double> hashMap = new HashMap<InvMapKey, Double>();
        this.populateVoidItemToMap(ticket, session, list, hashMap);
        return hashMap;
    }

    private void populateVoidItemToMap(Ticket ticket, Session session, List<TicketItem> list, HashMap<InvMapKey, Double> hashMap) {
        for (TicketItem ticketItem : list) {
            VoidItem voidItem = ticketItem.getVoidItem();
            String string = ticketItem.getMenuItemId();
            InvMapKey invMapKey = new InvMapKey(string, ticketItem.getUnitName());
            if (voidItem == null || !ticketItem.isVoided().booleanValue() || ticketItem.isReturnedItemVoided()) continue;
            Double d = hashMap.get(invMapKey);
            if (d == null) {
                d = 0.0;
            }
            double d2 = 0.0;
            d2 = voidItem.getQuantity();
            if ((d2 += d.doubleValue()) == 0.0) continue;
            if (!voidItem.isItemWasted().booleanValue() && !ticketItem.isInventoryAdjusted()) {
                hashMap.put(invMapKey, d2);
                ticketItem.setInventoryAdjustQty(ticketItem.getQuantity());
            }
            Boolean bl = ticketItem.isPrintedToKitchen();
            VoidItemDAO.getInstance().saveAndSentToKitchenIfNeeded(voidItem, bl, ticket, session);
            ticketItem.addProperty("voidId", voidItem.getId());
            List<VoidItem> list2 = voidItem.getVoidedModifiers();
            String string2 = "";
            if (list2 != null && list2.size() > 0) {
                Iterator<VoidItem> iterator = list2.iterator();
                while (iterator.hasNext()) {
                    VoidItem voidItem2 = iterator.next();
                    VoidItemDAO.getInstance().saveAndSentToKitchenIfNeeded(voidItem2, bl, ticket, session);
                    string2 = string2 + voidItem2.getId();
                    if (!iterator.hasNext()) continue;
                    string2 = string2 + ",";
                }
            }
            if (ticketItem.isReturned() && StringUtils.isNotBlank((String)string2)) {
                ticketItem.addProperty("modifierVoidIds", string2);
            }
            if (!ticketItem.isComboItem().booleanValue()) continue;
            this.populateVoidItemToMap(ticket, session, ticketItem.getComboItems(), hashMap);
        }
    }

    private HashMap<InvMapKey, Double> buildItemMapForReturnedVoidItems(Ticket ticket, Session session) {
        List<TicketItem> list = ticket.getTicketItems();
        HashMap<InvMapKey, Double> hashMap = new HashMap<InvMapKey, Double>();
        this.populateReturnedVoidItemToMap(ticket, session, list, hashMap);
        return hashMap;
    }

    private void populateReturnedVoidItemToMap(Ticket ticket, Session session, List<TicketItem> list, HashMap<InvMapKey, Double> hashMap) {
        for (TicketItem ticketItem : list) {
            String[] stringArray;
            String string;
            VoidItem voidItem;
            String string2;
            if (!ticketItem.isReturnedItemVoided() || StringUtils.isBlank((String)(string2 = ticketItem.getProperty("voidId"))) || (voidItem = VoidItemDAO.getInstance().get(string2)) == null) continue;
            String string3 = ticketItem.getMenuItemId();
            InvMapKey invMapKey = new InvMapKey(string3, ticketItem.getUnitName());
            Double d = hashMap.get(invMapKey);
            if (d == null) {
                d = 0.0;
            }
            double d2 = 0.0;
            d2 = Math.abs(voidItem.getQuantity());
            if ((d2 += d.doubleValue()) == 0.0) continue;
            if (!voidItem.isItemWasted().booleanValue() && !ticketItem.isInventoryAdjusted()) {
                hashMap.put(invMapKey, d2);
                ticketItem.setInventoryAdjustQty(ticketItem.getQuantity());
            }
            Boolean bl = ticketItem.isPrintedToKitchen();
            VoidItemDAO.getInstance().deleteAndSentToKitchenIfNeeded(voidItem, bl, ticket, session);
            if (ticketItem.isHasModifiers().booleanValue() && StringUtils.isNotBlank((String)(string = ticketItem.getProperty("modifierVoidIds"))) && (stringArray = string.split(",")).length > 0) {
                for (String string4 : stringArray) {
                    VoidItem voidItem2;
                    if (StringUtils.isBlank((String)string4) || (voidItem2 = VoidItemDAO.getInstance().get(string4)) == null) continue;
                    VoidItemDAO.getInstance().delete(voidItem2, session);
                }
            }
            if (!ticketItem.isComboItem().booleanValue()) continue;
            this.populateReturnedVoidItemToMap(ticket, session, ticketItem.getComboItems(), hashMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumTickets(Date date, Date date2) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            if (date != null) {
                criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_DELIVERY_DATE, (Object)date));
            }
            if (date2 != null) {
                criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_DELIVERY_DATE, (Object)date2));
            }
            criteria.add(Restrictions.isNotNull((String)Ticket.PROP_DELIVERY_DATE));
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                int n = number.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTickets(PaginatedTableModel paginatedTableModel, Date date, Date date2) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(this.getDefaultOrder());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            if (date != null) {
                criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_DELIVERY_DATE, (Object)date));
            }
            if (date2 != null) {
                criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_DELIVERY_DATE, (Object)date2));
            }
            criteria.setFirstResult(paginatedTableModel.getCurrentRowIndex());
            criteria.setMaxResults(paginatedTableModel.getPageSize());
            paginatedTableModel.setRows(criteria.list());
            return;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Ticket> getTicketsWithSpecificFields(String ... stringArray) {
        return this.getTicketsWithSpecificFields(true, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> getTicketsWithSpecificFields(boolean bl, String ... stringArray) {
        Session session = null;
        Criteria criteria = null;
        User user = Application.getCurrentUser();
        boolean bl2 = !user.isAdministrator() || !user.isManager();
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(Ticket.class);
            if (bl) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            }
            if (bl2) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
            }
            ProjectionList projectionList = Projections.projectionList();
            for (String string : stringArray) {
                projectionList.add((Projection)Projections.property((String)string), string);
            }
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(Ticket.class));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTicketByOnlineOrderId(String string) {
        Session session = null;
        try {
            session = this.createNewSession();
            String string2 = "select * from TICKET_PROPERTIES where PROPERTY_VALUE='%s' and PROPERTY_NAME='%s'";
            string2 = String.format(string2, string, "onlineOrderId");
            SQLQuery sQLQuery = session.createSQLQuery(string2);
            List list = sQLQuery.list();
            boolean bl = list.size() > 0;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTicketByReservationId(String string) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ID, (Object)string));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_TYPE, (Object)TicketType.RESERVATION.getTypeNo()));
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                boolean bl = number.intValue() > 0;
                return bl;
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getReferenceClass(), exception);
        }
        finally {
            this.closeSession(session);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findOnlineTickets(PaginatedTableModel paginatedTableModel) {
        Session session = null;
        try {
            session = this.createNewSession();
            String string = "select TICKET_ID from TICKET_PROPERTIES where PROPERTY_VALUE='online' and PROPERTY_NAME='source'";
            SQLQuery sQLQuery = session.createSQLQuery(string);
            List list = sQLQuery.list();
            ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
            for (String string2 : list) {
                if (string2 == null) continue;
                Ticket ticket = this.get(string2);
                arrayList.add(ticket);
            }
            ArrayList<Ticket> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDriverOut(List<Ticket> list, List<User> list2) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = TicketDAO.getInstance().createNewSession();
            transaction = session.beginTransaction();
            for (Ticket ticket : list) {
                ticket.setStatus("Driving");
                ticket.addProperty("OUT_AT", DateUtil.getReportDate());
                User user = ticket.getAssignedDriver();
                if (user != null && !list2.contains(user)) {
                    list2.add(user);
                }
                this.saveOrUpdate(ticket, session);
            }
            transaction.commit();
            for (Ticket ticket : list) {
                CloudDataUploader.get().uploadToCloudIfOnlineOrder(ticket);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage());
            if (transaction != null) {
                transaction.rollback();
            }
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findTicketForDeliveryDispath(PaginatedTableModel paginatedTableModel, OrderType orderType, String string, Date date, Date date2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        User user = Application.getCurrentUser();
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(this.getDefaultOrder());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ORDER_TYPE_ID, (Object)orderType.getId()));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)string));
            }
            if (!user.canViewAllOpenTickets()) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
            }
            if (date != null && date2 != null) {
                criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.ge((String)Ticket.PROP_DELIVERY_DATE, (Object)date), (Criterion)Restrictions.le((String)Ticket.PROP_DELIVERY_DATE, (Object)date2)));
            }
            if (bl2) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_WILL_PICKUP, (Object)Boolean.TRUE));
            }
            if (bl3) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_WILL_PICKUP, (Object)Boolean.FALSE));
            }
            if (bl4) {
                criteria.add(Restrictions.isNull((String)Ticket.PROP_ASSIGNED_DRIVER_ID));
            }
            int n = paginatedTableModel.getCurrentRowIndex();
            criteria.setFirstResult(n);
            criteria.setMaxResults(paginatedTableModel.getPageSize());
            List list = criteria.list();
            if (bl) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Ticket ticket = (Ticket)iterator.next();
                    if (ticket.isSourceOnline()) continue;
                    iterator.remove();
                }
            }
            paginatedTableModel.setRows(list);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void closeOrders(Ticket ... ticketArray) {
        Session session = TicketDAO.getInstance().createNewSession();
        Transaction transaction = null;
        if (ticketArray == null) {
            return;
        }
        try {
            transaction = session.beginTransaction();
            Date date = StoreDAO.getServerTimestamp();
            for (Ticket ticket : ticketArray) {
                ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
                ticket.setClosed(true);
                ticket.setClosingDate(date);
                TicketDAO.getInstance().saveOrUpdate(ticket, session);
            }
            transaction.commit();
            for (Ticket ticket : ticketArray) {
                CloudDataUploader.get().uploadToCloudIfOnlineOrder(ticket);
            }
        }
        catch (Exception exception) {
            PosLog.error(OrderController.class, exception);
            POSMessageDialog.showError(exception.getMessage());
            if (transaction != null) {
                transaction.rollback();
            }
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findBarTabOpenTickets(OrderType orderType) {
        List list;
        Criteria criteria;
        ArrayList<String> arrayList;
        Session session;
        block6: {
            session = null;
            try {
                arrayList = new ArrayList<String>();
                List<OrderType> list2 = DataProvider.get().getOrderTypes();
                if (list2 != null) {
                    for (OrderType comparable2 : list2) {
                        if (!comparable2.isBarTab().booleanValue()) continue;
                        arrayList.add(comparable2.getId());
                    }
                }
                if (arrayList != null && !arrayList.isEmpty()) break block6;
                criteria = null;
            }
            catch (Throwable throwable) {
                this.closeSession(session);
                throw throwable;
            }
            this.closeSession(session);
            return criteria;
        }
        session = this.getSession();
        criteria = session.createCriteria(this.getReferenceClass());
        User user = Application.getCurrentUser();
        if (user != null && !user.canViewAllOpenTickets()) {
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
        }
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ORDER_TYPE_ID, (Object)(orderType == null ? null : orderType.getId())));
        criteria.add(Restrictions.in((String)Ticket.PROP_ORDER_TYPE_ID, arrayList));
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
        criteria.addOrder(this.getDefaultOrder());
        List list2 = list = criteria.list();
        this.closeSession(session);
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findVoidTicketByDate(Date date, Date date2, Terminal terminal) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)true));
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CLOSING_DATE, (Object)date2));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public User findOwner(String string) {
        if (string == null) {
            return null;
        }
        Session session = this.getSession();
        Criteria criteria = session.createCriteria(Ticket.class);
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ID, (Object)string));
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.property((String)Ticket.PROP_OWNER_ID));
        criteria.setProjection((Projection)projectionList);
        if (criteria.list().isEmpty()) {
            return null;
        }
        User user = UserDAO.getInstance().get((String)criteria.list().get(0));
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ticket findByCustomerAndDeliveryDate(String string, Date date) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(Ticket.class);
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)string));
            criteria.add(Restrictions.between((String)Ticket.PROP_DELIVERY_DATE, (Object)DateUtil.startOfDay(date), (Object)DateUtil.endOfDay(date)));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)false));
            List list = criteria.list();
            if (!list.isEmpty()) {
                Ticket ticket = (Ticket)list.get(0);
                return ticket;
            }
            Ticket ticket = null;
            return ticket;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveMergedTickets(List<Ticket> list, Ticket ticket) throws Exception {
        Session session = null;
        Transaction transaction = null;
        try {
            ticket.setShouldUpdateTableStatus(true);
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.deleteTickets(session, list, true);
            this.saveOrUpdate(ticket, session, true);
            transaction.commit();
        }
        catch (Exception exception) {
            try {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw exception;
            }
            catch (Throwable throwable) {
                this.closeSession(session);
                throw throwable;
            }
        }
        this.closeSession(session);
    }

    public void saveOrUpdateTransferedTicketsList(List<Ticket> list, List<Ticket> list2) throws Exception {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            if (list != null || list.size() > 0) {
                this.deleteTickets(session, list, true);
            }
            for (Ticket ticket : list2) {
                this.saveOrUpdate(ticket, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void reversePayment(Ticket ticket, PosTransaction posTransaction, boolean bl) throws Exception {
        if (posTransaction instanceof CreditCardTransaction || posTransaction instanceof DebitCardTransaction) {
            CardProcessor cardProcessor;
            CardReader cardReader = CardReader.fromString(posTransaction.getCardReader());
            if (StringUtils.isBlank((String)posTransaction.getCardMerchantGateway()) || cardReader == CardReader.EXTERNAL_TERMINAL) {
                posTransaction.setVoided(true);
            } else {
                cardProcessor = CardConfig.getPaymentGatewayByName(posTransaction.getCardMerchantGateway()).getProcessor();
                cardProcessor.voidTransaction(posTransaction);
            }
            posTransaction.setVoided(true);
            ticket.setPaidAmount(ticket.getPaidAmount() - posTransaction.getAmount());
            ticket.setDueAmount(ticket.getDueAmount() + posTransaction.getAmount());
            ticket.setClosed(false);
            ticket.setPaid(false);
            cardProcessor = null;
            Transaction transaction = null;
            try {
                cardProcessor = this.createNewSession();
                transaction = cardProcessor.beginTransaction();
                if (bl) {
                    this.doReverseGiftCardBalance(ticket, posTransaction, (Session)cardProcessor);
                }
                this.update(ticket, (Session)cardProcessor);
                transaction.commit();
            }
            catch (Exception exception) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw exception;
            }
            finally {
                this.closeSession((Session)cardProcessor);
            }
        }
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            PaymentType paymentType = posTransaction.getPaymentType();
            PaymentPlugin paymentPlugin = paymentType.getPaymentPlugin();
            if (paymentPlugin != null) {
                paymentPlugin.voidPayment(posTransaction, session);
            }
            posTransaction.setVoided(true);
            if (paymentType == PaymentType.CASH) {
                PosTransactionService.getInstance().adjustMulticurrencyBalance(session, DataProvider.get().getCurrentTerminal(), Application.getCurrentUser().getActiveDrawerPullReport(), null, posTransaction);
            }
            ticket.setPaidAmount(ticket.getPaidAmount() - posTransaction.getAmount());
            ticket.setDueAmount(ticket.getDueAmount() + posTransaction.getAmount());
            ticket.setClosed(false);
            ticket.setPaid(false);
            if (bl) {
                this.doReverseGiftCardBalance(ticket, posTransaction, session);
            }
            this.update(ticket, session);
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw exception;
        }
    }

    public void doReverseGiftCardBalance(Ticket ticket, PosTransaction posTransaction, Session session) {
        String string = posTransaction.getGiftCardBalanceAddInfo();
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        JSONArray jSONArray = new JSONArray(string);
        for (Object e : jSONArray) {
            JSONObject jSONObject = (JSONObject)e;
            String string2 = jSONObject.getString("ticketItemId");
            String string3 = jSONObject.getString("giftCardNo");
            double d = jSONObject.getDouble("addedAmount");
            GiftCard giftCard = GiftCardDAO.getInstance().findByCardNumber(session, string3);
            if (giftCard != null) {
                giftCard.setBalance(giftCard.getBalance() - d);
                GiftCardDAO.getInstance().saveOrUpdate(giftCard, session);
            }
            List<TicketItem> list = ticket.getTicketItems();
            for (TicketItem ticketItem : list) {
                if (!ticketItem.getId().equals(string2)) continue;
                ticketItem.setGiftCardPaidAmount(0.0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTicketsForUser(User user, Date date, Date date2, PaginatedTableModel paginatedTableModel) {
        Session session = null;
        try {
            Number number;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
            }
            if (date != null) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date), (Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)false)));
            }
            if (date2 != null) {
                criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
            }
            if ((number = (Number)criteria.uniqueResult()) != null) {
                paginatedTableModel.setNumRows(number.intValue());
            } else {
                paginatedTableModel.setNumRows(0);
            }
            criteria.setProjection(null);
            criteria.setFirstResult(paginatedTableModel.getCurrentRowIndex());
            criteria.setMaxResults(paginatedTableModel.getPageSize());
            criteria.addOrder(Order.desc((String)Ticket.PROP_CREATE_DATE));
            paginatedTableModel.setRows(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    private boolean shouldUpdateStock(Ticket ticket) {
        if (ticket.isSourceOnline()) {
            return false;
        }
        if (ticket.isReservation()) {
            return true;
        }
        return ticket.isShouldUpdateStock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findAllUnSyncTicket(StoreSession storeSession) {
        List list;
        block6: {
            Session session;
            block4: {
                List list2;
                block5: {
                    session = null;
                    try {
                        List<String> list3 = CashDrawerDAO.getInstance().getCashDrawerIds(storeSession);
                        if (list3 != null && !list3.isEmpty()) break block4;
                        list2 = null;
                        if (session == null) break block5;
                    }
                    catch (Throwable throwable) {
                        if (session != null) {
                            this.closeSession(session);
                        }
                        throw throwable;
                    }
                    this.closeSession(session);
                }
                return list2;
            }
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            Criterion criterion = Restrictions.isNull((String)Ticket.PROP_LAST_UPDATE_TIME);
            Criterion criterion2 = Restrictions.isNull((String)Ticket.PROP_LAST_SYNC_TIME);
            PropertyExpression propertyExpression = Restrictions.gtProperty((String)Ticket.PROP_LAST_UPDATE_TIME, (String)Ticket.PROP_LAST_SYNC_TIME);
            criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{criterion, criterion2, propertyExpression}));
            list = criteria.list();
            if (session == null) break block6;
            this.closeSession(session);
        }
        return list;
    }

    public void updateTicketAndTicketItemSync(List<Ticket> list, boolean bl) {
        if (list != null) {
            for (Ticket ticket : list) {
                List<TicketItem> list2;
                this.loadFullTicket(ticket);
                if (!ticket.isCloudSynced().booleanValue() && ticket.isClosed().booleanValue()) {
                    ticket.setCloudSynced(bl);
                    TicketDAO.getInstance().update(ticket);
                }
                if ((list2 = ticket.getTicketItems()) == null) continue;
                for (TicketItem ticketItem : list2) {
                    if (ticketItem.isCloudSynced().booleanValue()) continue;
                    ticketItem.setCloudSynced(bl);
                    TicketItemDAO.getInstance().update(ticketItem);
                }
            }
        }
    }

    public void loadClosedTicket(PaginationSupport paginationSupport, String string, Date date, Date date2) {
        this.loadClosedTicket(paginationSupport, string, date, date2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadClosedTicket(PaginationSupport paginationSupport, String string, Date date, Date date2, User user) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(Customer.class);
            List list = null;
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.setProjection((Projection)Projections.property((String)Customer.PROP_ID));
                criteria.add(Restrictions.ilike((String)Customer.PROP_NAME, (String)string, (MatchMode)MatchMode.ANYWHERE));
                list = criteria.list();
            }
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            Disjunction disjunction = Restrictions.disjunction();
            if (StringUtils.isNotEmpty((String)string)) {
                disjunction.add((Criterion)Restrictions.eq((String)Ticket.PROP_ID, (Object)string));
            }
            if (list != null && list.size() > 0) {
                disjunction.add(Restrictions.in((String)Ticket.PROP_CUSTOMER_ID, (Collection)list));
            }
            criteria.add((Criterion)disjunction);
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
            }
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.TRUE));
            if (date != null && date2 != null) {
                criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
                criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
            }
            Number number = (Number)criteria.uniqueResult();
            paginationSupport.setNumRows(number.intValue());
            criteria.setProjection(null);
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            List list2 = criteria.list();
            paginationSupport.setRows(list2);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Date> findTicketWithinDate(Date date, Date date2, Session session) {
        try {
            Criteria criteria = session.createCriteria(Ticket.class);
            criteria.add(Restrictions.between((String)Ticket.PROP_CREATE_DATE, (Object)DateUtil.startOfDay(date), (Object)DateUtil.endOfDay(date2)));
            criteria.setProjection((Projection)Projections.property((String)Ticket.PROP_CREATE_DATE));
            List list = criteria.list();
            if (list != null && list.size() > 0) {
                return list;
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getReferenceClass(), exception);
        }
        return null;
    }

    public List<DeliverySummaryReportData> findTicketsForDeliverySummaryReport(Date date, Date date2) {
        try (Session session = this.createNewSession();){
            String string = " as ";
            String string2 = "select t." + Ticket.PROP_OWNER_ID + string + "employeeId" + ",t." + Ticket.PROP_CUSTOMER_ID + string + "customerId" + ",%s" + string + "customerName" + ",%s" + string + "memberId" + ",t." + Ticket.PROP_ID + string + "ticketId" + ",t." + Ticket.PROP_SUBTOTAL_AMOUNT + string + "netAmount" + ",t." + Ticket.PROP_TAX_AMOUNT + string + "taxAmount" + ",t." + Ticket.PROP_TOTAL_AMOUNT + string + "totalAmount" + ",t." + Ticket.PROP_SERVICE_CHARGE + string + "serviceCharge" + ",t." + Ticket.PROP_DISCOUNT_AMOUNT + string + "discount" + ",t." + Ticket.PROP_CREATE_DATE + string + "createdDate" + ",t." + Ticket.PROP_DELIVERY_DATE + string + "deliveryDate" + ",g." + Gratuity.PROP_AMOUNT + string + "gratuityAmount" + ",%s" + string + "cashPaymentCredit" + ",%s" + string + "creditCardPaymentCredit" + ",%s" + string + "memberChargeCredit" + ",%s" + string + "othersPaymentCredit" + ",%s" + string + "cashPaymentDebit" + ",%s" + string + "creditCardPaymentDebit" + ",%s" + string + "memberChargeDebit" + ",%s" + string + "othersPaymentDebit" + " from Ticket as t left outer join t.gratuity as g";
            String string3 = String.format("select sum(tr.%s) from PosTransaction as tr where t=tr.%s and tr.%s='%s' and tr.%s=%s", PosTransaction.PROP_AMOUNT, PosTransaction.PROP_TICKET, PosTransaction.PROP_TRANSACTION_TYPE, "%s", PosTransaction.PROP_VOIDED, false);
            String string4 = "(" + string3 + " and tr." + PosTransaction.PROP_PAYMENT_TYPE_STRING + "='%s')";
            String string5 = "(" + string3 + " and tr." + PosTransaction.PROP_PAYMENT_TYPE_STRING + " not in('%s','%s','%s'))";
            String string6 = "(select c.%s from Customer as c where t.%s=c.%s)";
            string2 = String.format(string2, String.format(string6, Customer.PROP_NAME, Ticket.PROP_CUSTOMER_ID, Customer.PROP_ID), String.format(string6, Customer.PROP_MEMBER_ID, Ticket.PROP_CUSTOMER_ID, Customer.PROP_ID), String.format(string4, TransactionType.CREDIT.name(), PaymentType.CASH.name()), String.format(string4, TransactionType.CREDIT.name(), PaymentType.CREDIT_CARD.name()), String.format(string4, TransactionType.CREDIT.name(), PaymentType.MEMBER_ACCOUNT.name()), String.format(string5, TransactionType.CREDIT.name(), PaymentType.CASH.name(), PaymentType.CREDIT_CARD.name(), PaymentType.MEMBER_ACCOUNT.name()), String.format(string4, TransactionType.DEBIT.name(), PaymentType.CASH.name()), String.format(string4, TransactionType.DEBIT.name(), PaymentType.CREDIT_CARD.name()), String.format(string4, TransactionType.DEBIT.name(), PaymentType.MEMBER_ACCOUNT.name()), String.format(string5, TransactionType.DEBIT.name(), PaymentType.CASH.name(), PaymentType.CREDIT_CARD.name(), PaymentType.MEMBER_ACCOUNT.name()));
            string2 = string2 + " where t." + Ticket.PROP_DELIVERY_DATE + " between :fromDate and :toDate";
            string2 = string2 + " and t." + Ticket.PROP_VOIDED + " =:voided";
            string2 = string2 + " order by t." + Ticket.PROP_OWNER_ID + " asc";
            Query query = session.createQuery(string2);
            query.setTimestamp("fromDate", date);
            query.setTimestamp("toDate", date2);
            query.setBoolean("voided", Boolean.FALSE.booleanValue());
            query.setResultTransformer(Transformers.aliasToBean(DeliverySummaryReportData.class));
            List list = query.list();
            return list;
        }
    }

    @Deprecated
    public List<EndOfDayReportData> findTicketsGroupedByEmployee(Date date, Date date2, List<OrderType> list) {
        try (Session session = this.createNewSession();){
            Object object;
            String string;
            String string2 = " as ";
            String string3 = "select t." + Ticket.PROP_OWNER_ID + string2 + "employeeId" + ",t." + Ticket.PROP_CUSTOMER_ID + string2 + "customerId" + ",%s" + string2 + "customerName" + ",%s" + string2 + "memberId" + ",t." + Ticket.PROP_ID + string2 + "ticketId" + ",t." + Ticket.PROP_SUBTOTAL_AMOUNT + string2 + "netAmount" + ",t." + Ticket.PROP_TAX_AMOUNT + string2 + "taxAmount" + ",t." + Ticket.PROP_TOTAL_AMOUNT + string2 + "totalTicketAmount" + ",t." + Ticket.PROP_SERVICE_CHARGE + string2 + "serviceCharge" + ",t." + Ticket.PROP_DISCOUNT_AMOUNT + string2 + "discount" + ",g." + Gratuity.PROP_AMOUNT + string2 + "gratuityAmount" + ",%s" + string2 + "cashPaymentCredit" + ",%s" + string2 + "creditCardPaymentCredit" + ",%s" + string2 + "memberChargeCredit" + ",%s" + string2 + "othersPaymentCredit" + ",%s" + string2 + "cashPaymentDebit" + ",%s" + string2 + "creditCardPaymentDebit" + ",%s" + string2 + "memberChargeDebit" + ",%s" + string2 + "othersPaymentDebit" + " from Ticket as t left outer join t.gratuity as g";
            String string4 = String.format("select sum(tr.%s) from PosTransaction as tr where t=tr.%s and tr.%s='%s' and tr.%s=%s", PosTransaction.PROP_AMOUNT, PosTransaction.PROP_TICKET, PosTransaction.PROP_TRANSACTION_TYPE, "%s", PosTransaction.PROP_VOIDED, false);
            String string5 = "(" + string4 + " and tr." + PosTransaction.PROP_PAYMENT_TYPE_STRING + "='%s')";
            String string6 = "(" + string4 + " and tr." + PosTransaction.PROP_PAYMENT_TYPE_STRING + " not in('%s','%s','%s'))";
            String string7 = "(select c.%s from Customer as c where t.%s=c.%s)";
            string3 = String.format(string3, String.format(string7, Customer.PROP_NAME, Ticket.PROP_CUSTOMER_ID, Customer.PROP_ID), String.format(string7, Customer.PROP_MEMBER_ID, Ticket.PROP_CUSTOMER_ID, Customer.PROP_ID), String.format(string5, TransactionType.CREDIT.name(), PaymentType.CASH.name()), String.format(string5, TransactionType.CREDIT.name(), PaymentType.CREDIT_CARD.name()), String.format(string5, TransactionType.CREDIT.name(), PaymentType.MEMBER_ACCOUNT.name()), String.format(string6, TransactionType.CREDIT.name(), PaymentType.CASH.name(), PaymentType.CREDIT_CARD.name(), PaymentType.MEMBER_ACCOUNT.name()), String.format(string5, TransactionType.DEBIT.name(), PaymentType.CASH.name()), String.format(string5, TransactionType.DEBIT.name(), PaymentType.CREDIT_CARD.name()), String.format(string5, TransactionType.DEBIT.name(), PaymentType.MEMBER_ACCOUNT.name()), String.format(string6, TransactionType.DEBIT.name(), PaymentType.CASH.name(), PaymentType.CREDIT_CARD.name(), PaymentType.MEMBER_ACCOUNT.name()));
            string3 = string3 + " where t." + Ticket.PROP_CREATE_DATE + " >= :fromDate and t." + Ticket.PROP_CREATE_DATE + " < :toDate";
            if (list != null) {
                string = "(";
                object = list.iterator();
                while (object.hasNext()) {
                    OrderType orderType = object.next();
                    string = string + "'" + orderType.getId() + "'";
                    if (!object.hasNext()) continue;
                    string = string + ",";
                }
                string = string + ")";
                string3 = string3 + " and t." + Ticket.PROP_ORDER_TYPE_ID + " in " + string;
            }
            string3 = string3 + " and t." + Ticket.PROP_VOIDED + " =:voided";
            string3 = string3 + " order by t." + Ticket.PROP_OWNER_ID + " asc";
            string = session.createQuery(string3);
            string.setTimestamp("fromDate", DateUtil.toUTC(date));
            string.setTimestamp("toDate", DateUtil.toUTC(date2));
            string.setBoolean("voided", Boolean.FALSE.booleanValue());
            string.setResultTransformer(Transformers.aliasToBean(EndOfDayReportData.class));
            object = string.list();
            return object;
        }
    }

    public List<Ticket> findTicketsByCustomer(String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)string));
            List list = criteria.list();
            return list;
        }
    }
}

