/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.util;

import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryStockUnit;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PackagingUnit;
import com.floreantpos.model.ext.UnitBaseItemPrice;
import com.floreantpos.model.util.InventoryUnitConversionRule;
import com.floreantpos.util.NumberUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class InventoryUnitConvertionUtil {
    public static double calculateCost(Double d, IUnit iUnit, MenuItem menuItem) {
        return InventoryUnitConvertionUtil.calculateCost(d, menuItem.getUnit(), iUnit, menuItem);
    }

    public static double calculateCost(Double d, IUnit iUnit, IUnit iUnit2, MenuItem menuItem) {
        if (iUnit == null || iUnit2 == null) {
            return d;
        }
        if (iUnit2 instanceof PackagingUnit) {
            PackagingUnit packagingUnit = (PackagingUnit)iUnit2;
            if (menuItem.getStockUnits() != null && !menuItem.getStockUnits().isEmpty()) {
                for (InventoryStockUnit inventoryStockUnit : menuItem.getStockUnits()) {
                    if (!inventoryStockUnit.getPackagingUnit().getId().equals(packagingUnit.getId())) continue;
                    return InventoryUnitConvertionUtil.getInventoryUnitCost(d, (InventoryUnit)iUnit, inventoryStockUnit.getUnit()) * inventoryStockUnit.getConversionValue();
                }
            }
        } else if (iUnit instanceof PackagingUnit) {
            PackagingUnit packagingUnit = (PackagingUnit)iUnit;
            if (menuItem.getStockUnits() != null && menuItem.getStockUnits().size() > 0) {
                for (InventoryStockUnit inventoryStockUnit : menuItem.getStockUnits()) {
                    if (!packagingUnit.getCode().equals(inventoryStockUnit.getPackagingUnit().getCode())) continue;
                    return InventoryUnitConvertionUtil.getInventoryUnitCost(d, inventoryStockUnit.getUnit(), (InventoryUnit)iUnit2) / inventoryStockUnit.getConversionValue();
                }
            }
        } else {
            InventoryUnit inventoryUnit = (InventoryUnit)iUnit2;
            if (!iUnit.getUniqueCode().equals(inventoryUnit.getUniqueCode())) {
                return InventoryUnitConvertionUtil.getInventoryUnitCost(d, (InventoryUnit)iUnit, inventoryUnit);
            }
        }
        return d == null ? 0.0 : d;
    }

    private static double getInventoryUnitCost(Double d, InventoryUnit inventoryUnit, InventoryUnit inventoryUnit2) {
        InventoryUnitConversionRule inventoryUnitConversionRule;
        double d2 = d;
        InventoryUnit inventoryUnit3 = inventoryUnit2;
        String string = inventoryUnit3.getProperty("conversion.rule", InventoryUnitConversionRule.DIVISION.getName());
        if (!inventoryUnit.isBaseUnit().booleanValue() && inventoryUnit.getConversionRate() != 1.0) {
            d2 = d * inventoryUnit.getConversionRate();
        }
        if ((inventoryUnitConversionRule = InventoryUnitConversionRule.fromName(string)) == InventoryUnitConversionRule.MULTIPLICATION) {
            return d2 * 1.0 / inventoryUnit3.getConversionRate();
        }
        return d2 / inventoryUnit3.getConversionRate();
    }

    public static double calculatePrice(Double d, IUnit iUnit, MenuItem menuItem) {
        return InventoryUnitConvertionUtil.calculatePrice(d, menuItem.getUnit(), iUnit, menuItem);
    }

    public static double calculatePrice(Double d, IUnit iUnit, IUnit iUnit2, MenuItem menuItem) {
        if (iUnit == null || iUnit2 == null) {
            return d;
        }
        if (iUnit2 instanceof PackagingUnit) {
            PackagingUnit packagingUnit = (PackagingUnit)iUnit2;
            if (menuItem.getStockUnits() != null && !menuItem.getStockUnits().isEmpty()) {
                for (InventoryStockUnit inventoryStockUnit : menuItem.getStockUnits()) {
                    if (!inventoryStockUnit.getPackagingUnit().getId().equals(packagingUnit.getId())) continue;
                    return InventoryUnitConvertionUtil.getInventoryUnitPrice(d, (InventoryUnit)iUnit, inventoryStockUnit.getUnit()) * inventoryStockUnit.getConversionValue();
                }
            }
        } else {
            InventoryUnit inventoryUnit = (InventoryUnit)iUnit2;
            if (!iUnit.getUniqueCode().equals(inventoryUnit.getUniqueCode())) {
                return InventoryUnitConvertionUtil.getInventoryUnitPrice(d, (InventoryUnit)iUnit, inventoryUnit);
            }
        }
        return d == null ? 0.0 : d;
    }

    private static double getInventoryUnitPrice(Double d, InventoryUnit inventoryUnit, InventoryUnit inventoryUnit2) {
        InventoryUnitConversionRule inventoryUnitConversionRule;
        double d2 = d;
        InventoryUnit inventoryUnit3 = inventoryUnit2;
        String string = inventoryUnit3.getProperty("conversion.rule", InventoryUnitConversionRule.DIVISION.getName());
        if (!inventoryUnit.isBaseUnit().booleanValue() && inventoryUnit.getConversionRate() != 1.0) {
            d2 = d * inventoryUnit.getConversionRate();
        }
        if ((inventoryUnitConversionRule = InventoryUnitConversionRule.fromName(string)) == InventoryUnitConversionRule.MULTIPLICATION) {
            return d2 * 1.0 / inventoryUnit3.getConversionRate();
        }
        return d2 / inventoryUnit3.getConversionRate();
    }

    public static double getUnitQuantity(IUnit iUnit, IUnit iUnit2, MenuItem menuItem) {
        PackagingUnit packagingUnit;
        if (iUnit2 instanceof PackagingUnit) {
            packagingUnit = (PackagingUnit)iUnit2;
            if (menuItem.getStockUnits() != null && menuItem.getStockUnits().size() > 0) {
                for (InventoryStockUnit inventoryStockUnit : menuItem.getStockUnits()) {
                    if (!packagingUnit.getCode().equals(inventoryStockUnit.getPackagingUnit().getCode())) continue;
                    return 1.0 / (inventoryStockUnit.getConversionValue() * InventoryUnitConvertionUtil.getBaseUnitQuantity(inventoryStockUnit.getUnit().getUniqueCode(), menuItem));
                }
            }
        }
        if (iUnit instanceof PackagingUnit) {
            packagingUnit = (PackagingUnit)iUnit;
            if (menuItem.getStockUnits() != null && menuItem.getStockUnits().size() > 0) {
                for (InventoryStockUnit inventoryStockUnit : menuItem.getStockUnits()) {
                    if (!packagingUnit.getCode().equals(inventoryStockUnit.getPackagingUnit().getCode())) continue;
                    return iUnit2.getConversionRate() * inventoryStockUnit.getBaseUnitValue();
                }
            }
        }
        if (iUnit != null && iUnit2 != null) {
            return iUnit.getConversionRate() == 0.0 ? iUnit2.getConversionRate() : iUnit2.getConversionRate() / iUnit.getConversionRate();
        }
        return 1.0;
    }

    public static double getBaseUnitQuantity(String string, MenuItem menuItem) {
        InventoryUnit inventoryUnit = menuItem.getUnit();
        if (inventoryUnit == null || inventoryUnit.getCode().equals(string)) {
            return 1.0;
        }
        if (menuItem.getStockUnits() != null) {
            for (InventoryStockUnit timedModel : menuItem.getStockUnits()) {
                if (!timedModel.getPackagingUnit().getCode().equals(string)) continue;
                if (!menuItem.getUnit().isBaseUnit().booleanValue()) {
                    return menuItem.getUnit().getConversionRate() * timedModel.getBaseUnitValue();
                }
                return timedModel.getBaseUnitValue();
            }
        }
        if (inventoryUnit.getUnitGroup() != null && inventoryUnit.getUnitGroup().getUnits() != null) {
            for (InventoryUnit inventoryUnit2 : inventoryUnit.getUnitGroup().getUnits()) {
                if (!inventoryUnit2.getCode().equals(string)) continue;
                return inventoryUnit.getConversionRate() / inventoryUnit2.getConversionRate();
            }
        }
        return 1.0;
    }

    public static List<UnitBaseItemPrice> buildUnitBasePriceList(MenuItem menuItem, boolean bl) {
        ArrayList<UnitBaseItemPrice> arrayList = new ArrayList<UnitBaseItemPrice>();
        for (IUnit iUnit : menuItem.getUnits()) {
            InventoryUnit inventoryUnit;
            if (iUnit.equals(inventoryUnit = menuItem.getUnit())) continue;
            Double d = InventoryUnitConvertionUtil.calculateUnitBaseItemPrice(menuItem, iUnit, bl);
            UnitBaseItemPrice unitBaseItemPrice = new UnitBaseItemPrice(iUnit.getName(), iUnit.getUniqueCode(), d);
            arrayList.add(unitBaseItemPrice);
        }
        return arrayList;
    }

    public static Double calculateUnitBaseItemPrice(MenuItem menuItem, IUnit iUnit, boolean bl) {
        String string = "unit.{name}.price".replace("{name}", iUnit.getUniqueCode());
        String string2 = menuItem.getProperty(string);
        Double d = 0.0;
        d = StringUtils.isBlank((String)string2) || bl ? Double.valueOf(InventoryUnitConvertionUtil.calculatePrice(menuItem.getPrice(), menuItem.getUnit(), iUnit, menuItem)) : Double.valueOf(NumberUtil.parseOrGetZero(string2).doubleValue());
        menuItem.addProperty(string, String.valueOf(d));
        return d;
    }
}

