/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.AttendanceReportData;
import com.floreantpos.swing.ListTableModel;
import java.text.DecimalFormat;
import org.joda.time.DateTime;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.ReadableInstant;

public class AttendanceReportModel
extends ListTableModel {
    DecimalFormat a = new DecimalFormat("0.00");

    public AttendanceReportModel() {
        super(new String[]{"employeeId", "employeeName", "clockIn", "clockOut", "workTime"});
    }

    @Override
    public Object getValueAt(int n, int n2) {
        AttendanceReportData attendanceReportData = (AttendanceReportData)this.rows.get(n);
        switch (n2) {
            case 0: {
                return String.valueOf(attendanceReportData.getUser().getId());
            }
            case 1: {
                return attendanceReportData.getUser().getFirstName() + " " + attendanceReportData.getUser().getLastName();
            }
            case 2: {
                return DateUtil.formatFullDateAndTimeAsString(attendanceReportData.getClockIn());
            }
            case 3: {
                if (attendanceReportData.getClockOut() == null) break;
                return DateUtil.formatFullDateAndTimeAsString(attendanceReportData.getClockOut());
            }
            case 4: {
                if (attendanceReportData.getClockOut() == null) break;
                DateTime dateTime = new DateTime(attendanceReportData.getClockIn().getTime());
                DateTime dateTime2 = new DateTime(attendanceReportData.getClockOut().getTime());
                return Hours.hoursBetween((ReadableInstant)dateTime, (ReadableInstant)dateTime2).getHours() % 24 + "." + Minutes.minutesBetween((ReadableInstant)dateTime, (ReadableInstant)dateTime2).getMinutes() % 60;
            }
        }
        return null;
    }
}

