/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.Customer;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.model.CustomerPaymentReportModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class CustomerPaymentReportView
extends TransparentPanel {
    private JButton a;
    private JXDatePicker b;
    private JXDatePicker c;
    private JPanel d;
    private JPanel e;
    private JComboBox f;

    public CustomerPaymentReportView() {
        this.setLayout(new BorderLayout());
        this.b();
    }

    private void a() {
        try {
            List<CustomerAccountTransactionItem> list;
            Date date = this.b.getDate();
            Date date2 = this.c.getDate();
            DateUtil.validateDate(date, date2);
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(date);
            calendar.set(1, calendar2.get(1));
            calendar.set(2, calendar2.get(2));
            calendar.set(5, calendar2.get(5));
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            date = calendar.getTime();
            calendar.clear();
            calendar2.setTime(date2);
            calendar.set(1, calendar2.get(1));
            calendar.set(2, calendar2.get(2));
            calendar.set(5, calendar2.get(5));
            calendar.set(10, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            date2 = calendar.getTime();
            Object object = this.f.getSelectedItem();
            Customer customer = null;
            if (object instanceof Customer) {
                customer = (Customer)object;
            }
            if ((list = PosTransactionDAO.getInstance().findCustomerAccountTransactions(date, date2, customer)) == null || list.size() < 1) {
                this.d.removeAll();
                POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("CustomerPaymentReportView.0"));
                return;
            }
            JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("customer-payment-report"));
            HashMap hashMap = new HashMap();
            ReportUtil.populateRestaurantProperties(hashMap);
            ReportUtil.populateReportTime(hashMap, date, date2);
            ReportUtil.populateReportFooter(hashMap);
            this.a(hashMap);
            CustomerPaymentReportModel customerPaymentReportModel = new CustomerPaymentReportModel();
            customerPaymentReportModel.setRows(list);
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)customerPaymentReportModel));
            JRViewer jRViewer = new JRViewer(jasperPrint);
            this.d.removeAll();
            this.d.add((Component)jRViewer);
            this.d.revalidate();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(HashMap hashMap) {
        hashMap.put("reportTitle", Messages.getString("CustomerPaymentReportView.2"));
        hashMap.put("tips", Messages.getString("CustomerPaymentReportView.13") + CurrencyUtil.getCurrencySymbolWithBracket());
        hashMap.put("totalAmount", Messages.getString("CustomerPaymentReportView.17") + CurrencyUtil.getCurrencySymbolWithBracket());
        hashMap.put("colCName", Messages.getString("CustomerName"));
        hashMap.put("colCId", Messages.getString("CustomerId"));
        hashMap.put("colTicketNo", Messages.getString("TicketNo"));
        hashMap.put("colTransNo", Messages.getString("TransNo"));
        hashMap.put("colDate", POSConstants.DATE);
        hashMap.put("colTotal", POSConstants.TOTAL);
    }

    private void b() {
        this.b = UiUtil.getCurrentMonthStart();
        this.c = UiUtil.getDeafultDate();
        this.c.setDate(new Date());
        this.a = new JButton();
        this.a.setText(POSConstants.GO);
        this.a.addActionListener(actionEvent -> this.a());
        this.f = new JComboBox();
        CustomerDAO customerDAO = new CustomerDAO();
        List<Customer> list = customerDAO.findAll();
        Vector<Object> vector = new Vector<Object>();
        vector.add(POSConstants.ALL);
        vector.addAll(list);
        this.f.setModel(new DefaultComboBoxModel(vector));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        jPanel.add(new JLabel(Messages.getString("CustomerPaymentReportView.20") + ":"));
        jPanel.add(this.f);
        jPanel.add(new JLabel(POSConstants.START_DATE + ":"));
        this.b.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.b);
        jPanel.add(new JLabel(POSConstants.END_DATE + ":"));
        this.c.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.c);
        jPanel.add((Component)this.a, "width 60!");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.add((Component)new JSeparator(), "North");
        this.d = new JPanel(new BorderLayout());
        jPanel2.add(this.d);
        this.add(jPanel2);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.e;
    }

    public static class CustomerAccountTransactionItem {
        private String a;
        private String b;
        private String c;
        private String d;
        private Date e;
        private Double f;
        private Double g;

        public String getCustomerId() {
            return this.b;
        }

        public void setCustomerId(String string) {
            this.b = string;
        }

        public String getTicketNo() {
            return this.c;
        }

        public void setTicketNo(String string) {
            this.c = string;
        }

        public String getTransactionNo() {
            return this.d;
        }

        public void setTransactionNo(String string) {
            this.d = string;
        }

        public Date getDate() {
            return this.e;
        }

        public void setDate(Date date) {
            this.e = date;
        }

        public Double getTips() {
            return this.f;
        }

        public void setTips(Double d) {
            this.f = d;
        }

        public Double getTotalAmount() {
            return this.g;
        }

        public void setTotalAmount(Double d) {
            this.g = d;
        }

        public String getCustomerName() {
            return this.a;
        }

        public void setCustomerName(String string) {
            this.a = string;
        }
    }
}

