/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.StoreSessionDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.SessionSummaryReportModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class SessionSummaryReportView
extends TransparentPanel {
    private JButton a;
    private JXDatePicker b;
    private JXDatePicker c;
    private JPanel d;

    public SessionSummaryReportView() {
        this.setLayout(new BorderLayout());
        this.b();
    }

    private void a() {
        try {
            SessionSummaryReportData sessionSummaryReportData;
            CashDrawer cashDrawer;
            Object object;
            StoreSession storeSession2;
            Date date = this.b.getDate();
            Date date2 = this.c.getDate();
            DateUtil.validateDate(date, date2);
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(date);
            calendar.set(1, calendar2.get(1));
            calendar.set(2, calendar2.get(2));
            calendar.set(5, calendar2.get(5));
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            date = calendar.getTime();
            calendar.clear();
            calendar2.setTime(date2);
            calendar.set(1, calendar2.get(1));
            calendar.set(2, calendar2.get(2));
            calendar.set(5, calendar2.get(5));
            calendar.set(10, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            date2 = calendar.getTime();
            List<StoreSession> list = StoreSessionDAO.getInstance().findSessions(date, date2);
            ArrayList<SessionSummaryReportData> arrayList = new ArrayList<SessionSummaryReportData>();
            for (StoreSession storeSession2 : list) {
                object = CashDrawerDAO.getInstance().findByStoreOperationData(storeSession2);
                cashDrawer = PosPrintService.populateCashDrawerReportSummary(object);
                cashDrawer.setStartTime(storeSession2.getOpenTime());
                cashDrawer.setAssignedBy(storeSession2.getOpenedBy());
                cashDrawer.setReportTime(storeSession2.getCloseTime());
                cashDrawer.setClosedBy(storeSession2.getClosedBy());
                sessionSummaryReportData = new SessionSummaryReportData();
                sessionSummaryReportData.setPeriod(DateUtil.formatFullDateAsString(cashDrawer.getStartTime()));
                String string = storeSession2.getId();
                String string2 = string.substring(string.length() - 4, string.length());
                sessionSummaryReportData.setSessionID(string2);
                double d = CashDrawerDAO.getInstance().getSumOfOpeningBalance(storeSession2);
                sessionSummaryReportData.setOpeningBalance(d);
                sessionSummaryReportData.setDeposit(cashDrawer.getCashToDeposit());
                sessionSummaryReportData.setOverOutage(cashDrawer.getCashToDeposit() - cashDrawer.getDrawerAccountable());
                sessionSummaryReportData.setCash(cashDrawer.getCashReceiptAmount());
                sessionSummaryReportData.setTips(cashDrawer.getTipsPaid());
                sessionSummaryReportData.setOnAccount(cashDrawer.getCashReceiptAmount() - d);
                double d2 = cashDrawer.getCustomPaymentAmount() != null ? cashDrawer.getCustomPaymentAmount() : 0.0;
                sessionSummaryReportData.setOtherPayment(d2 + cashDrawer.getGiftCardAddBalance() + cashDrawer.getCreditCardReceiptAmount() + cashDrawer.getDebitCardReceiptAmount());
                sessionSummaryReportData.setPayInOut(0.0 + cashDrawer.getPayOutAmount() * -1.0);
                sessionSummaryReportData.setVoids(cashDrawer.getTotalVoid());
                int n = StoreSessionDAO.getInstance().getStoreSessionTotalGuest(storeSession2);
                sessionSummaryReportData.setTotalGuest(n);
                sessionSummaryReportData.setRefund(cashDrawer.getRefundAmount());
                double d3 = n == 0 ? cashDrawer.getNetSales() : cashDrawer.getNetSales() / (double)n;
                sessionSummaryReportData.setAvgChk(d3);
                arrayList.add(sessionSummaryReportData);
            }
            if (arrayList.isEmpty()) {
                POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("DailySummaryReportView.0"));
                return;
            }
            JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("session_summary_subreport"));
            storeSession2 = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("session_summary_report"));
            object = new HashMap();
            ReportUtil.populateRestaurantProperties((Map)object);
            ReportUtil.populateReportHeader((HashMap)object, null, date, date2, null);
            ReportUtil.populateReportFooter((HashMap)object);
            this.a((HashMap)object);
            ((HashMap)object).put("reportTitle", POSConstants.SESSION_SUMMARY_REPORT);
            ((HashMap)object).put(POSConstants.TYPE, POSConstants.BY_RANGE_ACTUAL);
            ((HashMap)object).put("sessionSummaryReport", jasperReport);
            ((HashMap)object).put("sessionSummaryReportDatasource", new JRTableModelDataSource((TableModel)new SessionSummaryReportModel(arrayList)));
            cashDrawer = JasperFillManager.fillReport((JasperReport)storeSession2, (Map)object, (JRDataSource)new JREmptyDataSource());
            sessionSummaryReportData = new JRViewer((JasperPrint)cashDrawer);
            this.d.removeAll();
            this.d.add((Component)((Object)sessionSummaryReportData));
            this.d.revalidate();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(HashMap hashMap) {
        hashMap.put("colDate", POSConstants.DATE);
        hashMap.put("colSession", Messages.getString("SESSION"));
        hashMap.put("colOBalance", Messages.getString("Opening") + "<br/>" + Messages.getString("CustomerExplorer.13").toLowerCase());
        hashMap.put("colDeposits", Messages.getString("DEPOSITS"));
        hashMap.put("colOOutage", Messages.getString("OVER") + " " + Messages.getString("OUTAGE"));
        hashMap.put("colCash", POSConstants.CASH);
        hashMap.put("colTips", Messages.getString("SessionSummaryReportView.0"));
        hashMap.put("colRefund", POSConstants.REFUND_BUTTON_TEXT);
        hashMap.put("colOAccount", Messages.getString("OnAccount"));
        hashMap.put("colOPayment", Messages.getString("POSConstants.6") + "<br/>" + Messages.getString("PAYMENT"));
        hashMap.put("colPInOut", POSConstants.PAY + "<br/>" + Messages.getString("InOut"));
        hashMap.put("colVoids", Messages.getString("VOIDS"));
        hashMap.put("colTGuest", POSConstants.TOTAL + "<br/>" + Messages.getString("GUESTS").toLowerCase());
        hashMap.put("colACheck", Messages.getString("AVERAGE") + "<br/>" + Messages.getString("CHECK"));
        hashMap.put("rowGTotal", POSConstants.GRAND_TOTAL);
    }

    private void b() {
        this.b = UiUtil.getCurrentMonthStart();
        this.c = UiUtil.getCurrentMonthEnd();
        this.a = new JButton();
        this.a.setText(POSConstants.GO);
        this.a.addActionListener(actionEvent -> this.a());
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        jPanel.add(new JLabel(POSConstants.START_DATE + ":"));
        this.b.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.b);
        jPanel.add(new JLabel(POSConstants.END_DATE + ":"));
        this.c.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.c);
        jPanel.add((Component)this.a, "width 60!");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.add((Component)new JSeparator(), "North");
        this.d = new JPanel(new BorderLayout());
        jPanel2.add(this.d);
        this.add(jPanel2);
    }

    public static class SessionSummaryReportData {
        private String a;
        private String b;
        private double c;
        private double d;
        private double e;
        private double f;
        private double g;
        private double h;
        private double i;
        private double j;
        private double k;
        private int l;
        private double m;
        private double n;

        public String getPeriod() {
            return this.a;
        }

        public void setPeriod(String string) {
            this.a = string;
        }

        public double getDeposit() {
            return this.d;
        }

        public void setDeposit(double d) {
            this.d = d;
        }

        public double getOverOutage() {
            return this.e;
        }

        public void setOverOutage(double d) {
            this.e = d;
        }

        public double getCash() {
            return this.f;
        }

        public void setCash(double d) {
            this.f = d;
        }

        public double getOnAccount() {
            return this.h;
        }

        public void setOnAccount(double d) {
            this.h = d;
        }

        public double getOtherPayment() {
            return this.i;
        }

        public void setOtherPayment(double d) {
            this.i = d;
        }

        public double getPayInOut() {
            return this.j;
        }

        public void setPayInOut(double d) {
            this.j = d;
        }

        public double getVoids() {
            return this.k;
        }

        public void setVoids(double d) {
            this.k = d;
        }

        public int getTotalGuest() {
            return this.l;
        }

        public void setTotalGuest(int n) {
            this.l = n;
        }

        public double getAvgChk() {
            return this.m;
        }

        public void setAvgChk(double d) {
            this.m = d;
        }

        public String getSessionID() {
            return this.b;
        }

        public void setSessionID(String string) {
            this.b = string;
        }

        public double getOpeningBalance() {
            return this.c;
        }

        public void setOpeningBalance(double d) {
            this.c = d;
        }

        public double getTips() {
            return this.g;
        }

        public void setTips(double d) {
            this.g = d;
        }

        public double getRefund() {
            return this.n;
        }

        public void setRefund(double d) {
            this.n = d;
        }
    }
}

