/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.SalesSummaryDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.SalesStatistics;
import com.floreantpos.report.ShiftwiseSalesSummaryReportModel;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXDatePicker;

public class ShiftwiseSalesSummaryReportView
extends JPanel {
    public static final int REPORT_KEY_STATISTICS = 1;
    public static final int REPORT_SALES_ANALYSIS = 2;
    private JButton a;
    private JComboBox b;
    private JComboBox c;
    private JXDatePicker d;
    private JLabel e;
    private JLabel f;
    private JLabel g;
    private JLabel h;
    private JSeparator i;
    private JPanel j;
    private JXDatePicker k;
    private Date l;
    private Date m;
    private int n;
    private UserType o;
    private Terminal p;
    private int q;

    public ShiftwiseSalesSummaryReportView() {
        this.a();
        UserTypeDAO userTypeDAO = new UserTypeDAO();
        List<UserType> list = userTypeDAO.findAll();
        Vector<Object> vector = new Vector<Object>();
        vector.add(POSConstants.ALL);
        vector.addAll(list);
        this.c.setModel(new DefaultComboBoxModel(vector));
        TerminalDAO terminalDAO = new TerminalDAO();
        List<Terminal> list2 = terminalDAO.findAll();
        list2.add(0, (Terminal)((Object)POSConstants.ALL));
        this.b.setModel(new ListComboBoxModel(list2));
    }

    private void a() {
        this.e = new JLabel();
        this.f = new JLabel();
        this.g = new JLabel();
        this.h = new JLabel();
        this.d = UiUtil.getCurrentMonthStart();
        this.k = UiUtil.getCurrentMonthEnd();
        this.c = new JComboBox();
        this.b = new JComboBox();
        this.a = new JButton();
        this.i = new JSeparator();
        this.j = new JPanel();
        this.e.setText(POSConstants.FROM + ":");
        this.f.setText(POSConstants.TO + ":");
        this.g.setText(POSConstants.EMPLOYEE_TYPE + ":");
        this.h.setText(POSConstants.TERMINAL_LABEL + ":");
        this.a.setText(POSConstants.GO);
        this.a.addActionListener(actionEvent -> this.a(actionEvent));
        this.j.setLayout(new BorderLayout());
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.i, -1, 502, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.e).add((Component)this.f)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.k, -1, -1, Short.MAX_VALUE).add((Component)this.d, -1, -1, Short.MAX_VALUE)).add(20, 20, 20).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.g).add((Component)this.h)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.b, 0, -1, Short.MAX_VALUE).add((Component)this.c, 0, 137, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.a, -2, 72, -2)).add((Component)this.j, -1, 502, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.g).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.c, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.h).add((Component)this.b, -2, -1, -2).add((Component)this.a))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.e).add((Component)this.d, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.f).add((Component)this.k, -2, -1, -2)))).addPreferredGap(0).add((Component)this.i, -2, 10, -2).addPreferredGap(0).add((Component)this.j, -1, 303, Short.MAX_VALUE).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.b, this.c, this.g, this.h}, 2);
        groupLayout.linkSize(new Component[]{this.d, this.e, this.f, this.k}, 2);
    }

    private boolean b() {
        this.l = this.d.getDate();
        this.m = this.k.getDate();
        try {
            DateUtil.validateDate(this.l, this.m);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
            return false;
        }
        this.n = (int)((double)(this.m.getTime() - this.l.getTime()) * (1.15740741 * Math.pow(10.0, -8.0))) + 1;
        this.o = null;
        if (this.c.getSelectedItem() instanceof UserType) {
            this.o = (UserType)this.c.getSelectedItem();
        }
        this.p = null;
        if (this.b.getSelectedItem() instanceof Terminal) {
            this.p = (Terminal)this.b.getSelectedItem();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(this.l);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        this.l = calendar.getTime();
        calendar.clear();
        calendar2.setTime(this.m);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        this.m = calendar.getTime();
        return true;
    }

    private void a(ActionEvent actionEvent) {
        try {
            if (!this.b()) {
                return;
            }
            if (this.q == 1) {
                this.d();
            } else if (this.q == 2) {
                this.c();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void c() throws Exception {
        SalesSummaryDAO salesSummaryDAO = new SalesSummaryDAO();
        List<ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData> list = salesSummaryDAO.findSalesAnalysis(this.l, this.m, this.o, this.p);
        String string = this.o == null ? POSConstants.ALL : this.o.getName();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(hashMap, true);
        ReportUtil.populateReportHeader(hashMap, this.p, this.l, this.m, string);
        ReportUtil.populateReportFooter(hashMap);
        hashMap.put("subtitle", POSConstants.SALES_SUMMARY_REPORT);
        hashMap.put("colCategory", POSConstants.CATEGORY);
        hashMap.put("colCount", POSConstants.COUNT);
        hashMap.put("colGross", Messages.getString("GROSS"));
        hashMap.put("colDiscount", POSConstants.DISCOUNT);
        hashMap.put("colTaxAmnt", Messages.getString("TAX_AMOUNT"));
        hashMap.put("colNSales", POSConstants.NET_SALES);
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("shiftwise_sales_summary_report"));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)new ShiftwiseSalesSummaryReportModel(list)));
        this.a(jasperPrint);
    }

    private void d() throws Exception {
        SalesSummaryDAO salesSummaryDAO = new SalesSummaryDAO();
        SalesStatistics salesStatistics = salesSummaryDAO.findKeyStatistics(this.l, this.m, this.o, this.p);
        String string = this.o == null ? POSConstants.ALL : this.o.getName();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(hashMap, true);
        ReportUtil.populateReportHeader(hashMap, this.p, this.l, this.m, string);
        ReportUtil.populateReportFooter(hashMap);
        this.a(hashMap);
        hashMap.put("shift", ReportUtil.reportLabelWithBoldTag(POSConstants.SHIFT_WITH_CLONE) + " " + POSConstants.ALL);
        hashMap.put("days", ReportUtil.reportLabelWithBoldTag(POSConstants.DAYS) + " " + String.valueOf(this.n));
        hashMap.put("subtitle", POSConstants.SALES_SUMMARY_REPORT);
        hashMap.put("Capacity", String.valueOf(salesStatistics.getCapacity()));
        hashMap.put("GuestCount", String.valueOf(salesStatistics.getGuestCount()));
        hashMap.put("GuestPerSeat", NumberUtil.formatNumber(salesStatistics.getGuestPerSeat()));
        hashMap.put("Capacity", String.valueOf(salesStatistics.getCapacity()));
        hashMap.put("GuestCount", String.valueOf(salesStatistics.getGuestCount()));
        hashMap.put("GuestPerSeat", NumberUtil.formatNumber(salesStatistics.getGuestPerCheck()));
        hashMap.put("TableTrnOvr", NumberUtil.formatNumber(salesStatistics.getTableTurnOver()));
        hashMap.put("AVGGuest", NumberUtil.formatNumber(salesStatistics.getAvgGuest()));
        hashMap.put("OpenChecks", String.valueOf(salesStatistics.getOpenChecks()));
        hashMap.put("VOIDChecks", String.valueOf(salesStatistics.getVoidChecks()));
        hashMap.put("OPPDChecks", String.valueOf(" "));
        hashMap.put("TRNGChecks", String.valueOf(" "));
        hashMap.put("ROPNChecks", String.valueOf(salesStatistics.getRopnChecks()));
        hashMap.put("MergeChecks", String.valueOf(" "));
        hashMap.put("LaborHour", NumberUtil.formatNumber(salesStatistics.getLaborHour()));
        hashMap.put("LaborSales", NumberUtil.formatNumber(salesStatistics.getGrossSale()));
        hashMap.put("Tables", String.valueOf(salesStatistics.getTables()));
        hashMap.put("CheckCount", String.valueOf(salesStatistics.getCheckCount()));
        hashMap.put("GuestPerChecks", NumberUtil.formatNumber(salesStatistics.getGuestPerCheck()));
        hashMap.put("TrnOvrTime", String.valueOf(" "));
        hashMap.put("AVGChecks", NumberUtil.formatNumber(salesStatistics.getAvgCheck()));
        hashMap.put("OPENAmount", NumberUtil.formatNumber(salesStatistics.getOpenAmount()));
        hashMap.put("VOIDAmount", NumberUtil.formatNumber(salesStatistics.getVoidAmount()));
        hashMap.put("PAIDChecks", String.valueOf(salesStatistics.getPaidChecks()));
        hashMap.put("TRNGAmount", String.valueOf(" "));
        hashMap.put("ROPNAmount", NumberUtil.formatNumber(salesStatistics.getRopnAmount()));
        hashMap.put("NTaxChecks", String.valueOf(salesStatistics.getNtaxChecks()));
        hashMap.put("NTaxAmount", NumberUtil.formatNumber(salesStatistics.getNtaxAmount()));
        hashMap.put("MergeAmount", String.valueOf(" "));
        hashMap.put("Labor", NumberUtil.formatNumber(salesStatistics.getLaborCost()));
        hashMap.put("LaborCost", NumberUtil.formatNumber(salesStatistics.getLaborCost() / salesStatistics.getGrossSale() * 100.0));
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("key_statistics_report"));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)new SalesStatistics.ShiftwiseDataTableModel(salesStatistics.getSalesTableDataList())));
        this.a(jasperPrint);
    }

    private void a(HashMap hashMap) {
        hashMap.put("lblKSRT", ReportUtil.reportLabelWithBoldTag(Messages.getString("KeyStatistics")));
        hashMap.put("lblCapacity", ReportUtil.reportLabelWithBoldTag(POSConstants.CAPACITY));
        hashMap.put("lblGuestCount", ReportUtil.reportLabelWithBoldTag(Messages.getString("GuestCount")));
        hashMap.put("lblGuestSeat", ReportUtil.reportLabelWithBoldTag(Messages.getString("GuestSeat")));
        hashMap.put("lblTableTrnOvr", ReportUtil.reportLabelWithBoldTag(Messages.getString("TableTrnOvr")));
        hashMap.put("lblAVGGuest", ReportUtil.reportLabelWithBoldTag(Messages.getString("AVGGuest")));
        hashMap.put("lblOpenChecks", ReportUtil.reportLabelWithBoldTag(Messages.getString("OpenChecks")));
        hashMap.put("lblVoidChecks", ReportUtil.reportLabelWithBoldTag(Messages.getString("VoidChecks")));
        hashMap.put("lblOPPDChecks", ReportUtil.reportLabelWithBoldTag(Messages.getString("OPPDChecks")));
        hashMap.put("lblTRNGChecks", ReportUtil.reportLabelWithBoldTag(Messages.getString("TRNGChecks")));
        hashMap.put("lblROPNChecks", ReportUtil.reportLabelWithBoldTag(Messages.getString("ROPNChecks")));
        hashMap.put("lblNTaxChecks", ReportUtil.reportLabelWithBoldTag(Messages.getString("NTaxChecks")));
        hashMap.put("lblMergeChecks", ReportUtil.reportLabelWithBoldTag(Messages.getString("MergeChecks")));
        hashMap.put("lblLaborHour", ReportUtil.reportLabelWithBoldTag(Messages.getString("LaborHour")));
        hashMap.put("lblLaborSales", ReportUtil.reportLabelWithBoldTag(Messages.getString("LaborSales")));
        hashMap.put("lblTables", ReportUtil.reportLabelWithBoldTag(POSConstants.TABLES));
        hashMap.put("lblCheckCount", ReportUtil.reportLabelWithBoldTag(Messages.getString("CheckCount")));
        hashMap.put("lblGuestChecks", ReportUtil.reportLabelWithBoldTag(Messages.getString("GuestChecks")));
        hashMap.put("lblTrnOvrTime", ReportUtil.reportLabelWithBoldTag(Messages.getString("TrnOvrTime")));
        hashMap.put("lblAVGCheck", ReportUtil.reportLabelWithBoldTag(Messages.getString("AVGCheck")));
        hashMap.put("lblOpentAmnt", ReportUtil.reportLabelWithBoldTag(Messages.getString("OpenAmount")));
        hashMap.put("lblVoidAmntTx", ReportUtil.reportLabelWithBoldTag(Messages.getString("VoidAmntTx")));
        hashMap.put("lblPaidChecks", ReportUtil.reportLabelWithBoldTag(Messages.getString("PaidChecks")));
        hashMap.put("lblTRNGAmount", ReportUtil.reportLabelWithBoldTag(Messages.getString("TRNGAmount")));
        hashMap.put("lblROPNAmount", ReportUtil.reportLabelWithBoldTag(Messages.getString("ROPNAmount")));
        hashMap.put("lblNTaxAmount", ReportUtil.reportLabelWithBoldTag(Messages.getString("NTaxAmount")));
        hashMap.put("lblMergeAmount", ReportUtil.reportLabelWithBoldTag(Messages.getString("MergeAmount")));
        hashMap.put("lblLabor", ReportUtil.reportLabelWithBoldTag(Messages.getString("Labor")));
        hashMap.put("lblLaborCost", ReportUtil.reportLabelWithBoldTag(Messages.getString("LaborCost")));
        hashMap.put("lblDayPart", ReportUtil.reportLabelWithBoldTag(Messages.getString("DayPart")));
        hashMap.put("lblProfitCenter", ReportUtil.reportLabelWithBoldTag(Messages.getString("ProfitCenter")));
        hashMap.put("lblCheck", ReportUtil.reportLabelWithBoldTag(Messages.getString("CHECK")));
        hashMap.put("lblGuest", ReportUtil.reportLabelWithBoldTag(Messages.getString("OrderView.27")));
        hashMap.put("lblSales", ReportUtil.reportLabelWithBoldTag(POSConstants.SALES));
        hashMap.put("lblAVGCheck", ReportUtil.reportLabelWithBoldTag(Messages.getString("AVGCheck")));
        hashMap.put("lblAVGGuest", ReportUtil.reportLabelWithBoldTag(Messages.getString("AVGGuest")));
    }

    private void a(JasperPrint jasperPrint) {
        JRViewer jRViewer = new JRViewer(jasperPrint);
        this.j.removeAll();
        this.j.add((Component)jRViewer);
        this.j.revalidate();
    }

    public int getReportType() {
        return this.q;
    }

    public void setReportType(int n) {
        this.q = n;
    }
}

