/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.config.CardConfig;
import com.floreantpos.config.GiftCardConfig;
import com.floreantpos.extension.GiftCardPaymentPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.CashBreakdown;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CashDropTransaction;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Customer;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.StoreSessionControl;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BasePosTransaction;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.services.PostPaymentProcessor;
import com.floreantpos.ui.dialog.MultiCurrencyTenderDialog;
import com.floreantpos.ui.views.payment.CardProcessor;
import com.floreantpos.ui.views.payment.GiftCardProcessor;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.StoreUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class PosTransactionService {
    private static PosTransactionService a = new PosTransactionService();

    public void settleTicket(Ticket ticket, PosTransaction posTransaction, User user) throws Exception {
        this.settleTicket(ticket, posTransaction, user, null, null);
    }

    public void settleTicket(Ticket ticket, PosTransaction posTransaction, User user, PostPaymentProcessor postPaymentProcessor, List<MultiCurrencyTenderDialog.PaymentByCurrency> list) throws Exception {
        if (user == null) {
            user = Application.getCurrentUser();
        }
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        Transaction transaction = null;
        boolean bl = ticket.getId() == null;
        try (Session session = TerminalDAO.getInstance().createNewSession();){
            StoreSession storeSession;
            Date date = StoreDAO.getServerTimestamp();
            transaction = session.beginTransaction();
            CashDrawer cashDrawer = user.getActiveDrawerPullReport();
            this.adjustMulticurrencyBalance(session, terminal, cashDrawer, list, posTransaction);
            ticket.setVoided(false);
            ticket.setTerminal(terminal);
            ticket.setPaidAmount(ticket.getPaidAmount() + posTransaction.getAmount());
            if (ticket.isSourceOnline()) {
                ticket.setDueAmount(ticket.getTotalAmountWithTips() - ticket.getPaidAmount());
            } else {
                ticket.calculatePrice();
            }
            if (NumberUtil.roundToTwoDigit(ticket.getDueAmount()) == 0.0) {
                ticket.setPaid(true);
                PosTransactionService.closeTicketIfApplicable(ticket, date);
            } else {
                ticket.setPaid(false);
                ticket.setClosed(false);
            }
            posTransaction.setTransactionType(TransactionType.CREDIT.name());
            posTransaction.setPaymentType(posTransaction.getPaymentType());
            posTransaction.setTerminal(terminal);
            posTransaction.setUser(user);
            posTransaction.setServer(ticket.getOwner());
            posTransaction.setCashDrawer(cashDrawer);
            posTransaction.setTransactionTime(date);
            posTransaction.setCustomerId(ticket.getCustomerId());
            StoreSessionControl storeSessionControl = StoreUtil.getCurrentStoreOperation();
            if (storeSessionControl != null && (storeSession = storeSessionControl.getCurrentData()) != null) {
                posTransaction.setStoreSessionId(storeSession.getId());
            }
            ticket.setCashier(user);
            if (posTransaction.getAmount() > 0.0) {
                ticket.addTotransactions(posTransaction);
            }
            this.a(ticket, posTransaction, session);
            this.b(ticket, posTransaction);
            this.c(ticket, posTransaction);
            posTransaction.calculateTaxAmount();
            posTransaction.calculateServiceChargeAmount();
            if (ticket.getOrderType() != null && ticket.getOrderType().getName() == "BAR_TAB") {
                ticket.removeProperty("payment_method");
                ticket.removeProperty("card_name");
                ticket.removeProperty("card_transaction_id");
                ticket.removeProperty("card_tracks");
                ticket.removeProperty("card_reader");
                ticket.removeProperty("advance_payment");
                ticket.removeProperty("card_number");
                ticket.removeProperty("card_exp_year");
                ticket.removeProperty("card_exp_month");
                ticket.removeProperty("card_auth_code");
            }
            ticket.setShouldUpdateStock(true);
            TicketDAO.getInstance().saveOrUpdate(ticket, session);
            this.b(ticket, posTransaction, session);
            if (postPaymentProcessor != null) {
                postPaymentProcessor.paymentDone(posTransaction, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                PosLog.error(PosTransactionService.class, exception2);
            }
            throw exception;
        }
        ActionHistoryDAO.getInstance().performActionHistorySaveOperation(ticket, bl);
        this.a(ticket, posTransaction);
    }

    public void adjustMulticurrencyBalance(Session session, Terminal terminal, CashDrawer cashDrawer, List<MultiCurrencyTenderDialog.PaymentByCurrency> list, PosTransaction posTransaction) {
        if (cashDrawer == null) {
            return;
        }
        if (posTransaction.getPaymentType() != PaymentType.CASH) {
            return;
        }
        if (terminal.isEnableMultiCurrency().booleanValue()) {
            CashDrawerDAO.getInstance().refresh(cashDrawer, session);
            if (list == null) {
                if (posTransaction.isVoided().booleanValue()) {
                    list = new ArrayList<MultiCurrencyTenderDialog.PaymentByCurrency>();
                    List<Currency> list2 = CurrencyUtil.getAllCurrency();
                    if (list2 != null && list2.size() > 0) {
                        for (Currency currency : list2) {
                            MultiCurrencyTenderDialog.PaymentByCurrency paymentByCurrency2 = new MultiCurrencyTenderDialog.PaymentByCurrency();
                            paymentByCurrency2.currency = currency;
                            String string = currency.getId() + "_CASH_BACK";
                            String string2 = currency.getId() + "_TENDERED";
                            double d = POSUtil.parseDouble(posTransaction.getProperty(string2));
                            if (!(d > 0.0)) continue;
                            double d2 = POSUtil.parseDouble(posTransaction.getProperty(string));
                            double d3 = d - d2;
                            paymentByCurrency2.tenderedAmount = -1.0 * d3;
                            list.add(paymentByCurrency2);
                        }
                    }
                } else {
                    Double d = 0.0;
                    MultiCurrencyTenderDialog.PaymentByCurrency paymentByCurrency3 = new MultiCurrencyTenderDialog.PaymentByCurrency();
                    paymentByCurrency3.currency = CurrencyUtil.getMainCurrency();
                    paymentByCurrency3.tenderedAmount = posTransaction.getAmount();
                    if (posTransaction instanceof RefundTransaction || posTransaction instanceof PayOutTransaction || posTransaction instanceof CashDropTransaction) {
                        paymentByCurrency3.tenderedAmount = -1.0 * posTransaction.getAmount();
                    }
                    if (!(posTransaction instanceof RefundTransaction || posTransaction instanceof PayOutTransaction || posTransaction instanceof CashDropTransaction)) {
                        d = posTransaction.getTicket().getDueAmount();
                        paymentByCurrency3.cashBackAmount = d > paymentByCurrency3.tenderedAmount ? 0.0 : paymentByCurrency3.tenderedAmount - d;
                    }
                    list = Arrays.asList(paymentByCurrency3);
                }
            }
            list.forEach(paymentByCurrency -> {
                Currency currency = paymentByCurrency.currency;
                CashBreakdown cashBreakdown = cashDrawer.getCurrencyBalance(currency);
                double d = paymentByCurrency.tenderedAmount - paymentByCurrency.cashBackAmount;
                if (cashBreakdown != null) {
                    cashBreakdown.setBalance(cashBreakdown.getBalance() + d);
                }
                if (!posTransaction.isVoided().booleanValue()) {
                    String string = paymentByCurrency.currency.getId() + "_CASH_BACK";
                    String string2 = paymentByCurrency.currency.getId() + "_TENDERED";
                    posTransaction.addProperty(string2, String.valueOf(paymentByCurrency.tenderedAmount));
                    posTransaction.addProperty(string, String.valueOf(paymentByCurrency.cashBackAmount));
                }
            });
            session.saveOrUpdate((Object)cashDrawer);
        }
    }

    private void a(Ticket ticket, PosTransaction posTransaction) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Total: " + NumberUtil.formatNumber(ticket.getTotalAmountWithTips()));
        stringBuilder.append(". Transaction amount: " + NumberUtil.formatNumber(posTransaction.getAmount()));
        ActionHistoryDAO.saveHistory(Application.getCurrentUser(), ticket, posTransaction, "Settle check", stringBuilder.toString());
    }

    private void a(Ticket ticket, PosTransaction posTransaction, Session session) {
        Store store = DataProvider.get().getStore();
        Boolean bl = Boolean.valueOf(store.getProperty("loyalty.enabled"));
        if (!bl.booleanValue()) {
            return;
        }
        Customer customer = ticket.getCustomer();
        if (customer == null) {
            return;
        }
        customer = CustomerDAO.getInstance().get(customer.getId(), session);
        this.a(ticket, customer, posTransaction);
        this.a(ticket, posTransaction, store, customer, session);
        ticket.updateCustomer(customer);
    }

    private void a(Ticket ticket, Customer customer, PosTransaction posTransaction) {
        if (ticket == null) {
            throw new PosException(Messages.getString("PosTransactionService.0"));
        }
        if (ticket.getDiscounts() == null) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ticket.getDiscounts().forEach(ticketDiscount -> {
            if (!ticketDiscount.isLoyaltyCharged()) {
                arrayList.add(ticketDiscount);
            }
        });
        if (arrayList.isEmpty()) {
            return;
        }
        if (customer == null) {
            throw new PosException(Messages.getString("PosTransactionService.3"));
        }
        int n = 0;
        for (TicketDiscount ticketDiscount2 : arrayList) {
            int n2 = ticketDiscount2.getLoyaltyPoint();
            int n3 = customer.getLoyaltyPoint();
            customer.setLoyaltyPoint(n3 - n2);
            ticketDiscount2.setLoyaltyCharged(Boolean.TRUE);
            n += n2;
        }
        posTransaction.addExtraProperty("loyalty.charged_amount", String.valueOf(n));
        ticket.buildDiscounts();
    }

    private void a(Ticket ticket, PosTransaction posTransaction, Store store, Customer customer, Session session) {
        if (ticket == null) {
            throw new PosException(Messages.getString("PosTransactionService.0"));
        }
        if (posTransaction == null) {
            throw new PosException(Messages.getString("PosTransactionService.5"));
        }
        if (store == null) {
            throw new PosException(Messages.getString("PosTransactionService.6"));
        }
        if (customer == null) {
            return;
        }
        Integer n = customer.getLoyaltyPoint();
        int n2 = 0;
        try {
            String string = ticket.getProperty("loyalty");
            Boolean bl = string != null && Boolean.valueOf(string) != false;
            if (!bl.booleanValue()) {
                int n3 = Integer.parseInt(store.getProperty("loyalty.pointForVisit"));
                if (n3 > 0) {
                    n2 = n3;
                }
                ticket.addProperty("loyalty", String.valueOf(Boolean.TRUE));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        n = n + n2;
        int n4 = 0;
        try {
            int n5 = Integer.parseInt(store.getProperty("loyalty.pointForPuchases"));
            if (n5 > 0) {
                n4 = (int)(posTransaction.getAmount() / (double)n5);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        n = n + n4;
        posTransaction.addExtraProperty("transaction.loyalty_point_earned", String.valueOf(n4));
        customer.setLoyaltyPoint(n);
        CustomerDAO.getInstance().update(customer, session);
    }

    private void a(Customer customer, double d) {
        if (customer == null || d <= 0.0) {
            return;
        }
        Store store = DataProvider.get().getStore();
        Boolean bl = Boolean.valueOf(store.getProperty("loyalty.enabled"));
        Boolean bl2 = Boolean.valueOf(store.getProperty("loyalty.deductPointOnRefund"));
        if (!bl.booleanValue() || !bl2.booleanValue()) {
            return;
        }
        Integer n = customer.getLoyaltyPoint();
        Integer n2 = 0;
        try {
            int n3 = Integer.parseInt(store.getProperty("loyalty.pointForPuchases"));
            if (n3 > 0) {
                n2 = (int)Math.ceil(d / (double)n3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        n = n - n2;
        customer.setLoyaltyPoint(n > 0 ? n : 0);
        CustomerDAO.getInstance().update(customer);
    }

    private void b(Ticket ticket, PosTransaction posTransaction) {
        double d;
        double d2 = 0.0;
        Currency currency = CurrencyUtil.getMainCurrency();
        if (currency != null) {
            d2 = currency.getTolerance();
        }
        if (ticket.getRoundedDueAmount() == 0.0 || ticket.getRoundedDueAmount() <= d2) {
            posTransaction.setToleranceAmount(ticket.getToleranceAmount());
        }
        if ((d = NumberUtil.round(posTransaction.getTenderAmount() - posTransaction.getAmount())) == 0.0) {
            return;
        }
        Store store = DataProvider.get().getStore();
        double d3 = store.isAllowPenyRounding() ? (double)Math.round(d * 100.0 / 5.0) * 5.0 / 100.0 : d;
        double d4 = d - d3;
        if (Math.abs(d3) <= d2) {
            posTransaction.setToleranceAmount(d);
            posTransaction.setChangeAmount(0.0);
        } else {
            posTransaction.setToleranceAmount(d4);
            posTransaction.setChangeAmount(d3);
        }
        posTransaction.setAmount(posTransaction.getAmount() + posTransaction.getToleranceAmount());
    }

    public void settleBarTabTicket(Ticket ticket, PosTransaction posTransaction, boolean bl, User user) throws Exception {
        Application application = Application.getInstance();
        Terminal terminal = application.refreshAndGetTerminal();
        Transaction transaction = null;
        GenericDAO genericDAO = new GenericDAO();
        try (Session session = genericDAO.createNewSession();){
            Date date = StoreDAO.getServerTimestamp();
            transaction = session.beginTransaction();
            ticket.setVoided(false);
            ticket.setTerminal(terminal);
            ticket.setPaidAmount(ticket.getPaidAmount() + posTransaction.getAmount());
            ticket.calculatePrice();
            if (bl) {
                ticket.setPaid(true);
                PosTransactionService.closeTicketIfApplicable(ticket, date);
            } else {
                ticket.setPaid(false);
                ticket.setClosed(false);
            }
            posTransaction.setTransactionType(TransactionType.CREDIT.name());
            posTransaction.setPaymentType(posTransaction.getPaymentType());
            posTransaction.setTerminal(terminal);
            posTransaction.setUser(user);
            posTransaction.setServer(ticket.getOwner());
            posTransaction.setCashDrawer(user.getActiveDrawerPullReport());
            posTransaction.setTransactionTime(date);
            ticket.setCashier(user);
            ticket.addTotransactions(posTransaction);
            ticket.setShouldUpdateStock(true);
            TicketDAO.getInstance().saveOrUpdate(ticket, session);
            transaction.commit();
        }
        catch (Exception exception) {
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        this.a(ticket, posTransaction);
    }

    public static void closeTicketIfApplicable(Ticket ticket, Date date) {
        OrderType orderType = ticket.getOrderType();
        if (orderType != null && (orderType.isCloseOnPaid().booleanValue() || orderType.isBarTab().booleanValue())) {
            ticket.setClosed(true);
            ticket.setClosingDate(date);
        }
    }

    private void c(Ticket ticket, PosTransaction posTransaction) {
        double d = ticket.getGratuityAmount();
        if (d <= 0.0) {
            return;
        }
        double d2 = 0.0;
        Set<PosTransaction> set = ticket.getTransactions();
        if (set != null && set.size() > 0) {
            for (PosTransaction posTransaction2 : set) {
                if (posTransaction2 instanceof RefundTransaction || posTransaction2.isVoided().booleanValue()) continue;
                d2 += posTransaction2.getTipsAmount().doubleValue();
            }
        }
        double d3 = d - d2;
        double d4 = d3 + ticket.getPaidAmount() - ticket.getTotalAmountWithTips();
        if (d3 > 0.0) {
            if (ticket.getDueAmount() == 0.0) {
                posTransaction.setTipsAmount(d3);
            } else if (d4 > 0.0) {
                Double d5 = posTransaction.getAmount();
                if (d4 > d5) {
                    posTransaction.setTipsAmount(d5);
                } else {
                    posTransaction.setTipsAmount(NumberUtil.roundToTwoDigit(d4));
                }
            }
        }
    }

    public void voidTicket(Ticket ticket, User user) throws Exception {
        Terminal terminal = Application.getInstance().getTerminal();
        ticket.setVoidedBy(user);
        ticket.setTerminal(terminal);
        ticket.calculatePrice();
        TicketDAO.getInstance().voidTicket(ticket);
        try {
            ReceiptPrintService.printVoidTicket(ticket);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private double a(PosTransaction posTransaction) {
        double d = 0.0;
        String string = posTransaction.getProperty("REFUNDED_AMOUNT");
        if (StringUtils.isNotEmpty((String)string)) {
            try {
                d = NumberUtil.parseDouble(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return NumberUtil.roundToTwoDigit(posTransaction.getAmount() - d);
    }

    public double refundTicket(Ticket ticket, double d, Double d2, User user, List<PosTransaction> list, PaymentType paymentType, Map<String, String> map) throws Exception {
        double d3;
        if (map == null) {
            map = new HashMap<String, String>();
        }
        double d4 = d;
        boolean bl = false;
        if (list == null || list.isEmpty()) {
            RefundTransaction refundTransaction = this.createRefundTransaction(ticket, null, d, paymentType, map);
            refundTransaction.setUser(user);
            refundTransaction.setPaymentType(paymentType);
            ticket.addTotransactions(refundTransaction);
            ticket.setRefunded(true);
            ticket.setCashier(user);
            ticket.calculateRefundAmount();
            ticket.calculatePrice();
            if (NumberUtil.roundToTwoDigit(ticket.getDueAmount()) == 0.0) {
                ticket.setClosed(true);
                ticket.setClosingDate(StoreDAO.getServerTimestamp());
            }
            Object transaction = null;
            try (Session session = TicketDAO.getInstance().createNewSession();){
                Transaction comparable = session.beginTransaction();
                ticket.setShouldUpdateStock(true);
                TicketDAO.getInstance().saveOrUpdate(ticket, session);
                if (bl) {
                    CustomerDAO.getInstance().saveOrUpdate(ticket.getCustomer(), session);
                }
                if (paymentType == PaymentType.GIFT_CERTIFICATE) {
                    String string = map.get(PosTransaction.PROP_GIFT_CERT_NUMBER);
                    if (StringUtils.isBlank((String)string)) {
                        throw new PosException(Messages.getString("GiftCardCannotBeEmpty"));
                    }
                    GiftCard giftCard = GiftCardDAO.getInstance().get(string, session);
                    if (giftCard != null) {
                        giftCard.setBalance(giftCard.getBalance() + refundTransaction.getAmount());
                        GiftCardDAO.getInstance().update(giftCard, session);
                    }
                }
                comparable.commit();
            }
            catch (Exception exception) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw exception;
            }
            return d;
        }
        if (list.size() > 1) {
            for (PosTransaction posTransaction : list) {
                if (this.a(posTransaction) != d) continue;
                list = new ArrayList<PosTransaction>();
                list.add(posTransaction);
                break;
            }
        }
        for (PosTransaction posTransaction : list) {
            double d5 = this.a(posTransaction);
            if (d5 > d4) {
                d5 = d4;
            }
            if (!(d5 <= d4)) continue;
            double d6 = d2 * d5 / d;
            this.refundTicket(ticket, d5, d6, user, posTransaction, paymentType, map);
            if (!posTransaction.isRefunded()) continue;
            d4 -= d5;
            if (paymentType != PaymentType.MEMBER_ACCOUNT) continue;
            bl = true;
        }
        if (d != d4) {
            ticket.setRefunded(true);
            ticket.setCashier(user);
            ticket.calculateRefundAmount();
            ticket.calculatePrice();
            if (NumberUtil.roundToTwoDigit(ticket.getDueAmount()) == 0.0) {
                ticket.setClosed(true);
                ticket.setClosingDate(StoreDAO.getServerTimestamp());
            }
            this.a(ticket);
            Transaction transaction = null;
            Terminal terminal = DataProvider.get().getCurrentTerminal();
            CashDrawer cashDrawer = user.getActiveDrawerPullReport();
            try (Session session = TicketDAO.getInstance().createNewSession();){
                transaction = session.beginTransaction();
                Set<PosTransaction> set = ticket.getTransactions();
                for (PosTransaction posTransaction : set) {
                    if (!(posTransaction instanceof RefundTransaction) || posTransaction.getId() != null || posTransaction.getPaymentType() != PaymentType.CASH) continue;
                    this.adjustMulticurrencyBalance(session, terminal, cashDrawer, null, posTransaction);
                }
                ticket.setShouldUpdateStock(true);
                TicketDAO.getInstance().saveOrUpdate(ticket, session);
                if (bl) {
                    CustomerDAO.getInstance().saveOrUpdate(ticket.getCustomer(), session);
                }
                transaction.commit();
            }
            catch (Exception exception) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw exception;
            }
        }
        if ((d3 = d - d4) > 0.0) {
            this.a(ticket.getCustomer(), d3);
        }
        return d3;
    }

    private void a(Ticket ticket) {
        BasePosTransaction basePosTransaction = null;
        Iterator<PosTransaction> iterator = ticket.getTransactions().iterator();
        while (iterator.hasNext()) {
            PosTransaction posTransaction = iterator.next();
            if (!(posTransaction instanceof RefundTransaction) || posTransaction.getId() != null || posTransaction.getPaymentType() != PaymentType.CASH) continue;
            if (basePosTransaction != null) {
                basePosTransaction.setAmount(basePosTransaction.getAmount() + posTransaction.getAmount());
                basePosTransaction.setTipsAmount(basePosTransaction.getTipsAmount() + posTransaction.getTipsAmount());
                basePosTransaction.setTaxAmount(basePosTransaction.getTaxAmount() + posTransaction.getTaxAmount());
                iterator.remove();
                continue;
            }
            if (posTransaction.getId() != null) continue;
            basePosTransaction = (RefundTransaction)posTransaction;
        }
    }

    public void refundTicket(Ticket ticket, double d, double d2, User user, PosTransaction posTransaction, PaymentType paymentType, Map<String, String> map) throws Exception {
        Object object;
        if (d <= 0.0) {
            return;
        }
        if (paymentType == PaymentType.GIFT_CERTIFICATE) {
            object = map.get(PosTransaction.PROP_GIFT_CERT_NUMBER);
            if (StringUtils.isBlank((String)object)) {
                throw new PosException(Messages.getString("GiftCardCannotBeEmpty"));
            }
            GiftCardPaymentPlugin giftCardPaymentPlugin = GiftCardConfig.getPaymentGateway();
            GiftCardProcessor giftCardProcessor = giftCardPaymentPlugin.getProcessor();
            giftCardProcessor.refund((String)object, d);
        } else if (paymentType == PaymentType.CREDIT_CARD || paymentType == PaymentType.DEBIT_CARD) {
            if (StringUtils.isNotBlank((String)posTransaction.getCardMerchantGateway()) && CardReader.fromString(posTransaction.getCardReader()) != CardReader.EXTERNAL_TERMINAL) {
                double d3 = posTransaction.getAmount();
                CardProcessor cardProcessor = CardConfig.getPaymentGatewayByName(posTransaction.getCardMerchantGateway()).getProcessor();
                try {
                    posTransaction.setAmount(d);
                    cardProcessor.refundTransaction(posTransaction, d);
                }
                catch (PosException posException) {
                    throw posException;
                }
                catch (Exception exception) {
                    throw new PosException(Messages.getString("PosTransactionService.2"));
                }
                finally {
                    posTransaction.setAmount(d3);
                }
            }
        } else if (paymentType == PaymentType.MEMBER_ACCOUNT) {
            Customer customer = ticket.getCustomer();
            if (customer == null) {
                throw new PosException(Messages.getString("PosTransactionService.1"));
            }
            customer.setBalance(customer.getBalance() + d);
            posTransaction.setRefunded(true);
        }
        object = this.createRefundTransaction(ticket, posTransaction, d, paymentType, map);
        ((PosTransaction)object).setPaymentType(paymentType);
        ((PosTransaction)object).setUser(user);
        ((PosTransaction)object).setServer(ticket.getOwner());
        ((BasePosTransaction)object).setTaxAmount(d2);
        ((BasePosTransaction)object).setCustomerId(ticket.getCustomerId());
        ticket.addTotransactions((PosTransaction)object);
        posTransaction.setRefunded(true);
    }

    public RefundTransaction createRefundTransaction(Ticket ticket, PosTransaction posTransaction, double d, PaymentType paymentType, Map<String, String> map) {
        RefundTransaction refundTransaction = new RefundTransaction();
        if (map != null) {
            refundTransaction.setCustomPaymentFieldName(map.get(PosTransaction.PROP_CUSTOM_PAYMENT_FIELD_NAME));
            refundTransaction.setCustomPaymentName(map.get(PosTransaction.PROP_CUSTOM_PAYMENT_NAME));
            refundTransaction.setCustomPaymentRef(map.get(PosTransaction.PROP_CUSTOM_PAYMENT_REF));
            refundTransaction.setGiftCertNumber(map.get(PosTransaction.PROP_GIFT_CERT_NUMBER));
        }
        refundTransaction.setAmount(d);
        refundTransaction.setTicket(ticket);
        refundTransaction.setTerminal(DataProvider.get().getCurrentTerminal());
        refundTransaction.setTransactionType(TransactionType.DEBIT.name());
        refundTransaction.setCashDrawer(Application.getCurrentUser().getActiveDrawerPullReport());
        refundTransaction.setTransactionTime(StoreDAO.getServerTimestamp());
        refundTransaction.setStoreSessionId(DataProvider.get().getStoreSession().getId());
        if (posTransaction == null) {
            return refundTransaction;
        }
        refundTransaction.setCardExpMonth(posTransaction.getCardExpMonth());
        refundTransaction.setCardHolderName(posTransaction.getCardHolderName());
        refundTransaction.setCardAuthCode(posTransaction.getCardAuthCode());
        refundTransaction.setCardMerchantGateway(posTransaction.getCardMerchantGateway());
        refundTransaction.setCardNumber(posTransaction.getCardNumber());
        refundTransaction.setCardTrack(posTransaction.getCardTrack());
        refundTransaction.setCardTransactionId(posTransaction.getCardTransactionId());
        refundTransaction.setCardReader(posTransaction.getCardReader());
        refundTransaction.setCardType(posTransaction.getCardType());
        refundTransaction.addProperty("REFUNDED_TRANSACTION_ID", posTransaction.getId());
        String string = posTransaction.getProperty("REFUNDED_AMOUNT");
        double d2 = 0.0;
        if (StringUtils.isNotEmpty((String)string)) {
            try {
                d2 = NumberUtil.parseDouble(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        posTransaction.addProperty("REFUNDED_AMOUNT", String.valueOf(d + d2));
        if (posTransaction.getTipsAmount() > 0.0) {
            double d3;
            double d4;
            double d5;
            String string2 = posTransaction.getProperty("REFUNDED_TIPS_AMOUNT");
            double d6 = 0.0;
            if (StringUtils.isNotEmpty((String)string)) {
                try {
                    d6 = NumberUtil.parseDouble(string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((d5 = (d4 = d2 + d) - (d3 = posTransaction.getAmount() - posTransaction.getTipsAmount()) - d6) > 0.0) {
                refundTransaction.setTipsAmount(d5);
                posTransaction.addProperty("REFUNDED_TIPS_AMOUNT", String.valueOf(d5 + d6));
            }
        }
        return refundTransaction;
    }

    @Deprecated
    public double refundTicket(Ticket ticket, PosTransaction posTransaction, double d, Double d2, User user, Session session) throws Exception {
        ticket.addTotransactions(posTransaction);
        ticket.setRefunded(true);
        ticket.setClosed(true);
        ticket.setClosingDate(StoreDAO.getServerTimestamp());
        ticket.setCashier(user);
        ticket.calculateRefundAmount();
        ticket.calculatePrice();
        ticket.setShouldUpdateStock(true);
        TicketDAO.getInstance().saveOrUpdate(ticket, session);
        return d;
    }

    private void b(Ticket ticket, PosTransaction posTransaction, Session session) {
        if (ticket.hasGiftCard()) {
            List<TicketItem> list = ticket.getTicketItems();
            for (TicketItem ticketItem : list) {
                double d;
                if (!ticketItem.isGiftCard()) continue;
                String string = ticketItem.getGiftCardNo();
                double d2 = ticketItem.getUnitPrice();
                if (d2 == (d = ticketItem.getGiftCardPaidAmount())) {
                    return;
                }
                ticketItem.setGiftCardPaidAmount(d2);
                posTransaction.addGiftCardBalanceAddInfo(ticketItem.getId(), string, d2);
                GiftCard giftCard = GiftCardDAO.getInstance().findByCardNumber(string);
                giftCard.setBalance(giftCard.getBalance() + d2);
                GiftCardDAO.getInstance().saveOrUpdate(giftCard, session);
            }
        }
    }

    public static PosTransactionService getInstance() {
        return a;
    }
}

