/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.swing.CheckBoxListModel;
import com.floreantpos.swing.PosUIManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class CheckBoxList<E>
extends JTable {
    public CheckBoxList() {
        this.setRowHeight(PosUIManager.getSize(this.getRowHeight()));
    }

    public CheckBoxList(E[] EArray) {
        this.setModel(EArray);
        this.setRowHeight(PosUIManager.getSize(this.getRowHeight()));
    }

    public CheckBoxList(List<E> list) {
        this.setModel(list);
        this.setRowHeight(PosUIManager.getSize(this.getRowHeight()));
    }

    public void setModel(E[] EArray) {
        this.setModel(EArray, new String[]{"", ""});
    }

    public void setModel(List<E> list) {
        this.setModel(list, new String[]{"", ""});
    }

    public void setModel(List<E> list, String[] stringArray) {
        CheckBoxListModel<E> checkBoxListModel = new CheckBoxListModel<E>(stringArray, list);
        this.setModel(checkBoxListModel);
        this.init();
    }

    public void setModel(E[] EArray, String[] stringArray) {
        CheckBoxListModel<E> checkBoxListModel = new CheckBoxListModel<E>(EArray, stringArray);
        this.setModel(checkBoxListModel);
        this.init();
    }

    public List<E> getCheckedValues() {
        ArrayList arrayList = new ArrayList();
        CheckBoxListModel checkBoxListModel = (CheckBoxListModel)this.getModel();
        int n = checkBoxListModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            Entry entry = (Entry)checkBoxListModel.getRow(i);
            if (!entry.checked) continue;
            arrayList.add(entry.value);
        }
        return arrayList;
    }

    public Set<E> getCheckedValuesAsSet() {
        HashSet hashSet = new HashSet();
        CheckBoxListModel checkBoxListModel = (CheckBoxListModel)this.getModel();
        int n = checkBoxListModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            Entry entry = (Entry)checkBoxListModel.getRow(i);
            if (!entry.checked) continue;
            hashSet.add(entry.value);
        }
        return hashSet;
    }

    @Override
    public void selectAll() {
        CheckBoxListModel checkBoxListModel = (CheckBoxListModel)this.getModel();
        for (int i = 0; i < checkBoxListModel.getRowCount(); ++i) {
            Entry entry = (Entry)checkBoxListModel.getRow(i);
            entry.checked = true;
        }
        checkBoxListModel.fireTableRowsUpdated(0, checkBoxListModel.getRowCount());
    }

    public void selectItems(List list) {
        CheckBoxListModel checkBoxListModel = (CheckBoxListModel)this.getModel();
        if (list != null) {
            block0: for (int i = 0; i < checkBoxListModel.getRowCount(); ++i) {
                Entry entry = (Entry)checkBoxListModel.getRow(i);
                for (int j = 0; j < list.size(); ++j) {
                    Object e = list.get(j);
                    if (!e.equals(entry.value)) continue;
                    entry.checked = true;
                    continue block0;
                }
            }
            checkBoxListModel.fireTableRowsUpdated(0, checkBoxListModel.getRowCount());
        }
    }

    public void selectItems(Set<E> set) {
        CheckBoxListModel checkBoxListModel = (CheckBoxListModel)this.getModel();
        if (set != null) {
            block0: for (int i = 0; i < checkBoxListModel.getRowCount(); ++i) {
                Entry entry = (Entry)checkBoxListModel.getRow(i);
                for (E e : set) {
                    if (!e.equals(entry.value)) continue;
                    entry.checked = true;
                    continue block0;
                }
            }
            checkBoxListModel.fireTableRowsUpdated(0, checkBoxListModel.getRowCount());
        }
    }

    public void selectItem(E e) {
        if (e == null) {
            return;
        }
        CheckBoxListModel checkBoxListModel = (CheckBoxListModel)this.getModel();
        for (int i = 0; i < checkBoxListModel.getRowCount(); ++i) {
            Entry entry = (Entry)checkBoxListModel.getRow(i);
            if (!e.equals(entry.value)) continue;
            entry.checked = true;
            break;
        }
        checkBoxListModel.fireTableRowsUpdated(0, checkBoxListModel.getRowCount());
    }

    public void unCheckAll() {
        CheckBoxListModel checkBoxListModel = (CheckBoxListModel)this.getModel();
        for (int i = 0; i < checkBoxListModel.getRowCount(); ++i) {
            Entry entry = (Entry)checkBoxListModel.getRow(i);
            entry.checked = false;
        }
        checkBoxListModel.fireTableRowsUpdated(0, checkBoxListModel.getRowCount());
    }

    public Entry[] getValues() {
        CheckBoxListModel checkBoxListModel = (CheckBoxListModel)this.getModel();
        return (Entry[])checkBoxListModel.getItems().toArray();
    }

    public Object getSelectedValue() {
        int n = this.getSelectedRow();
        if (n == -1) {
            return null;
        }
        return this.getModel().getValueAt(n, 1);
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableCellRenderer tableCellRenderer = super.getCellRenderer(n, n2);
        if (tableCellRenderer instanceof JCheckBox) {
            ((JCheckBox)((Object)tableCellRenderer)).setEnabled(this.isEnabled());
        }
        return tableCellRenderer;
    }

    public void init() {
        this.getSelectionModel().setSelectionMode(0);
        this.setShowGrid(false);
        this.setAutoResizeMode(3);
        if (this.getColumnModel() != null && this.getColumnCount() > 0) {
            TableColumn tableColumn = this.getColumnModel().getColumn(0);
            int n = new JCheckBox().getPreferredSize().width;
            tableColumn.setPreferredWidth(n);
            tableColumn.setMinWidth(n);
            tableColumn.setWidth(n);
            tableColumn.setMaxWidth(n);
            tableColumn.setResizable(false);
        }
    }

    public void setTableHeaderHide(boolean bl) {
        if (bl) {
            this.setTableHeader(null);
        }
    }

    public static class Entry<E> {
        public boolean checked;
        public E value;

        public Entry(boolean bl, E e) {
            this.checked = bl;
            this.value = e;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public Object getValue() {
            return this.value;
        }

        public void setChecked(boolean bl) {
            this.checked = bl;
        }

        public void setValue(E e) {
            this.value = e;
        }
    }
}

