/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui;

import com.floreantpos.Messages;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosTable;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.JXTable;

public class TransactionListView
extends JPanel {
    private PosTable a = new TransactionListTable();
    private TransactionListTableModel b;

    public TransactionListView() {
        this(false);
    }

    public TransactionListView(boolean bl) {
        this.a.setSortable(false);
        this.b = new TransactionListTableModel();
        this.a.setModel(this.b);
        this.a.setRowHeight(PosUIManager.getSize(40));
        this.a.setAutoResizeMode(3);
        this.a.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.a.setGridColor(Color.LIGHT_GRAY);
        this.a.setEditable(bl);
        DoubleTextField doubleTextField = new DoubleTextField();
        doubleTextField.setHorizontalAlignment(4);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(doubleTextField);
        defaultCellEditor.setClickCountToStart(1);
        this.a.getColumnModel().getColumn(7).setCellEditor(defaultCellEditor);
        PosScrollPane posScrollPane = new PosScrollPane((Component)((Object)this.a), 20, 31);
        JScrollBar jScrollBar = posScrollPane.getVerticalScrollBar();
        jScrollBar.setPreferredSize(PosUIManager.getSize(30, 60));
        this.setLayout(new BorderLayout());
        this.add(posScrollPane);
    }

    public void setTransactions(List<PosTransaction> list) {
        this.b.setRows(list);
    }

    public void addTransaction(PosTransaction posTransaction) {
        this.b.addItem(posTransaction);
    }

    public PosTransaction getSelectedTransaction() {
        int n = this.a.getSelectedRow();
        if (n < 0) {
            return null;
        }
        return (PosTransaction)this.b.getRowData(n);
    }

    public List<PosTransaction> getAllTransactions() {
        return this.b.getRows();
    }

    public List<PosTransaction> getSelectedTransactions() {
        int[] nArray = this.a.getSelectedRows();
        ArrayList<PosTransaction> arrayList = new ArrayList<PosTransaction>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            PosTransaction posTransaction = (PosTransaction)this.b.getRowData(nArray[i]);
            arrayList.add(posTransaction);
        }
        return arrayList;
    }

    public PosTransaction getFirstSelectedTransaction() {
        List<PosTransaction> list = this.getSelectedTransactions();
        if (list.size() == 0 || list.size() > 1) {
            POSMessageDialog.showMessage(Messages.getString("TransactionListView.7"));
            return null;
        }
        PosTransaction posTransaction = list.get(0);
        return posTransaction;
    }

    public JXTable getTable() {
        return this.a;
    }

    private class TransactionListTableModel
    extends ListTableModel<PosTransaction> {
        public TransactionListTableModel() {
            super(new String[]{Messages.getString("TransactionListView.0"), Messages.getString("TransactionListView.1"), Messages.getString("TransactionListView.10"), Messages.getString("TransactionListView.2"), Messages.getString("TransactionListView.3"), Messages.getString("TransactionListView.13"), Messages.getString("TransactionListView.14"), Messages.getString("TransactionListView.4") + " (" + CurrencyUtil.getCurrencySymbol() + ")", Messages.getString("TransactionListView.5") + " (" + CurrencyUtil.getCurrencySymbol() + ")", Messages.getString("TransactionListView.6") + " (" + CurrencyUtil.getCurrencySymbol() + ")"});
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 7) {
                return true;
            }
            return super.isCellEditable(n, n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (object == null) {
                return;
            }
            PosTransaction posTransaction = (PosTransaction)this.getRowData(n);
            if (n2 == 7) {
                double d = posTransaction.getTipsAmount();
                Double d2 = 0.0;
                String string = object.toString();
                if (StringUtils.isNotBlank((String)string)) {
                    d2 = POSUtil.parseDouble(string);
                }
                posTransaction.setTipsAmount(d2);
                posTransaction.setAmount(posTransaction.getAmount() - d + d2);
                Ticket ticket = TicketDAO.getInstance().loadFullTicket(posTransaction.getTicket().getId());
                Set<PosTransaction> set = ticket.getTransactions();
                for (PosTransaction posTransaction2 : set) {
                    if (!posTransaction.getId().equals(posTransaction2.getId())) continue;
                    posTransaction = posTransaction2;
                    break;
                }
                posTransaction.setTipsAmount(d2);
                posTransaction.setAmount(posTransaction.getAmount() - d + d2);
                if (ticket.hasGratuity()) {
                    double d3 = ticket.getGratuity().getAmount();
                    double d4 = ticket.getPaidAmount();
                    double d5 = d3 - d + d2;
                    double d6 = d4 - d + d2;
                    ticket.setGratuityAmount(d5);
                    ticket.setPaidAmount(d6);
                } else {
                    ticket.setGratuityAmount(d2);
                    ticket.setPaidAmount(ticket.getPaidAmount() + d2);
                }
                ticket.calculatePrice();
            }
            TransactionListView.this.b.fireTableDataChanged();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            PosTransaction posTransaction = (PosTransaction)this.rows.get(n);
            Ticket ticket = posTransaction.getTicket();
            switch (n2) {
                case 0: {
                    return posTransaction.getId();
                }
                case 1: {
                    return ticket.getId();
                }
                case 2: {
                    return posTransaction.getCardMerchantGateway();
                }
                case 3: {
                    User user = ticket.getOwner();
                    if (user == null) {
                        return null;
                    }
                    return user.getFirstName();
                }
                case 4: {
                    return posTransaction.getCardType();
                }
                case 5: {
                    return posTransaction.getCardNumber();
                }
                case 6: {
                    return posTransaction.getCardHolderName();
                }
                case 7: {
                    return posTransaction.getTipsAmount();
                }
                case 8: {
                    return posTransaction.getAmount() - posTransaction.getTipsAmount();
                }
                case 9: {
                    return posTransaction.getAmount();
                }
            }
            return null;
        }
    }

    private class TransactionListTable
    extends PosTable {
        public TransactionListTable() {
            this.setColumnControlVisible(false);
        }
    }
}

