/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.Discount;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.dao.DiscountDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ButtonColumnWithLabel;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosOptionPane;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ScrollableFlowPanel;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.util.DiscountUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;

public class TicketDiscountSelectionDialog
extends OkCancelOptionDialog {
    private ScrollableFlowPanel a;
    private Ticket b;
    private JPanel c;
    private JTextField d;
    private JPanel e;
    private JTable f;
    private DiscountTableModel g;
    private List<TicketDiscountMapping> h;

    public TicketDiscountSelectionDialog(Ticket ticket) {
        super(POSUtil.getFocusedWindow(), Messages.getString("DiscountSelection"));
        this.b = ticket;
        this.h = new ArrayList<TicketDiscountMapping>();
        this.a();
    }

    private void a() {
        this.setOkButtonText(POSConstants.SAVE);
        this.c();
        this.getContentPanel().setBorder(new EmptyBorder(0, 10, 0, 10));
        this.getContentPanel().add((Component)this.c, "North");
        this.a = new ScrollableFlowPanel(3);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(null, Messages.getString("TicketDiscountSelectionDialog.0"), 2, 0);
        this.a.setBorder(titledBorder);
        PosScrollPane posScrollPane = new PosScrollPane(this.a, 20, 31);
        posScrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(80, 0));
        this.getContentPanel().add((Component)this.a, "Center");
        this.createTicketDiscountPanel();
        this.d();
        this.setSize(1024, 720);
    }

    public void createTicketDiscountPanel() {
        this.e = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,ins 8 5 2 5"));
        this.f = new JTable();
        this.f.setGridColor(Color.LIGHT_GRAY);
        this.f.setCellSelectionEnabled(false);
        this.f.setColumnSelectionAllowed(false);
        this.f.setRowSelectionAllowed(false);
        this.f.setAutoscrolls(true);
        this.f.setRowHeight(PosUIManager.getSize(40));
        this.f.setShowGrid(true);
        this.f.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.f.setFocusable(false);
        this.f.setAutoResizeMode(4);
        this.g = new DiscountTableModel();
        this.f.setModel(this.g);
        this.f.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                this.setHorizontalAlignment(4);
                if (bl) {
                    return component;
                }
                component.setBackground(jTable.getBackground());
                return component;
            }

            @Override
            protected void setValue(Object object) {
                if (object == null) {
                    this.setText("");
                    return;
                }
                String string = object.toString();
                if (object instanceof Double || object instanceof Float) {
                    string = NumberUtil.formatNumberAcceptNegative(((Number)object).doubleValue());
                }
                this.setText(string);
            }
        });
        this.a(0, PosUIManager.getSize(250));
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Integer.parseInt(actionEvent.getActionCommand());
                TicketDiscount ticketDiscount = (TicketDiscount)TicketDiscountSelectionDialog.this.g.getRowData(n);
                List<TicketDiscount> list = TicketDiscountSelectionDialog.this.b.getDiscounts();
                if (list != null) {
                    Iterator<TicketDiscount> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        TicketDiscount ticketDiscount2 = iterator.next();
                        if (ticketDiscount2 != ticketDiscount) continue;
                        iterator.remove();
                        TicketDiscountSelectionDialog.this.b(ticketDiscount2);
                        break;
                    }
                    OrderController.saveOrder(TicketDiscountSelectionDialog.this.b);
                    TicketDiscountSelectionDialog.this.b();
                }
            }
        };
        new ButtonColumnWithLabel(this.f, abstractAction, 0, "delete-icon.png", false){

            @Override
            public boolean hasButtonAction(int n) {
                return true;
            }
        };
        JScrollPane jScrollPane = new JScrollPane(this.f);
        this.e.add((Component)jScrollPane, "grow,span");
        this.getContentPanel().add((Component)this.e, "West");
        this.b();
    }

    private void a(int n, int n2) {
        TableColumn tableColumn = this.f.getColumnModel().getColumn(n);
        tableColumn.setPreferredWidth(n2);
        tableColumn.setMinWidth(n2);
    }

    private void b() {
        List<TicketDiscount> list = this.b.getDiscounts();
        this.g.setRows(list);
        this.e.revalidate();
        this.e.repaint();
    }

    private void c() {
        this.c = new JPanel(new BorderLayout(5, 5));
        this.c.setBorder(new EmptyBorder(0, 5, 0, 5));
        PosButton posButton = new PosButton(IconFactory.getIcon("/ui_icons/", "search.png"));
        posButton.setPreferredSize(new Dimension(60, 40));
        JLabel jLabel = new JLabel(Messages.getString("DiscountSelectionDialog.4"));
        this.d = new JTextField();
        this.d.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                TicketDiscountSelectionDialog.this.d.setText(Messages.getString("DiscountSelectionDialog.5"));
                TicketDiscountSelectionDialog.this.d.setForeground(Color.gray);
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                TicketDiscountSelectionDialog.this.d.setForeground(Color.black);
                TicketDiscountSelectionDialog.this.d.setText("");
            }
        });
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TicketDiscountSelectionDialog.this.d.getText().equals("")) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("DiscountSelectionDialog.8"));
                    return;
                }
                if (!TicketDiscountSelectionDialog.this.b(TicketDiscountSelectionDialog.this.d.getText()) && TicketDiscountSelectionDialog.this.a(TicketDiscountSelectionDialog.this.d.getText())) {
                    POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("DiscountSelectionDialog.11"));
                }
                TicketDiscountSelectionDialog.this.d.setText("");
            }
        });
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = PosOptionPane.showInputDialog(Messages.getString("DiscountSelectionDialog.10"));
                if (string == null || string.isEmpty()) {
                    return;
                }
                TicketDiscountSelectionDialog.this.d.requestFocus();
                if (!TicketDiscountSelectionDialog.this.b(string) && !TicketDiscountSelectionDialog.this.a(string)) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("DiscountSelectionDialog.11"));
                }
            }
        });
        this.c.add((Component)jLabel, "West");
        this.c.add(this.d);
        this.c.add((Component)posButton, "East");
    }

    private boolean a(String string) {
        Discount discount = DiscountDAO.getInstance().getDiscountById(string, 1);
        if (discount == null) {
            return false;
        }
        this.a(discount);
        return true;
    }

    private boolean b(String string) {
        Discount discount = DiscountDAO.getInstance().getDiscountByBarcode(string, 1);
        if (discount == null) {
            return false;
        }
        this.a(discount);
        return true;
    }

    private void d() {
        List<Discount> list = DiscountDAO.getInstance().getTicketValidCoupon();
        for (Discount discount : list) {
            if (discount.getType() == 3) continue;
            DiscountButton discountButton = new DiscountButton(discount);
            discountButton.setSelected(false);
            this.a.add(discountButton);
        }
        this.a.repaint();
        this.a.revalidate();
    }

    @Override
    public void doOk() {
        this.h.clear();
        this.setCanceled(false);
        this.dispose();
    }

    @Override
    public void doCancel() {
        this.e();
        this.setCanceled(true);
        this.dispose();
    }

    private void a(Discount discount) {
        Discount discount2;
        TicketDiscount ticketDiscount = null;
        Store store = DataProvider.get().getStore();
        List<TicketDiscount> list = this.b.getDiscounts();
        if (list != null && !list.isEmpty()) {
            if (this.a(list) >= 1 && !store.isAllowMulDiscount()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TicketItemDiscountSelectionDialog.20"));
                return;
            }
            ticketDiscount = list.get(0);
        }
        if (ticketDiscount != null && ticketDiscount.getCouponQuantity() <= discount.getMaximumOff()) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TicketDiscountSelectionDialog.2"));
            return;
        }
        if (ticketDiscount != null && (discount2 = DiscountDAO.getInstance().get(ticketDiscount.getDiscountId())) != null && discount2.getType() == 2) {
            return;
        }
        boolean bl = discount.getType() == 2;
        Double d = 0.0;
        if (bl) {
            String string = Messages.getString("TicketItemDiscountSelectionDialog.17");
            double d2 = NumberSelectionDialog2.takeDoubleInput(string, 0.0, true);
            if (d2 == -1.0 || d2 > this.b.getTotalAmount()) {
                return;
            }
            d = d2;
            if (d == 0.0) {
                return;
            }
        } else {
            d = discount.getValue();
            if (discount.isModifiable().booleanValue() && (d = this.b(discount)) == null) {
                return;
            }
        }
        if (ticketDiscount == null || ticketDiscount.getValue().doubleValue() != d.doubleValue()) {
            ticketDiscount = Ticket.convertToTicketDiscount(discount, this.b);
            this.b.addTodiscounts(ticketDiscount);
            this.a(ticketDiscount);
        } else {
            ticketDiscount.setCouponQuantity(ticketDiscount.getCouponQuantity() + 1.0);
            this.a(ticketDiscount);
        }
        ticketDiscount.setValue(d);
        this.b();
    }

    private int a(List<TicketDiscount> list) {
        int n = 0;
        for (TicketDiscount ticketDiscount : list) {
            if (ticketDiscount.getType() == 3) continue;
            ++n;
        }
        return n;
    }

    private void a(TicketDiscount ticketDiscount) {
        block4: {
            try {
                TicketDiscountMapping ticketDiscountMapping = new TicketDiscountMapping(ticketDiscount, 1.0);
                if (this.h.contains(ticketDiscountMapping)) {
                    for (TicketDiscountMapping ticketDiscountMapping2 : this.h) {
                        if (!ticketDiscountMapping2.equals(ticketDiscountMapping)) continue;
                        ticketDiscountMapping2.setQuantity(ticketDiscountMapping2.getQuantity() + 1.0);
                        break block4;
                    }
                    break block4;
                }
                this.h.add(ticketDiscountMapping);
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }
    }

    private void b(TicketDiscount ticketDiscount) {
        block4: {
            try {
                TicketDiscountMapping ticketDiscountMapping = new TicketDiscountMapping(ticketDiscount, -ticketDiscount.getCouponQuantity().doubleValue());
                if (this.h.contains(ticketDiscountMapping)) {
                    for (TicketDiscountMapping ticketDiscountMapping2 : this.h) {
                        if (!ticketDiscountMapping2.equals(ticketDiscountMapping)) continue;
                        ticketDiscountMapping2.setQuantity(ticketDiscountMapping2.getQuantity() + ticketDiscountMapping.getQuantity());
                        break block4;
                    }
                    break block4;
                }
                this.h.add(ticketDiscountMapping);
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }
    }

    private void e() {
        if (this.h.isEmpty()) {
            return;
        }
        Iterator<TicketDiscountMapping> iterator = this.h.iterator();
        while (iterator.hasNext()) {
            TicketDiscountMapping ticketDiscountMapping = iterator.next();
            while (ticketDiscountMapping.getQuantity() != 0.0) {
                TicketDiscount ticketDiscount = ticketDiscountMapping.getDiscount();
                if (ticketDiscountMapping.getQuantity() > 0.0) {
                    Iterator<TicketDiscount> iterator2 = this.b.getDiscounts().iterator();
                    while (iterator2.hasNext()) {
                        TicketDiscount ticketDiscount2 = iterator2.next();
                        if (!ticketDiscount2.getName().equals(ticketDiscount.getName())) continue;
                        if (ticketDiscount2.getCouponQuantity().equals(ticketDiscountMapping.getQuantity())) {
                            iterator2.remove();
                        } else {
                            ticketDiscount2.setCouponQuantity(ticketDiscount2.getCouponQuantity() - ticketDiscountMapping.getQuantity());
                        }
                        ticketDiscountMapping.setQuantity(0.0);
                    }
                    continue;
                }
                ticketDiscount.setCouponQuantity(-ticketDiscountMapping.getQuantity().doubleValue());
                this.b.addTodiscounts(ticketDiscount);
                ticketDiscountMapping.setQuantity(0.0);
            }
            iterator.remove();
        }
        this.b.calculatePrice();
        this.b();
    }

    private Double b(Discount discount) {
        this.b.calculatePrice();
        Double d = NumberSelectionDialog2.takeDoubleInput(Messages.getString("TicketDiscountSelectionDialog.3"), discount.getValue(), true);
        if (d == -1.0) {
            return null;
        }
        if (d > 0.0) {
            return d;
        }
        return 0.0;
    }

    private class TicketDiscountMapping {
        private TicketDiscount b;
        private Double c;

        public TicketDiscountMapping(TicketDiscount ticketDiscount, Double d) {
            this.b = ticketDiscount;
            this.c = d;
        }

        public Double getQuantity() {
            return this.c;
        }

        public void setQuantity(Double d) {
            this.c = d;
        }

        public TicketDiscount getDiscount() {
            return this.b;
        }

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = 31 * n2 + this.a().hashCode();
            n2 = 31 * n2 + (this.b == null ? 0 : this.b.hashCode());
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            TicketDiscountMapping ticketDiscountMapping = (TicketDiscountMapping)object;
            if (!this.a().equals(ticketDiscountMapping.a())) {
                return false;
            }
            return !(this.b == null ? ticketDiscountMapping.b != null : !this.b.equals(ticketDiscountMapping.b));
        }

        private TicketDiscountSelectionDialog a() {
            return TicketDiscountSelectionDialog.this;
        }
    }

    public class DiscountTableModel
    extends ListTableModel<TicketDiscount> {
        public DiscountTableModel() {
            super(new String[]{POSConstants.NAME, POSConstants.PRICE});
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            TicketDiscount ticketDiscount = (TicketDiscount)this.rows.get(n);
            switch (n2) {
                case 0: {
                    return ticketDiscount.getNameDisplay();
                }
                case 1: {
                    if (ticketDiscount.getType() == 2 || ticketDiscount.getType() == 3) {
                        return ticketDiscount.getValue();
                    }
                    return NumberUtil.formatNumberAcceptNegative(-DiscountUtil.calculateDiscountAmount(TicketDiscountSelectionDialog.this.b.getSubtotalAmount(), ticketDiscount).doubleValue() * ticketDiscount.getCouponQuantity());
                }
            }
            return null;
        }
    }

    private class DiscountButton
    extends JPanel
    implements ActionListener {
        private Discount b;
        private PosButton c;

        DiscountButton(Discount discount) {
            this.b = discount;
            this.setPreferredSize(PosUIManager.getSize(120, 120));
            this.setLayout((LayoutManager)new MigLayout("fill", "", "[60%][40%]"));
            JLabel jLabel = new JLabel();
            jLabel.setOpaque(false);
            jLabel.setHorizontalAlignment(0);
            jLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            jLabel.setText("<html><body><center><strong>" + discount.getName() + "</strong></center></body></html>");
            this.setBackground(Color.WHITE);
            this.setForeground(Color.BLACK);
            this.add((Component)jLabel, "grow,span,wrap");
            this.c = new PosButton(POSConstants.APPLY);
            this.c.addActionListener(this);
            this.add((Component)this.c, "center");
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.setBorder(BorderFactory.createLineBorder(Color.red));
            super.paintComponent(graphics);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TicketDiscountSelectionDialog.this.a(this.b);
        }

        public void setSelected(Boolean bl) {
            this.c.setSelected(bl);
            if (bl.booleanValue()) {
                this.c.setText(Messages.getString("TicketItemDiscountSelectionDialog.13"));
                this.c.setBackground(Color.PINK);
            } else {
                this.c.setText(POSConstants.APPLY);
                this.c.setBackground(UIManager.getColor("control"));
            }
        }
    }
}

