/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.menuitem.variant;

import com.floreantpos.Messages;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.InventoryVendorItems;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.dao.InventoryVendorItemsDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.menuitem.ButtonStylePanel;
import com.floreantpos.ui.menuitem.InventoryPanel;
import com.floreantpos.ui.menuitem.VariantGeneralPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JTabbedPane;
import org.hibernate.StaleStateException;

public class VariantForm
extends BeanEditor<MenuItem>
implements RefreshableView {
    private ButtonStylePanel a;
    private InventoryPanel b;
    private VariantGeneralPanel c;

    public VariantForm(MenuItem menuItem) {
        this.a(menuItem);
        this.setBean(menuItem);
    }

    private void a(MenuItem menuItem) {
        this.setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.a = new ButtonStylePanel();
        this.a.setSortOrderVisibility(true);
        this.b = new InventoryPanel(menuItem);
        this.c = new VariantGeneralPanel(menuItem);
        jTabbedPane.addTab(Messages.getString("VariantForm.5"), this.c);
        jTabbedPane.addTab(Messages.getString("VariantForm.0"), this.a);
        jTabbedPane.addTab(Messages.getString("VariantForm.1"), this.b);
        this.add((Component)jTabbedPane, "Center");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            MenuItem menuItem = (MenuItem)this.getBean();
            MenuItemDAO menuItemDAO = new MenuItemDAO();
            if (menuItem.getId() == null) {
                menuItemDAO.save(menuItem);
            } else {
                menuItemDAO.saveOrUpdate(menuItem);
            }
            List<InventoryVendorItems> list = this.b.getVendorItems();
            InventoryVendorItemsDAO.getInstance().saveOrUpdateMenuItemVendors(menuItem, list);
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
            return false;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        Color color;
        MenuItem menuItem = (MenuItem)this.getBean();
        ImageResource imageResource = ImageResourceDAO.getInstance().findById(menuItem.getImageId());
        if (imageResource != null) {
            this.a.setImageResource(imageResource);
        }
        if ((color = menuItem.getButtonColor()) != null) {
            this.a.setButtonColor(color);
            this.a.setTextColor(color);
        }
        if (menuItem.getTextColor() != null) {
            this.a.setTextForegroundColor(menuItem.getTextColor());
        }
        this.a.setSortOrder(menuItem.getSortOrder());
        this.c.setUnit(menuItem.getUnit());
        this.c.setExtraPrice(menuItem.getPrice());
        this.c.setDisplayName(menuItem.getDisplayName());
        this.b.setSku(menuItem.getSku());
        this.b.setReOrderLevel(menuItem.getReorderLevel());
        this.b.setReplenishLevel(menuItem.getReplenishLevel());
        this.b.setCbDisableStockCount(menuItem.isDisableWhenStockAmountIsZero());
    }

    @Override
    public boolean updateModel() {
        MenuItem menuItem = (MenuItem)this.getBean();
        menuItem.setReorderLevel(this.b.getReOrderLevel());
        menuItem.setReplenishLevel(this.b.getReplenishLevel());
        menuItem.setDisableWhenStockAmountIsZero(this.b.isCbDisableStockCount());
        menuItem.setShowImageOnly(this.a.isShowTextWithImage());
        menuItem.setUnit(this.c.getUnit());
        menuItem.setTranslatedName(this.c.getDisplayName());
        menuItem.setPrice(this.c.getExtraPrice());
        menuItem.setButtonColor(this.a.getButtonColor());
        menuItem.setButtonColorCode(this.a.getButtonColorCode());
        menuItem.setTextColor(this.a.getTextColor());
        menuItem.setTextColorCode(this.a.getTextColorCode());
        menuItem.setImageId(this.a.getImageResourceId());
        menuItem.setSortOrder(this.a.getSortOrder());
        menuItem.setSku(this.b.getSku());
        return true;
    }

    @Override
    public String getDisplayText() {
        return Messages.getString("VariantForm.2");
    }

    @Override
    public void refresh() {
        MenuItem menuItem = (MenuItem)this.getBean();
        MenuItem menuItem2 = MenuItemDAO.getInstance().get(menuItem.getId());
        this.setBean(menuItem2, false);
    }
}

