/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.DayPart;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.ShiftDAO;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.ShiftUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class BusinessHourForm
extends BeanEditor<DayPart> {
    private JComboBox a;
    private JComboBox b;
    private JComboBox c;
    private JComboBox d;
    private FixedLengthTextField e;
    private Vector<Integer> f;
    private Vector<Integer> g;
    private Date h;
    private Date i;

    public BusinessHourForm() {
        this(new DayPart());
    }

    public BusinessHourForm(DayPart dayPart) {
        int n;
        this.b();
        this.f = new Vector();
        for (n = 0; n <= 23; ++n) {
            this.f.add(n);
        }
        this.g = new Vector();
        for (n = 0; n < 60; ++n) {
            this.g.add(n);
        }
        this.a.setModel(new DefaultComboBoxModel<Integer>(this.f));
        this.c.setModel(new DefaultComboBoxModel<Integer>(this.f));
        this.b.setModel(new DefaultComboBoxModel<Integer>(this.g));
        this.d.setModel(new DefaultComboBoxModel<Integer>(this.g));
        this.setBean(dayPart);
    }

    private boolean a() {
        int n = (Integer)this.a.getSelectedItem();
        int n2 = (Integer)this.c.getSelectedItem();
        int n3 = (Integer)this.b.getSelectedItem();
        int n4 = (Integer)this.d.getSelectedItem();
        this.h = ShiftUtil.buildShiftWithoutAmPm(n, n3, 0);
        this.i = ShiftUtil.buildShiftWithoutAmPm(n2, n4, 59);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.h);
        calendar.add(12, 30);
        if (!this.i.after(calendar.getTime())) {
            String string = Messages.getString("ShiftEntryDialog.1");
            POSMessageDialog.showError(this, String.format(string, calendar.getTime().getHours(), calendar.getTime().getMinutes()));
            return false;
        }
        return true;
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            DayPart dayPart = (DayPart)this.getBean();
            ShiftDAO.getInstance().saveOrUpdate(dayPart);
            return true;
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_SAVING_SHIFT_STATE, exception);
        }
        return false;
    }

    @Override
    public void updateView() {
        DayPart dayPart = (DayPart)this.getBean();
        if (dayPart == null) {
            return;
        }
        this.e.setText(dayPart.getName());
        Date date = dayPart.getStartTime();
        Date date2 = dayPart.getEndTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n = calendar.get(9);
        if (n == 0) {
            this.a.setSelectedItem(calendar.get(11));
        } else {
            this.a.setSelectedItem(calendar.get(11));
        }
        this.b.setSelectedItem(calendar.get(12));
        calendar.setTime(date2);
        int n2 = calendar.get(9);
        if (n2 == 0) {
            this.c.setSelectedItem(calendar.get(11));
        } else {
            this.c.setSelectedItem(calendar.get(11));
        }
        this.d.setSelectedItem(calendar.get(12));
    }

    @Override
    public boolean updateModel() {
        DayPart dayPart = (DayPart)this.getBean();
        if (dayPart == null) {
            dayPart = new DayPart();
        }
        String string = this.e.getText().trim();
        if (StringUtils.isBlank((String)this.e.getText())) {
            POSMessageDialog.showError(this, Messages.getString("ShiftEntryDialog.0"));
            return false;
        }
        GenericDAO.getInstance().checkIdOrNameExists(dayPart.getId(), string, DayPart.class);
        if (!this.a()) {
            return false;
        }
        dayPart.setName(string);
        dayPart.setStartTime(this.h);
        dayPart.setEndTime(this.i);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.h);
        long l = Math.abs(this.h.getTime() - this.i.getTime());
        dayPart.setShiftLength(l);
        return true;
    }

    private void b() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx", "[][grow]", ""));
        JSeparator jSeparator = new JSeparator();
        JLabel jLabel = new JLabel();
        jLabel.setText(POSConstants.START_TIME + ":");
        JSeparator jSeparator2 = new JSeparator();
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(POSConstants.HOUR + ":");
        this.a = new JComboBox();
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(POSConstants.MIN);
        this.b = new JComboBox();
        JLabel jLabel4 = new JLabel();
        jLabel4.setText(POSConstants.END_TIME + ":");
        JSeparator jSeparator3 = new JSeparator();
        JLabel jLabel5 = new JLabel();
        jLabel5.setText(POSConstants.HOUR + ":");
        this.c = new JComboBox();
        JLabel jLabel6 = new JLabel();
        jLabel6.setText(POSConstants.MIN);
        this.d = new JComboBox();
        JLabel jLabel7 = new JLabel();
        jLabel7.setText(POSConstants.SHIFT_NAME + ":");
        this.e = new FixedLengthTextField();
        this.e.setLength(30);
        jPanel.add(jLabel7);
        jPanel.add((Component)this.e, "grow,wrap");
        jPanel.add(jLabel);
        jPanel.add((Component)this.a, "split 4,h 25!,w 90!");
        jPanel.add(jLabel2);
        jPanel.add((Component)this.b, "w 90!");
        jPanel.add((Component)jLabel3, "wrap");
        jPanel.add(jLabel4);
        jPanel.add((Component)this.c, "split 4,h 25!,w 90!");
        jPanel.add(jLabel5);
        jPanel.add((Component)this.d, "w 90!");
        jPanel.add(jLabel6);
        this.add(jPanel);
    }

    @Override
    public String getDisplayText() {
        return this.getBean() == null || ((DayPart)this.getBean()).getId() == null ? POSConstants.NEW_SHIFT : "Edit shift";
    }
}

