/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierMultiplierPrice;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.MultiplierDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.OverflowCombobox;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.TaxForm;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;

public class MenuModifierForm
extends BeanEditor
implements RefreshableView {
    private JCheckBox a;
    private JComboBox b;
    private FixedLengthTextField c;
    private FixedLengthTextField d;
    private DoubleTextField e;
    private DoubleTextField f;
    private IntegerTextField g;
    private JButton h;
    private JButton i;
    private JTable j;
    private JTabbedPane k;
    private Map<String, MultiplierPricePanel> l = new HashMap<String, MultiplierPricePanel>();
    private JCheckBox m;
    private JCheckBox n;
    private JCheckBox o;
    private JPanel p;
    private JLabel q;
    private JButton r;
    private JRadioButton s;
    private JRadioButton t;

    public MenuModifierForm() throws Exception {
        this(new MenuModifier());
    }

    public MenuModifierForm(MenuModifier menuModifier) throws Exception {
        this.d();
        this.b();
        this.a();
        this.add(this.k);
        this.setBean(menuModifier);
    }

    private void a() {
        ComboBoxModel comboBoxModel = new ComboBoxModel();
        comboBoxModel.addElement((Object)null);
        List<TaxGroup> list = TaxGroupDAO.getInstance().findAll();
        for (TaxGroup taxGroup : list) {
            comboBoxModel.addElement(taxGroup);
        }
        this.b.setModel(comboBoxModel);
    }

    private void b() {
        this.setLayout(new BorderLayout(0, 0));
        this.k = new JTabbedPane();
        this.c = new FixedLengthTextField(30, 120);
        this.d = new FixedLengthTextField(30, 120);
        this.e = new DoubleTextField();
        this.f = new DoubleTextField();
        this.g = new IntegerTextField(100);
        this.b = new OverflowCombobox();
        this.b.setVisible(Boolean.FALSE);
        this.r = new JButton();
        this.r.setVisible(Boolean.FALSE);
        this.a = new JCheckBox();
        this.m = new JCheckBox(Messages.getString("MenuModifierForm.11"));
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        this.j = new JTable();
        JLabel jLabel = new JLabel(POSConstants.NAME + ":");
        JLabel jLabel2 = new JLabel(Messages.getString("MenuModifierForm.0"));
        JLabel jLabel3 = new JLabel(Messages.getString("MenuModifierForm.15"));
        this.q = new JLabel(Messages.getString("MenuModifierForm.13") + ":");
        this.q.setVisible(Boolean.FALSE);
        this.f.setText("0");
        this.e.setText("0");
        this.r.setText("...");
        this.r.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuModifierForm.this.a(actionEvent);
            }
        });
        this.a.setText(POSConstants.PRINT_TO_KITCHEN);
        this.a.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.a.setMargin(new Insets(0, 0, 0, 0));
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        this.k.addTab(POSConstants.GENERAL, jPanel2);
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.setLayout((LayoutManager)new MigLayout("wrap 2,hidemode 3", "[90px][grow]", ""));
        transparentPanel.add((Component)jLabel, "alignx left,aligny center");
        transparentPanel.add((Component)this.c, "growx,aligny top");
        transparentPanel.add((Component)jLabel2, "alignx left,aligny center");
        transparentPanel.add((Component)this.d, "growx");
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("hidemode 3,wrap 2", "[90px][grow]", ""));
        this.o = new JCheckBox(Messages.getString("MenuModifierForm.333"));
        this.o.addItemListener(itemEvent -> this.c());
        jPanel3.add((Component)this.o, "alignx left,aligny center,wrap");
        this.p = new JPanel((LayoutManager)new MigLayout("hidemode 3,wrap 2", "[86px][grow]"));
        this.p.setBorder(BorderFactory.createTitledBorder(POSConstants.TAX));
        this.p.setVisible(Boolean.FALSE);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.s = new JRadioButton(Messages.getString("MenuModifierForm.777"));
        this.s.setSelected(Boolean.TRUE);
        this.t = new JRadioButton(Messages.getString("MenuModifierForm.888"));
        this.t.addItemListener(itemEvent -> this.a(itemEvent));
        buttonGroup.add(this.s);
        buttonGroup.add(this.t);
        this.p.add((Component)this.s, "alignx left,aligny center,wrap");
        this.p.add((Component)this.t, "alignx left,aligny center,wrap");
        this.p.add((Component)this.q, "alignx left,aligny top,split 2");
        this.p.add((Component)this.b, "growx,aligny top,split 2,width 100!");
        this.p.add((Component)this.r, "alignx left,aligny top");
        jPanel3.add(this.p);
        jPanel3.add((Component)jLabel3, "newline,alignx left,aligny center,split 2");
        jPanel3.add((Component)this.g, "alignx left,growx,aligny top,width 150!");
        jPanel3.add((Component)this.a, "skip 1,alignx left,aligny top");
        this.n = new JCheckBox(Messages.getString("MenuModifierForm.18"));
        jPanel3.add((Component)this.n, "skip 1,alignx left,aligny top");
        jPanel2.add(transparentPanel);
        jPanel2.add((Component)jPanel3, "East");
        JLabel jLabel4 = new JLabel(Messages.getString("MenuModifierForm.1"));
        this.h = new JButton("");
        this.h.setPreferredSize(new Dimension(140, 40));
        JLabel jLabel5 = new JLabel(Messages.getString("MenuModifierForm.27"));
        this.i = new JButton(Messages.getString("MenuModifierForm.29"));
        this.i.setPreferredSize(new Dimension(140, 40));
        JPanel jPanel4 = new JPanel((LayoutManager)new MigLayout("hidemode 3,wrap 2"));
        jPanel4.add(jLabel4);
        jPanel4.add(this.h);
        jPanel4.add(jLabel5);
        jPanel4.add(this.i);
        this.k.addTab("Button Style", jPanel4);
        this.h.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(MenuModifierForm.this, Messages.getString("MenuModifierForm.39"), MenuModifierForm.this.h.getBackground());
                if (color != null) {
                    MenuModifierForm.this.h.setBackground(color);
                    MenuModifierForm.this.i.setBackground(color);
                }
            }
        });
        this.i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(MenuModifierForm.this, Messages.getString("MenuModifierForm.40"), MenuModifierForm.this.i.getForeground());
                if (color != null) {
                    MenuModifierForm.this.i.setForeground(color);
                }
            }
        });
        this.j.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        jScrollPane.setViewportView(this.j);
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel((LayoutManager)new MigLayout("fillx,wrap 1"));
        List<Multiplier> list = MultiplierDAO.getInstance().findAll();
        if (list != null) {
            for (Multiplier multiplier : list) {
                MultiplierPricePanel multiplierPricePanel = new MultiplierPricePanel(multiplier);
                jPanel6.add((Component)multiplierPricePanel, "grow");
                this.l.put(multiplier.getId(), multiplierPricePanel);
            }
        }
        JScrollPane jScrollPane2 = new JScrollPane(jPanel6);
        jScrollPane2.setBorder(new TitledBorder(Messages.getString("MenuModifierForm.28")));
        transparentPanel.add((Component)jScrollPane2, "newline,skip 1,grow");
        jPanel.add((Component)jPanel5, "South");
        if (TerminalConfig.isMultipleOrderSupported()) {
            // empty if block
        }
    }

    private void a(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.q.setVisible(Boolean.TRUE);
            this.b.setVisible(Boolean.TRUE);
            this.r.setVisible(Boolean.TRUE);
        } else {
            this.q.setVisible(Boolean.FALSE);
            this.b.setVisible(Boolean.FALSE);
            this.r.setVisible(Boolean.FALSE);
        }
    }

    private void c() {
        if (this.o.isSelected()) {
            this.p.setVisible(Boolean.TRUE);
        } else {
            this.p.setVisible(Boolean.FALSE);
        }
    }

    private void d() {
        Multiplier multiplier = MultiplierDAO.getInstance().get("Regular");
        if (multiplier != null && multiplier.isMain().booleanValue()) {
            return;
        }
        if (multiplier == null) {
            multiplier = new Multiplier("Regular");
            multiplier.setRate(0.0);
            multiplier.setSortOrder(0);
            multiplier.setTicketPrefix("");
            multiplier.setDefaultMultiplier(true);
            multiplier.setMain(true);
            MultiplierDAO.getInstance().save(multiplier);
        } else {
            multiplier.setMain(true);
            MultiplierDAO.getInstance().update(multiplier);
        }
    }

    private void a(ActionEvent actionEvent) {
        try {
            TaxForm taxForm = new TaxForm();
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)taxForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            ComboBoxModel comboBoxModel = (ComboBoxModel)this.b.getModel();
            comboBoxModel.setDataList(TaxGroupDAO.getInstance().findAll());
        }
        catch (Exception exception) {
            MessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            MenuModifier menuModifier = (MenuModifier)this.getBean();
            MenuModifierDAO.getInstance().saveMenuModifierFormData(menuModifier);
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
            return false;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        Object object;
        Object object2;
        MenuModifier menuModifier = (MenuModifier)this.getBean();
        if (menuModifier == null) {
            this.c.setText("");
            this.e.setText("0");
            this.f.setText("0");
            return;
        }
        MenuModifierDAO.getInstance().initialize(menuModifier);
        this.c.setText(menuModifier.getName());
        this.d.setText(menuModifier.getTranslatedName());
        this.e.setText(NumberUtil.formatNumber(menuModifier.getPrice()));
        this.f.setText(NumberUtil.formatNumber(menuModifier.getExtraPrice()));
        this.a.setSelected(menuModifier.isShouldPrintToKitchen());
        this.n.setSelected(menuModifier.isComboModifier());
        this.m.setSelected(menuModifier.isFixedPrice());
        this.o.setSelected(menuModifier.isTaxable());
        boolean bl = POSUtil.getBoolean(menuModifier.getProperty("tax.same.as.item"));
        if (bl) {
            this.s.setSelected(true);
        } else {
            this.t.setSelected(true);
        }
        if (menuModifier.getSortOrder() != null) {
            this.g.setText(menuModifier.getSortOrder().toString());
        }
        if (menuModifier.getButtonColor() != null) {
            object2 = new Color(menuModifier.getButtonColor());
            this.h.setBackground((Color)object2);
            this.i.setBackground((Color)object2);
        }
        if (menuModifier.getTextColor() != null) {
            object2 = new Color(menuModifier.getTextColor());
            this.i.setForeground((Color)object2);
        }
        if (menuModifier.getTaxGroup() != null) {
            this.b.setSelectedItem(menuModifier.getTaxGroup());
        }
        if ((object2 = menuModifier.getMultiplierPriceList()) != null && object2.size() > 0) {
            object = object2.iterator();
            while (object.hasNext()) {
                MultiplierPricePanel multiplierPricePanel;
                ModifierMultiplierPrice modifierMultiplierPrice = (ModifierMultiplierPrice)object.next();
                Multiplier multiplier = modifierMultiplierPrice.getMultiplier();
                if (multiplier == null || (multiplierPricePanel = this.l.get(multiplier.getId())) == null) continue;
                multiplierPricePanel.setModifierMultiplierPrice(modifierMultiplierPrice);
            }
        }
        if ((object = this.l.get("Regular")) != null) {
            ((MultiplierPricePanel)object).c.setText(NumberUtil.formatNumber(menuModifier.getPrice()));
        }
    }

    @Override
    protected boolean updateModel() {
        MenuModifier menuModifier = (MenuModifier)this.getBean();
        String string = this.c.getText();
        if (StringUtils.isBlank((String)string)) {
            POSMessageDialog.showError(this, Messages.getString("MenuModifierForm.44"));
            return false;
        }
        double d = this.f.getDoubleOrZero();
        menuModifier.setName(string.trim());
        menuModifier.setExtraPrice(d);
        menuModifier.setShouldPrintToKitchen(this.a.isSelected());
        menuModifier.setComboModifier(this.n.isSelected());
        menuModifier.setTranslatedName(this.d.getText());
        menuModifier.setButtonColor(this.h.getBackground().getRGB());
        menuModifier.setTextColor(this.i.getForeground().getRGB());
        menuModifier.setSortOrder(this.g.getInteger());
        menuModifier.setFixedPrice(this.m.isSelected());
        boolean bl = this.o.isSelected();
        menuModifier.setTaxable(bl);
        if (bl) {
            if (this.s.isSelected()) {
                menuModifier.addProperty("tax.same.as.item", String.valueOf(Boolean.TRUE));
            } else {
                menuModifier.addProperty("tax.same.as.item", String.valueOf(Boolean.FALSE));
                menuModifier.setTaxGroup((TaxGroup)this.b.getSelectedItem());
            }
        }
        ArrayList<ModifierMultiplierPrice> arrayList = new ArrayList<ModifierMultiplierPrice>();
        for (MultiplierPricePanel multiplierPricePanel : this.l.values()) {
            if (!multiplierPricePanel.isSelected()) continue;
            ModifierMultiplierPrice modifierMultiplierPrice = multiplierPricePanel.getMultiplierPrice();
            if (modifierMultiplierPrice == null) {
                modifierMultiplierPrice = new ModifierMultiplierPrice();
                modifierMultiplierPrice.setMultiplier(multiplierPricePanel.getMultiplier());
                modifierMultiplierPrice.setModifierId(menuModifier.getId());
            }
            modifierMultiplierPrice.setPrice(multiplierPricePanel.getPrice());
            arrayList.add(modifierMultiplierPrice);
        }
        MultiplierPricePanel multiplierPricePanel = this.l.get("Regular");
        if (multiplierPricePanel != null) {
            menuModifier.setPrice(multiplierPricePanel.getPrice());
        }
        menuModifier.setMultiplierPriceList(arrayList);
        return true;
    }

    @Override
    public String getDisplayText() {
        MenuModifier menuModifier = (MenuModifier)this.getBean();
        if (menuModifier.getId() == null) {
            return Messages.getString("MenuModifierForm.45");
        }
        return Messages.getString("MenuModifierForm.46");
    }

    protected void doCalculateMultiplierPrice() {
        try {
            MultiplierPricePanel multiplierPricePanel = this.l.get("Regular");
            if (multiplierPricePanel == null) {
                return;
            }
            double d = multiplierPricePanel.getPrice();
            for (MultiplierPricePanel multiplierPricePanel2 : this.l.values()) {
                multiplierPricePanel2.calculatePrice(d);
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    public double getDoubleOrZero(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    @Override
    public void refresh() {
        MenuModifier menuModifier = (MenuModifier)this.getBean();
        MenuModifier menuModifier2 = MenuModifierDAO.getInstance().get(menuModifier.getId());
        this.setBean(menuModifier2);
    }

    private class MultiplierPricePanel
    extends JPanel {
        ModifierMultiplierPrice a;
        Multiplier b;
        DoubleTextField c;

        public MultiplierPricePanel(Multiplier multiplier) {
            this.b = multiplier;
            this.setLayout((LayoutManager)new MigLayout("inset 0,fillx", "[100px][grow][100px]", ""));
            Boolean bl = multiplier.isMain();
            this.c = new DoubleTextField(bl != false ? 6 : 9, bl != false ? 6 : 12);
            this.c.setHorizontalAlignment(4);
            JLabel jLabel = new JLabel(multiplier.getTicketPrefix());
            if (bl.booleanValue()) {
                jLabel.setFont(new Font(null, 1, MenuModifierForm.this.c.getFont().getSize()));
            }
            this.add(jLabel);
            this.add((Component)new JLabel(bl != false ? Messages.getString("MenuModifierForm.35") : Messages.getString("MenuModifierForm.36"), 11), "grow, gapright 10px");
            this.add((Component)this.c, "split 2,grow");
            if (bl.booleanValue()) {
                JButton jButton = new JButton(Messages.getString("MenuModifierForm.41"));
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MenuModifierForm.this.doCalculateMultiplierPrice();
                    }
                });
                this.add(jButton);
            }
        }

        public void calculatePrice(double d) {
            if (this.b.isMain().booleanValue()) {
                return;
            }
            this.c.setText(NumberUtil.formatNumber(d * this.b.getRate() / 100.0));
        }

        public Double getPrice() {
            double d = this.c.getDoubleOrZero();
            if (d < 0.0) {
                throw new PosException(Messages.getString("NegativePriceNotAllowed"));
            }
            return d;
        }

        public Multiplier getMultiplier() {
            return this.b;
        }

        public boolean isSelected() {
            Double d = this.c.getDouble();
            return !d.isNaN();
        }

        private void a() {
            if (this.a == null) {
                return;
            }
            this.c.setText(NumberUtil.formatNumber(this.a.getPrice()));
        }

        public void setModifierMultiplierPrice(ModifierMultiplierPrice modifierMultiplierPrice) {
            this.a = modifierMultiplierPrice;
            this.a();
        }

        public ModifierMultiplierPrice getMultiplierPrice() {
            return this.a;
        }
    }
}

