/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PizzaCrust;
import com.floreantpos.model.PizzaPrice;
import com.floreantpos.model.dao.MenuItemSizeDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.PizzaCrustDAO;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.combobox.ListComboBoxModel;

public class PizzaItemPriceDialog
extends POSDialog {
    private JPanel b;
    private JButton c;
    private JButton d;
    private JComboBox e;
    private JComboBox f;
    private DoubleTextField g;
    private PizzaPrice h;
    List<PizzaPrice> a;

    public PizzaItemPriceDialog(Frame frame, PizzaPrice pizzaPrice, List<PizzaPrice> list) {
        super(frame, true);
        this.h = pizzaPrice;
        this.a = list;
        this.a();
        this.d();
    }

    private void a() {
        this.e();
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.c);
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PizzaItemPriceDialog.this.b();
            }
        });
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PizzaItemPriceDialog.this.c();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PizzaItemPriceDialog.this.c();
            }
        });
        this.b.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PizzaItemPriceDialog.this.c();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    private void b() {
        if (!this.updateModel()) {
            return;
        }
        try {
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void c() {
        this.setCanceled(true);
        this.dispose();
    }

    private void d() {
        if (this.h == null) {
            return;
        }
        this.f.setSelectedItem(this.h.getSize());
        this.e.setSelectedItem(this.h.getCrust());
        this.g.setText(String.valueOf(this.h.getPrice()));
    }

    public boolean updateModel() {
        if (this.h == null) {
            this.h = new PizzaPrice();
        }
        if (this.f.getSelectedItem() == null) {
            POSMessageDialog.showError(this, Messages.getString("PizzaItemPriceDialog.0"));
            return false;
        }
        if (this.e.getSelectedItem() == null) {
            POSMessageDialog.showError(this, Messages.getString("PizzaItemPriceDialog.1"));
            return false;
        }
        if (this.g.getText() == null) {
            POSMessageDialog.showError(this, Messages.getString("PizzaItemPriceDialog.2"));
            return false;
        }
        double d = 0.0;
        try {
            d = Double.parseDouble(this.g.getText());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.PRICE_IS_NOT_VALID_);
            return false;
        }
        if (d < 0.0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("NegativePriceNotAllowed"));
            return false;
        }
        if (this.a != null) {
            for (PizzaPrice pizzaPrice : this.a) {
                if (!pizzaPrice.getSize().equals(this.f.getSelectedItem()) || !pizzaPrice.getCrust().equals(this.e.getSelectedItem()) || pizzaPrice == this.h) continue;
                POSMessageDialog.showMessage(this, Messages.getString("PizzaItemPriceDialog.3"));
                return false;
            }
        }
        this.h.setSize((MenuItemSize)this.f.getSelectedItem());
        this.h.setCrust((PizzaCrust)this.e.getSelectedItem());
        this.h.setPrice(d);
        return true;
    }

    private void e() {
        this.b = new JPanel(new BorderLayout());
        List<MenuItemSize> list = MenuItemSizeDAO.getInstance().findAll();
        List<PizzaCrust> list2 = PizzaCrustDAO.getInstance().findAll();
        List<OrderType> list3 = OrderTypeDAO.getInstance().findAll();
        list3.add(0, null);
        JLabel jLabel = new JLabel();
        jLabel.setText(Messages.getString("PizzaItemPriceDialog.4"));
        this.f = new JComboBox(new ListComboBoxModel(list));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(Messages.getString("PizzaItemPriceDialog.5"));
        this.e = new JComboBox(new ListComboBoxModel(list2));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(POSConstants.PRICE + ":");
        this.g = new DoubleTextField();
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("", "grow", ""));
        jPanel.add((Component)jLabel, "right");
        jPanel.add((Component)this.f, "grow,wrap");
        jPanel.add((Component)jLabel2, "right");
        jPanel.add((Component)this.e, "grow,wrap");
        jPanel.add((Component)jLabel3, "right");
        jPanel.add((Component)this.g, "grow");
        this.b.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("al center center", "sg", ""));
        this.c = new JButton(Messages.getString("MenuItemPriceByOrderTypeDialog.0"));
        this.d = new JButton(Messages.getString("Cancel"));
        jPanel2.add((Component)this.c, "grow");
        jPanel2.add((Component)this.d, "grow");
        this.b.add((Component)jPanel2, "South");
        this.add(this.b);
    }

    public PizzaPrice getPizzaPrice() {
        return this.h;
    }
}

