/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.ComboItem;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.Department;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseMenuItem;
import com.floreantpos.model.base.BaseTicketItemModifier;
import com.floreantpos.model.base.BaseTicketItemSeat;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.AutomatedWeightInputDialog;
import com.floreantpos.ui.dialog.ComboTicketItemSelectionDialog;
import com.floreantpos.ui.dialog.ItemQtySelectionDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.GroupView;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.TicketView;
import com.floreantpos.ui.views.order.actions.CategorySelectionListener;
import com.floreantpos.ui.views.order.actions.GroupSelectionListener;
import com.floreantpos.ui.views.order.actions.ItemSelectionListener;
import com.floreantpos.ui.views.order.actions.TicketEditListener;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionDialog;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionModel;
import com.floreantpos.ui.views.order.multipart.PizzaModifierSelectionDialog;
import com.floreantpos.ui.views.voidticket.VoidInfoInputDialog;
import com.floreantpos.webservice.CloudDataUploader;
import java.awt.Dialog;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;

public class OrderController
implements CategorySelectionListener,
GroupSelectionListener,
ItemSelectionListener {
    protected OrderView orderView;
    List<TicketEditListener> a;

    public OrderController(OrderView orderView) {
        this.orderView = orderView;
        orderView.getCategoryView().addCategorySelectionListener(this);
        orderView.getGroupView().addGroupSelectionListener(this);
        orderView.getItemView().addItemSelectionListener(this);
        this.a = new ArrayList<TicketEditListener>();
    }

    @Override
    public void categorySelected(MenuCategory menuCategory) {
        try {
            this.orderView.showView("GROUP_VIEW");
            this.orderView.getGroupView().setMenuCategory(menuCategory);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    @Override
    public void groupSelected(MenuGroup menuGroup) {
        try {
            this.orderView.showView("ITEM_VIEW");
            this.orderView.getItemView().setMenuGroup(menuGroup);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    @Override
    public void itemSelected(MenuItem menuItem) {
        try (Session session = MenuItemDAO.getInstance().createNewSession();){
            Object object;
            Object object2;
            Serializable serializable;
            menuItem = MenuItemDAO.getInstance().get(menuItem.getId(), session);
            if (!this.a(menuItem, 1.0)) {
                return;
            }
            if (menuItem.isVariant().booleanValue()) {
                serializable = MenuItemDAO.getInstance().get(menuItem.getParentMenuItemId(), session);
                menuItem.setParentMenuItem((MenuItem)serializable);
            }
            if (menuItem.isHasVariant().booleanValue()) {
                this.orderView.getItemView().rendererVariants(menuItem);
                return;
            }
            serializable = this.orderView.getTicketView();
            Ticket ticket = this.orderView.getCurrentTicket();
            double d = 1.0;
            IUnit iUnit = null;
            if (menuItem.isFractionalUnit().booleanValue() || menuItem.isAllowUnitSelection()) {
                if (TerminalConfig.getScaleActivationValue().equals("cas10")) {
                    d = AutomatedWeightInputDialog.takeDoubleInput(menuItem.getName(), 1.0);
                } else {
                    ItemQtySelectionDialog itemQtySelectionDialog = ItemQtySelectionDialog.getQtyAndUnit(menuItem, Messages.getString("OrderController.2"), 1.0);
                    itemQtySelectionDialog.pack();
                    itemQtySelectionDialog.open();
                    d = itemQtySelectionDialog.isCanceled() ? -1.0 : itemQtySelectionDialog.getValue();
                    iUnit = itemQtySelectionDialog.getSelectedUnit();
                }
                if (d <= -1.0) {
                    return;
                }
                if (d == 0.0) {
                    POSMessageDialog.showError(Messages.getString("OrderController.3"));
                    return;
                }
            }
            double d2 = 0.0;
            if (menuItem.isEditablePrice().booleanValue()) {
                d2 = NumberSelectionDialog2.takeDoubleInput(Messages.getString("OrderController.5"), menuItem.getPrice());
                if (d2 <= -1.0) {
                    return;
                }
                menuItem.setPrice(d2);
            }
            TicketItem ticketItem = menuItem.convertToTicketItem(ticket, d, iUnit);
            String string = null;
            boolean bl = false;
            double d3 = 0.0;
            if (this.orderView.isReturnMode()) {
                object2 = new VoidInfoInputDialog(ticketItem);
                ((Window)object2).setSize(PosUIManager.getSize(400, 600));
                ((POSDialog)object2).open();
                if (((POSDialog)object2).isCanceled()) {
                    return;
                }
                string = ((VoidInfoInputDialog)object2).getVoidReason();
                bl = ((VoidInfoInputDialog)object2).isItemWasted();
                d3 = ((VoidInfoInputDialog)object2).getVoidQuantity();
            }
            if (menuItem.isVariant().booleanValue()) {
                menuItem = menuItem.getParentMenuItem();
            }
            if (menuItem.isComboItem().booleanValue()) {
                if (this.orderView.isReturnMode() && d3 > 1.0) {
                    ticketItem.setQuantity(d3);
                }
                if (!this.a(menuItem, ticketItem)) {
                    return;
                }
            }
            if (this.orderView.isReturnMode()) {
                ticketItem.markVoided(string, bl, d3, true);
            }
            ticketItem.setTicket(ticket);
            object2 = this.orderView.getSelectedSeatNumber();
            if (object2 instanceof Integer) {
                ticketItem.setSeatNumber((Integer)object2);
            } else if (object2 instanceof TicketItemSeat) {
                object = (TicketItemSeat)object2;
                ticketItem.setSeat((TicketItemSeat)object);
                ticketItem.setSeatNumber(((BaseTicketItemSeat)object).getSeatNumber());
            }
            if (menuItem.isPizzaType().booleanValue()) {
                object = new PizzaModifierSelectionDialog(ticket, ticketItem, menuItem, false);
                ((Dialog)object).setResizable(false);
                if (TerminalConfig.isKioskMode()) {
                    ((POSDialog)object).openUndecoratedFullScreen();
                } else {
                    ((POSDialog)object).openFullScreen();
                }
                if (((POSDialog)object).isCanceled()) {
                    return;
                }
                List<TicketItem> list = ((PizzaModifierSelectionDialog)object).getPizzzItemList();
                for (TicketItem ticketItem2 : list) {
                    ((TicketView)serializable).addTicketItem(ticketItem2);
                }
                this.fireTicketItemUpdated(ticket, ticketItem);
            } else if (menuItem.hasMandatoryModifiers()) {
                object = new ModifierSelectionModel(ticket, ticketItem, menuItem);
                ModifierSelectionDialog modifierSelectionDialog = new ModifierSelectionDialog((ModifierSelectionModel)object);
                modifierSelectionDialog.open();
                if (!modifierSelectionDialog.isCanceled()) {
                    ((TicketView)serializable).addTicketItem(ticketItem);
                    this.fireTicketItemUpdated(ticket, ticketItem);
                }
            } else {
                ((TicketView)serializable).addTicketItem(ticketItem);
                this.fireTicketItemUpdated(ticket, ticketItem);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private boolean a(MenuItem menuItem, double d) {
        List<TicketItem> list;
        if (menuItem == null || !menuItem.isDisableWhenStockAmountIsZero().booleanValue() || menuItem.isHasVariant().booleanValue()) {
            return true;
        }
        Ticket ticket = this.orderView.getCurrentTicket();
        double d2 = 0.0;
        if (ticket != null && (list = ticket.getTicketItems()) != null) {
            for (TicketItem ticketItem : list) {
                if (!ticketItem.getMenuItemId().equals(menuItem.getId())) continue;
                d2 += ticketItem.getQuantity() - ticketItem.getInventoryAdjustQty();
            }
        }
        d2 += d;
        return !(menuItem.getAvailableUnit() < d2) || POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), Messages.getString("OrderController.6"), Messages.getString("CONFIRM"), Messages.getString("OrderController.8"), Messages.getString("OrderController.9")) == 0;
    }

    public void doEditTicketItemQuantity(Object object) {
        TicketItem ticketItem = (TicketItem)object;
        MenuItem menuItem = ticketItem.getMenuItem();
        IUnit iUnit = null;
        double d = 0.0;
        if (ticketItem.isFractionalUnit().booleanValue() || ticketItem.isAllowUnitSelection()) {
            ItemQtySelectionDialog itemQtySelectionDialog = ItemQtySelectionDialog.getQtyAndUnit(menuItem, DataProvider.get().getUnitByCode(ticketItem.getUnitName()), Messages.getString("OrderController.2"), ticketItem.getQuantity());
            itemQtySelectionDialog.pack();
            itemQtySelectionDialog.open();
            d = itemQtySelectionDialog.isCanceled() ? -1.0 : itemQtySelectionDialog.getValue();
            iUnit = itemQtySelectionDialog.getSelectedUnit();
        } else {
            d = NumberSelectionDialog2.takeIntInput(Messages.getString("OrderController.10"), Math.abs(ticketItem.getQuantity()));
        }
        if (d <= 0.0) {
            return;
        }
        if (d > ticketItem.getQuantity() && !this.a(menuItem, d - ticketItem.getQuantity())) {
            return;
        }
        if (this.orderView.isReturnMode()) {
            ticketItem.markVoided(Messages.getString("OrderController.12"), false, ticketItem.getQuantity(), true);
        } else {
            if (menuItem != null) {
                if (menuItem.isComboItem().booleanValue()) {
                    this.updateComboTicketItemQuantity(ticketItem, d);
                }
                if (iUnit != null) {
                    double d2 = menuItem.getUnitQuantity(menuItem.getUnit(), iUnit);
                    String string = "unit.{name}.price";
                    string = string.replace("{name}", iUnit.getUniqueCode());
                    String string2 = menuItem.getProperty(string);
                    OrderType orderType = ticketItem.getTicket().getOrderType();
                    Department department = Application.getInstance().getTerminal().getDepartment();
                    SalesArea salesArea = ticketItem.getTicket().getSalesArea();
                    Customer customer = ticketItem.getTicket().getCustomer();
                    CustomerGroup customerGroup = customer == null ? null : customer.getCustomerGroup();
                    Double d3 = DataProvider.get().getPriceFromPriceRule(menuItem, orderType, department, salesArea, customerGroup);
                    d3 = StringUtils.isNotEmpty((String)string2) ? Double.valueOf(menuItem.getPrice() / d3 * Double.parseDouble(string2)) : Double.valueOf(d3 / d2);
                    Double d4 = menuItem.getCost() / d2;
                    ticketItem.setUnitName(iUnit.getUniqueCode());
                    ticketItem.setUnitCost(d4);
                    ticketItem.setUnitPrice(d3);
                }
            }
            ticketItem.setQuantity(d);
        }
        this.fireTicketItemUpdated(ticketItem.getTicket(), ticketItem);
    }

    public void updateComboTicketItemQuantity(TicketItem ticketItem, double d) {
        List<TicketItem> list = ticketItem.getComboItems();
        double d2 = ticketItem.getQuantity();
        double d3 = d - d2;
        if (list != null) {
            for (TicketItem ticketItem2 : list) {
                ticketItem2.setQuantity(ticketItem2.getQuantity() + d3 * ticketItem2.getQuantity() / d2);
            }
        }
    }

    private boolean a(MenuItem menuItem, TicketItem ticketItem) {
        ComboTicketItem comboTicketItem = (ComboTicketItem)ticketItem;
        Ticket ticket = this.orderView.getCurrentTicket();
        if (menuItem.getComboItems() != null && !menuItem.getComboItems().isEmpty()) {
            for (ComboItem comboItem : menuItem.getComboItems()) {
                POSDialog pOSDialog;
                MenuItemDAO menuItemDAO;
                MenuItem menuItem2;
                if (comboItem.getQuantity() == 0.0 || comboItem.getItemId() == null || (menuItem2 = (menuItemDAO = MenuItemDAO.getInstance()).get(comboItem.getItemId())) == null) continue;
                menuItemDAO.initialize(menuItem2);
                if (menuItem2.isVariant().booleanValue()) {
                    menuItemDAO.initialize(menuItem2.getParentMenuItem());
                }
                TicketItem ticketItem2 = menuItem2.convertToTicketItem(ticket, comboItem.getQuantity());
                ticketItem2.setMenuItem(menuItem2);
                if (menuItem2.hasMandatoryModifiers()) {
                    pOSDialog = new ModifierSelectionDialog(new ModifierSelectionModel(ticket, ticketItem2, menuItem2));
                    pOSDialog.open();
                    if (pOSDialog.isCanceled()) {
                        return false;
                    }
                } else if (menuItem.isPizzaType().booleanValue()) {
                    pOSDialog = new PizzaModifierSelectionDialog(ticket, ticketItem2, menuItem2, false);
                    pOSDialog.openFullScreen();
                    if (pOSDialog.isCanceled()) {
                        return false;
                    }
                }
                ticketItem2.setMenuItemId(menuItem2.getId());
                ticketItem2.setName(menuItem2.getName());
                ticketItem2.setQuantity(comboTicketItem.getQuantity() * comboItem.getQuantity());
                ticketItem2.setParentTicketItem(comboTicketItem);
                ticketItem2.setTicket(null);
                ticketItem2.setGroupId(null);
                comboTicketItem.addTocomboItems(ticketItem2);
            }
        }
        if (menuItem.getComboGroups() != null && !menuItem.getComboGroups().isEmpty()) {
            ComboTicketItemSelectionDialog comboTicketItemSelectionDialog = new ComboTicketItemSelectionDialog(menuItem, comboTicketItem);
            comboTicketItemSelectionDialog.setTitle(Messages.getString("OrderController.13"));
            comboTicketItemSelectionDialog.setSize(PosUIManager.getSize(1024, 700));
            comboTicketItemSelectionDialog.open();
            if (comboTicketItemSelectionDialog.isCanceled()) {
                return false;
            }
            if (menuItem.isModifiablePriceForComboItem()) {
                comboTicketItem.doCalculateComboItemPrice();
            }
        }
        return true;
    }

    public void itemSelectionFinished(MenuGroup menuGroup) {
        GroupView groupView;
        MenuCategory menuCategory = menuGroup.getParent();
        if (!menuCategory.equals((groupView = this.orderView.getGroupView()).getMenuCategory())) {
            groupView.setMenuCategory(menuCategory);
        }
        this.orderView.showView("GROUP_VIEW");
    }

    public static void openModifierDialog(ITicketItem iTicketItem) {
        try {
            ArrayList arrayList;
            List<TicketItemModifier> list;
            Comparable comparable;
            Ticket ticket = OrderView.getInstance().getCurrentTicket();
            TicketItem ticketItem = null;
            if (iTicketItem instanceof TicketItem) {
                ticketItem = (TicketItem)iTicketItem;
            } else if (iTicketItem instanceof TicketItemModifier && (ticketItem = ((BaseTicketItemModifier)(comparable = (TicketItemModifier)iTicketItem)).getTicketItem()) == null) {
                ticketItem = ((BaseTicketItemModifier)comparable).getTicketItem();
            }
            comparable = ticketItem.getMenuItem();
            MenuItemDAO.getInstance().initialize((MenuItem)comparable);
            if (((BaseMenuItem)comparable).isVariant().booleanValue()) {
                comparable = ((MenuItem)comparable).getParentMenuItem();
                MenuItemDAO.getInstance().initialize((MenuItem)comparable);
            }
            if ((list = ticketItem.getTicketItemModifiers()) == null) {
                list = new ArrayList<TicketItemModifier>();
            }
            TicketItem ticketItem2 = ticketItem.clone();
            boolean bl = ticketItem.isPizzaType();
            if (bl) {
                arrayList = new PizzaModifierSelectionDialog(ticket, ticketItem2, (MenuItem)comparable, true);
                ((POSDialog)((Object)arrayList)).openFullScreen();
                if (((POSDialog)((Object)arrayList)).isCanceled()) {
                    return;
                }
                TicketItemModifier ticketItemModifier = ticketItem2.getSizeModifier();
                ticketItemModifier.setTicketItem(ticketItem);
                ticketItem.setSizeModifier(ticketItemModifier);
                ticketItem.setQuantity(ticketItem2.getQuantity());
                ticketItem.setUnitPrice(ticketItem2.getUnitPrice());
            } else {
                arrayList = new ModifierSelectionDialog(new ModifierSelectionModel(ticket, ticketItem2, (MenuItem)comparable));
                ((POSDialog)((Object)arrayList)).open();
                if (((POSDialog)((Object)arrayList)).isCanceled()) {
                    return;
                }
            }
            arrayList = ticketItem2.getTicketItemModifiers();
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            list.clear();
            for (TicketItemModifier ticketItemModifier : arrayList) {
                ticketItemModifier.setTicketItem(ticketItem);
                ticketItem.addToticketItemModifiers(ticketItemModifier);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
        OrderView.getInstance().getTicketView().getTicketViewerTable().updateView();
    }

    public static synchronized void saveOrder(Ticket ticket) {
        if (ticket == null) {
            return;
        }
        TicketDAO.getInstance().saveOrUpdate(ticket);
    }

    public static synchronized void closeOrder(Ticket ticket) {
        ticket.setClosed(true);
        ticket.setClosingDate(StoreDAO.getServerTimestamp());
        TicketDAO.getInstance().saveOrUpdate(ticket);
        User user = ticket.getAssignedDriver();
        if (user != null) {
            user.setAvailableForDelivery(true);
            UserDAO.getInstance().saveOrUpdate(user);
        }
        CloudDataUploader.get().uploadToCloudIfOnlineOrder(ticket);
    }

    public void addTicketUpdateListener(TicketEditListener ticketEditListener) {
        this.a.add(ticketEditListener);
    }

    public void removeTicketUpdateListener(TicketEditListener ticketEditListener) {
        this.a.remove(ticketEditListener);
    }

    public void fireTicketItemUpdated(Ticket ticket, TicketItem ticketItem) {
        for (TicketEditListener ticketEditListener : this.a) {
            ticketEditListener.itemAdded(ticket, ticketItem);
        }
    }

    public void fireTicketEditingStart(Ticket ticket) {
        for (TicketEditListener ticketEditListener : this.a) {
            ticketEditListener.ticketEditingStart(ticket);
        }
    }

    public void fireTicketEdited(Ticket ticket) {
        for (TicketEditListener ticketEditListener : this.a) {
            ticketEditListener.ticketEdited(ticket);
        }
    }

    public void fireTicketEditingFinish(Ticket ticket) {
        for (TicketEditListener ticketEditListener : this.a) {
            ticketEditListener.ticketEditingFinish(ticket);
        }
    }
}

