/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ScrollableFlowPanel;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.TicketInfoButton;
import com.floreantpos.util.POSUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;

public class StyledTicketSelectionDialog
extends OkCancelOptionDialog
implements MouseListener {
    private ScrollableFlowPanel a;
    private Map<String, Ticket> b = new HashMap<String, Ticket>();
    private POSToggleButton c;
    private boolean d;
    private boolean e;
    private Integer f;
    public static Dimension tokenSize = PosUIManager.getSize(180, 160);

    public StyledTicketSelectionDialog() {
        this(false);
    }

    public StyledTicketSelectionDialog(boolean bl) {
        super((Window)Application.getPosWindow());
        this.e = bl;
        this.a();
        this.b();
    }

    public StyledTicketSelectionDialog(List<Ticket> list) {
        this.a();
        this.a(list);
        this.setResizable(true);
    }

    private void a() {
        this.setOkButtonText(Messages.getString("DONE"));
        this.a = new ScrollableFlowPanel(3);
        this.c = new POSToggleButton(Messages.getString("StyledTicketSelectionDialog.0"));
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StyledTicketSelectionDialog.this.b.clear();
                for (Component component : StyledTicketSelectionDialog.this.a.getContentPane().getComponents()) {
                    TicketInfoButton ticketInfoButton = (TicketInfoButton)component;
                    if (StyledTicketSelectionDialog.this.c.isSelected()) {
                        ticketInfoButton.setSelected(true);
                        StyledTicketSelectionDialog.this.b.put(ticketInfoButton.getTicket().getId(), ticketInfoButton.getTicket());
                        continue;
                    }
                    ticketInfoButton.setSelected(false);
                }
            }
        });
        this.getButtonPanel().add((Component)this.c, 0);
        PosScrollPane posScrollPane = new PosScrollPane(this.a, 20, 31);
        posScrollPane.getVerticalScrollBar().setPreferredSize(PosUIManager.getSize(40, 0));
        this.getContentPanel().add((Component)posScrollPane, "Center");
        this.setSize(1024, 600);
    }

    private void b() {
        this.setCaption(Messages.getString("StyledTicketSelectionDialog.1"));
        this.a((List<Ticket>)null);
    }

    private void a(List<Ticket> list) {
        try {
            if (list == null || list.size() <= 0) {
                User user = Application.getCurrentUser();
                list = !user.hasPermission(UserPermission.EDIT_OTHER_USERS_TICKETS) ? TicketDAO.getInstance().findOpenTicketsForUser(user) : TicketDAO.getInstance().findOpenTickets();
            }
            for (Ticket ticket : list) {
                OrderType orderType;
                ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
                if ((ticket.getDueAmount() <= 0.0 || !this.e) && !ticket.getDueAmount().equals(ticket.getTotalAmountWithTips()) || (orderType = ticket.getOrderType()) != null && orderType.isBarTab().booleanValue()) continue;
                TicketInfoButton ticketInfoButton = new TicketInfoButton(ticket);
                ticketInfoButton.addMouseListener(this);
                this.a.add(ticketInfoButton);
                ticketInfoButton.setPreferredSize(tokenSize);
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, posException.getLocalizedMessage(), posException);
        }
    }

    @Override
    public void doOk() {
        if (this.b.isEmpty() && this.f == null) {
            POSMessageDialog.showMessage(Messages.getString("TicketSelectionDialog.5"));
            return;
        }
        if (this.f != null && this.b.size() < this.f) {
            POSMessageDialog.showMessage(Messages.getString("StyledTicketSelectionDialog.2") + this.f + Messages.getString("StyledTicketSelectionDialog.3"));
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    @Override
    public void doCancel() {
        this.b.clear();
        this.setCanceled(true);
        this.dispose();
    }

    public List<Ticket> getSelectedTickets() {
        return new ArrayList<Ticket>(this.b.values());
    }

    public Ticket getMainTicket() {
        return this.b.get("root");
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        TicketInfoButton ticketInfoButton = (TicketInfoButton)mouseEvent.getSource();
        if (this.d) {
            this.setSelectedSectionForMerge(ticketInfoButton);
        } else {
            this.setSelectedSection(ticketInfoButton);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void setSelectedSectionForMerge(TicketInfoButton ticketInfoButton) {
        for (Component component : this.a.getContentPane().getComponents()) {
            TicketInfoButton ticketInfoButton2 = (TicketInfoButton)component;
            if (ticketInfoButton2 != ticketInfoButton) continue;
            if (ticketInfoButton2.isSelected()) {
                if (this.b.get("root") == ticketInfoButton2.getTicket() && this.b.values().size() > 1) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("StyledTicketSelectionDialog.9"));
                    continue;
                }
                if (this.b.get("root") == ticketInfoButton2.getTicket()) {
                    this.b.remove("root");
                } else {
                    this.b.remove(ticketInfoButton2.getTicket().getId());
                }
                ticketInfoButton2.setSelected(false);
                continue;
            }
            ticketInfoButton2.setSelected(true);
            if (this.b.isEmpty()) {
                ticketInfoButton2.setBorder(BorderFactory.createLineBorder(Color.GREEN, 4));
                this.b.put("root", ticketInfoButton2.getTicket());
                continue;
            }
            this.b.put(ticketInfoButton2.getTicket().getId(), ticketInfoButton2.getTicket());
        }
    }

    public void setSelectedSection(TicketInfoButton ticketInfoButton) {
        for (Component component : this.a.getContentPane().getComponents()) {
            TicketInfoButton ticketInfoButton2 = (TicketInfoButton)component;
            if (ticketInfoButton2 != ticketInfoButton) continue;
            this.a(ticketInfoButton2);
        }
    }

    private void a(TicketInfoButton ticketInfoButton) {
        if (ticketInfoButton.isSelected()) {
            ticketInfoButton.setSelected(false);
            this.b.remove(ticketInfoButton.getTicket().getId());
        } else {
            ticketInfoButton.setSelected(true);
            this.b.put(ticketInfoButton.getTicket().getId(), ticketInfoButton.getTicket());
        }
    }

    public TicketInfoButton getSelectedSection() {
        for (Component component : this.a.getComponents()) {
            TicketInfoButton ticketInfoButton = (TicketInfoButton)component;
            if (!ticketInfoButton.isSelected()) continue;
            return ticketInfoButton;
        }
        return null;
    }

    public void setMerge(boolean bl) {
        this.d = bl;
        if (bl) {
            this.setCaption(Messages.getString("StyledTicketSelectionDialog.13"));
            this.c.setVisible(false);
        }
    }

    public int getRequiredNumber() {
        return this.f;
    }

    public void setRequiredNumber(int n) {
        this.f = n;
    }
}

