/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.rest.service.server;

import com.floreantpos.PosLog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.GratuityDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.SequenceNumberDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.dao.TicketItemModifierDAO;
import com.floreantpos.model.dao.TicketItemSeatDAO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class TicketDataServiceDao {
    private static TicketDataServiceDao instance;

    private TicketDataServiceDao() {
    }

    public static TicketDataServiceDao getInstance() {
        if (instance == null) {
            instance = new TicketDataServiceDao();
        }
        return instance;
    }

    public static TicketDataServiceDao get() {
        return TicketDataServiceDao.getInstance();
    }

    private void debug(String string) {
        PosLog.debug(this.getClass(), string);
    }

    public void saveOrUpdateTicket(Ticket ticket, boolean bl, boolean bl2) throws Exception {
        GenericDAO genericDAO = new GenericDAO();
        Transaction transaction = null;
        Session session = null;
        try {
            Object object;
            session = genericDAO.createNewSession();
            transaction = session.beginTransaction();
            TicketDAO ticketDAO = TicketDAO.getInstance();
            this.debug(ticket.getId() + " is processing...");
            Ticket ticket2 = ticketDAO.loadFullTicket(ticket.getId());
            if (ticket2 != null) {
                ticket.mergeTicket(ticket2);
            }
            Gratuity gratuity = ticket.getGratuity();
            List<TicketItem> list = ticket.getTicketItems();
            Set<PosTransaction> set = ticket.getTransactions();
            ticket.setUpdateLastUpdateTime(bl);
            ticket.setUpdateSyncTime(bl2);
            ticket.setTicketItems(null);
            ticket.setGratuity(null);
            ticket.setTransactions(null);
            this.saveOrUpdateTicket(session, ticket, ticket2);
            this.saveOrUpdateTicketItems(session, ticket, ticket2, list);
            if (gratuity != null) {
                object = gratuity.getTicketId();
                if (object == null) {
                    gratuity.setTicketId(ticket.getId());
                    this.saveOrUpdateGratuity(session, gratuity);
                } else if (((String)object).equalsIgnoreCase(ticket.getId())) {
                    this.saveOrUpdateGratuity(session, gratuity);
                } else {
                    gratuity = null;
                }
            }
            this.saveOrUpdatePosTransactions(session, ticket, ticket2, set);
            ticket.setTicketItems(list);
            ticket.setGratuity(gratuity);
            ticket.setTransactions(set);
            ticket.setShouldUpdateTableStatus(ticket2 == null);
            this.saveCustomerIfNotExists(session, ticket);
            object = new HashMap();
            for (TicketItem ticketItem : ticket.getTicketItems()) {
                TicketItemSeat ticketItemSeat = ticketItem.getSeat();
                if (ticketItemSeat == null) continue;
                TicketItemSeat ticketItemSeat2 = (TicketItemSeat)object.get(ticketItemSeat.getId());
                if (ticketItemSeat2 == null) {
                    object.put(ticketItemSeat.getId(), ticketItemSeat);
                    continue;
                }
                ticketItem.setSeat(ticketItemSeat2);
            }
            Date date = new Date();
            if (bl) {
                ticket.setLastUpdateTime(date);
            }
            if (bl2) {
                ticket.setLastSyncTime(date);
            }
            session.saveOrUpdate((Object)ticket);
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            PosLog.error(this.getClass(), exception);
            throw exception;
        }
        finally {
            genericDAO.closeSession(session);
        }
    }

    private void saveOrUpdateTicket(Session session, Ticket ticket, Ticket ticket2) {
        if (ticket2 == null) {
            if (StringUtils.isEmpty((String)ticket.getShortId())) {
                ticket.setShortId(RandomStringUtils.randomNumeric((int)7));
            }
            if (ticket.getTokenNo() == 0) {
                ticket.setTokenNo(SequenceNumberDAO.getInstance().getNextSequenceNumber("TICKET_TOKEN_NUMBER", session));
            }
            ticket.setVersion(0L);
            TicketDAO.getInstance().save(ticket, session);
        } else {
            ticket.setVersion(ticket2.getVersion());
        }
    }

    private void saveOrUpdateTicketItems(Session session, Ticket ticket, Ticket ticket2, List<TicketItem> list) {
        List<TicketItem> list2 = null;
        if (ticket2 != null) {
            list2 = ticket2.getTicketItems();
        }
        HashMap<String, TicketItem> hashMap = new HashMap<String, TicketItem>();
        if (list2 != null && list2.size() > 0) {
            for (TicketItem ticketItem : list2) {
                hashMap.put(ticketItem.getId(), ticketItem);
            }
        }
        for (TicketItem ticketItem : list) {
            ticketItem.setTicket(ticket);
            this.saveOrUpdateTicketItem(session, ticketItem, hashMap);
        }
    }

    private void saveOrUpdatePosTransactions(Session session, Ticket ticket, Ticket ticket2, Set<PosTransaction> set) {
        ArrayList<PosTransaction> arrayList = null;
        if (ticket2 != null) {
            arrayList = new ArrayList<PosTransaction>(ticket2.getTransactions());
        }
        if (set != null && set.size() > 0) {
            for (PosTransaction posTransaction : set) {
                posTransaction.setTicket(ticket);
                if (ticket2 == null || arrayList == null || arrayList.isEmpty()) {
                    posTransaction.setVersion(0L);
                    PosTransactionDAO.getInstance().save(posTransaction, session);
                    continue;
                }
                this.saveOrUpdatePosTransaction(session, posTransaction, arrayList);
            }
        }
    }

    private void saveCustomerIfNotExists(Session session, Ticket ticket) {
        Customer customer;
        if (StringUtils.isEmpty((String)ticket.getCustomerId())) {
            return;
        }
        Customer customer2 = CustomerDAO.getInstance().get(ticket.getCustomerId());
        if (customer2 == null && (customer = ticket.getCustomer()) != null) {
            customer.setVersion(0L);
            CustomerDAO.getInstance().save(customer, session);
        }
    }

    private void saveOrUpdateTicketItem(Session session, TicketItem ticketItem, Map<String, TicketItem> map) {
        Object object;
        TicketItemDAO ticketItemDAO = new TicketItemDAO();
        TicketItem ticketItem2 = null;
        TicketItemModifier ticketItemModifier = ticketItem.getSizeModifier();
        List<TicketItemModifier> list = ticketItem.getTicketItemModifiers();
        TicketItemSeat ticketItemSeat = ticketItem.getSeat();
        List<TicketItem> list2 = null;
        if (ticketItem.isComboItem().booleanValue()) {
            list2 = ticketItem.getComboItems();
        }
        ticketItem.setTicketItemModifiers(null);
        ticketItem.setSizeModifier(null);
        ticketItem.setComboItems(null);
        ticketItem.setSeat(null);
        if (map == null || map.isEmpty()) {
            object = ticketItemDAO.get(ticketItem.getId());
            if (object == null) {
                ticketItem.setVersion(0L);
                ticketItemDAO.save(ticketItem, session);
            } else {
                ticketItem.setVersion(((BaseTicketItem)object).getVersion());
            }
        } else {
            ticketItem2 = map.get(ticketItem.getId());
            if (ticketItem2 == null) {
                ticketItem.setVersion(0L);
                ticketItemDAO.save(ticketItem, session);
            } else {
                ticketItem.setVersion(ticketItem2.getVersion());
            }
        }
        this.saveOrSetVersionTicketItemSeat(ticketItemSeat);
        ticketItem.setSeat(ticketItemSeat);
        object = null;
        if (ticketItem2 != null) {
            object = ticketItem2.getTicketItemModifiers();
        }
        if (list != null && list.size() > 0) {
            for (TicketItemModifier object2 : list) {
                object2.setTicketItem(ticketItem);
                if (ticketItem2 == null) {
                    object2.setVersion(0L);
                    TicketItemModifierDAO.getInstance().save(object2, session);
                    continue;
                }
                this.saveTicketItemModifier(session, object2, (List<TicketItemModifier>)object);
            }
        }
        Object object3 = null;
        if (ticketItem2 != null) {
            object3 = ticketItem2.getSizeModifier();
        }
        if (ticketItemModifier != null) {
            ticketItemModifier.setTicketItem(ticketItem);
            this.saveOrUpdateSizeModifier(session, ticketItemModifier, (TicketItemModifier)object3);
        }
        ticketItem.setTicketItemModifiers(list);
        ticketItem.setSizeModifier(ticketItemModifier);
        if (ticketItem.isComboItem().booleanValue()) {
            if (list2 != null && list2.size() > 0) {
                for (TicketItem ticketItem3 : list2) {
                    List<TicketItem> list3;
                    ticketItem3.setParentTicketItem(ticketItem);
                    HashMap<String, TicketItem> hashMap = new HashMap<String, TicketItem>();
                    if (ticketItem2 != null && (list3 = ticketItem2.getComboItems()) != null && list3.size() > 0) {
                        for (TicketItem ticketItem4 : list3) {
                            hashMap.put(ticketItem4.getId(), ticketItem4);
                        }
                    }
                    this.saveOrUpdateTicketItem(session, ticketItem3, ticketItem2 == null ? null : hashMap);
                }
            }
            ticketItem.setComboItems(list2);
        }
    }

    private void saveOrSetVersionTicketItemSeat(TicketItemSeat ticketItemSeat) {
        if (ticketItemSeat == null) {
            return;
        }
        TicketItemSeatDAO ticketItemSeatDAO = new TicketItemSeatDAO();
        TicketItemSeat ticketItemSeat2 = ticketItemSeatDAO.get(ticketItemSeat.getId());
        if (ticketItemSeat2 == null) {
            ticketItemSeatDAO.save(ticketItemSeat);
        } else {
            ticketItemSeat.setVersion(ticketItemSeat2.getVersion());
        }
    }

    private void saveOrUpdateSizeModifier(Session session, TicketItemModifier ticketItemModifier, TicketItemModifier ticketItemModifier2) {
        TicketItemModifierDAO ticketItemModifierDAO = TicketItemModifierDAO.getInstance();
        TicketItemModifier ticketItemModifier3 = ticketItemModifierDAO.get(ticketItemModifier.getId());
        if (ticketItemModifier3 == null) {
            ticketItemModifier.setVersion(0L);
            ticketItemModifierDAO.save(ticketItemModifier, session);
        } else {
            ticketItemModifier.setVersion(ticketItemModifier3.getVersion());
        }
    }

    private void saveTicketItemModifier(Session session, TicketItemModifier ticketItemModifier, List<TicketItemModifier> list) {
        TicketItemModifierDAO ticketItemModifierDAO = new TicketItemModifierDAO();
        if (list == null || list.isEmpty()) {
            return;
        }
        TicketItemModifier ticketItemModifier2 = null;
        int n = list.indexOf(ticketItemModifier);
        if (n != -1) {
            ticketItemModifier2 = list.get(n);
            if (ticketItemModifier2 == null) {
                ticketItemModifier.setVersion(0L);
                ticketItemModifierDAO.save(ticketItemModifier, session);
            } else {
                ticketItemModifier.setVersion(ticketItemModifier2.getVersion());
            }
        } else {
            ticketItemModifier.setVersion(0L);
            ticketItemModifierDAO.save(ticketItemModifier, session);
        }
    }

    private void saveOrUpdateGratuity(Session session, Gratuity gratuity) {
        if (gratuity == null || StringUtils.isEmpty((String)gratuity.getId())) {
            return;
        }
        Gratuity gratuity2 = GratuityDAO.getInstance().get(gratuity.getId());
        if (gratuity2 == null) {
            gratuity.setVersion(0L);
            GratuityDAO.getInstance().save(gratuity, session);
        } else {
            gratuity.setVersion(gratuity2.getVersion());
        }
    }

    private void saveOrUpdatePosTransaction(Session session, PosTransaction posTransaction, List<PosTransaction> list) {
        PosTransactionDAO posTransactionDAO = new PosTransactionDAO();
        if (list == null || list.size() == 0) {
            return;
        }
        PosTransaction posTransaction2 = null;
        int n = list.indexOf(posTransaction);
        if (n != -1) {
            posTransaction2 = list.get(n);
            if (posTransaction2 == null) {
                posTransaction.setVersion(0L);
                posTransactionDAO.save(posTransaction, session);
            } else {
                posTransaction.setVersion(posTransaction2.getVersion());
            }
        } else {
            posTransaction.setVersion(0L);
            posTransactionDAO.save(posTransaction, session);
        }
    }
}

