/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.TicketService;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.VoidTicketDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;
import java.awt.Window;
import java.util.ArrayList;

public class VoidTicketAction
extends PosAction {
    Ticket a;

    public VoidTicketAction(DataChangeListener dataChangeListener) {
        super(POSConstants.VOID_TICKET_BUTTON_TEXT + "/" + POSConstants.REFUND_BUTTON_TEXT, dataChangeListener);
        super.setRequiredPermission(UserPermission.VOID_TICKET);
        this.setMandatoryPermission(true);
    }

    public VoidTicketAction(Ticket ticket) {
        super(POSConstants.VOID_TICKET_BUTTON_TEXT + "/" + POSConstants.REFUND_BUTTON_TEXT);
        super.setRequiredPermission(UserPermission.VOID_TICKET);
        this.setMandatoryPermission(true);
        this.a = ticket;
    }

    @Override
    public void execute() {
        try {
            ArrayList<Ticket> arrayList;
            Ticket ticket = null;
            if (this.a == null) {
                arrayList = this.getSelectedObject();
                if (arrayList == null) {
                    return;
                }
                ticket = arrayList instanceof Ticket ? (Ticket)((Object)arrayList) : TicketService.getTicket((String)((Object)arrayList));
            } else {
                ticket = this.a;
            }
            if (ticket.isVoided().booleanValue()) {
                POSMessageDialog.showMessage(Application.getPosWindow(), POSConstants.TICKET_IS_VOIDED);
                return;
            }
            if (ticket.getPaidAmount() > 0.0) {
                POSMessageDialog.showMessage(Application.getPosWindow(), Messages.getString("VoidTicketAction.0"));
                return;
            }
            TicketDAO.getInstance().loadFullTicket(ticket);
            if (ticket.getPaidAmount() == 0.0 && !ticket.isPrintedToKitchenOrInventoryAdjusted()) {
                arrayList = new ArrayList<Ticket>();
                arrayList.add(ticket);
                TicketDAO.getInstance().deleteTickets(arrayList, true, true);
                ticket.setVoided(true);
                if (this.listener != null) {
                    this.listener.dataRemoved(ticket);
                }
            } else {
                arrayList = new VoidTicketDialog(POSUtil.getFocusedWindow(), ticket);
                ((Window)((Object)arrayList)).setSize(PosUIManager.getSize(550, 280));
                ((POSDialog)((Object)arrayList)).open();
                if (((POSDialog)((Object)arrayList)).isCanceled()) {
                    return;
                }
                if (this.listener != null) {
                    this.listener.dataChanged(ticket);
                }
            }
            POSMessageDialog.showMessage(Messages.getString("VoidTicketAction.3"));
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }
}

