/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.bo.ui.explorer.PizzaExplorer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class PizzaItemExplorerAction
extends AbstractAction {
    public PizzaItemExplorerAction() {
        super(Messages.getString("PizzaItemExplorerAction.0"));
    }

    public PizzaItemExplorerAction(String string) {
        super(string);
    }

    public PizzaItemExplorerAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            PizzaExplorer pizzaExplorer = null;
            int n = jTabbedPane.indexOfTab(Messages.getString("PizzaItemExplorerAction.0"));
            if (n == -1) {
                pizzaExplorer = new PizzaExplorer();
                jTabbedPane.addTab(Messages.getString("PizzaItemExplorerAction.0"), pizzaExplorer);
            } else {
                pizzaExplorer = (PizzaExplorer)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(pizzaExplorer);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

