/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.bo.ui.explorer.ShiftExplorer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class ShiftExplorerAction
extends AbstractAction {
    public ShiftExplorerAction() {
        super(POSConstants.SHIFTS);
    }

    public ShiftExplorerAction(String string) {
        super(string);
    }

    public ShiftExplorerAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            ShiftExplorer shiftExplorer = null;
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            int n = jTabbedPane.indexOfTab(POSConstants.SHIFTS);
            if (n == -1) {
                shiftExplorer = new ShiftExplorer();
                jTabbedPane.addTab(POSConstants.SHIFTS, shiftExplorer);
            } else {
                shiftExplorer = (ShiftExplorer)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(shiftExplorer);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

