/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.Department;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.swing.CheckBoxList;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;

public class DepartmentEntryForm
extends BeanEditor<Department> {
    DefaultMutableTreeNode a;
    private Department b;
    private FixedLengthTextField c;
    private FixedLengthTextField d;
    private FixedLengthTextField e;
    private CheckBoxList f = new CheckBoxList();
    private CheckBoxList g = new CheckBoxList();

    public DepartmentEntryForm(Department department) {
        this.b = department;
        DepartmentDAO.getInstance().initialize(department);
        this.setLayout(new BorderLayout());
        this.a();
        this.setBean(department);
    }

    public DepartmentEntryForm() {
        this.setLayout(new BorderLayout());
        this.a();
    }

    private void a() {
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "Center");
        jPanel.setLayout((LayoutManager)new MigLayout("", "[][grow][]", ""));
        JLabel jLabel = new JLabel(Messages.getString("NAME"));
        jPanel.add((Component)jLabel, "cell 0 0,alignx trailing");
        this.c = new FixedLengthTextField(20, 60);
        jPanel.add((Component)this.c, "cell 1 0,growx");
        JLabel jLabel2 = new JLabel(Messages.getString("DepartmentEntryForm.6"));
        jPanel.add((Component)jLabel2, "cell 0 1,alignx trailing");
        this.d = new FixedLengthTextField(20, 220);
        jPanel.add((Component)this.d, "cell 1 1,growx");
        JLabel jLabel3 = new JLabel(Messages.getString("DepartmentEntryForm.9"));
        jPanel.add((Component)jLabel3, "cell 0 2,alignx trailing");
        this.e = new FixedLengthTextField(20, 255);
        jPanel.add((Component)this.e, "cell 1 2,growx");
        OutletDAO outletDAO = new OutletDAO();
        List<Outlet> list = outletDAO.findAll();
        if (list == null) {
            list = new ArrayList<Outlet>();
        }
        this.g.setModel(list);
        TitledBorder titledBorder = new TitledBorder(Messages.getString("DepartmentEntryForm.0"));
        JScrollPane jScrollPane = new JScrollPane(this.g);
        jScrollPane.setBorder(titledBorder);
        jPanel.add((Component)jScrollPane, "cell 0 3,growx,span 2,center");
        List<SalesArea> list2 = SalesAreaDAO.getInstance().findAll();
        if (list2 == null) {
            return;
        }
        this.f.setModel(list2);
        this.f.setEnabled(false);
        TitledBorder titledBorder2 = new TitledBorder(Messages.getString("DepartmentEntryForm.2"));
        JScrollPane jScrollPane2 = new JScrollPane(this.f);
        jScrollPane2.setBorder(titledBorder2);
        jPanel.add((Component)jScrollPane2, "cell 0 4,growx,span 2,center");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            Department department = (Department)this.getBean();
            DepartmentDAO departmentDAO = new DepartmentDAO();
            departmentDAO.saveOrUpdate(department);
            return true;
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage());
        }
        return false;
    }

    @Override
    public void updateView() {
        Department department = (Department)this.getBean();
        if (department == null) {
            return;
        }
        this.c.setText(department.getName());
        this.d.setText(department.getAddress());
        this.e.setText(department.getDescription());
        this.g.selectItems(department.getOutlets());
        this.f.selectItems(SalesAreaDAO.getInstance().findSalesAreaByDept(department));
    }

    @Override
    public boolean updateModel() {
        String string = this.c.getText();
        Department department = (Department)this.getBean();
        if (department == null) {
            return false;
        }
        GenericDAO.getInstance().checkIdOrNameExists(department.getId(), string, Department.class);
        department.setName(string);
        department.setAddress(this.d.getText());
        department.setDescription(this.e.getText());
        department.setOutlets(this.g.getCheckedValues());
        return true;
    }

    @Override
    public String getDisplayText() {
        if (this.b.getId() == null) {
            return Messages.getString("DepartmentEntryForm.5");
        }
        return Messages.getString("DepartmentEntryForm.7");
    }
}

