/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Store;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.CurrencyDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.OverflowCombobox;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class ChargeConfigurationView
extends ConfigurationView {
    private DoubleTextField a;
    private DoubleTextField b;
    private DoubleTextField c;
    private JCheckBox d;
    private JCheckBox e;
    private JCheckBox f;
    private JComboBox g;
    private JComboBox h;
    private JCheckBox i;
    private JCheckBox j;
    private Outlet k;
    private Store l;
    private JCheckBox m;
    private JCheckBox n;
    private JCheckBox o;
    private JLabel p;
    private IntegerTextField q;

    public ChargeConfigurationView(Store store) {
        this.l = store;
        this.a();
        this.d();
    }

    private void a() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3", "[][grow][]", ""));
        JLabel jLabel = new JLabel(Messages.getString("RestaurantConfigurationView.42") + ":");
        jPanel.add((Component)jLabel, "alignx trailing");
        this.a = new DoubleTextField();
        jPanel.add((Component)this.a, "growx");
        JLabel jLabel2 = new JLabel("%");
        jPanel.add((Component)jLabel2, "wrap");
        JLabel jLabel3 = new JLabel(Messages.getString("RestaurantConfigurationView.48") + ":");
        jPanel.add((Component)jLabel3, "flowy,alignx trailing");
        this.b = new DoubleTextField();
        jPanel.add((Component)this.b, "growx");
        JLabel jLabel4 = new JLabel("%");
        jPanel.add((Component)jLabel4, "wrap");
        JLabel jLabel5 = new JLabel(Messages.getString("ChargeConfigurationView.0"));
        jPanel.add((Component)jLabel5, "flowy,alignx trailing");
        this.c = new DoubleTextField();
        jPanel.add((Component)this.c, "growx");
        JLabel jLabel6 = new JLabel("%");
        jPanel.add((Component)jLabel6, "wrap");
        JLabel jLabel7 = new JLabel(Messages.getString("ChargeConfigurationView.1"));
        this.g = new OverflowCombobox();
        jPanel.add((Component)jLabel7, "alignx trailing");
        jPanel.add((Component)this.g, "grow, wrap");
        JLabel jLabel8 = new JLabel(Messages.getString("ChargeConfigurationView.3"));
        this.h = new JComboBox();
        jPanel.add((Component)jLabel8, "alignx trailing");
        jPanel.add((Component)this.h, "grow, wrap");
        this.p = new JLabel(Messages.getString("NextTokenSequence"));
        jPanel.add((Component)this.p, "alignx trailing");
        this.q = new IntegerTextField();
        jPanel.add((Component)this.q, "growx,wrap");
        this.d = new JCheckBox(Messages.getString("ChargeConfigurationView.5"));
        jPanel.add((Component)this.d, "skip 1, wrap");
        this.e = new JCheckBox(Messages.getString("TaxConfigurationView.4"));
        jPanel.add((Component)this.e, "skip 1,wrap");
        this.e.addItemListener(itemEvent -> this.b());
        this.j = new JCheckBox(Messages.getString("ChargeConfigurationView.4"));
        this.j.setVisible(false);
        jPanel.add((Component)this.j, "skip 1,wrap");
        this.f = new JCheckBox(Messages.getString("ChargeConfigurationView.2"));
        jPanel.add((Component)this.f, "skip 1,wrap");
        this.i = new JCheckBox(Messages.getString("ChargeConfigurationView.6"));
        jPanel.add((Component)this.i, "skip 1,wrap");
        this.m = new JCheckBox(Messages.getString("ChargeConfigurationView.7"));
        jPanel.add((Component)this.m, "skip 1, wrap");
        this.n = new JCheckBox(Messages.getString("ChargeConfigurationView.21"));
        jPanel.add((Component)this.n, "skip 1, wrap");
        this.o = new JCheckBox(Messages.getString("ResetTokenNo"));
        this.o.addActionListener(actionEvent -> this.c());
        jPanel.add((Component)this.o, "skip 1,wrap");
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(null);
        this.add(jScrollPane);
    }

    private void b() {
        if (this.e.isSelected()) {
            this.j.setVisible(true);
        } else {
            this.j.setVisible(false);
        }
    }

    private void c() {
        if (this.o.isSelected()) {
            this.a(true);
        } else {
            this.a(false);
        }
    }

    private void a(boolean bl) {
        this.p.setVisible(bl);
        this.q.setVisible(bl);
    }

    private void d() {
        ArrayList<TaxGroup> arrayList = new ArrayList<TaxGroup>();
        arrayList.add(null);
        arrayList.addAll(TaxGroupDAO.getInstance().findAll());
        this.g.setModel(new ComboBoxModel(arrayList));
        ArrayList<Currency> arrayList2 = new ArrayList<Currency>();
        arrayList2.add(null);
        arrayList2.addAll(CurrencyDAO.getInstance().findAll());
        this.h.setModel(new ComboBoxModel(arrayList2));
        this.n.setSelected(!this.l.isShowVoidedItemsOnTicket());
        boolean bl = this.l.getBooleanProperty("reset.token", true);
        this.o.setSelected(bl);
        String string = this.l.getProperty("token_no.start");
        String string2 = string == null ? String.valueOf(1) : string;
        this.q.setText(string2);
        this.a(bl);
    }

    @Override
    public boolean save() throws Exception {
        if (!this.isInitialized()) {
            return true;
        }
        double d = 0.0;
        double d2 = 0.0;
        String string = null;
        String string2 = null;
        if (StringUtils.isEmpty(string)) {
            string = POSConstants.DOLLAR;
        }
        if (StringUtils.isEmpty(string2)) {
            string2 = "$";
        }
        d = this.a.getDoubleOrZero();
        d2 = this.b.getDoubleOrZero();
        double d3 = this.c.getDoubleOrZero();
        if (d3 > 100.0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ChargeConfigurationView.8"));
            return false;
        }
        this.l.setCurrencyName(string);
        this.l.setCurrencySymbol(string2);
        this.l.addProperty("show_subtotal.without_tax", String.valueOf(this.j.isSelected()));
        this.l.addProperty("overtime.markup", String.valueOf(d3));
        this.l.addProperty("store.peny.rounding", String.valueOf(this.i.isSelected()));
        this.l.addProperty("store.allow.multiple.discount", String.valueOf(this.m.isSelected()));
        this.l.setShowVoidedItemsOnTicket(!this.n.isSelected());
        this.l.setUseDetailedReconciliation(this.d.isSelected());
        this.l.setItemPriceIncludesTax(this.e.isSelected());
        this.l.setEnableFloridaTaxRule(this.f.isSelected());
        if (this.o.isSelected()) {
            int n = this.q.getInteger();
            if (n < 1) {
                throw new PosException(Messages.getString("TokenNoGreaterOne"));
            }
            this.l.addProperty("token_no.start", String.valueOf(n));
        }
        this.l.addProperty("reset.token", String.valueOf(this.o.isSelected()));
        if (this.k != null) {
            this.k.setServiceChargePercentage(d);
            this.k.setDefaultGratuityPercentage(d2);
            TaxGroup taxGroup = (TaxGroup)this.g.getSelectedItem();
            this.k.setTaxGroup(taxGroup);
            Currency currency = (Currency)this.h.getSelectedItem();
            this.k.setCurrency(currency);
            OutletDAO.getInstance().saveOrUpdate(this.k);
        }
        return true;
    }

    @Override
    public void initialize() throws Exception {
        this.k = DataProvider.get().getCurrentTerminal().getOutlet();
        if (this.k == null) {
            this.k = OutletDAO.getInstance().get(DataProvider.get().getStore().getDefaultOutletId());
        }
        if (this.k != null) {
            this.a.setText(String.valueOf(this.k.getServiceChargePercentage()));
            this.b.setText(String.valueOf(this.k.getDefaultGratuityPercentage()));
            this.g.setSelectedItem(this.k.getTaxGroup());
            this.h.setSelectedItem(this.k.getCurrency());
        }
        this.j.setSelected(POSUtil.getBoolean(this.l.getProperty("show_subtotal.without_tax")));
        this.c.setText(String.valueOf(this.l.getOvertimeMarkup()));
        this.d.setSelected(this.l.isUseDetailedReconciliation());
        this.e.setSelected(this.l.isItemPriceIncludesTax());
        this.f.setSelected(this.l.isEnableFloridaTaxRule());
        this.i.setSelected(this.l.isAllowPenyRounding());
        this.m.setSelected(this.l.isAllowMulDiscount());
        this.setInitialized(true);
    }

    @Override
    public String getName() {
        return POSConstants.CONFIG_TAB_CHARGE;
    }
}

