/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.model.Address;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.AddressDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.EnumDateFormat;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.AddressUtil;
import com.floreantpos.util.POSUtil;
import com.jidesoft.swing.AutoCompletionComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class StoreConfigurationView
extends ConfigurationView {
    private Store a;
    private FixedLengthTextField b;
    private FixedLengthTextField c;
    private FixedLengthTextField d;
    private FixedLengthTextField e;
    private FixedLengthTextField f;
    private POSTextField g;
    private IntegerTextField h;
    private POSTextField i;
    private JComboBox<EnumDateFormat> j;
    private AutoCompletionComboBox k;
    private AutoCompletionComboBox l;
    private AutoCompletionComboBox m;
    private AddressUtil n;
    private JLabel o;
    private JLabel p;
    private JLabel q;
    private JLabel r;

    public StoreConfigurationView(Store store) {
        this.a = store;
        this.n = new AddressUtil();
        this.a();
    }

    private void a() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3", "[][grow][][grow]", ""));
        this.o = new JLabel(Messages.getString("RestaurantConfigurationView.3") + ":");
        jPanel.add((Component)this.o, "cell 0 1");
        this.b = new FixedLengthTextField();
        this.b.setLength(120);
        jPanel.add((Component)this.b, "cell 1 1 3 1,growx");
        this.p = new JLabel(Messages.getString("StoreConfigurationView.0") + Messages.getString("StoreConfigurationView.1"));
        jPanel.add((Component)this.p, "cell 0 2");
        this.c = new FixedLengthTextField();
        this.c.setLength(120);
        jPanel.add((Component)this.c, "cell 1 2 3 1,growx");
        JLabel jLabel = new JLabel(Messages.getString("RestaurantConfigurationView.7") + ":");
        jPanel.add((Component)jLabel, "cell 0 3");
        this.d = new FixedLengthTextField();
        this.d.setLength(60);
        jPanel.add((Component)this.d, "cell 1 3 3 1,growx");
        JLabel jLabel2 = new JLabel(Messages.getString("StoreConfigurationView.3") + ":");
        jPanel.add((Component)jLabel2, "cell 0 4");
        this.e = new FixedLengthTextField();
        this.e.setLength(60);
        jPanel.add((Component)this.e, "cell 1 4 3 1,growx");
        JLabel jLabel3 = new JLabel(Messages.getString("StoreConfigurationView.4") + ":");
        jPanel.add((Component)jLabel3, "cell 0 5");
        this.f = new FixedLengthTextField();
        this.f.setLength(60);
        jPanel.add((Component)this.f, "cell 1 5 3 1,growx");
        JLabel jLabel4 = new JLabel(Messages.getString("StoreConfigurationView.5") + ":");
        jPanel.add((Component)jLabel4, "cell 0 6");
        this.k = new AutoCompletionComboBox();
        this.k.setModel(new DefaultComboBoxModel<Object>(this.n.getCountryNames().toArray()));
        jPanel.add((Component)this.k, "cell 1 6 3 1,growx");
        JLabel jLabel5 = new JLabel(Messages.getString("StoreConfigurationView.6") + ":");
        jPanel.add((Component)jLabel5, "cell 0 7");
        this.l = new AutoCompletionComboBox();
        jPanel.add((Component)this.l, "cell 1 7 3 1,growx");
        JLabel jLabel6 = new JLabel(Messages.getString("StoreConfigurationView.7") + ":");
        jPanel.add((Component)jLabel6, "cell 0 8");
        this.m = new AutoCompletionComboBox();
        jPanel.add((Component)this.m, "cell 1 8 3 1,growx");
        JLabel jLabel7 = new JLabel(Messages.getString("RestaurantConfigurationView.19"));
        jPanel.add((Component)jLabel7, "cell 0 9");
        this.h = new IntegerTextField();
        jPanel.add((Component)this.h, "cell 1 9,growx");
        this.h.setColumns(10);
        JLabel jLabel8 = new JLabel(Messages.getString("RestaurantConfigurationView.22"));
        jPanel.add((Component)jLabel8, "cell 0 10");
        this.g = new POSTextField();
        jPanel.add((Component)this.g, "cell 1 10,growx");
        this.q = new JLabel(Messages.getString("StoreConfigurationView.2"));
        jPanel.add((Component)this.q, "cell 0 11");
        this.i = new POSTextField();
        jPanel.add((Component)this.i, "cell 1 11,growx");
        this.r = new JLabel(Messages.getString("DATE_FORMAT"));
        jPanel.add((Component)this.r, "cell 0 12");
        this.j = new JComboBox();
        jPanel.add(this.j, "cell 1 12,growx");
        this.d();
        this.k.addActionListener(actionEvent -> this.b());
        this.l.addActionListener(actionEvent -> this.c());
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(null);
        this.add(jScrollPane);
    }

    private void b() {
        try {
            this.l.setEnabled(true);
            this.m.setEnabled(false);
            String string = (String)this.k.getSelectedItem();
            List<String> list = this.n.getStateNames(string);
            this.l.removeAllItems();
            this.m.removeAllItems();
            this.l.addItem(null);
            for (String string2 : list) {
                this.l.addItem((Object)string2);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void c() {
        try {
            this.m.setEnabled(true);
            String string = (String)this.k.getSelectedItem();
            String string2 = (String)this.l.getSelectedItem();
            List<String> list = this.n.getCityNames(string, string2);
            this.m.removeAllItems();
            this.m.addItem(null);
            for (String string3 : list) {
                this.m.addItem((Object)string3);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void d() {
        LinkedList<EnumDateFormat> linkedList = new LinkedList<EnumDateFormat>();
        linkedList.addAll(Arrays.asList(EnumDateFormat.values()));
        this.j.setModel(new ComboBoxModel(linkedList));
    }

    @Override
    public boolean save() throws Exception {
        Address address;
        String string;
        if (!this.isInitialized()) {
            return true;
        }
        StoreDAO.getInstance().refresh(this.a);
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        string2 = this.b.getText();
        string3 = this.d.getText();
        string4 = this.e.getText();
        string5 = this.f.getText();
        string6 = this.g.getText();
        if (StringUtils.isBlank((String)string2)) {
            POSMessageDialog.showError(this, Messages.getString("StoreConfigurationView.8"));
            this.b.requestFocus();
            this.b.selectAll();
            return false;
        }
        if (StringUtils.isNotBlank((String)string6) && !POSUtil.validatePhoneNo(string6)) {
            POSMessageDialog.showError(this, Messages.getString("QuickCustomerForm.10"));
            this.g.requestFocus();
            this.g.selectAll();
            return false;
        }
        if (StringUtils.isBlank((String)string3)) {
            POSMessageDialog.showError(this, Messages.getString("StoreConfigurationView.9"));
            this.d.requestFocus();
            this.d.selectAll();
            return false;
        }
        String string7 = this.k.getSelectedItem() == null ? "" : this.k.getSelectedItem().toString();
        String string8 = this.l.getSelectedItem() == null ? "" : this.l.getSelectedItem().toString();
        String string9 = string = this.m.getSelectedItem() == null ? "" : this.m.getSelectedItem().toString();
        if (StringUtils.isBlank((String)string7)) {
            POSMessageDialog.showError(this, Messages.getString("StoreConfigurationView.10"));
            return false;
        }
        if (StringUtils.isBlank((String)string8)) {
            POSMessageDialog.showError(this, Messages.getString("StoreConfigurationView.11"));
            return false;
        }
        if (StringUtils.isBlank((String)string)) {
            POSMessageDialog.showError(this, Messages.getString("StoreConfigurationView.12"));
            return false;
        }
        this.a.setName(string2);
        this.a.setOutletName(this.c.getText());
        this.a.setAddressLine1(string3);
        this.a.setAddressLine2(string4);
        this.a.setAddressLine3(string5);
        this.a.setZipCode(this.h.getText());
        this.a.setTelephone(string6);
        this.a.setAdminEmail(this.i.getText());
        EnumDateFormat enumDateFormat = (EnumDateFormat)((Object)this.j.getSelectedItem());
        if (enumDateFormat != null) {
            this.a.setDateFormat(enumDateFormat.getFormat());
        }
        if ((address = this.e()) == null) {
            address = new Address("store-address");
            address.setAddressLine(string3);
            address.setAddressLine2(string4);
            address.setStreet(string5);
            address.setCountry(string7);
            address.setState(string8);
            address.setCity(string);
            address.setZipCode(this.h.getText());
            AddressDAO.getInstance().save(address);
        } else {
            AddressDAO.getInstance().refresh(address);
            address.setAddressLine(string3);
            address.setAddressLine2(string4);
            address.setStreet(string5);
            address.setCountry(string7);
            address.setState(string8);
            address.setCity(string);
            address.setZipCode(this.a.getZipCode());
            AddressDAO.getInstance().update(address);
        }
        this.a.setAddress(address);
        return true;
    }

    @Override
    public void initialize() throws Exception {
        this.b.setText(this.a.getName());
        this.c.setText(this.a.getOutletName());
        this.d.setText(this.a.getAddressLine1());
        this.e.setText(this.a.getAddressLine2());
        this.f.setText(this.a.getAddressLine3());
        Address address = this.a.getAddress();
        if (address != null) {
            this.k.setSelectedItem((Object)address.getCountry());
            this.l.setSelectedItem((Object)address.getState());
            this.m.setSelectedItem((Object)address.getCity());
        }
        this.h.setText(this.a.getZipCode());
        this.g.setText(this.a.getTelephone());
        this.i.setText(this.a.getAdminEmail());
        this.j.setSelectedItem((Object)EnumDateFormat.get(this.a.getDateFormat()));
        this.setInitialized(true);
    }

    @Override
    public String getName() {
        return POSConstants.CONFIG_TAB_STORE;
    }

    public Store getStore() {
        return this.a;
    }

    public void hideNonAddressFields() {
        this.o.setVisible(false);
        this.b.setVisible(false);
        this.p.setVisible(false);
        this.c.setVisible(false);
        this.q.setVisible(false);
        this.i.setVisible(false);
        this.r.setVisible(false);
        this.j.setVisible(false);
    }

    private Address e() {
        Address address = this.a.getAddress();
        if (address == null) {
            return AddressDAO.getInstance().get("store-address");
        }
        return address;
    }
}

