/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.base.BasePurchaseOrderItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.util.NumberUtil;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown=true, value={"menuItem", "purchaseOrder"})
public class PurchaseOrderItem
extends BasePurchaseOrderItem {
    private static final long serialVersionUID = 1L;
    private Double quantityToReceive;
    private MenuItem menuItem;

    public PurchaseOrderItem() {
    }

    public PurchaseOrderItem(String string) {
        super(string);
    }

    public PurchaseOrderItem(String string, PurchaseOrder purchaseOrder) {
        super(string, purchaseOrder);
    }

    public void calculatePrice() {
        this.setSubtotalAmount(NumberUtil.roundToTwoDigit(this.getUnitPrice() * this.getItemQuantity()));
        this.setTotalAmount(NumberUtil.roundToTwoDigit(this.getSubtotalAmount() + this.getTaxAmount() - this.getDiscountAmount()));
    }

    public String getQuantityDisplay() {
        return NumberUtil.format6DigitNumber(super.getItemQuantity());
    }

    public String getPriceDisplay() {
        return NumberUtil.getCurrencyFormatWithoutCurrencySymbol(super.getUnitPrice());
    }

    public String getTotalDisplay() {
        return NumberUtil.getCurrencyFormatWithoutCurrencySymbol(super.getTotalAmount());
    }

    public Double getQuantityToReceive() {
        return this.quantityToReceive == null ? Double.valueOf(0.0) : this.quantityToReceive;
    }

    public void setQuantityToReceive(Double d) {
        this.quantityToReceive = d;
    }

    @XmlTransient
    public MenuItem getMenuItem() {
        if (this.menuItem == null) {
            String string = this.getMenuItemId();
            if (StringUtils.isEmpty((String)string)) {
                return null;
            }
            this.menuItem = MenuItemDAO.getInstance().loadInitialized(string);
        }
        return this.menuItem;
    }

    public void setMenuItem(MenuItem menuItem) {
        this.menuItem = menuItem;
    }
}

