/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Department;
import com.floreantpos.model.Discount;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Printer;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Shift;
import com.floreantpos.model.ShopSeat;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.SubOrderType;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketType;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.TipsReceivedBy;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseTicket;
import com.floreantpos.model.base.BaseTicketItemModifier;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.model.util.TicketUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.DiscountUtil;
import com.floreantpos.util.JsonUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.ShiftUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.beans.Transient;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;

@JsonIgnoreProperties(ignoreUnknown=true, value={"properties", "customer", "tables", "terminal", "createDateFormatted", "title", "outlet", "customerName", "customerEmail", "customerMobileNo", "bartabName", "gratuityAmount"})
@XmlSeeAlso(value={PosTransaction.class, TicketItem.class})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="ticket")
public class Ticket
extends BaseTicket
implements TimedModel {
    public static final String CUSTOMER_TAX_EXEMPT = "customer.taxExempt";
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_ONLINE_ID = "onlineOrderId";
    public static final String PROPERTY_CARD_TRANSACTION_ID = "card_transaction_id";
    public static final String PROPERTY_CARD_TRACKS = "card_tracks";
    public static final String PROPERTY_CARD_NAME = "card_name";
    public static final String PROPERTY_PAYMENT_METHOD = "payment_method";
    public static final String PROPERTY_CARD_READER = "card_reader";
    public static final String PROPERTY_CARD_NUMBER = "card_number";
    public static final String PROPERTY_CARD_EXP_YEAR = "card_exp_year";
    public static final String PROPERTY_CARD_EXP_MONTH = "card_exp_month";
    public static final String PROPERTY_ADVANCE_PAYMENT = "advance_payment";
    public static final String PROPERTY_CARD_AUTH_CODE = "card_auth_code";
    public static final String PROPERTY_SUB_ORDER_TYPE = "ticket.sub_order_type";
    public static final String PROPERTY_LOYALTY_ADDED = "loyalty";
    public static final String PROPERTY_EXTRA_SEATS = "extra_seats";
    public static final String PROPERTY_OUTLET_SC_RATE = "storeScRate";
    private static final String PROPERTY_OUTLET_GRATUITY_RATE = "storeGratuityRate";
    public static final String STATUS_PENDING = "Pending";
    public static final String STATUS_CONFIRMED = "Confirmed";
    public static final String STATUS_WAITING = "Waiting (Kitchen)";
    public static final String STATUS_READY = "Ready";
    public static final String STATUS_NOT_SENT = "Not Sent";
    public static final String STATUS_DRIVING = "Driving";
    public static final String STATUS_VOID = "Void";
    public static final String CUSTOMER_PHONE = "CUSTOMER_MOBILE";
    public static final String CUSTOMER_NAME = "CUSTOMER_NAME";
    public static final String CUSTOMER_LAST_NAME = "CUSTOMER_LAST_NAME";
    public static final String CUSTOMER_ID = "CUSTOMER_ID";
    public static final String CUSTOMER_ZIP_CODE = "CUSTOMER_ZIP_CODE";
    public static final String MANAGER_INSTRUCTION = "MANAGER_INSTRUCTION";
    public static final String PHONE_EXTENSION = "PHONE_EXTENSION";
    public static final String DRIVER_OUT_TIME = "OUT_AT";
    public static final String PROPERTY_DISCOUNT = "DISCOUNT";
    public static final int ORDER_PENDING = 0;
    public static final int ORDER_VERIFIED = 1;
    public static final int ORDER_FULLY_INVOICED = 2;
    public static final int ORDER_PARTIALLY_INVOICED = 3;
    public static final int ORDER_FULLY_SHIPMENT = 4;
    public static final int ORDER_PARTIALLY_SHIPMENT = 5;
    public static final int ORDER_PARTIALLY_SHIPMENT_AND_INVOICED = 6;
    public static final int ORDER_CLOSED = 7;
    public static final int ORDER_CANCELLED = 8;
    private transient Map<String, ActionHistory> events = new LinkedHashMap<String, ActionHistory>();
    public static final String[] ORDER_STATUS = new String[]{"Pending", "Verified", "Fully Invoiced", "Partially Invoiced", "Fully Shipped", "Partially Shipped", "Partially Shipped and Invoiced", "Closed", "Cancelled"};
    public static final String ORDER_VERIFIED_BY = "Verified_By";
    public static final String ORDER_SENT_BY = "Sent_By";
    public static final String ORDER_SHIPMENT_BY = "Shipping_By";
    public static final String ORDER_INVOICED_BY = "Invoiced_By";
    public static final String ORDER_CLOSED_BY = "Closed_By";
    public static final String DEBIT = "DEBIT";
    public static final String CREDIT = "CREDIT";
    public static final String SPLIT = "split";
    public static final String SPLIT_TICKET_ID = "split_ticket_id";
    public static final String SPLIT_SEAT_NUMBER = "split_seat_number";
    public static final String SPLIT_TYPE = "SPLIT_TYPE";
    public static final int SPLIT_EQUALLY = 0;
    public static final int SPLIT_BY_SEAT = 1;
    public static final int SPLIT_MANUALLY = 2;
    private double ticketDiscountAmount;
    private double itemDiscountAmount;
    private double voidSubtotal;
    private double voidTotal;
    private List deletedItems;
    private String sortOrder;
    private boolean needSpecialAttention;
    private transient Customer customer;
    private transient Outlet outlet;
    private transient Department department;
    private transient SalesArea salesArea;
    private List<TicketDiscount> discounts;
    private List<Integer> tableNumbers;
    private List<ShopTable> tables;
    private boolean shouldUpdateTableStatus;
    private boolean shouldUpdateStock;
    private double roundedDueAmount;
    private double toleranceAmount;
    private Boolean refundableItem;
    private transient OrderType orderType;
    private transient com.google.gson.JsonObject propertiesContainer;
    private boolean shouldPublishMqtt = true;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private static final String jSON_PROP_TABLE_NAMES = "tableNames";

    public Ticket() {
    }

    public Ticket(String string) {
        super(string);
    }

    public Ticket(boolean bl) {
        if (bl) {
            this.populateDefaultProperties();
        }
    }

    public TicketType getTicketType() {
        return TicketType.getByTypeNo(super.getType());
    }

    public void setTicketType(TicketType ticketType) {
        if (ticketType != null) {
            super.setType(ticketType.getTypeNo());
        }
    }

    public void addTable(int n) {
        List<Integer> list = this.getTableNumbers();
        if (list == null) {
            list = new ArrayList<Integer>();
        }
        list.add(n);
        this.setTableNumbers(list);
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    @XmlTransient
    public double getGratuityAmount() {
        Gratuity gratuity = this.getGratuity();
        if (gratuity != null) {
            return gratuity.getAmount();
        }
        return 0.0;
    }

    public void updateGratuityInfo() {
        Gratuity gratuity = this.getGratuity();
        if (gratuity == null || gratuity.getAmount() == 0.0) {
            return;
        }
        Store store = DataProvider.get().getStore();
        if (this.getAssignedDriver() != null) {
            TipsReceivedBy tipsReceivedBy = store.getTipsReceivedByForDeliveryOrder();
            if (tipsReceivedBy == TipsReceivedBy.Driver) {
                gratuity.setOwnerId(this.getAssignedDriver().getId());
            } else if (tipsReceivedBy == TipsReceivedBy.Cashier) {
                gratuity.setOwnerId(this.getCashier() != null ? this.getCashier().getId() : this.getOwner().getId());
            } else {
                gratuity.setOwnerId(this.getOwner().getId());
            }
        } else {
            TipsReceivedBy tipsReceivedBy = store.getTipsReceivedByForNonDeliveryOrder();
            if (tipsReceivedBy == TipsReceivedBy.Cashier) {
                gratuity.setOwnerId(this.getCashier().getId());
            } else {
                gratuity.setOwnerId(this.getOwner().getId());
            }
        }
        gratuity.setTicketId(this.getId());
    }

    public void setGratuityAmount(double d) {
        Gratuity gratuity = this.createGratuity();
        gratuity.setAutoCalculated(false);
        gratuity.setAmount(d);
        this.setGratuity(gratuity);
    }

    public Gratuity createGratuity() {
        Gratuity gratuity = this.getGratuity();
        if (gratuity == null) {
            gratuity = new Gratuity();
            gratuity.setTicketId(this.getId());
            Terminal terminal = Application.getInstance().getTerminal();
            if (terminal != null) {
                gratuity.setTerminalId(terminal.getId());
            }
            gratuity.setPaid(false);
        }
        return gratuity;
    }

    public boolean hasGratuity() {
        Gratuity gratuity = this.getGratuity();
        return gratuity != null && gratuity.getAmount() > 0.0;
    }

    @Override
    public void setCreateDate(Date date) {
        super.setCreateDate(date);
        super.setActiveDate(date);
    }

    @Override
    public List<TicketItem> getTicketItems() {
        List<TicketItem> list = super.getTicketItems();
        if (list == null) {
            list = new ArrayList<TicketItem>();
            super.setTicketItems(list);
        }
        return list;
    }

    @Override
    @XmlElement(name="transactionList")
    public Set<PosTransaction> getTransactions() {
        Set<PosTransaction> set = super.getTransactions();
        if (set == null) {
            set = new HashSet<PosTransaction>();
            super.setTransactions(set);
        }
        return set;
    }

    @Override
    public Integer getNumberOfGuests() {
        Integer n = super.getNumberOfGuests();
        if (n == null || n == 0) {
            return 1;
        }
        return n;
    }

    public String getCreateDateFormatted() {
        return DateUtil.formatDateWithTime(this.getCreateDate());
    }

    public String getTitle() {
        String string = "";
        if (this.getId() != null) {
            string = string + "#" + this.getId();
        }
        string = string + ": " + this.getOwner();
        string = string + ":" + this.getCreateDateFormatted();
        string = string + ": " + NumberUtil.formatNumber(this.getTotalAmountWithTips());
        return string;
    }

    public int getBeverageCount() {
        List<TicketItem> list = this.getTicketItems();
        if (list == null) {
            return 0;
        }
        int n = 0;
        for (TicketItem ticketItem : list) {
            if (!ticketItem.isBeverage().booleanValue()) continue;
            n = (int)((double)n + ticketItem.getQuantity());
        }
        return n;
    }

    public void calculatePrice() {
        BigDecimal bigDecimal;
        List<TicketItem> list = this.getTicketItems();
        if (list == null) {
            return;
        }
        if (!this.isShouldCalculatePrice().booleanValue()) {
            this.setDiscountAmount(this.calculateTicketDiscount(this.getSubtotalAmount(), 0.0, 0.0));
            return;
        }
        BigDecimal bigDecimal2 = NumberUtil.convertToBigDecimal(0.0);
        BigDecimal bigDecimal3 = NumberUtil.convertToBigDecimal(0.0);
        BigDecimal bigDecimal4 = NumberUtil.convertToBigDecimal(0.0);
        BigDecimal bigDecimal5 = NumberUtil.convertToBigDecimal(0.0);
        BigDecimal bigDecimal6 = NumberUtil.convertToBigDecimal(0.0);
        this.voidSubtotal = 0.0;
        this.voidTotal = 0.0;
        this.itemDiscountAmount = 0.0;
        this.ticketDiscountAmount = 0.0;
        double d = 0.0;
        this.setRefundableItem(false);
        for (TicketItem ticketItem : list) {
            if (!this.isPriceApplicable(ticketItem)) {
                if (!ticketItem.isVoided().booleanValue()) continue;
                this.setRefundableItem(ticketItem.getVoidItem() != null);
                if (ticketItem.getVoidedItemId() == null) continue;
                this.voidSubtotal += Math.abs(ticketItem.getSubtotalAmount());
                this.voidTotal += Math.abs(ticketItem.getSubtotalAmount()) + Math.abs(ticketItem.getTaxAmount());
                continue;
            }
            ticketItem.calculatePrice();
            bigDecimal2 = NumberUtil.round(bigDecimal2.add(NumberUtil.convertToBigDecimal(ticketItem.getSubtotalAmount())));
            bigDecimal4 = NumberUtil.round(bigDecimal4.add(NumberUtil.convertToBigDecimal(ticketItem.getServiceCharge())));
            bigDecimal5 = NumberUtil.round(bigDecimal5.add(NumberUtil.convertToBigDecimal(ticketItem.getTaxAmount())));
            d += ticketItem.getTaxAmountFromProperty();
            bigDecimal6 = NumberUtil.round(bigDecimal6.add(NumberUtil.convertToBigDecimal(ticketItem.getDiscountAmount())));
            if (ticketItem.isVoided().booleanValue()) {
                this.setRefundableItem(true);
                if (ticketItem.getVoidedItemId() == null) continue;
                this.voidSubtotal += Math.abs(ticketItem.getSubtotalAmount());
                this.voidTotal += Math.abs(ticketItem.getSubtotalAmount()) + Math.abs(ticketItem.getTaxAmount());
                continue;
            }
            this.itemDiscountAmount += ticketItem.getDiscountAmount().doubleValue();
        }
        this.addProperty("tax.exempt.amount", String.valueOf(d));
        this.ticketDiscountAmount = this.calculateTicketDiscount(bigDecimal2.doubleValue(), this.voidSubtotal, this.itemDiscountAmount);
        bigDecimal3 = NumberUtil.convertToBigDecimal(this.calculateTotalDiscountAmount(bigDecimal2.doubleValue(), this.voidSubtotal, this.ticketDiscountAmount, bigDecimal6.doubleValue()));
        double d2 = this.getDeliveryCharge();
        double d3 = this.calculateServiceCharge(bigDecimal2.doubleValue(), bigDecimal3.doubleValue());
        double d4 = d3 + bigDecimal4.doubleValue();
        BigDecimal bigDecimal7 = NumberUtil.convertToBigDecimal(0.0);
        if (this.ticketDiscountAmount > 0.0) {
            BigDecimal bigDecimal8 = bigDecimal2.subtract(NumberUtil.convertToBigDecimal(this.itemDiscountAmount));
            BigDecimal bigDecimal9 = bigDecimal8.subtract(NumberUtil.convertToBigDecimal(this.ticketDiscountAmount));
            bigDecimal = NumberUtil.convertToBigDecimal(0.0);
            if (bigDecimal8.compareTo(BigDecimal.ZERO) > 0) {
                bigDecimal = bigDecimal9.multiply(bigDecimal5).divide(bigDecimal8, 4, RoundingMode.HALF_UP);
            }
            bigDecimal5 = NumberUtil.round(bigDecimal);
            bigDecimal7 = this.isTaxIncluded().booleanValue() ? bigDecimal7.add(bigDecimal9) : bigDecimal7.add(bigDecimal9).add(NumberUtil.convertToBigDecimal(bigDecimal.doubleValue()));
        } else {
            bigDecimal7 = this.isTaxIncluded() != false ? bigDecimal7.add(bigDecimal2).subtract(bigDecimal3) : bigDecimal7.add(bigDecimal2).subtract(bigDecimal3).add(bigDecimal5);
        }
        this.calculateGratuity(bigDecimal2.doubleValue(), bigDecimal3.doubleValue());
        double d5 = this.getGratuityAmount();
        bigDecimal = NumberUtil.convertToBigDecimal(d2);
        BigDecimal bigDecimal10 = NumberUtil.convertToBigDecimal(d4);
        BigDecimal bigDecimal11 = NumberUtil.convertToBigDecimal(this.getFeeAmount());
        bigDecimal7 = NumberUtil.round(bigDecimal7.add(bigDecimal).add(bigDecimal10).add(bigDecimal11));
        BigDecimal bigDecimal12 = NumberUtil.convertToBigDecimal(d5);
        BigDecimal bigDecimal13 = NumberUtil.convertToBigDecimal(this.getPaidAmount());
        BigDecimal bigDecimal14 = NumberUtil.convertToBigDecimal(this.getRefundAmount());
        BigDecimal bigDecimal15 = NumberUtil.round(bigDecimal7.add(bigDecimal12).subtract(bigDecimal13).add(bigDecimal14));
        bigDecimal15 = this.calculateToleranceAmount(bigDecimal15);
        this.setSubtotalAmount(NumberUtil.round(bigDecimal2.doubleValue()));
        this.setDiscountAmount(NumberUtil.round(bigDecimal3.doubleValue()));
        this.setServiceCharge(NumberUtil.round(d4));
        this.setDeliveryCharge(NumberUtil.round(d2));
        this.setTaxAmount(NumberUtil.round(bigDecimal5.doubleValue()));
        this.setTotalAmount(bigDecimal7.doubleValue());
        this.setDueAmount(bigDecimal15.doubleValue());
        if (this.ticketDiscountAmount <= 0.0) {
            return;
        }
        for (TicketItem ticketItem : list) {
            if (!this.isPriceApplicable(ticketItem)) continue;
            ticketItem.calculateAdjustedPrice();
        }
    }

    private BigDecimal calculateToleranceAmount(BigDecimal bigDecimal) {
        double d = bigDecimal.doubleValue();
        Store store = DataProvider.get().getStore();
        if (store != null) {
            this.roundedDueAmount = store.isAllowPenyRounding() ? (double)Math.round(d * 100.0 / 5.0) * 5.0 / 100.0 : d;
        }
        this.toleranceAmount = this.roundedDueAmount - d;
        double d2 = 0.0;
        Currency currency = CurrencyUtil.getMainCurrency();
        if (currency != null) {
            d2 = currency.getTolerance();
        }
        if (Math.abs(this.roundedDueAmount) <= d2) {
            this.toleranceAmount = this.toleranceAmount < 0.0 || this.roundedDueAmount > 0.0 ? (this.toleranceAmount += -this.roundedDueAmount) : (this.toleranceAmount += this.roundedDueAmount);
            return BigDecimal.ZERO;
        }
        if (this.roundedDueAmount == 0.0 || this.roundedDueAmount <= 0.05) {
            return NumberUtil.convertToBigDecimal(this.roundedDueAmount);
        }
        return bigDecimal;
    }

    public double getSubtotalAmountWithVoidItems() {
        return this.getSubtotalAmount() + this.getVoidSubtotal();
    }

    private double calculateTotalDiscountAmount(double d, double d2, double d3, double d4) {
        d2 = 0.0;
        if (this.getDiscounts() == null || this.getDiscounts().size() == 0) {
            return d4;
        }
        double d5 = 0.0;
        d5 += d4;
        d5 += d3;
        if (d > 0.0 && d5 > d) {
            d5 = d;
        }
        if (d3 > d) {
            d3 = d;
        }
        if (d5 < 0.0) {
            d5 = 0.0;
        }
        return NumberUtil.round(d5);
    }

    private double calculateTicketDiscount(double d, double d2, double d3) {
        double d4 = d - d3;
        double d5 = 0.0;
        List<TicketDiscount> list = this.getDiscounts();
        if (list != null) {
            for (TicketDiscount ticketDiscount : list) {
                Double d6;
                double d7 = 0.0;
                Integer n = ticketDiscount.getType();
                if (n == 2) {
                    d7 = DiscountUtil.calculateRepriceDiscount(this, ticketDiscount.getValue());
                } else if (n == 3) {
                    d7 = ticketDiscount.getValue() * ticketDiscount.getCouponQuantity();
                } else if (n == 1) {
                    d6 = DiscountUtil.calculateDiscountAmount(d - this.itemDiscountAmount, ticketDiscount);
                    d7 = d6 * ticketDiscount.getCouponQuantity();
                } else {
                    d6 = DiscountUtil.calculateDiscountAmount(d4, ticketDiscount);
                    d7 = d6 * ticketDiscount.getCouponQuantity();
                }
                if (d < ticketDiscount.getMinimumAmount()) {
                    d7 = 0.0;
                }
                ticketDiscount.setTotalDiscountAmount(d7);
                d5 += d7;
            }
        }
        this.buildDiscounts();
        return NumberUtil.round(d5);
    }

    public double getAmountByType(TicketDiscount ticketDiscount) {
        switch (ticketDiscount.getType()) {
            case 0: {
                return ticketDiscount.getValue();
            }
            case 1: {
                return ticketDiscount.getValue() * this.getSubtotalAmount() / 100.0;
            }
        }
        return 0.0;
    }

    public static TicketDiscount convertToTicketDiscount(Discount discount, Ticket ticket) {
        TicketDiscount ticketDiscount = new TicketDiscount();
        ticketDiscount.setDiscountId(discount.getId());
        ticketDiscount.setName(discount.getName());
        ticketDiscount.setType(discount.getType());
        ticketDiscount.setMinimumAmount(discount.getMinimumBuy());
        ticketDiscount.setValue(discount.getValue());
        ticketDiscount.setCouponQuantity(1.0);
        ticketDiscount.setTicket(ticket);
        return ticketDiscount;
    }

    public static TicketDiscount buildLoyaltyDiscount(Ticket ticket) {
        TicketDiscount ticketDiscount = new TicketDiscount();
        ticketDiscount.setDiscountId(Discount.getLoyaltyDiscountId());
        ticketDiscount.setName("Loyalty");
        ticketDiscount.setType(3);
        ticketDiscount.setMinimumAmount(1.0);
        ticketDiscount.setValue(null);
        ticketDiscount.setCouponQuantity(1.0);
        ticketDiscount.setTicket(ticket);
        return ticketDiscount;
    }

    private double fixInvalidAmount(double d) {
        if (Double.isNaN(d)) {
            d = 0.0;
        }
        return d;
    }

    public double calculateDiscountFromType(TicketDiscount ticketDiscount, double d) {
        List<TicketItem> list = this.getTicketItems();
        double d2 = 0.0;
        int n = ticketDiscount.getType();
        double d3 = ticketDiscount.getValue();
        switch (n) {
            case 3: {
                d2 += d3;
                break;
            }
            case 1: {
                HashSet<String> hashSet = new HashSet<String>();
                for (TicketItem ticketItem : list) {
                    String string = ticketItem.getMenuItemId();
                    if (hashSet.contains(string)) continue;
                    d2 += d3;
                    hashSet.add(string);
                }
                break;
            }
            case 2: {
                for (TicketItem ticketItem : list) {
                    d2 += d3 * ticketItem.getQuantity();
                }
                break;
            }
            case 6: {
                d2 += d * d3 / 100.0;
                break;
            }
            case 4: {
                HashSet<String> hashSet = new HashSet<String>();
                for (TicketItem ticketItem : list) {
                    String string = ticketItem.getMenuItemId();
                    if (hashSet.contains(string)) continue;
                    d2 += ticketItem.getUnitPrice() * d3 / 100.0;
                    hashSet.add(string);
                }
                break;
            }
            case 5: {
                for (TicketItem ticketItem : list) {
                    d2 += ticketItem.getSubtotalAmountWithoutModifiers() * d3 / 100.0;
                }
                break;
            }
            case 0: {
                d2 += d3;
            }
        }
        return d2;
    }

    public void addDeletedItems(Object object) {
        if (this.deletedItems == null) {
            this.deletedItems = new ArrayList();
        }
        this.deletedItems.add(object);
    }

    public List getDeletedItems() {
        return this.deletedItems;
    }

    public void clearDeletedItems() {
        if (this.deletedItems != null) {
            this.deletedItems.clear();
        }
        this.deletedItems = null;
    }

    public int countItem(TicketItem ticketItem) {
        List<TicketItem> list = this.getTicketItems();
        if (list == null) {
            return 0;
        }
        int n = 0;
        for (TicketItem ticketItem2 : list) {
            if (!ticketItem.getMenuItemId().equals(ticketItem2.getMenuItemId())) continue;
            ++n;
        }
        return n;
    }

    public boolean needsKitchenPrint() {
        if (this.getDeletedItems() != null && this.getDeletedItems().size() > 0) {
            return true;
        }
        List<TicketItem> list = this.getTicketItems();
        for (TicketItem ticketItem : list) {
            if (!ticketItem.isShouldPrintToKitchen().booleanValue() || ticketItem.isPrintedToKitchen().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isCoreAmountPaid() {
        return !(this.getPaidAmount() < this.getTotalAmount());
    }

    public double getRemainingGratuity() {
        if (!this.hasGratuity()) {
            return 0.0;
        }
        Set<PosTransaction> set = this.getTransactions();
        double d = 0.0;
        for (PosTransaction posTransaction : set) {
            d += posTransaction.getTipsAmount().doubleValue();
        }
        Gratuity gratuity = this.getGratuity();
        return gratuity.getAmount() - d;
    }

    public double calculateServiceCharge(double d, double d2) {
        OrderType orderType = this.getOrderType();
        if (orderType != null && !orderType.isServiceChargeApplicable().booleanValue()) {
            return 0.0;
        }
        Double d3 = this.getOutletServiceChargeRate();
        double d4 = 0.0;
        if (d3 > 0.0) {
            d4 = (d - d2) * (d3 / 100.0);
        }
        return this.fixInvalidAmount(d4);
    }

    public void calculateGratuity(double d, double d2) {
        Double d3 = this.getOutletGratuityRate();
        if (d3 <= 0.0) {
            return;
        }
        Gratuity gratuity = this.getGratuity();
        if (gratuity != null && !gratuity.isAutoCalculated()) {
            return;
        }
        if (gratuity == null) {
            gratuity = new Gratuity();
            gratuity.setAutoCalculated(true);
        }
        double d4 = 0.0;
        if (d3 > 0.0) {
            d4 = (d - d2) * (d3 / 100.0);
        }
        if (d4 > 0.0) {
            gratuity.setAmount(d4);
        } else {
            gratuity.setAmount(0.0);
        }
        this.setGratuity(gratuity);
    }

    public void addProperty(String string, String string2) {
        if (StringUtils.isEmpty((String)string2)) {
            return;
        }
        this.initPropertiesContainer();
        this.propertiesContainer.addProperty(string, string2);
        super.setExtraProperties(this.propertiesContainer.toString());
    }

    public boolean hasProperty(String string) {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.has(string);
        }
        return false;
    }

    public String getProperty(String string) {
        return this.getProperty(string, null);
    }

    private void initPropertiesContainer() {
        if (this.propertiesContainer == null) {
            String string = super.getExtraProperties();
            this.propertiesContainer = StringUtils.isBlank((String)string) ? new com.google.gson.JsonObject() : (com.google.gson.JsonObject)new Gson().fromJson(string, com.google.gson.JsonObject.class);
        }
    }

    public String getProperty(String string, String string2) {
        JsonElement jsonElement;
        this.initPropertiesContainer();
        if (this.propertiesContainer.has(string) && !(jsonElement = this.propertiesContainer.get(string)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return string2;
    }

    public void removeProperty(String string) {
        this.initPropertiesContainer();
        this.propertiesContainer.remove(string);
        super.setExtraProperties(this.propertiesContainer.toString());
    }

    public boolean isPropertyValueTrue(String string) {
        String string2 = this.getProperty(string);
        return POSUtil.getBoolean(string2);
    }

    public String toURLForm() {
        String string = "ticket_id=" + this.getId();
        List<TicketItem> list = this.getTicketItems();
        if (list == null || list.size() == 0) {
            return string;
        }
        for (int i = 0; i < list.size(); ++i) {
            TicketItem ticketItem = list.get(i);
            string = string + "&items[" + i + "][id]=" + ticketItem.getId();
            string = string + "&items[" + i + "][name]=" + POSUtil.encodeURLString(ticketItem.getName());
            string = string + "&items[" + i + "][price]=" + ticketItem.getSubtotalAmount();
        }
        string = string + "&tax=" + this.getTaxAmount();
        string = string + "&subtotal=" + this.getSubtotalAmount();
        string = string + "&grandtotal=" + this.getTotalAmountWithTips();
        return string;
    }

    public void updateCustomer(Customer customer) {
        this.customer = customer;
    }

    public void setCustomer(Customer customer) {
        String string = this.getCustomerId();
        this.customer = customer;
        TicketUtil.setCustomer(this, customer);
        if (this.getId() == null) {
            return;
        }
        String string2 = "Customer removed";
        String string3 = null;
        if (customer != null) {
            string2 = "Customer set";
            string3 = customer.getId();
        }
        ActionHistoryDAO.addActionHistory(this, string2, String.format("Old customer : %s, New customer : %s", string, string3));
    }

    public void updateCustomerRef(Customer customer) {
        this.customer = customer;
    }

    @Transient
    public Customer getCustomer() {
        if (this.customer != null) {
            return this.customer;
        }
        String string = this.getCustomerId();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.customer = DataProvider.get().getCustomer(string);
        return this.customer;
    }

    public void removeCustomer() {
        this.removeProperty(CUSTOMER_ID);
        this.removeProperty(CUSTOMER_NAME);
        this.removeProperty(CUSTOMER_PHONE);
        this.removeProperty(CUSTOMER_ZIP_CODE);
        this.removeProperty(CUSTOMER_TAX_EXEMPT);
    }

    public String getSortOrder() {
        if (this.sortOrder == null) {
            return "";
        }
        return this.sortOrder;
    }

    public void setSortOrder(String string) {
        this.sortOrder = string;
    }

    @Override
    public String getStatus() {
        if (super.getStatus() == null) {
            return "";
        }
        return super.getStatus();
    }

    public String getOrderStatusDisplay() {
        return ORDER_STATUS[this.getOrderStatus()];
    }

    public void setOrderStatusDisplay(String string) {
    }

    public void consolidateTicketItems() {
        Object object;
        if (this.hasSeat()) {
            return;
        }
        List<TicketItem> list = this.getTicketItems();
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (TicketItem object22 : list) {
            object = object22.getMenuItemId() == null ? object22.getName() : object22.getMenuItemId();
            if (StringUtils.isEmpty((String)object)) continue;
            List list2 = (List)linkedHashMap.get(object);
            if (list2 == null) {
                ArrayList<TicketItem> arrayList = new ArrayList<TicketItem>();
                arrayList.add(object22);
                linkedHashMap.put(((String)object).toString(), arrayList);
                continue;
            }
            boolean bl = false;
            for (TicketItem ticketItem : list2) {
                if (!ticketItem.isMergable(object22, false)) continue;
                ticketItem.merge(object22);
                bl = true;
                break;
            }
            if (bl) continue;
            list2.add(object22);
        }
        this.getTicketItems().clear();
        Collection collection = linkedHashMap.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (List)iterator.next();
            if (object == null) continue;
            this.getTicketItems().addAll((Collection<TicketItem>)object);
        }
        List<TicketItem> list3 = this.getTicketItems();
        if (this.getOrderType().isAllowSeatBasedOrder().booleanValue()) {
            Collections.sort(list3, new Comparator<TicketItem>(){

                @Override
                public int compare(TicketItem ticketItem, TicketItem ticketItem2) {
                    if (ticketItem.getId() == null || ticketItem2.getId() == null) {
                        return 0;
                    }
                    return ticketItem.getId().compareTo(ticketItem2.getId());
                }
            });
            Collections.sort(list3, new Comparator<TicketItem>(){

                @Override
                public int compare(TicketItem ticketItem, TicketItem ticketItem2) {
                    return ticketItem.getSeatNumber() - ticketItem2.getSeatNumber();
                }
            });
        }
        this.calculatePrice();
    }

    public void consolidateKitchenTicketItems() {
        boolean bl = true;
        this.consolidateKitchenTicketItems(bl);
    }

    public void consolidateKitchenTicketItems(boolean bl) {
        this.consolidateKitchenTicketItems(bl, null);
    }

    public void consolidateKitchenTicketItems(boolean bl, List<TicketItem> list) {
        Object object;
        if (this.hasSeat() || this.isSourceOnline()) {
            return;
        }
        if (list == null) {
            list = this.getTicketItems();
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (TicketItem object22 : list) {
            List list2;
            if (!object22.isShouldPrintToKitchen().booleanValue() && !object22.isPrintKitchenSticker().booleanValue() || bl && object22.isPrintedToKitchen().booleanValue()) continue;
            object = object22.getMenuItemId();
            if (StringUtils.isEmpty((String)object)) {
                object = object22.getName();
            }
            if ((list2 = (List)linkedHashMap.get(object)) == null) {
                ArrayList<TicketItem> arrayList = new ArrayList<TicketItem>();
                arrayList.add(object22);
                linkedHashMap.put(((String)object).toString(), arrayList);
                continue;
            }
            list2.add(object22);
        }
        list.clear();
        Collection collection = linkedHashMap.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (List)iterator.next();
            if (object == null) continue;
            list.addAll((Collection<TicketItem>)object);
        }
        List<TicketItem> list3 = list;
        if (this.getOrderType().isAllowSeatBasedOrder().booleanValue()) {
            Collections.sort(list3, new Comparator<TicketItem>(){

                @Override
                public int compare(TicketItem ticketItem, TicketItem ticketItem2) {
                    if (ticketItem.getId() == null || ticketItem2.getId() == null) {
                        return 0;
                    }
                    return ticketItem.getId().compareTo(ticketItem2.getId());
                }
            });
            Collections.sort(list3, new Comparator<TicketItem>(){

                @Override
                public int compare(TicketItem ticketItem, TicketItem ticketItem2) {
                    return ticketItem.getSeatNumber() - ticketItem2.getSeatNumber();
                }
            });
        }
        this.calculatePrice();
    }

    public void markPrintedToKitchen() {
        List<TicketItem> list = this.getTicketItems();
        this.markPrintedToKitchen(list);
    }

    public void markPrintedToKitchen(List<TicketItem> list) {
        for (TicketItem ticketItem : list) {
            Object object;
            Object object2;
            List<Printer> list2;
            if (ticketItem.isPrintedToKitchen().booleanValue() || !ticketItem.isShouldPrintToKitchen().booleanValue() || (list2 = ticketItem.getPrinters(this.getOrderType())) == null) continue;
            ticketItem.setPrintedToKitchen(true);
            ticketItem.setKitchenStatusValue(KitchenStatus.WAITING);
            List<TicketItemModifier> list3 = ticketItem.getTicketItemModifiers();
            if (list3 != null) {
                object2 = list3.iterator();
                while (object2.hasNext()) {
                    object = (TicketItemModifier)object2.next();
                    ((BaseTicketItemModifier)object).setPrintedToKitchen(true);
                }
            }
            if ((object2 = ticketItem.getCookingInstructions()) == null) continue;
            object = object2.iterator();
            while (object.hasNext()) {
                TicketItemCookingInstruction ticketItemCookingInstruction = (TicketItemCookingInstruction)object.next();
                ticketItemCookingInstruction.setPrintedToKitchen(true);
            }
            ticketItem.buildCoookingInstructions();
        }
    }

    public boolean isSourceOnline() {
        String string = this.getProperty("source");
        return "online".equals(string);
    }

    public boolean isReservation() {
        TicketType ticketType;
        return this.getTicketType() != null && (ticketType = this.getTicketType()).equals((Object)TicketType.RESERVATION);
    }

    public static Ticket clone(Ticket ticket) {
        return (Ticket)SerializationUtils.clone((Serializable)ticket);
    }

    public boolean isNeedSpecialAttention() {
        return this.needSpecialAttention;
    }

    public void setNeedSpecialAttention(boolean bl) {
        this.needSpecialAttention = bl;
    }

    public String getNumberToDisplay() {
        return Messages.getString("Ticket.11") + this.getTokenNo();
    }

    @XmlTransient
    @JsonIgnore
    public Outlet getOutlet() {
        if (this.outlet != null) {
            return this.outlet;
        }
        String string = this.getOutletId();
        if (string == null) {
            return null;
        }
        this.outlet = (Outlet)DataProvider.get().getObjectOf(Outlet.class, (Serializable)((Object)string));
        return this.outlet;
    }

    @Transient
    public void setOutlet(Outlet outlet) {
        this.outlet = outlet;
        if (outlet == null) {
            this.setOutletId(null);
        } else {
            this.setOutletId(outlet.getId());
        }
    }

    public Department getDepartment() {
        String string = this.getDepartmentId();
        if (string == null) {
            return null;
        }
        if (this.department == null) {
            this.department = (Department)DataProvider.get().getObjectOf(Department.class, (Serializable)((Object)string));
        }
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
        if (department == null) {
            this.setDepartmentId(null);
        } else {
            this.setDepartmentId(department.getId());
        }
    }

    public SalesArea getSalesArea() {
        if (this.salesArea != null) {
            return this.salesArea;
        }
        String string = this.getSalesAreaId();
        if (string == null) {
            return null;
        }
        this.salesArea = DataProvider.get().getSalesArea(string);
        return this.salesArea;
    }

    public void setSalesArea(SalesArea salesArea) {
        this.salesArea = salesArea;
        if (salesArea == null) {
            this.setSalesAreaId(null);
        } else {
            this.setSalesAreaId(salesArea.getId());
        }
    }

    public boolean isSplited() {
        return Boolean.valueOf(this.getProperty(SPLIT));
    }

    public void updateTicketItemPriceByOrderType(String string) {
        List<TicketItem> list = this.getTicketItems();
        OrderType orderType = this.getOrderType();
        TaxGroup taxGroup = null;
        if (list == null) {
            return;
        }
        if (string.equals(SubOrderType.FOR_HERE.getName())) {
            taxGroup = orderType.getForHereTaxGroup();
            this.addProperty(PROPERTY_SUB_ORDER_TYPE, SubOrderType.FOR_HERE.getName());
        } else if (string.equals(SubOrderType.TO_GO.getName())) {
            taxGroup = orderType.getToGoTaxGroup();
            this.addProperty(PROPERTY_SUB_ORDER_TYPE, SubOrderType.TO_GO.getName());
        }
        for (TicketItem ticketItem : list) {
            MenuItem.setItemTaxes(ticketItem, taxGroup, this.getOrderType());
        }
        this.calculatePrice();
    }

    public String getSplitId() {
        return this.getProperty(SPLIT_TICKET_ID);
    }

    public void setSplitOrder(int n) {
        this.addProperty("SPLIT_ORDER", String.valueOf(n));
    }

    @JsonIgnore
    public String getDiffWithCrntTime() {
        return DateUtil.getElapsedTime(this.getCreateDate(), new Date());
    }

    public void setDiffWithCrntTime(String string) {
    }

    public String getTableNames() {
        return this.getProperty(jSON_PROP_TABLE_NAMES);
    }

    @XmlTransient
    public String getBartabName() {
        String string;
        if (this.getOrderType().isBarTab().booleanValue() && StringUtils.isNotBlank((String)(string = this.getProperty(CUSTOMER_NAME)))) {
            return string;
        }
        return null;
    }

    public String getTableNameDisplay() {
        String string = this.getTableNames();
        if (StringUtils.isBlank((String)string)) {
            return POSUtil.toFormattedString(this.getTableNumbers());
        }
        return string;
    }

    public String getTableNameOrNumberDisplay() {
        Store store = DataProvider.get().getStore();
        if (store.isShowTableNameOnTable()) {
            return this.getTableNameDisplay();
        }
        return this.getTableNumbersDisplay();
    }

    public Double getTotalAmountWithTips() {
        return super.getTotalAmount() + this.getGratuityAmount();
    }

    public void calculateRefundAmount() {
        double d = 0.0;
        double d2 = 0.0;
        Set<PosTransaction> set = this.getTransactions();
        if (set != null) {
            for (PosTransaction posTransaction : set) {
                if (!(posTransaction instanceof RefundTransaction)) continue;
                d += posTransaction.getAmount().doubleValue();
            }
        }
        this.setRefundAmount(d + d2);
    }

    public String getTableNumbersDisplay() {
        List<Integer> list = this.getTableNumbers();
        if (list == null || list.size() <= 0) {
            return "";
        }
        String string = list.toString().replaceAll("[\\[\\]]", "");
        return string;
    }

    public boolean isPrintedToKitchenOrInventoryAdjusted() {
        for (TicketItem ticketItem : this.getTicketItems()) {
            if (ticketItem.isPrintedToKitchen().booleanValue() || ticketItem.isInventoryAdjusted() || !ticketItem.isReturned() && ticketItem.isVoided().booleanValue()) {
                return true;
            }
            if (!ticketItem.isHasModifiers().booleanValue()) continue;
            for (TicketItemModifier ticketItemModifier : ticketItem.getTicketItemModifiers()) {
                if (!ticketItemModifier.isPrintedToKitchen().booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public Boolean hasRefundableItem() {
        return this.refundableItem == null ? false : this.refundableItem;
    }

    public void setRefundableItem(boolean bl) {
        this.refundableItem = bl;
    }

    public double getTicketDiscountAmount() {
        return this.ticketDiscountAmount;
    }

    public double getItemDiscountAmount() {
        return this.itemDiscountAmount;
    }

    public double getVoidSubtotal() {
        return this.voidSubtotal;
    }

    public double getVoidTotal() {
        return this.voidTotal;
    }

    @Override
    public void setTotalAmount(Double d) {
        super.setTotalAmount(d + 0.0);
    }

    @Override
    public void setDueAmount(Double d) {
        super.setDueAmount(d + 0.0);
    }

    @Override
    public void setDiscountAmount(Double d) {
        super.setDiscountAmount(d + 0.0);
    }

    @Override
    public void setTaxAmount(Double d) {
        super.setTaxAmount(d + 0.0);
    }

    public OrderType getOrderType() {
        if (this.orderType == null) {
            this.orderType = DataProvider.get().getOrderTypeById(this.getOrderTypeId());
        }
        return this.orderType;
    }

    public void setOrderType(OrderType orderType) {
        this.orderType = orderType;
        String string = null;
        if (orderType != null) {
            string = orderType.getId();
        }
        super.setOrderTypeId(string);
    }

    public Shift getShift() {
        return DataProvider.get().getShiftById(this.getShiftId());
    }

    public void setShift(Shift shift) {
        String string = null;
        if (shift != null) {
            string = shift.getId();
        }
        super.setShiftId(string);
    }

    public User getOwner() {
        return DataProvider.get().getUserById(this.getOwnerId());
    }

    public void setOwner(User user) {
        String string = null;
        String string2 = null;
        if (user != null) {
            string = user.getId();
            string2 = user.getUserTypeId();
            if (this.getCreatedByUserId() == null) {
                this.setCreatedByUserId(string);
            }
        }
        super.setOwnerId(string);
        super.setOwnerTypeId(string2);
    }

    public User getCashier() {
        return DataProvider.get().getUserById(this.getCashierId());
    }

    public void setCashier(User user) {
        String string = null;
        if (user != null) {
            string = user.getId();
        }
        super.setCashierId(string);
    }

    public User getAssignedDriver() {
        return DataProvider.get().getUserById(this.getAssignedDriverId());
    }

    public void setAssignedDriver(User user) {
        String string = null;
        if (user != null) {
            string = user.getId();
        }
        super.setAssignedDriverId(string);
    }

    public User getVoidedBy() {
        return DataProvider.get().getUserById(this.getVoidedById());
    }

    public void setVoidedBy(User user) {
        String string = null;
        if (user != null) {
            string = user.getId();
        }
        super.setVoidedById(string);
    }

    @JsonIgnore
    public Terminal getTerminal() {
        return DataProvider.get().getTerminalById(this.getTerminalId());
    }

    public void setTerminal(Terminal terminal) {
        Integer n = null;
        if (terminal != null) {
            n = terminal.getId();
        }
        super.setTerminalId(n);
    }

    public void setDiscounts(List<TicketDiscount> list) {
        this.discounts = list;
        if (this.discounts == null) {
            this.discounts = new ArrayList<TicketDiscount>();
        }
    }

    public List<TicketDiscount> getDiscounts() {
        if (this.discounts == null) {
            this.discounts = new ArrayList<TicketDiscount>();
            this.convertDiscountPropertyToList();
        }
        return this.discounts;
    }

    public void convertDiscountPropertyToList() {
        String string = super.getDiscountsProperty();
        if (StringUtils.isNotEmpty((String)string)) {
            JsonReader jsonReader = Json.createReader((Reader)new StringReader(string));
            JsonArray jsonArray = jsonReader.readArray();
            jsonReader.close();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject jsonObject = (JsonObject)jsonArray.get(i);
                TicketDiscount ticketDiscount = new TicketDiscount();
                ticketDiscount.setTicket(this);
                ticketDiscount.setId(JsonUtil.getString(jsonObject, TicketDiscount.PROP_ID));
                ticketDiscount.setLoyaltyPoint(JsonUtil.getInt(jsonObject, TicketDiscount.PROP_LOYALTY_POINT));
                ticketDiscount.setLoyaltyCharged(JsonUtil.getBoolean(jsonObject, TicketDiscount.PROP_LOYALTY_CHARGED));
                ticketDiscount.setDiscountId(JsonUtil.getString(jsonObject, TicketDiscount.PROP_DISCOUNT_ID));
                ticketDiscount.setName(JsonUtil.getString(jsonObject, TicketDiscount.PROP_NAME));
                ticketDiscount.setType(JsonUtil.getInt(jsonObject, TicketDiscount.PROP_TYPE));
                ticketDiscount.setAutoApply(JsonUtil.getBoolean(jsonObject, TicketDiscount.PROP_AUTO_APPLY));
                ticketDiscount.setCouponQuantity(JsonUtil.getDouble(jsonObject, TicketDiscount.PROP_COUPON_QUANTITY));
                ticketDiscount.setMinimumAmount(JsonUtil.getDouble(jsonObject, TicketDiscount.PROP_MINIMUM_AMOUNT));
                ticketDiscount.setValue(JsonUtil.getDouble(jsonObject, TicketDiscount.PROP_VALUE));
                ticketDiscount.setTotalDiscountAmount(JsonUtil.getDouble(jsonObject, TicketDiscount.PROP_TOTAL_DISCOUNT_AMOUNT));
                this.discounts.add(ticketDiscount);
            }
        }
    }

    public void addTodiscounts(TicketDiscount ticketDiscount) {
        this.discounts = this.getDiscounts();
        this.discounts.add(ticketDiscount);
        this.buildDiscounts();
        ActionHistoryDAO.addDiscountAddedActionHistory(this, ticketDiscount);
    }

    public void buildDiscounts() {
        JSONArray jSONArray = new JSONArray();
        for (TicketDiscount ticketDiscount : this.discounts) {
            jSONArray.put((Object)ticketDiscount.toJson());
        }
        this.setDiscountsProperty(jSONArray.toString());
    }

    @Override
    @XmlTransient
    public Map<String, String> getProperties() {
        Map<String, String> map = super.getProperties();
        if (map == null) {
            map = new HashMap<String, String>();
            super.setProperties(map);
        }
        return map;
    }

    @Override
    public String getTicketTableNumbers() {
        String string = "";
        List<Integer> list = this.getTableNumbers();
        if (list != null && list.size() > 0) {
            Iterator<Integer> iterator = list.iterator();
            while (iterator.hasNext()) {
                Integer n = iterator.next();
                string = string + n;
                if (!iterator.hasNext()) continue;
                string = string + ",";
            }
        }
        return string;
    }

    @Override
    public void setTicketTableNumbers(String string) {
        this.tableNumbers = new ArrayList<Integer>();
        if (StringUtils.isNotEmpty((String)string)) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(",")) {
                int n = POSUtil.parseInteger(string2);
                if (n <= 0) continue;
                this.tableNumbers.add(n);
            }
        }
        super.setTicketTableNumbers(string);
    }

    public List<Integer> getTableNumbers() {
        return this.tableNumbers;
    }

    public void setTableNumbers(List<Integer> list) {
        this.tableNumbers = list;
        if (list == null || list.size() <= 0) {
            this.removeProperty(jSON_PROP_TABLE_NAMES);
            return;
        }
        List<String> list2 = ShopTableDAO.getInstance().getTableNames(list);
        if (list2 != null && !list2.isEmpty()) {
            this.addProperty(jSON_PROP_TABLE_NAMES, POSUtil.toFormattedString(list2));
        } else {
            this.addProperty(jSON_PROP_TABLE_NAMES, POSUtil.toFormattedString(list));
        }
    }

    public List<ShopTable> getTables() {
        List<Integer> list = this.getTableNumbers();
        if (list == null || list.size() == 0) {
            return new ArrayList<ShopTable>(1);
        }
        if (this.tables == null) {
            this.tables = new ArrayList<ShopTable>(1);
        }
        for (Integer n : list) {
            ShopTable shopTable2 = new ShopTable(n);
            if (this.tables.contains(shopTable2) || (shopTable2 = ShopTableDAO.getInstance().loadWithSeats(n)) == null) continue;
            this.tables.add(shopTable2);
        }
        this.tables = this.tables.stream().filter(shopTable -> list.contains(shopTable.getId())).collect(Collectors.toList());
        return this.tables;
    }

    public void voidItem(TicketItem ticketItem, String string, boolean bl) {
        this.voidItem(ticketItem, string, bl, ticketItem.getQuantity());
    }

    public void voidItem(TicketItem ticketItem, String string, boolean bl, double d) {
        Iterator<TicketItem> iterator;
        if (ticketItem.isTreatAsSeat().booleanValue()) {
            return;
        }
        if (StringUtils.isEmpty((String)string)) {
            throw new PosException(Messages.getString("Ticket.23"));
        }
        if (d == 0.0) {
            throw new PosException(Messages.getString("Ticket.24"));
        }
        if (d > Math.abs(ticketItem.getQuantity())) {
            throw new PosException(Messages.getString("Ticket.25"));
        }
        double d2 = ticketItem.getQuantity();
        boolean bl2 = ticketItem.getQuantity() == d;
        TicketItem ticketItem2 = null;
        if (bl2) {
            ticketItem.setVoided(true);
            ticketItem.setQuantity(-d);
            ticketItem.setVoidedItemId(ticketItem.getId());
            ticketItem2 = ticketItem;
        } else {
            ticketItem.setQuantity(ticketItem.getQuantity() - d);
            ticketItem2 = ticketItem.cloneAsNew();
            ticketItem2.setId(null);
            ticketItem2.setQuantity(-d);
        }
        Boolean bl3 = ticketItem.isPrintedToKitchen();
        ticketItem2.setDiscounts(null);
        ticketItem2.setPrintedToKitchen(false);
        ticketItem2.setVoided(true);
        ticketItem2.setCloudSynced(false);
        ticketItem2.setVoidDate(StoreDAO.getServerTimestamp());
        ticketItem2.setVoidedItemId(ticketItem.getId());
        ticketItem2.setInventoryAdjustQty(bl ? -d : 0.0);
        if (ticketItem2.isHasModifiers().booleanValue() && (iterator = ticketItem2.getTicketItemModifiers()) != null) {
            Iterator<TicketItemModifier> object = iterator.iterator();
            while (object.hasNext()) {
                TicketItemModifier ticketItemModifier = object.next();
                if (ticketItemModifier.isInfoOnly().booleanValue()) continue;
                ticketItemModifier.setItemQuantity(-ticketItemModifier.getItemQuantity().doubleValue());
            }
        }
        ticketItem2.setVoidProperties(string, bl, d, bl3);
        if (ticketItem.isComboItem().booleanValue()) {
            if (ticketItem2.getComboItems() != null) {
                for (TicketItem ticketItem3 : ticketItem2.getComboItems()) {
                    double d3 = ticketItem3.getQuantity() / d2 * d;
                    ticketItem3.setQuantity(-d3);
                    ticketItem2.setInventoryAdjustQty(bl ? -d3 : 0.0);
                    ticketItem3.setVoidProperties(string, bl, d3);
                    ticketItem3.setVoided(true);
                }
            }
            if (!bl2 && ticketItem.getComboItems() != null) {
                for (TicketItem ticketItem4 : ticketItem.getComboItems()) {
                    ticketItem4.setQuantity(ticketItem4.getQuantity() - ticketItem4.getQuantity() / d2 * d);
                }
            }
        }
        ticketItem2.calculatePrice();
        if (ticketItem2 != ticketItem) {
            this.addToticketItems(ticketItem2);
        }
    }

    public void voidReturnedItem(TicketItem ticketItem, String string, boolean bl) {
        if (ticketItem.isTreatAsSeat().booleanValue()) {
            return;
        }
        ticketItem.markReturnedItemVoided(string, bl, ticketItem.getQuantity());
        if (ticketItem.isComboItem().booleanValue() && ticketItem.getComboItems() != null) {
            for (TicketItem ticketItem2 : ticketItem.getComboItems()) {
                ticketItem2.markReturnedItemVoided(string, bl, ticketItem2.getQuantity());
            }
        }
    }

    public TicketItem undoVoidItem(TicketItem ticketItem) {
        Iterator<TicketItem> iterator;
        boolean bl;
        TicketItem ticketItem2 = this.getTicketItem(ticketItem.getVoidedItemId());
        if (ticketItem2 == null) {
            return null;
        }
        double d = Math.abs(ticketItem.getQuantity());
        if (ticketItem2.getVoidedItemId() != null) {
            ticketItem2 = ticketItem;
        }
        boolean bl2 = POSUtil.getBoolean(ticketItem.getProperty("wasted"));
        double d2 = ticketItem2.getQuantity();
        boolean bl3 = bl = ticketItem == ticketItem2;
        if (bl) {
            ticketItem2.setQuantity(d);
        } else {
            ticketItem2.setQuantity(ticketItem2.getQuantity() + d);
        }
        ticketItem2.setPrintedToKitchen(POSUtil.getBoolean(ticketItem.getProperty("originalItemPrintedToKitchen")));
        ticketItem2.setVoided(false);
        ticketItem2.setVoidDate(null);
        ticketItem2.setVoidedItemId(null);
        ticketItem2.setCloudSynced(false);
        ticketItem2.setHasSyncError(false);
        ticketItem2.removeProperty("returned");
        if (ticketItem.isInventoryAdjusted() && !bl2) {
            ticketItem2.setInventoryAdjustQty(Math.abs(ticketItem2.getInventoryAdjustQty()) - d);
        } else {
            ticketItem2.setInventoryAdjustQty(Math.abs(bl ? ticketItem2.getQuantity() : ticketItem2.getQuantity() + d));
        }
        if (ticketItem2.isHasModifiers().booleanValue() && (iterator = ticketItem2.getTicketItemModifiers()) != null) {
            Iterator<TicketItemModifier> object = iterator.iterator();
            while (object.hasNext()) {
                TicketItemModifier ticketItemModifier = object.next();
                if (ticketItemModifier.isInfoOnly().booleanValue()) continue;
                ticketItemModifier.setItemQuantity(Math.abs(ticketItemModifier.getItemQuantity()));
            }
        }
        ticketItem2.removeVoidProperties();
        if (ticketItem.isComboItem().booleanValue()) {
            if (ticketItem.getComboItems() != null) {
                for (TicketItem ticketItem3 : ticketItem.getComboItems()) {
                    double d3 = Math.abs(ticketItem3.getQuantity() / d2 * d);
                    ticketItem3.setQuantity(d3);
                    ticketItem.setInventoryAdjustQty(bl2 ? -d3 : 0.0);
                    ticketItem3.removeVoidProperties();
                    ticketItem3.setVoided(false);
                }
            }
            if (!bl && ticketItem2.getComboItems() != null) {
                for (TicketItem ticketItem4 : ticketItem2.getComboItems()) {
                    ticketItem4.setQuantity(ticketItem4.getQuantity() + ticketItem4.getQuantity() / d2 * d);
                }
            }
        }
        ticketItem2.calculatePrice();
        return ticketItem2;
    }

    private TicketItem getTicketItem(String string) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        for (TicketItem ticketItem : this.getTicketItems()) {
            if (ticketItem.getId() == null || !ticketItem.getId().equals(string)) continue;
            return ticketItem;
        }
        return null;
    }

    public boolean isPriceIncludesTax() {
        return super.isTaxIncluded();
    }

    public void setPriceIncludesTax(boolean bl) {
        super.setTaxIncluded(bl);
    }

    private void populateDefaultProperties() {
        Outlet outlet;
        Department department;
        Application application = Application.getInstance();
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        this.setTaxIncluded(application.isPriceIncludesTax());
        this.setTerminal(terminal);
        StoreSession storeSession = DataProvider.get().getStoreSession();
        if (storeSession != null) {
            this.setStoreSessionId(storeSession.getId());
        }
        if ((department = terminal.getDepartment()) != null) {
            this.setDepartmentId(department.getId());
        }
        if ((outlet = terminal.getOutlet()) != null) {
            this.setOutletId(outlet.getId());
            this.setOutletServiceChargeRate(outlet.getServiceChargePercentage());
            this.setOutletGratuityRate(outlet.getDefaultGratuityPercentage());
        }
        this.setOwner(Application.getCurrentUser());
        this.setShift(ShiftUtil.getCurrentShift());
        this.setShouldIncludeInSales(true);
    }

    public boolean isShouldUpdateTableStatus() {
        return this.shouldUpdateTableStatus;
    }

    public void setShouldUpdateTableStatus(boolean bl) {
        this.shouldUpdateTableStatus = bl;
    }

    public double getToleranceAmount() {
        return this.toleranceAmount;
    }

    public double getRoundedDueAmount() {
        return this.roundedDueAmount;
    }

    public PosTransaction getBartabTransaction() {
        String string = this.getProperty("bartab.transaction.id");
        if (StringUtils.isNotEmpty((String)string)) {
            for (PosTransaction posTransaction : this.getTransactions()) {
                if (!string.equals(String.valueOf(posTransaction.getId()))) continue;
                return posTransaction;
            }
        }
        return null;
    }

    @Override
    public String getExtraProperties() {
        this.initPropertiesContainer();
        return this.propertiesContainer.toString();
    }

    @Override
    public void setExtraProperties(String string) {
        super.setExtraProperties(string);
        this.propertiesContainer = null;
        this.initPropertiesContainer();
    }

    public void addExtraProperty(String string, String string2) {
        this.initPropertiesContainer();
        this.propertiesContainer.addProperty(string, string2);
        super.setExtraProperties(this.propertiesContainer.toString());
    }

    public String getExtraProperty(String string) {
        JsonElement jsonElement;
        this.initPropertiesContainer();
        if (this.propertiesContainer.has(string) && !(jsonElement = this.propertiesContainer.get(string)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return null;
    }

    @Override
    public String toString() {
        return "Ticket [ticketDiscountAmount=" + this.ticketDiscountAmount + ", itemDiscountAmount=" + this.itemDiscountAmount + ", voidSubtotal=" + this.voidSubtotal + ", voidTotal=" + this.voidTotal + ", deletedItems=" + this.deletedItems + ", sortOrder=" + this.sortOrder + ", needSpecialAttention=" + this.needSpecialAttention + ", customer=" + this.customer + ", outlet=" + this.outlet + ", department=" + this.department + ", salesArea=" + this.salesArea + ", discounts=" + this.discounts + ", tableNumbers=" + this.tableNumbers + ", tables=" + this.tables + ", shouldUpdateTableStatus=" + this.shouldUpdateTableStatus + ", roundedDueAmount=" + this.roundedDueAmount + ", toleranceAmount=" + this.toleranceAmount + ", refundableItem=" + this.refundableItem + ", getTicketItems()=" + this.getTicketItems() + "]";
    }

    public boolean isShouldPublishMqtt() {
        return this.shouldPublishMqtt;
    }

    public void setShouldPublishMqtt(boolean bl) {
        this.shouldPublishMqtt = bl;
    }

    public String getOwnerName() {
        if (this.getOwner() != null) {
            return this.getOwner().getFullName();
        }
        return "";
    }

    public void setOwnerName(String string) {
    }

    @XmlTransient
    public String getCustomerName() {
        if (this.getCustomer() != null) {
            return this.getCustomer().getName();
        }
        return "";
    }

    public void setCustomerName(String string) {
    }

    @XmlTransient
    public String getCustomerEmail() {
        if (this.getCustomer() != null) {
            return this.getCustomer().getEmail();
        }
        return "";
    }

    public void setCustomerEmail(String string) {
    }

    @XmlTransient
    public String getCustomerMobileNo() {
        if (this.getCustomer() != null) {
            return this.getCustomer().getMobileNo();
        }
        return "";
    }

    public void setCustomerMobileNo(String string) {
    }

    public void makeXmlTransient() {
        this.setProperties(null);
        this.setDiscounts(null);
        for (TicketItem comparable : this.getTicketItems()) {
            comparable.setTicket(null);
        }
        if (this.getTransactions() != null) {
            for (PosTransaction posTransaction : this.getTransactions()) {
                posTransaction.setTicket(null);
                posTransaction.setProperties(null);
            }
        }
    }

    public void mergeTicket(Ticket ticket) {
        List<TicketItem> list = this.getTicketItems();
        if (list != null && list.size() > 0) {
            for (TicketItem ticketItem : list) {
                Object object;
                Object object2;
                if (ticketItem.isHasModifiers().booleanValue() && ticketItem.getTicketItemModifiers() != null && ticketItem.getTicketItemModifiers().size() > 0) {
                    object2 = ticketItem.getTicketItemModifiers().iterator();
                    while (object2.hasNext()) {
                        object = (TicketItemModifier)object2.next();
                        ((BaseTicketItemModifier)object).setTicketItem(ticketItem);
                    }
                }
                if ((object2 = ticketItem.getDiscounts()) == null || object2.size() <= 0) continue;
                object = object2.iterator();
                while (object.hasNext()) {
                    TicketItemDiscount ticketItemDiscount = object.next();
                    ticketItemDiscount.setTicketItem(ticketItem);
                }
            }
        }
        this.mergeTicketItems(ticket.getTicketItems());
        this.mergeTransactions(ticket.getTransactions());
    }

    private void mergeTicketItems(List<TicketItem> list) {
        if (list.isEmpty()) {
            return;
        }
        List<TicketItem> list2 = this.getTicketItems();
        for (TicketItem ticketItem : list) {
            int n = list2.indexOf(ticketItem);
            if (n != -1) {
                TicketItem ticketItem2 = list2.get(n);
                if (ticketItem.getQuantity() == ticketItem2.getQuantity()) continue;
            }
            ticketItem.setTicket(this);
            this.addToticketItems(ticketItem);
        }
    }

    private void mergeTransactions(Set<PosTransaction> set) {
        if (set == null || set.isEmpty()) {
            return;
        }
        int n = 0;
        ArrayList<PosTransaction> arrayList = new ArrayList<PosTransaction>(this.getTransactions());
        for (PosTransaction posTransaction : set) {
            int n2 = arrayList.indexOf(posTransaction);
            if (n2 != -1) continue;
            ++n;
            posTransaction.setTicket(this);
            this.addTotransactions(posTransaction);
        }
        if (n > 0) {
            this.recalculatePaidAmount();
        }
    }

    private void recalculatePaidAmount() {
        double d = 0.0;
        double d2 = 0.0;
        Set<PosTransaction> set = super.getTransactions();
        if (set != null && set.size() > 0) {
            for (PosTransaction posTransaction : set) {
                if (posTransaction.isVoided().booleanValue()) continue;
                if (posTransaction.getTransactionType().equals(TransactionType.CREDIT.toString())) {
                    d += posTransaction.getAmount().doubleValue();
                    continue;
                }
                if (!posTransaction.getTransactionType().equals(TransactionType.DEBIT.toString())) continue;
                d2 += posTransaction.getAmount().doubleValue();
            }
        }
        this.setPaidAmount(d - d2);
        this.calculateRefundAmount();
        if (this.getRefundAmount() > 0.0) {
            this.setRefunded(true);
        }
        this.calculatePrice();
        if (NumberUtil.roundToTwoDigit(this.getDueAmount()) == 0.0) {
            this.setPaid(true);
            OrderType orderType = this.getOrderType();
            if (orderType != null && (orderType.isCloseOnPaid().booleanValue() || orderType.isBarTab().booleanValue())) {
                this.setClosed(true);
            }
        } else {
            this.setPaid(false);
            this.setClosed(false);
        }
    }

    private boolean isPriceApplicable(TicketItem ticketItem) {
        return ticketItem.isVoided() == false || ticketItem.getVoidedItemId() == null;
    }

    public void setHasGiftCard(boolean bl) {
        this.addProperty("hasGiftCard", String.valueOf(bl));
    }

    public boolean hasGiftCard() {
        return Boolean.valueOf(this.getProperty("hasGiftCard"));
    }

    public void setSubOrderType(SubOrderType subOrderType) {
        if (subOrderType != null) {
            this.addProperty(PROPERTY_SUB_ORDER_TYPE, subOrderType.getName());
        }
    }

    public SubOrderType getSubOrderType() {
        return SubOrderType.fromName(this.getExtraProperty(PROPERTY_SUB_ORDER_TYPE));
    }

    public boolean hasSeat() {
        for (TicketItem ticketItem : this.getTicketItems()) {
            if (!ticketItem.isTreatAsSeat().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isKitchenPrintable() {
        List<TicketItem> list = this.getTicketItems();
        if (list == null) {
            return false;
        }
        for (TicketItem ticketItem : list) {
            if (ticketItem.isTreatAsSeat().booleanValue() || !ticketItem.isShouldPrintToKitchen().booleanValue() || ticketItem.isPrintedToKitchen().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isDiscountable() {
        List<TicketItem> list = this.getTicketItems();
        if (list == null || list.isEmpty()) {
            return Boolean.FALSE;
        }
        for (TicketItem ticketItem : list) {
            if (ticketItem.isTreatAsSeat().booleanValue()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean isVoidable() {
        List<TicketItem> list = this.getTicketItems();
        if (list == null || list.isEmpty()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public List<ShopSeat> getExtraSeats() {
        List<ShopSeat> list = null;
        String string = this.getProperty(PROPERTY_EXTRA_SEATS, null);
        if (StringUtils.isEmpty((String)string)) {
            list = new ArrayList<ShopSeat>();
        } else {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                list = (List)objectMapper.readValue(string, (TypeReference)new TypeReference<List<ShopSeat>>(){});
            }
            catch (IOException iOException) {
                PosLog.error(this.getClass(), iOException);
            }
        }
        return list;
    }

    public void addExtraSeats(List<ShopSeat> list) {
        String string = null;
        if (list != null) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                string = objectMapper.writeValueAsString(list);
            }
            catch (JsonProcessingException jsonProcessingException) {
                PosLog.error(this.getClass(), (Exception)((Object)jsonProcessingException));
            }
        }
        this.addProperty(PROPERTY_EXTRA_SEATS, string);
    }

    public Map<String, ActionHistory> getEvents() {
        if (this.events == null) {
            this.events = new LinkedHashMap<String, ActionHistory>();
        }
        return this.events;
    }

    public boolean hasLoyaltyDiscount() {
        List<TicketDiscount> list = this.getDiscounts();
        if (list == null) {
            return false;
        }
        for (TicketDiscount ticketDiscount : list) {
            String string = ticketDiscount.getDiscountId();
            if (!StringUtils.isNotBlank((String)string) || !string.equals("loyalty_discount")) continue;
            return true;
        }
        return false;
    }

    public int getBeverageItemCount() {
        List<TicketItem> list = this.getTicketItems();
        if (list == null) {
            return 0;
        }
        int n = 0;
        for (TicketItem ticketItem : list) {
            if (ticketItem.isTreatAsSeat().booleanValue() || !ticketItem.isBeverage().booleanValue()) continue;
            n = (int)((double)n + Math.abs(ticketItem.getQuantity()));
        }
        return n;
    }

    public void validateTicketBeforeSave() {
        if (this.getTicketItems() == null || this.getTicketItems().size() == 0) {
            throw new PosException(POSConstants.TICKET_IS_EMPTY_);
        }
        if (this.orderType.isBeverageMandatory()) {
            Integer n = this.getNumberOfGuests();
            int n2 = this.getBeverageItemCount();
            if (n2 < n) {
                throw new PosException(String.format(Messages.getString("Ticket.2"), n));
            }
        }
    }

    public double getTaxAmountFromProperty() {
        return POSUtil.parseDouble(this.getProperty("tax.exempt.amount"));
    }

    public String getCustomerNameByProperty() {
        String string = this.getProperty(CUSTOMER_NAME) == null ? "" : this.getProperty(CUSTOMER_NAME);
        String string2 = this.getProperty(CUSTOMER_LAST_NAME) == null ? "" : this.getProperty(CUSTOMER_LAST_NAME);
        return string + " " + string2;
    }

    public Double getOutletServiceChargeRate() {
        String string = this.getProperty(PROPERTY_OUTLET_SC_RATE);
        if (StringUtils.isBlank((String)string)) {
            return 0.0;
        }
        try {
            return NumberUtil.parse(string).doubleValue();
        }
        catch (ParseException parseException) {
            PosLog.error(this.getClass(), parseException);
            return 0.0;
        }
    }

    public void setOutletServiceChargeRate(Double d) {
        this.addProperty(PROPERTY_OUTLET_SC_RATE, String.valueOf(d));
    }

    public Double getOutletGratuityRate() {
        String string = this.getProperty(PROPERTY_OUTLET_GRATUITY_RATE);
        if (StringUtils.isBlank((String)string)) {
            return 0.0;
        }
        try {
            return NumberUtil.parse(string).doubleValue();
        }
        catch (ParseException parseException) {
            PosLog.error(this.getClass(), parseException);
            return 0.0;
        }
    }

    public void setOutletGratuityRate(Double d) {
        this.addProperty(PROPERTY_OUTLET_GRATUITY_RATE, String.valueOf(d));
    }

    public Double getSubtotalWithoutIncludedTax() {
        if (this.isTaxIncluded().booleanValue()) {
            return this.getSubtotalAmount() - this.getTaxAmount();
        }
        return this.getSubtotalAmount();
    }

    public void closeIfApplicable() {
        OrderType orderType;
        if (NumberUtil.round(this.getDueAmount()) == 0.0 && (orderType = this.getOrderType()) != null && (orderType.isCloseOnPaid().booleanValue() || orderType.isBarTab().booleanValue())) {
            this.setClosed(true);
            this.setClosingDate(StoreDAO.getServerTimestamp());
        }
    }

    public boolean isShouldUpdateStock() {
        return this.shouldUpdateStock;
    }

    public void setShouldUpdateStock(boolean bl) {
        this.shouldUpdateStock = bl;
    }
}

