/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.base.BaseTicketItemDiscount;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.util.DiscountUtil;
import com.floreantpos.util.NumberUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.json.JSONObject;

@JsonIgnoreProperties(ignoreUnknown=true, value={"subTotalAmountWithoutModifiersDisplay"})
public class TicketItemDiscount
extends BaseTicketItemDiscount
implements ITicketItem {
    private static final long serialVersionUID = 1L;
    private double discountPercentage;
    private int tableRowNum;
    private String ticketItemId;

    public TicketItemDiscount() {
    }

    public TicketItemDiscount(String string) {
        super(string);
    }

    public TicketItemDiscount(String string, String string2, double d, double d2, int n) {
        this.setId(string);
        this.setDiscountId(string);
        this.setName(string2);
        this.setCouponQuantity(d);
        this.setValue(d2);
        this.setType(n);
    }

    public TicketItemDiscount(TicketItemDiscount ticketItemDiscount) {
        this.setDiscountId(ticketItemDiscount.getDiscountId());
        this.setName(ticketItemDiscount.getName());
        this.setType(ticketItemDiscount.getType());
        this.setAutoApply(ticketItemDiscount.isAutoApply());
        this.setCouponQuantity(ticketItemDiscount.getCouponQuantity());
        this.setMinimumAmount(ticketItemDiscount.getMinimumAmount());
        this.setValue(ticketItemDiscount.getValue());
        this.setAmount(ticketItemDiscount.getAmount());
    }

    public double calculateDiscount(double d) {
        double d2;
        double d3 = 1.0;
        double d4 = this.getCouponQuantity();
        if (this.getMinimumAmount() > 1.0 && d4 >= (d3 = Math.abs(Math.floor(this.getTicketItem().getQuantity() / this.getMinimumAmount())))) {
            d4 = d3;
        }
        if ((d2 = DiscountUtil.calculateDiscountAmount(this, d) * d4) > 0.0 && d2 > Math.abs(d)) {
            d2 = d;
        }
        this.setAmount(d2);
        return d2;
    }

    public BigDecimal calculateDiscount(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2;
        BigDecimal bigDecimal3 = NumberUtil.convertToBigDecimal("1");
        BigDecimal bigDecimal4 = NumberUtil.convertToBigDecimal(this.getCouponQuantity());
        BigDecimal bigDecimal5 = NumberUtil.convertToBigDecimal(this.getMinimumAmount());
        if (bigDecimal5.compareTo(BigDecimal.ONE) > 0 && bigDecimal4.compareTo(bigDecimal3 = NumberUtil.convertToBigDecimal(this.getTicketItem().getQuantity()).divide(bigDecimal5, 4, RoundingMode.HALF_DOWN)) >= 0) {
            bigDecimal4 = bigDecimal3;
        }
        if ((bigDecimal2 = DiscountUtil.calculateDiscountAmount(this, bigDecimal).multiply(bigDecimal4)).compareTo(BigDecimal.ZERO) > 0 && bigDecimal2.compareTo(bigDecimal) > 0) {
            bigDecimal2 = bigDecimal;
        }
        this.setAmount(bigDecimal2.doubleValue());
        return bigDecimal2;
    }

    public void setTableRowNum(int n) {
        this.tableRowNum = n;
    }

    public int getTableRowNum() {
        return this.tableRowNum;
    }

    @Override
    public String getItemCode() {
        return "";
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String getNameDisplay() {
        double d = this.getCouponQuantity();
        String string = d > 1.0 ? NumberUtil.trimDecilamIfNotNeeded(d) + "x " + this.getName() : this.getName().trim();
        return "  *" + string;
    }

    @Override
    public boolean canAddCookingInstruction() {
        return false;
    }

    @Override
    public boolean canAddDiscount() {
        return false;
    }

    @Override
    public boolean canVoid() {
        return false;
    }

    @Override
    public boolean canAddAdOn() {
        return false;
    }

    @Override
    public Boolean isPrintedToKitchen() {
        return false;
    }

    @Override
    public String getUnitPriceDisplay() {
        return null;
    }

    @Override
    public String getItemQuantityDisplay() {
        return null;
    }

    @Override
    public String getTaxAmountWithoutModifiersDisplay() {
        return null;
    }

    @Override
    public void setDiscountAmount(Double d) {
    }

    @Override
    public Double getDiscountAmount() {
        return null;
    }

    @Override
    public KitchenStatus getKitchenStatusValue() {
        return null;
    }

    @Override
    public Double getSubtotalAmount() {
        TicketItem ticketItem = this.getTicketItem();
        if (ticketItem != null && ticketItem.getDiscounts() != null && ticketItem.getDiscounts().size() == 1) {
            return -ticketItem.getDiscountAmount().doubleValue();
        }
        double d = this.getAmount();
        if (d <= 0.0) {
            return 0.0;
        }
        return -d;
    }

    @Override
    public String getSubTotalAmountDisplay() {
        return NumberUtil.formatAmount(this.getSubtotalAmount());
    }

    public double getDiscountPercentage() {
        return this.discountPercentage;
    }

    public void setDiscountPercentage(double d) {
        this.discountPercentage = d;
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(PROP_DISCOUNT_ID, (Object)this.getDiscountId());
        jSONObject.put(PROP_NAME, (Object)this.getName());
        jSONObject.put(PROP_TYPE, (Object)this.getType());
        jSONObject.put(PROP_AUTO_APPLY, (Object)this.isAutoApply());
        jSONObject.put(PROP_COUPON_QUANTITY, (Object)this.getCouponQuantity());
        jSONObject.put(PROP_MINIMUM_AMOUNT, (Object)this.getMinimumAmount());
        jSONObject.put(PROP_VALUE, (Object)this.getValue());
        jSONObject.put(PROP_AMOUNT, (Object)this.getAmount());
        return jSONObject;
    }

    public String getTicketItemId() {
        return this.ticketItemId;
    }

    public void setTicketItemId(String string) {
        this.ticketItemId = string;
    }

    @Override
    public boolean isSaved() {
        return this.getTicketItem() == null ? false : this.getTicketItem().isSaved();
    }
}

