/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.CookingInstruction;
import com.floreantpos.model.dao.BaseCookingInstructionDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class CookingInstructionDAO
extends BaseCookingInstructionDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Override
    protected void delete(Object object, Session session) {
        CookingInstruction cookingInstruction = (CookingInstruction)object;
        if (cookingInstruction == null) {
            throw new PosException(Messages.getString("CookingInstructionDAO.0"));
        }
        cookingInstruction.setDeleted(Boolean.TRUE);
        this.update(cookingInstruction, session);
    }

    @Override
    public List<CookingInstruction> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    public void saveOrUpdateCookingInstructionList(List<CookingInstruction> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (CookingInstruction cookingInstruction : list) {
                CookingInstruction cookingInstruction2 = this.get(cookingInstruction.getId());
                if (cookingInstruction2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(cookingInstruction.getLastUpdateTime(), cookingInstruction2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), cookingInstruction.getId() + " already updated");
                        continue;
                    }
                    long l = cookingInstruction2.getVersion();
                    PropertyUtils.copyProperties((Object)cookingInstruction2, (Object)cookingInstruction);
                    cookingInstruction2.setVersion(l);
                    cookingInstruction2.setUpdateLastUpdateTime(bl);
                    cookingInstruction2.setUpdateSyncTime(bl2);
                    this.update(cookingInstruction2, session);
                    continue;
                }
                cookingInstruction.setUpdateLastUpdateTime(bl);
                cookingInstruction.setUpdateSyncTime(bl2);
                this.save(cookingInstruction, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

