/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.ModifierMultiplierPrice;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.dao.BaseMultiplierDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class MultiplierDAO
extends BaseMultiplierDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void delete(Object object, Session session) {
        if (object instanceof Multiplier) {
            Multiplier multiplier = (Multiplier)object;
            String string = "DELETE FROM %s MMP WHERE MMP.%s=:m_id";
            string = String.format(string, ModifierMultiplierPrice.REF, ModifierMultiplierPrice.PROP_MULTIPLIER_ID);
            Query query = session.createQuery(string);
            query.setParameter("m_id", (Object)multiplier.getId());
            query.executeUpdate();
            multiplier.setDeleted(Boolean.TRUE);
            super.update(multiplier, session);
        } else {
            super.delete(object, session);
        }
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Multiplier> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.addOrder(Order.asc((String)Multiplier.PROP_SORT_ORDER));
            List list = criteria.list();
            return list;
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            return null;
        }
    }

    public void saveOrUpdateMultipliers(List<Multiplier> list) {
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            for (Multiplier multiplier : list) {
                session.saveOrUpdate((Object)multiplier);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            PosLog.error(this.getClass(), exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Multiplier getDefaultMutltiplier() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)Multiplier.PROP_DEFAULT_MULTIPLIER, (Object)Boolean.TRUE));
            List list = criteria.list();
            if (list == null) return null;
            if (list.isEmpty()) return null;
            Multiplier multiplier = (Multiplier)list.get(0);
            return multiplier;
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
        return null;
    }

    public boolean nameExists(String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Multiplier.PROP_ID, (Object)string).ignoreCase());
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = number.intValue() > 0;
            return bl;
        }
    }

    public void deleteMultiplier(Multiplier multiplier) {
        this.delete(multiplier);
    }

    public void saveOrUpdateMultiplierList(List<Multiplier> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (Multiplier multiplier : list) {
                Multiplier multiplier2 = this.get(multiplier.getId());
                if (multiplier2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(multiplier.getLastUpdateTime(), multiplier2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), multiplier.getId() + " already updated");
                        continue;
                    }
                    long l = multiplier2.getVersion();
                    PropertyUtils.copyProperties((Object)multiplier2, (Object)multiplier);
                    multiplier2.setVersion(l);
                    multiplier2.setUpdateLastUpdateTime(bl);
                    multiplier2.setUpdateSyncTime(bl2);
                    this.update(multiplier2, session);
                    continue;
                }
                multiplier.setUpdateLastUpdateTime(bl);
                multiplier.setUpdateSyncTime(bl2);
                this.save(multiplier, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

