/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.StoreAlreadyCloseException;
import com.floreantpos.model.Address;
import com.floreantpos.model.DataSyncInfo;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.StoreSessionControl;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.AddressDAO;
import com.floreantpos.model.dao.BaseStoreDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.util.StoreUtil;
import com.orocube.siiopa.common.model.SubscriptionProduct;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class StoreDAO
extends BaseStoreDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    public static Store getRestaurant() {
        return StoreDAO.getInstance().get("1");
    }

    @Deprecated
    public static Date geServerTimestamp() {
        return StoreDAO.getServerTimestamp();
    }

    public static Date getServerTimestamp() {
        return new Date();
    }

    public void closeStore(User user) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            StoreSessionControl storeSessionControl = StoreUtil.getCurrentStoreOperation();
            if (storeSessionControl.getCurrentData() == null) {
                throw new StoreAlreadyCloseException("Store is already closed.");
            }
            StoreSession storeSession = storeSessionControl.getCurrentData();
            storeSession.setClosedBy(user);
            storeSession.setCloseTime(new Date());
            storeSessionControl.setCurrentData(null);
            session.saveOrUpdate((Object)storeSession);
            session.saveOrUpdate((Object)storeSessionControl);
            String string = "delete from KITCHEN_TICKET_ITEM";
            String string2 = "delete from KIT_TICKET_TABLE_NUM";
            String string3 = "delete from KITCHEN_TICKET";
            SQLQuery sQLQuery = session.createSQLQuery(string);
            sQLQuery.executeUpdate();
            SQLQuery sQLQuery2 = session.createSQLQuery(string2);
            sQLQuery2.executeUpdate();
            SQLQuery sQLQuery3 = session.createSQLQuery(string3);
            sQLQuery3.executeUpdate();
            transaction.commit();
        }
        catch (Exception exception) {
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store getCloudRestaurant(String string) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Store.PROP_UUID, (Object)string));
            Store store = (Store)criteria.uniqueResult();
            return store;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void saveOrUpdateStore(List<Store> list, boolean bl, boolean bl2, boolean bl3) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (Store store : list) {
                Store store2 = this.get(store.getId());
                Address address = store.getAddress();
                Map<String, String> map = store.getProperties();
                store.setUpdateLastUpdateTime(bl);
                store.setUpdateSyncTime(bl2);
                store.setAddress(null);
                this.saveOrUpdateStore(session, store, store2);
                this.saveOrUpdateStoreAddress(session, store, address);
                this.addOrUpdateStoreProperties(session, store, store2, map, bl3);
                Map<String, String> map2 = store2.getProperties();
                store.setProperties(map2);
                store.setAddress(address);
                this.saveOrUpdate(store, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    private void addOrUpdateStoreProperties(Session session, Store store, Store store2, Map<String, String> map, boolean bl) {
        Map<String, String> map2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        SubscriptionProduct[] subscriptionProductArray = SubscriptionProduct.values();
        for (Object object : subscriptionProductArray) {
            arrayList.add(object.getId());
        }
        if (store2 != null) {
            map2 = store2.getProperties();
        }
        for (Map.Entry entry : map.entrySet()) {
            String string;
            Object object;
            String string2 = (String)entry.getKey();
            object = map2.get(string2);
            if (!bl) {
                if (StringUtils.isNotEmpty((String)object)) {
                    string = StringUtils.substringBefore((String)string2, (String)".");
                    if (arrayList.contains(string) || string.contains("database")) continue;
                    this.addProperty(map2, entry, (String)object);
                    continue;
                }
                string = string2.substring(string2.lastIndexOf(".") + 1);
                if (string.equals("lastUpdateTime")) continue;
                this.addProperty(map2, entry, (String)entry.getValue());
                continue;
            }
            string = string2.substring(string2.lastIndexOf(".") + 1);
            if (string.equals("lastUpdateTime")) continue;
            this.addProperty(map2, entry, (String)object);
        }
    }

    private void addProperty(Map<String, String> map, Map.Entry<String, String> entry, String string) {
        if (StringUtils.isNotEmpty((String)string)) {
            map.put(entry.getKey(), entry.getValue());
        } else {
            map.putIfAbsent(entry.getKey(), entry.getValue());
        }
    }

    private void saveOrUpdateStoreAddress(Session session, Store store, Address address) {
        if (address == null) {
            return;
        }
        AddressDAO addressDAO = AddressDAO.getInstance();
        Address address2 = addressDAO.get(address.getId());
        if (address2 == null) {
            addressDAO.save(address);
        } else {
            address.setVersion(address2.getVersion());
        }
    }

    private void saveOrUpdateStore(Session session, Store store, Store store2) {
        if (store2 != null) {
            store.setVersion(store2.getVersion());
            store.setUuid(store2.getUuid());
            store.setDefaultOutletId(store2.getDefaultOutletId());
        }
    }

    public void removeLastUpdateTime() {
        try (Session session = this.createNewSession();){
            Transaction transaction = session.beginTransaction();
            Store store = (Store)session.get(Store.class, (Serializable)((Object)"1"));
            this.removeLastUpdateTime(store);
            transaction.commit();
        }
    }

    public void removeLastUpdateTime(Store store) {
        Map<String, String> map = store.getProperties();
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        arrayList.forEach(string -> {
            if (string.endsWith("lastUpdateTime")) {
                map.remove(string);
            }
        });
        map.remove("sync.conflict_resolve_option");
    }

    public void updateLastUpdateTimeProperty(Date date, List<DataSyncInfo> list) {
        Store store = StoreDAO.getRestaurant();
        for (DataSyncInfo dataSyncInfo : list) {
            GenericDAO.getInstance().updateLastUpdateTimeProperty(store, dataSyncInfo.getBeanClass(), date);
        }
        StoreDAO.getInstance().saveOrUpdate(store);
    }
}

