/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.util;

import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import java.util.Iterator;
import java.util.List;

public class TicketMergeUtil {
    public static void doMergeTickets(Ticket ticket, List<Ticket> list) {
        TicketMergeUtil.cleanMainTicket(ticket);
        Iterator<Ticket> iterator = list.iterator();
        while (iterator.hasNext()) {
            Ticket ticket2 = iterator.next();
            if (ticket2.equals(ticket)) {
                iterator.remove();
                continue;
            }
            List<TicketItem> list2 = ticket2.getTicketItems();
            if (list2 == null) continue;
            Iterator<TicketItem> iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                TicketItem ticketItem = iterator2.next();
                if (ticketItem.isTreatAsSeat().booleanValue()) {
                    iterator2.remove();
                    continue;
                }
                TicketItem ticketItem2 = ticketItem.clone();
                TicketMergeUtil.cleanTicketItem(ticket, ticket2, ticketItem2);
                ticket.addToticketItems(ticketItem2);
            }
        }
    }

    private static void cleanTicketItem(Ticket ticket, Ticket ticket2, TicketItem ticketItem) {
        ComboTicketItem comboTicketItem;
        List<TicketItem> list;
        List<TicketDiscount> list2;
        ticketItem.setId(null);
        ticketItem.setVersion(0L);
        ticketItem.setSeat(null);
        ticketItem.setSeatNumber(null);
        ticketItem.setTicket(ticket);
        TicketMergeUtil.cleanModifiers(ticketItem);
        if (ticketItem.isPizzaType().booleanValue()) {
            TicketMergeUtil.cleanSizeModifier(ticketItem);
        }
        if ((list2 = ticket2.getDiscounts()) != null && list2.size() > 0) {
            ticket2.getDiscounts().clear();
        }
        if (ticketItem instanceof ComboTicketItem && (list = (comboTicketItem = (ComboTicketItem)ticketItem).getComboItems()) != null) {
            for (TicketItem ticketItem2 : list) {
                TicketMergeUtil.cleanTicketItem(ticket, ticket2, ticketItem2);
                ticketItem2.setTicket(null);
            }
        }
    }

    private static void cleanModifiers(TicketItem ticketItem) {
        List<TicketItemModifier> list = ticketItem.getTicketItemModifiers();
        if (list != null && !list.isEmpty()) {
            for (TicketItemModifier ticketItemModifier : list) {
                ticketItemModifier.setId(null);
                ticketItemModifier.setVersion(0L);
            }
        }
    }

    private static void cleanSizeModifier(TicketItem ticketItem) {
        TicketItemModifier ticketItemModifier = ticketItem.getSizeModifier();
        if (ticketItemModifier != null) {
            ticketItemModifier.setId(null);
            ticketItemModifier.setVersion(0L);
        }
    }

    private static void cleanMainTicket(Ticket ticket) {
        ticket.getDiscounts().clear();
        if (ticket.getTicketItems() != null) {
            Iterator<TicketItem> iterator = ticket.getTicketItems().iterator();
            while (iterator.hasNext()) {
                TicketItem ticketItem = iterator.next();
                if (ticketItem.isTreatAsSeat().booleanValue()) {
                    iterator.remove();
                    continue;
                }
                ticketItem.setSeat(null);
                ticketItem.setSeatNumber(null);
            }
        }
    }
}

