/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.HourlySalesReportModel;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class HourlySalesReportView
extends TransparentPanel {
    private JButton a;
    private JComboBox<Terminal> b;
    private JXDatePicker c;
    private JXDatePicker d;
    private JPanel e;
    private JPanel f;
    private JComboBox<ReportTypeEnum> g;

    public HourlySalesReportView() {
        this.setLayout(new BorderLayout());
        this.b();
    }

    private void a() {
        try {
            Date date = this.c.getDate();
            Date date2 = this.d.getDate();
            DateUtil.validateDate(date, date2);
            Terminal terminal = null;
            if (this.b.getSelectedItem() instanceof Terminal) {
                terminal = (Terminal)this.b.getSelectedItem();
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            Date date3 = calendar.getTime();
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(date2);
            calendar2.set(10, 0);
            calendar2.set(12, 0);
            calendar2.set(13, 0);
            calendar2.add(5, 1);
            Date date4 = calendar2.getTime();
            List<LaborReportData> list = null;
            ReportTypeEnum reportTypeEnum = (ReportTypeEnum)((Object)this.g.getSelectedItem());
            if (reportTypeEnum == ReportTypeEnum.GROSS || reportTypeEnum == ReportTypeEnum.NET) {
                list = this.a(date3, date4, terminal, reportTypeEnum);
            } else if (reportTypeEnum == ReportTypeEnum.RECEIVED) {
                list = this.a(date3, date4);
            }
            JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("hourly_labor_subreport"));
            JasperReport jasperReport2 = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("hourly_labor_report"));
            String string = terminal == null ? POSConstants.ALL : terminal.getName();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            ReportUtil.populateRestaurantProperties(hashMap);
            ReportUtil.populateReportTime(hashMap, date, date2);
            ReportUtil.populateReportFooter(hashMap);
            this.a(hashMap);
            hashMap.put("reportTitle", Messages.getString("HourlySalesReportView.5"));
            hashMap.put("currency", ReportUtil.reportLabelWithBoldTag(POSConstants.CURRENCY) + " " + CurrencyUtil.getCurrencyName() + CurrencyUtil.getCurrencySymbolWithBracket());
            hashMap.put("salesType", ReportUtil.reportLabelWithBoldTag(Messages.getString("salesType")) + this.g.getSelectedItem());
            hashMap.put("incr", ReportUtil.reportLabelWithBoldTag(Messages.getString("incr")) + Messages.getString("HourlyLaborReportView.0"));
            hashMap.put("cntr", ReportUtil.reportLabelWithBoldTag(POSConstants.TERMINAL) + string);
            hashMap.put("hourlyReport", jasperReport);
            hashMap.put("hourlyReportDatasource", new JRTableModelDataSource((TableModel)new HourlySalesReportModel(list)));
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport2, hashMap, (JRDataSource)new JREmptyDataSource());
            JRViewer jRViewer = new JRViewer(jasperPrint);
            this.e.removeAll();
            this.e.add((Component)jRViewer);
            this.e.revalidate();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private List<LaborReportData> a(Date date, Date date2, Terminal terminal, ReportTypeEnum reportTypeEnum) {
        Object object;
        Comparable comparable;
        DecimalFormat decimalFormat = new DecimalFormat("00");
        HashMap<Integer, LaborReportData> hashMap = new HashMap<Integer, LaborReportData>();
        ArrayList<LaborReportData> arrayList = new ArrayList<LaborReportData>();
        List<TicketItem> list = TicketItemDAO.getInstance().getSalesItems(date, date2, terminal);
        for (TicketItem object22 : list) {
            comparable = object22.getTicket();
            object = object22.getCreateDate();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)object);
            Integer n = calendar.get(11);
            LaborReportData laborReportData = (LaborReportData)hashMap.get(n);
            if (laborReportData == null) {
                laborReportData = new LaborReportData();
                hashMap.put(n, laborReportData);
            }
            laborReportData.a.add((Ticket)comparable);
            laborReportData.b.add(((Ticket)comparable).getOwner());
            if (reportTypeEnum == ReportTypeEnum.GROSS) {
                laborReportData.setSales(laborReportData.getSales() + object22.getSubtotalAmount());
                continue;
            }
            if (reportTypeEnum != ReportTypeEnum.NET) continue;
            double d = object22.getSubtotalAmount() - object22.getAdjustedDiscount();
            laborReportData.setSales(laborReportData.getSales() + d);
        }
        ArrayList arrayList2 = new ArrayList(hashMap.keySet());
        Collections.sort(arrayList2);
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            comparable = (Integer)iterator.next();
            object = (LaborReportData)hashMap.get(comparable);
            ((LaborReportData)object).setPeriod(decimalFormat.format(comparable));
            this.a((LaborReportData)object);
            arrayList.add((LaborReportData)object);
        }
        return arrayList;
    }

    private List<LaborReportData> a(Date date, Date date2, Shift shift) {
        Object object;
        Comparable comparable;
        DecimalFormat decimalFormat = new DecimalFormat("00");
        HashMap<Integer, LaborReportData> hashMap = new HashMap<Integer, LaborReportData>();
        ArrayList<LaborReportData> arrayList = new ArrayList<LaborReportData>();
        List<TicketItem> list = TicketItemDAO.getInstance().getSalesItems(date, date2, null);
        for (TicketItem object22 : list) {
            comparable = object22.getTicket();
            object = object22.getCreateDate();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)object);
            Integer n = calendar.get(11);
            LaborReportData laborReportData = (LaborReportData)hashMap.get(n);
            if (laborReportData == null) {
                laborReportData = new LaborReportData();
                hashMap.put(n, laborReportData);
            }
            laborReportData.a.add((Ticket)comparable);
            laborReportData.b.add(((Ticket)comparable).getOwner());
            if (this.g.getSelectedIndex() == 0) {
                laborReportData.setSales(laborReportData.getSales() + object22.getSubtotalAmount());
                continue;
            }
            if (this.g.getSelectedIndex() != 1) continue;
            double d = object22.getSubtotalAmount() - object22.getAdjustedDiscount();
            laborReportData.setSales(laborReportData.getSales() + d);
        }
        ArrayList arrayList2 = new ArrayList(hashMap.keySet());
        Collections.sort(arrayList2);
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            comparable = (Integer)iterator.next();
            object = (LaborReportData)hashMap.get(comparable);
            ((LaborReportData)object).setPeriod(decimalFormat.format(comparable));
            this.a((LaborReportData)object);
            arrayList.add((LaborReportData)object);
        }
        return arrayList;
    }

    private List<LaborReportData> a(Date date, Date date2) {
        Object object;
        Comparable comparable;
        DecimalFormat decimalFormat = new DecimalFormat("00");
        HashMap<Integer, LaborReportData> hashMap = new HashMap<Integer, LaborReportData>();
        ArrayList<LaborReportData> arrayList = new ArrayList<LaborReportData>();
        List<PosTransaction> list = PosTransactionDAO.getInstance().findReceived(null, date, date2);
        for (PosTransaction object22 : list) {
            comparable = object22.getTicket();
            object = object22.getTransactionTime();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)object);
            Integer n = calendar.get(11);
            LaborReportData laborReportData = (LaborReportData)hashMap.get(n);
            if (laborReportData == null) {
                laborReportData = new LaborReportData();
                hashMap.put(n, laborReportData);
            }
            laborReportData.a.add((Ticket)comparable);
            laborReportData.b.add(((Ticket)comparable).getOwner());
            laborReportData.setSales(laborReportData.getSales() + object22.getAmount());
        }
        ArrayList arrayList2 = new ArrayList(hashMap.keySet());
        Collections.sort(arrayList2);
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            comparable = (Integer)iterator.next();
            object = (LaborReportData)hashMap.get(comparable);
            ((LaborReportData)object).setPeriod(decimalFormat.format(comparable));
            this.a((LaborReportData)object);
            arrayList.add((LaborReportData)object);
        }
        return arrayList;
    }

    private void a(LaborReportData laborReportData) {
        for (Ticket ticket : laborReportData.a) {
            laborReportData.setNoOfGuests(laborReportData.getNoOfGuests() + (double)ticket.getNumberOfGuests().intValue());
        }
        laborReportData.setNoOfChecks(laborReportData.a.size());
        double d = laborReportData.b.size();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (User user : laborReportData.b) {
            if (user == null) continue;
            d2 += user.getCostPerHour() == null ? 0.0 : user.getCostPerHour();
        }
        if (d > 0.0) {
            d2 /= d;
            d3 = laborReportData.f / d;
            d4 = laborReportData.e / d;
            d5 = laborReportData.d / d;
        }
        laborReportData.setManHour(d);
        laborReportData.setLabor(d2);
        laborReportData.setSalesPerMHr(d3);
        laborReportData.setGuestsPerMHr(d4);
        laborReportData.setCheckPerMHr(d5);
        double d6 = d2 != 0.0 ? (laborReportData.f != 0.0 ? d2 * 100.0 / laborReportData.f : 100.0) : 0.0;
        laborReportData.setLaborCost(d6);
    }

    private void a(HashMap<String, Object> hashMap) {
        hashMap.put("SWRTitle", "");
        hashMap.put("SRGTotal", POSConstants.GRAND_TOTAL);
        hashMap.put("SRPeriod", Messages.getString("PERIOD"));
        hashMap.put("SRChecks", Messages.getString("CHECKS"));
        hashMap.put("SRGuests", Messages.getString("GUESTS"));
        hashMap.put("SRSales", POSConstants.SALES);
        hashMap.put("SRMHour", Messages.getString("ManHour"));
        hashMap.put("SRSMH", Messages.getString("SManHour"));
        hashMap.put("SRGMH", Messages.getString("GManHour"));
        hashMap.put("SRCMH", Messages.getString("CManHour"));
        hashMap.put("SRLCost", Messages.getString("LaborCost"));
        hashMap.put("SRLCostP", Messages.getString("LaborCostP"));
    }

    private void b() {
        this.c = UiUtil.getCurrentMonthStart();
        this.d = UiUtil.getCurrentMonthEnd();
        this.a = new JButton();
        this.a.setText(POSConstants.GO);
        this.a.addActionListener(actionEvent -> this.a());
        this.b = new JComboBox();
        TerminalDAO terminalDAO = new TerminalDAO();
        List<Terminal> list = terminalDAO.findAll();
        list.add(0, (Terminal)((Object)POSConstants.ALL));
        this.b.setModel(new ListComboBoxModel(list));
        this.g = new JComboBox();
        this.g.addItem(ReportTypeEnum.GROSS);
        this.g.addItem(ReportTypeEnum.NET);
        this.g.addItem(ReportTypeEnum.RECEIVED);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("", "[][][][][][]"));
        jPanel.add(new JLabel(POSConstants.START_DATE + ":"));
        this.c.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.c);
        jPanel.add(new JLabel(POSConstants.END_DATE + ":"));
        this.d.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.d);
        jPanel.add(new JLabel(POSConstants.TERMINAL_LABEL + ":"));
        jPanel.add(this.b);
        jPanel.add(new JLabel(Messages.getString("HourlySalesReportView.15") + ":"));
        jPanel.add(this.g);
        jPanel.add((Component)this.a, "width 60!");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.add((Component)new JSeparator(), "North");
        this.e = new JPanel(new BorderLayout());
        jPanel2.add(this.e);
        this.add(jPanel2);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.f;
    }

    static enum ReportTypeEnum {
        GROSS(Messages.getString("HourlySalesReportView.7")),
        NET(Messages.getString("HourlySalesReportView.8")),
        RECEIVED(Messages.getString("HourlySalesReportView.9"));

        private String a;

        private ReportTypeEnum(String string2) {
            this.a = string2;
        }

        public String toString() {
            return this.a;
        }
    }

    public static class LaborReportData {
        private String c;
        private double d;
        private double e;
        private double f;
        private double g;
        private double h;
        private double i;
        private double j;
        private double k;
        private double l;
        Set<Ticket> a = new HashSet<Ticket>();
        Set<User> b = new HashSet<User>();

        public double getCheckPerMHr() {
            return this.k;
        }

        public void setCheckPerMHr(double d) {
            this.k = d;
        }

        public double getGuestsPerMHr() {
            return this.j;
        }

        public void setGuestsPerMHr(double d) {
            this.j = d;
        }

        public double getLabor() {
            return this.h;
        }

        public void setLabor(double d) {
            this.h = d;
        }

        public double getLaborCost() {
            return this.l;
        }

        public void setLaborCost(double d) {
            this.l = d;
        }

        public double getManHour() {
            return this.g;
        }

        public void setManHour(double d) {
            this.g = d;
        }

        public double getNoOfChecks() {
            return this.d;
        }

        public void setNoOfChecks(double d) {
            this.d = d;
        }

        public double getNoOfGuests() {
            return this.e;
        }

        public void setNoOfGuests(double d) {
            this.e = d;
        }

        public String getPeriod() {
            return this.c;
        }

        public void setPeriod(String string) {
            this.c = string;
        }

        public double getSales() {
            return this.f;
        }

        public void setSales(double d) {
            this.f = d;
        }

        public double getSalesPerMHr() {
            return this.i;
        }

        public void setSalesPerMHr(double d) {
            this.i = d;
        }
    }

    public static enum SalesType {
        GROSS_SALES,
        NET_SALES;

    }
}

