/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.DayOfWeek;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.WeeklyPayrollReportData;
import com.floreantpos.report.WeeklyPayrollReportModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class WeeklyPayrollReportView
extends TransparentPanel {
    private JButton a;
    private JXDatePicker b;
    private JXDatePicker c;
    private JPanel d;
    private JPanel e;
    private JComboBox f;
    private JComboBox<DayOfWeek> g;

    public WeeklyPayrollReportView() {
        this.setLayout(new BorderLayout());
        this.b();
    }

    private void a() {
        try {
            DayOfWeek dayOfWeek = (DayOfWeek)((Object)this.g.getSelectedItem());
            int n = dayOfWeek.getValue();
            Date date = this.b.getDate();
            Date date2 = this.c.getDate();
            DateUtil.validateDate(date, date2);
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(date);
            calendar.set(1, calendar2.get(1));
            calendar.set(2, calendar2.get(2));
            calendar.set(5, calendar2.get(5));
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            date = calendar.getTime();
            calendar.clear();
            calendar2.setTime(date2);
            calendar.set(1, calendar2.get(1));
            calendar.set(2, calendar2.get(2));
            calendar.set(5, calendar2.get(5));
            calendar.set(10, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            date2 = calendar.getTime();
            Object object = this.f.getSelectedItem();
            User user = null;
            if (object instanceof User) {
                user = (User)object;
            }
            List<WeeklyPayrollReportData> list = AttendenceHistoryDAO.getInstance().findWeeklyPayroll(date, date2, user, n);
            JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("WeeklyPayrollReport"));
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            ReportUtil.populateRestaurantProperties(hashMap);
            ReportUtil.populateReportTime(hashMap, date, date2);
            ReportUtil.populateReportFooter(hashMap);
            this.a(hashMap);
            WeeklyPayrollReportModel weeklyPayrollReportModel = new WeeklyPayrollReportModel();
            weeklyPayrollReportModel.setRows(list);
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)weeklyPayrollReportModel));
            JRViewer jRViewer = new JRViewer(jasperPrint);
            this.d.removeAll();
            this.d.add((Component)jRViewer);
            this.d.revalidate();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(HashMap<String, Object> hashMap) {
        hashMap.put("RTitle", Messages.getString("WeeklyPayrollReportAction.0"));
        hashMap.put("colEID", Messages.getString("EmployeeId"));
        hashMap.put("colEName", Messages.getString("EmployeeName"));
        hashMap.put("colRole", Messages.getString("colRole"));
        hashMap.put("colRHW", Messages.getString("RegularH") + "<br/>" + Messages.getString("Worked"));
        hashMap.put("colOHW", Messages.getString("OvertimeH") + "<br/>" + Messages.getString("Worked"));
        hashMap.put("colRPay", Messages.getString("Regular") + "<br/>" + Messages.getString("PAYMENT"));
        hashMap.put("colOTPay", Messages.getString("OvertimeTH") + "<br/>" + Messages.getString("PAYMENT"));
        hashMap.put("colTHWork", Messages.getString("TotalH") + "<br/>" + Messages.getString("Worked"));
        hashMap.put("colTPay", POSConstants.TOTAL + "<br/>" + Messages.getString("PAYMENT"));
        hashMap.put("colDTips", Messages.getString("declaredTips"));
        hashMap.put("colNCTips", Messages.getString("NoncashTips"));
    }

    private void b() {
        this.g = new JComboBox<DayOfWeek>(DayOfWeek.values());
        this.g.setSelectedIndex(1);
        this.b = UiUtil.getCurrentMonthStart();
        this.c = UiUtil.getDeafultDate();
        this.c.setDate(new Date());
        this.a = new JButton();
        this.a.setText(POSConstants.GO);
        this.a.addActionListener(actionEvent -> this.a());
        this.f = new JComboBox();
        UserDAO userDAO = new UserDAO();
        List<User> list = userDAO.findActiveUsersForPayroll();
        Vector<Object> vector = new Vector<Object>();
        vector.add(POSConstants.ALL);
        vector.addAll(list);
        this.f.setModel(new DefaultComboBoxModel(vector));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        jPanel.add(new JLabel(Messages.getString("WeeklyPayrollReportView.2")));
        jPanel.add(this.g);
        jPanel.add(new JLabel(POSConstants.START_DATE + ":"));
        this.b.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.b);
        jPanel.add(new JLabel(POSConstants.END_DATE + ":"));
        this.c.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.c);
        jPanel.add(new JLabel(POSConstants.EMPLOYEE + ":"));
        jPanel.add(this.f);
        jPanel.add((Component)this.a, "width 60!");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.add((Component)new JSeparator(), "North");
        this.d = new JPanel(new BorderLayout());
        jPanel2.add(this.d);
        this.add(jPanel2);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.e;
    }

    public static class LaborReportData {
        private String a;
        private int b;
        private int c;
        private double d;
        private double e;
        private double f;
        private double g;
        private double h;
        private double i;
        private double j;

        public double getCheckPerMHr() {
            return this.i;
        }

        public void setCheckPerMHr(double d) {
            this.i = d;
        }

        public double getGuestsPerMHr() {
            return this.h;
        }

        public void setGuestsPerMHr(double d) {
            this.h = d;
        }

        public double getLabor() {
            return this.f;
        }

        public void setLabor(double d) {
            this.f = d;
        }

        public double getLaborCost() {
            return this.j;
        }

        public void setLaborCost(double d) {
            this.j = d;
        }

        public double getManHour() {
            return this.e;
        }

        public void setManHour(double d) {
            this.e = d;
        }

        public int getNoOfChecks() {
            return this.b;
        }

        public void setNoOfChecks(int n) {
            this.b = n;
        }

        public int getNoOfGuests() {
            return this.c;
        }

        public void setNoOfGuests(int n) {
            this.c = n;
        }

        public String getPeriod() {
            return this.a;
        }

        public void setPeriod(String string) {
            this.a = string;
        }

        public double getSales() {
            return this.d;
        }

        public void setSales(double d) {
            this.d = d;
        }

        public double getSalesPerMHr() {
            return this.g;
        }

        public void setSalesPerMHr(double d) {
            this.g = d;
        }
    }

    public static enum PayrollType {
        WEEKLY(Messages.getString("WeeklyPayrollReportView.0")),
        DO_WEEKLY(Messages.getString("WeeklyPayrollReportView.1"));

        private String a;

        private PayrollType(String string2) {
            this.a = string2;
        }

        public String toString() {
            return this.a;
        }
    }
}

