/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.service;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.report.ReportItem;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.SalesReportModel;
import com.floreantpos.util.CurrencyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;

public class SalesReportService {
    private SalesReportModel a;
    private SalesReportModel b;
    private Date c;
    private Date d;
    private Terminal e;
    private List<MenuGroup> f;
    private boolean g;
    private boolean h;
    private boolean i;

    public SalesReportService(Date date, Date date2, Terminal terminal, List<MenuGroup> list, boolean bl, boolean bl2, boolean bl3) {
        this.c = date;
        this.d = date2;
        this.e = terminal;
        this.f = list;
        this.g = bl;
        this.h = bl2;
        this.i = bl3;
    }

    public JasperPrint createJasperPrint() throws JRException {
        this.a();
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("sales_sub_report"));
        JasperReport jasperReport2 = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("sales_sub_report"));
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(hashMap);
        ReportUtil.populateReportHeader(hashMap, this.e, this.c, this.d, null);
        String string = this.g ? Messages.getString("SalesReport.3") : Messages.getString("SalesReport.9");
        hashMap.put("reportTitle", string);
        hashMap.put("itemDataSource", new JRTableModelDataSource((TableModel)this.a));
        hashMap.put("modifierDataSource", new JRTableModelDataSource((TableModel)this.b));
        hashMap.put("currencySymbol", CurrencyUtil.getCurrencySymbolWithBracket());
        hashMap.put("itemReport", jasperReport);
        hashMap.put("isShowGroup", this.h);
        hashMap.put("modifierReport", jasperReport2);
        hashMap.put("colId", ReportUtil.reportLabelWithBoldTag(POSConstants.ID));
        hashMap.put("colName", ReportUtil.reportLabelWithBoldTag(POSConstants.NAME));
        hashMap.put("colQty", ReportUtil.reportLabelWithBoldTag(POSConstants.QTY));
        hashMap.put("colUnit", ReportUtil.reportLabelWithBoldTag(POSConstants.UNIT));
        hashMap.put("colSales", ReportUtil.reportLabelWithBoldTag(POSConstants.SALES));
        hashMap.put("colDiscount", ReportUtil.reportLabelWithBoldTag(POSConstants.DISCOUNT));
        hashMap.put("colCost", ReportUtil.reportLabelWithBoldTag(POSConstants.COST));
        hashMap.put("colCostPer", ReportUtil.reportLabelWithBoldTag(POSConstants.COST_PERCENTAGE));
        hashMap.put("colNetTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.NET_TOTAL));
        hashMap.put("colTax", ReportUtil.reportLabelWithBoldTag(POSConstants.TAX));
        hashMap.put("colSC", ReportUtil.reportLabelWithBoldTag(POSConstants.S_C));
        hashMap.put("colGrossT", ReportUtil.reportLabelWithBoldTag(POSConstants.GROSS_TOTAL));
        hashMap.put("groupTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.GROUP_TOTAL));
        hashMap.put("lblGrandTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.GRAND_TOTAL));
        if (this.b.getItems().size() > 0) {
            hashMap.put("modifierSection", Messages.getString("SalesReportService.5"));
        }
        JasperReport jasperReport3 = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("sales_report"));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport3, hashMap, (JRDataSource)new JREmptyDataSource());
        return jasperPrint;
    }

    private void a() {
        LinkedHashMap<String, ReportItem> linkedHashMap = new LinkedHashMap<String, ReportItem>();
        LinkedHashMap<Object, ReportItem> linkedHashMap2 = new LinkedHashMap<Object, ReportItem>();
        TicketItemDAO ticketItemDAO = TicketItemDAO.getInstance();
        List<TicketItem> list = ticketItemDAO.findTicketItemWithinDate(this.c, this.d, this.e, this.f, this.g);
        ArrayList<TicketItemModifier> arrayList = new ArrayList<TicketItemModifier>();
        for (TicketItem serializable2 : list) {
            List<TicketItem> list2;
            if (serializable2.getUnitPrice() == 0.0 && !this.i) continue;
            this.a(serializable2, serializable2.getUnitPrice(), linkedHashMap);
            this.a(serializable2, arrayList, false);
            if (!serializable2.isComboItem().booleanValue() || (list2 = ((ComboTicketItem)serializable2).getComboItems()) == null || list2.size() <= 0) continue;
            for (Object object : list2) {
                ((BaseTicketItem)object).setUnitPrice(0.0);
                ((TicketItem)object).calculatePrice();
                this.a((TicketItem)object, serializable2.getUnitPrice(), linkedHashMap);
                this.a((TicketItem)object, arrayList, true);
            }
        }
        ArrayList arrayList2 = new ArrayList(((HashMap)linkedHashMap).values());
        if (this.h) {
            Collections.sort(arrayList2, new Comparator<ReportItem>(){

                @Override
                public int compare(ReportItem reportItem, ReportItem reportItem2) {
                    if (reportItem.getGroupName() == reportItem2.getGroupName()) {
                        return 0;
                    }
                    if (reportItem.getGroupName() == null) {
                        return 1;
                    }
                    if (reportItem2.getGroupName() == null) {
                        return -1;
                    }
                    return reportItem.getGroupName().compareTo(reportItem2.getGroupName());
                }
            });
        }
        this.a = new SalesReportModel();
        this.a.setItems(arrayList2);
        for (TicketItemModifier ticketItemModifier : arrayList) {
            Object object;
            if (ticketItemModifier.getUnitPrice() == 0.0 && !this.i) continue;
            String string = ticketItemModifier.getItemId();
            object = (String)(string == null ? ticketItemModifier.getName() : string) + "-" + ticketItemModifier.getModifierType() + "-" + ticketItemModifier.getUnitPrice();
            ReportItem reportItem = (ReportItem)((HashMap)linkedHashMap2).get(object);
            if (reportItem == null) {
                reportItem = new ReportItem();
                reportItem.setId(string);
                reportItem.setPrice(ticketItemModifier.getUnitPrice());
                reportItem.setName(ticketItemModifier.getName());
                reportItem.setTaxRate(ticketItemModifier.getTotalTaxRate());
                reportItem.setAdjustedPrice(ticketItemModifier.getAdjustedUnitPrice());
                reportItem.setServiceCharge(ticketItemModifier.getServiceCharge());
                linkedHashMap2.put(object, reportItem);
            }
            reportItem.setQuantity(reportItem.getQuantity() + ticketItemModifier.getItemQuantity() * ticketItemModifier.getTicketItemQuantity());
            reportItem.setDiscount(reportItem.getDiscount() + ticketItemModifier.getAdjustedDiscount());
            reportItem.setServiceCharge(reportItem.getServiceCharge() + ticketItemModifier.getServiceCharge());
            reportItem.setGrossTotal(reportItem.getGrossTotal() + ticketItemModifier.getAdjustedTotal());
            reportItem.setTaxTotal(reportItem.getTaxTotal() + ticketItemModifier.getAdjustedTax());
            double d = ticketItemModifier.isTaxIncluded() != false ? ticketItemModifier.getAdjustedSubtotal() - ticketItemModifier.getAdjustedTax() : ticketItemModifier.getAdjustedSubtotal();
            reportItem.setNetTotal(reportItem.getNetTotal() + d);
        }
        this.b = new SalesReportModel();
        ArrayList<ReportItem> arrayList3 = new ArrayList<ReportItem>(((HashMap)linkedHashMap2).values());
        this.b.setItems(arrayList3);
    }

    private void a(TicketItem ticketItem, List<TicketItemModifier> list, boolean bl) {
        if (ticketItem instanceof ModifiableTicketItem) {
            List<TicketItemModifier> list2 = ((ModifiableTicketItem)ticketItem).getTicketItemModifiers();
            list.addAll(list2);
        }
    }

    private void a(TicketItem ticketItem, Double d, HashMap<String, ReportItem> hashMap) {
        String string = ticketItem.getMenuItemId();
        String string2 = (string == null ? ticketItem.getName() : string) + "-" + d;
        ReportItem reportItem = hashMap.get(string2);
        if (reportItem == null) {
            reportItem = new ReportItem();
            reportItem.setId(string2);
            reportItem.setPrice(ticketItem.getUnitPrice());
            reportItem.setCost(ticketItem.getUnitCost());
            reportItem.setName(ticketItem.getName());
            reportItem.setUnit(ticketItem.getUnitName());
            reportItem.setTaxRate(ticketItem.getTotalTaxRate());
            reportItem.setGroupName(ticketItem.getGroupName());
            reportItem.setBarcode(string);
            reportItem.setAdjustedPrice(ticketItem.getAdjustedUnitPrice());
            hashMap.put(string2, reportItem);
        }
        reportItem.setQuantity(reportItem.getQuantity() + ticketItem.getQuantity());
        reportItem.setGrossTotal(reportItem.getGrossTotal() + ticketItem.getAdjustedTotalWithoutModifiers());
        reportItem.setDiscount(reportItem.getDiscount() + ticketItem.getAdjustedDiscountWithoutModifiers());
        reportItem.setTaxTotal(reportItem.getTaxTotal() + ticketItem.getAdjustedTaxWithoutModifiers());
        reportItem.setServiceCharge(reportItem.getServiceCharge() + ticketItem.getServiceCharge());
        double d2 = ticketItem.isTaxIncluded() != false ? ticketItem.getAdjustedTotalWithoutModifiers() - ticketItem.getAdjustedTaxWithoutModifiers() : ticketItem.getAdjustedSubtotalWithoutModifiers();
        reportItem.setNetTotal(reportItem.getNetTotal() + d2);
    }
}

