/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services.report;

import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.CategoryBreakOut;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.GiftCertificateTransaction;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;

public class ServerSummaryReportService {
    private StoreSession a;
    private Session b;
    private User c;
    private CashDrawer d = new CashDrawer();

    public ServerSummaryReportService(User user, StoreSession storeSession) {
        this.c = user;
        this.a = storeSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CashDrawer populateServerSummaryReport() {
        GenericDAO genericDAO = new GenericDAO();
        try {
            this.b = genericDAO.createNewSession();
            this.b();
            this.l();
            this.m();
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            d = this.d.getNetSales() + this.d.getSalesTax() + this.d.getServiceCharge() - this.d.getTotalDiscountSales();
            this.d.setTotalRevenue(POSUtil.getRoundedDouble(d));
            d2 = this.d.getCashTips() + this.d.getChargedTips();
            d3 = d + d2;
            this.d.setGrossReceipts(d3);
            this.c();
            this.e();
            this.f();
            this.g();
            this.h();
            this.i();
            this.j();
            this.k();
            this.d();
            Store store = DataProvider.get().getStore();
            if (POSUtil.getBoolean(store.getProperty("show_category_breakout.in_server_Summary"))) {
                this.a();
            }
            double d4 = this.d.getCashReceiptAmount() + this.d.getCreditCardReceiptAmount() + this.d.getDebitCardReceiptAmount() + this.d.getCustomerPaymentAmount() + this.d.getPromotionAmount() + this.d.getCustomPaymentAmount() + this.d.getGiftCertChangeAmount() - this.d.getRefundAmount() - this.d.getToleranceAmount();
            this.d.setReceiptDifferential(POSUtil.getRoundedDouble(d3 - d4));
            this.d.setAssignedUser(this.c);
            this.d.setStartTime(this.a.getOpenTime());
            this.d.setAssignedBy(this.a.getOpenedBy());
            this.d.setReportTime(this.a.getCloseTime());
            this.d.setClosedBy(this.a.getClosedBy());
            this.d.setStoreOperationData(this.a);
            CashDrawer cashDrawer = this.d;
            return cashDrawer;
        }
        finally {
            if (this.b != null) {
                this.b.close();
            }
        }
    }

    private void a() {
        Criteria criteria = this.b.createCriteria(TicketItem.class);
        criteria.createAlias("ticket", "t");
        criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_OWNER_ID), (Object)this.c.getId()));
        criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_STORE_SESSION_ID), (Object)this.a.getId()));
        criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_VOIDED), (Object)Boolean.FALSE));
        criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_VOIDED, (Object)Boolean.FALSE));
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.groupProperty((String)TicketItem.PROP_CATEGORY_ID), "categoryId");
        projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_SUBTOTAL_AMOUNT), "breakOutAmt");
        criteria.setProjection((Projection)projectionList);
        criteria.setResultTransformer(Transformers.aliasToBean(CategoryBreakOut.class));
        List list = criteria.list();
        ArrayList<CategoryBreakOut> arrayList = new ArrayList<CategoryBreakOut>();
        for (CategoryBreakOut categoryBreakOut : list) {
            if (categoryBreakOut.getBreakOutAmt() <= 0.0) continue;
            String string = categoryBreakOut.getCategoryId();
            if (StringUtils.isNotBlank((String)string)) {
                categoryBreakOut.setCategoryName(MenuCategoryDAO.getInstance().getNameById(string));
            }
            arrayList.add(categoryBreakOut);
        }
        this.d.setCategoryBreakOut(arrayList);
    }

    private void b() {
        Criteria criteria = this.b.createCriteria(Ticket.class);
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)this.c.getId()));
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_STORE_SESSION_ID, (Object)this.a.getId()));
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.sum((String)Ticket.PROP_SUBTOTAL_AMOUNT));
        projectionList.add((Projection)Projections.sum((String)Ticket.PROP_TAX_AMOUNT));
        projectionList.add((Projection)Projections.sum((String)Ticket.PROP_SERVICE_CHARGE));
        projectionList.add((Projection)Projections.sum((String)Ticket.PROP_DISCOUNT_AMOUNT));
        criteria.setProjection((Projection)projectionList);
        List list = criteria.list();
        for (Object[] objectArray : list) {
            double d = objectArray[0] != null ? ((Number)objectArray[0]).doubleValue() : 0.0;
            double d2 = objectArray[1] != null ? ((Number)objectArray[1]).doubleValue() : 0.0;
            double d3 = objectArray[2] != null ? ((Number)objectArray[2]).doubleValue() : 0.0;
            double d4 = objectArray[3] != null ? ((Number)objectArray[3]).doubleValue() : 0.0;
            this.d.setNetSales(NumberUtil.round(d));
            this.d.setSalesTax(NumberUtil.round(d2));
            this.d.setServiceCharge(NumberUtil.round(d3));
            this.d.setTotalDiscountSales(NumberUtil.round(d4));
        }
    }

    private Criteria a(Class clazz) {
        Criteria criteria = this.b.createCriteria(clazz);
        if (clazz.equals(RefundTransaction.class) || clazz.equals(PayOutTransaction.class)) {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.DEBIT.name()));
        } else {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        }
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.a.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        return criteria;
    }

    private void c() {
        Criteria criteria = this.a(CashTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)this.c.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.a.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        this.d.setCashReceiptAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void d() {
        Criteria criteria = this.a(CashTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)this.c.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.a.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TOLERANCE_AMOUNT));
        this.d.setToleranceAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void e() {
        Criteria criteria = this.a(CreditCardTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)this.c.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.a.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        this.d.setCreditCardReceiptAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void f() {
        Criteria criteria = this.a(DebitCardTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)CashTransaction.PROP_USER_ID, (Object)this.c.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.a.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        this.d.setDebitCardReceiptAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void g() {
        Criteria criteria = this.a(CustomerAccountTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)this.c.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.a.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        this.d.setCustomerPaymentAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void h() {
        Criteria criteria = this.a(CustomPaymentTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)this.c.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.a.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.add((Criterion)Restrictions.ne((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.PROMOTION.name()));
        criteria.setProjection((Projection)Projections.sum((String)CustomPaymentTransaction.PROP_AMOUNT));
        this.d.setCustomPaymentAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void i() {
        Criteria criteria = this.a(CustomPaymentTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)this.c.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.a.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.PROMOTION.name()));
        criteria.setProjection((Projection)Projections.sum((String)CustomPaymentTransaction.PROP_AMOUNT));
        this.d.setPromotionAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void j() {
        Criteria criteria = this.a(GiftCertificateTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)this.c.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.a.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)GiftCertificateTransaction.PROP_AMOUNT));
        this.d.setGiftCertChangeAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void k() {
        Criteria criteria = this.a(RefundTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)RefundTransaction.PROP_USER_ID, (Object)this.c.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.a.getId()));
        criteria.setProjection((Projection)Projections.sum((String)RefundTransaction.PROP_AMOUNT));
        this.d.setRefundAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void l() {
        Criteria criteria = this.a(CashTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)this.c.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.a.getId()));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        this.d.setCashTips(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void m() {
        Criteria criteria = this.a(PosTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)this.c.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.a.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.add((Criterion)Restrictions.ne((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        this.d.setChargedTips(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }
}

