/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.kitchendisplay;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.config.AppConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.SlideShowImageDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.PaginatedTableModel;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.ticket.TicketViewerTable;
import com.floreantpos.ui.ticket.TicketViewerTableModel;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.actions.TicketEditListener;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.Timer;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;

public class LineDisplayWindow
extends JFrame
implements TicketEditListener,
WindowListener {
    private static final String a = "bwy";
    private static final String b = "bwx";
    private static final String c = "bwheight";
    private static final String d = "bwwidth";
    public static final String VIEW_NAME = "KD";
    private JLabel e;
    private JLabel f;
    private JLabel g;
    private JLabel h;
    private JLabel i;
    private JLabel j;
    private static LineDisplayWindow k;
    private JPanel l;
    private JLabel m;
    private JLabel n;
    private JLabel o;
    private JLabel p;
    private JLabel q;
    private JPanel r;
    private TicketViewerTable s = new TicketViewerTable(null, 0, 2);
    private Store t;
    private boolean u;
    private boolean v;
    private boolean w;
    private Timer x;
    private JLabel y;
    private JPanel z;
    private JPanel A;
    private JLabel B;
    private JLabel C;
    private JLabel D;
    private JLabel E;
    private JLabel F;
    private JLabel G;
    private PosScrollPane H;
    private PaginatedTableModel I;
    private JLabel J;
    private JSeparator K;
    private JSeparator L;
    private JLabel M;

    public LineDisplayWindow() {
        this.setIconImage(Application.getApplicationIcon().getImage());
        this.s.setModel(new TicketViewerTableModel(this.s));
        this.s.setShowGrid(false);
        this.s.setFont(this.s.getFont().deriveFont((float)PosUIManager.getFontSize(18)));
        TableColumnModel tableColumnModel = this.s.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(PosUIManager.getSize(250));
        this.d();
        this.f();
        this.addWindowListener(this);
        this.setDefaultCloseOperation(0);
        this.setTitle(Application.getTitle() + "- " + Messages.getString("LineDisplayWindow.1"));
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        OrderView.getInstance().getOrderController().addTicketUpdateListener(this);
        this.a();
        this.b();
    }

    private void a() {
        this.I = new PaginatedTableModel(){

            @Override
            public Object getValueAt(int n, int n2) {
                return null;
            }
        };
        this.I.setRows(new ArrayList());
        this.I.setPageSize(1);
        this.I.setNumRows(SlideShowImageDAO.getInstance().rowCount());
    }

    private void b() {
        this.t = DataProvider.get().getStore();
        int n = this.t.getCustomerMonitorDisplayOption();
        switch (n) {
            case 0: {
                this.u = true;
                break;
            }
            case 1: {
                this.v = true;
                break;
            }
            case 2: {
                this.w = true;
                break;
            }
        }
        this.c();
        this.y.setText(DateUtil.getOnlyFormattedDate(new Date()));
        this.f.setText(this.t.getName());
    }

    private void c() {
        if (!this.v && !this.w) {
            return;
        }
        int n = this.t.getCustomerMonitorDisplaySlideDuration();
        this.x = new Timer(n * 1000, new ImageUpdateTask());
        this.x.setInitialDelay(0);
        this.x.start();
    }

    public static LineDisplayWindow getInstance() {
        if (k == null) {
            k = new LineDisplayWindow();
        }
        return k;
    }

    private void d() {
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setOpaque(true);
        jPanel.setBackground(Color.WHITE);
        this.getContentPane().add(jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        jPanel2.setOpaque(true);
        jPanel2.setBackground(Color.black);
        this.e = new JLabel();
        this.e.setHorizontalAlignment(0);
        jPanel2.add((Component)this.e, "Center");
        jPanel.add((Component)jPanel2, "Center");
        this.r = new JPanel((LayoutManager)new MigLayout("fillx"));
        this.r.setOpaque(true);
        this.r.setBackground(Color.WHITE);
        this.l = new JPanel((LayoutManager)new MigLayout("fill"));
        this.l.setOpaque(false);
        this.l.setPreferredSize(PosUIManager.getSize(500, 750));
        this.z = new JPanel((LayoutManager)new MigLayout("fillx, center"));
        this.A = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3, center, ins 10 10 10 10", "[][right]", ""));
        this.A.setOpaque(true);
        this.A.setBackground(Color.WHITE);
        JLabel jLabel = new JLabel(Messages.getString("LineDisplayWindow.5"));
        this.G = new JLabel();
        JLabel jLabel2 = new JLabel(Messages.getString("LineDisplayWindow.9"));
        this.F = new JLabel();
        JLabel jLabel3 = new JLabel(Messages.getString("LineDisplayWindow.11"));
        this.D = new JLabel();
        this.M = new JLabel(POSConstants.SERVICE_CHARGE);
        this.E = new JLabel();
        JLabel jLabel4 = new JLabel(Messages.getString("LineDisplayWindow.12"));
        this.C = new JLabel();
        JLabel jLabel5 = new JLabel(Messages.getString("LineDisplayWindow.13"));
        this.B = new JLabel();
        this.A.add(jLabel);
        this.A.add((Component)this.G, "wrap");
        this.A.add(jLabel2);
        this.A.add((Component)this.F, "wrap");
        this.A.add(jLabel3);
        this.A.add((Component)this.D, "wrap");
        this.A.add(this.M);
        this.A.add((Component)this.E, "wrap");
        this.A.add(jLabel4);
        this.A.add((Component)this.C, "wrap");
        this.A.add(jLabel5);
        this.A.add((Component)this.B, "wrap");
        this.K = new JSeparator(){
            private static final long b = 1L;

            @Override
            public void paintComponent(Graphics graphics) {
                for (int i = 0; i < 640; i += 15) {
                    graphics.drawLine(i, 0, i + 10, 0);
                }
            }
        };
        this.L = new JSeparator(){
            private static final long b = 1L;

            @Override
            public void paintComponent(Graphics graphics) {
                for (int i = 0; i < 640; i += 15) {
                    graphics.drawLine(i, 0, i + 10, 0);
                }
            }
        };
        this.r.add((Component)this.z, "grow, wrap");
        this.r.add((Component)this.K, "center, grow, wrap");
        this.r.add((Component)this.l, "growx, wrap");
        this.r.add((Component)this.L, "center, grow, wrap");
        this.r.add((Component)this.A, "grow");
        int n = 48;
        int n2 = 20;
        int n3 = 32;
        this.f = new JLabel();
        Font font = this.f.getFont();
        this.f.setFont(new Font(font.getName(), 1, n));
        this.J = new JLabel();
        this.g = new JLabel(Messages.getString("LineDisplayWindow.6"));
        Font font2 = this.g.getFont();
        Font font3 = new Font(font2.getName(), 0, n2);
        this.g.setFont(font3);
        this.p = new JLabel(Messages.getString("LineDisplayWindow.7"));
        this.p.setFont(font3);
        this.q = new JLabel();
        this.q.setFont(font3);
        this.h = new JLabel();
        this.h.setFont(font3);
        this.m = new JLabel(Messages.getString("LineDisplayWindow.8"));
        this.m.setFont(font3);
        this.n = new JLabel();
        this.n.setFont(font3);
        this.o = new JLabel();
        this.o.setFont(new Font(font2.getName(), 1, n2));
        this.o.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Color.BLACK));
        this.i = new JLabel(Messages.getString("LineDisplayWindow.10"));
        this.i.setFont(new Font(font2.getName(), 1, n3));
        this.j = new JLabel();
        this.j.setFont(new Font(font2.getName(), 1, n3));
        this.s.setOpaque(true);
        this.s.setBackground(Color.WHITE);
        this.s.setTableHeader(null);
        this.s.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.s.setRowSelectionAllowed(false);
        this.s.setRowHeight(30);
        this.H = new PosScrollPane(this.s);
        this.H.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.H.getViewport().setBorder(null);
        this.H.setOpaque(true);
        this.H.getViewport().setOpaque(true);
        this.H.getViewport().setBackground(Color.WHITE);
        this.H.setBackground(Color.WHITE);
        this.H.setHorizontalScrollBarPolicy(31);
        this.H.setVerticalScrollBarPolicy(20);
        this.H.setPreferredSize(PosUIManager.getSize(180, 200));
        this.l.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.l.add((Component)this.H, "grow");
        this.y = new JLabel();
        this.z.setOpaque(true);
        this.z.setBackground(Color.WHITE);
        this.z.add((Component)this.y, "center, wrap");
        this.z.add((Component)this.f, "center, wrap");
        this.z.add((Component)this.J, "center, wrap");
        jPanel.add((Component)this.r, "East");
        this.y.setFont(font3);
        jLabel.setFont(font3);
        this.G.setFont(font3);
        jLabel2.setFont(font3);
        this.F.setFont(font3);
        jLabel3.setFont(font3);
        this.D.setFont(font3);
        this.M.setFont(font3);
        this.E.setFont(font3);
        jLabel4.setFont(font3);
        this.C.setFont(font3);
        jLabel5.setFont(font3);
        this.B.setFont(font3);
        this.J.setFont(new Font(font2.getName(), 1, n3));
        this.J.setForeground(Color.RED);
        jLabel.setForeground(Color.RED);
        this.G.setForeground(Color.RED);
        jLabel2.setForeground(Color.RED);
        this.F.setForeground(Color.RED);
        jLabel3.setForeground(Color.RED);
        this.D.setForeground(Color.RED);
        this.M.setForeground(Color.RED);
        this.E.setForeground(Color.RED);
        jLabel4.setForeground(Color.RED);
        this.C.setForeground(Color.RED);
        jLabel5.setForeground(Color.RED);
        this.B.setForeground(Color.RED);
    }

    private void e() {
        AppConfig.putInt(d, this.getWidth());
        AppConfig.putInt(c, this.getHeight());
        AppConfig.putInt(b, this.getX());
        AppConfig.putInt(a, this.getY());
    }

    private void f() {
        int n = AppConfig.getInt(d, 900);
        int n2 = AppConfig.getInt(c, 650);
        this.setSize(n, n2);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n3 = dimension.width - n >> 1;
        int n4 = dimension.height - n2 >> 1;
        n3 = AppConfig.getInt(b, n3);
        n4 = AppConfig.getInt(a, n4);
        this.setLocation(n3, n4);
    }

    @Override
    public void itemAdded(final Ticket ticket, final ITicketItem iTicketItem) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (!(iTicketItem instanceof TicketItem)) {
                    return;
                }
                TicketItem ticketItem = (TicketItem)iTicketItem;
                MenuItem menuItem = ticketItem.getMenuItem();
                ImageIcon imageIcon = menuItem.getImage();
                LineDisplayWindow.this.s.setTicket(ticket);
                LineDisplayWindow.this.s.scrollLast();
                if (LineDisplayWindow.this.u || LineDisplayWindow.this.w) {
                    if (imageIcon == null) {
                        LineDisplayWindow.this.a(null);
                    } else {
                        String string = menuItem.getImageId();
                        ImageIcon imageIcon2 = IconFactory.getIconFromImageResource(string);
                        if (imageIcon2 != null) {
                            Image image = imageIcon2.getImage();
                            LineDisplayWindow.this.a(image);
                        }
                    }
                }
                LineDisplayWindow.this.a(ticket);
            }
        }).start();
    }

    @Override
    public void ticketEditingStart(Ticket ticket) {
        this.ticketEdited(ticket);
    }

    @Override
    public void ticketEdited(final Ticket ticket) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if ((LineDisplayWindow.this.u || LineDisplayWindow.this.w) && LineDisplayWindow.this.x != null) {
                    LineDisplayWindow.this.x.stop();
                }
                if (ticket.getId() == null) {
                    LineDisplayWindow.this.J.setText(Messages.getString("LineDisplayWindow.28"));
                } else {
                    LineDisplayWindow.this.J.setText(Messages.getString("LineDisplayWindow.29") + ticket.getTokenNo());
                }
                LineDisplayWindow.this.s.setTicket(ticket);
                LineDisplayWindow.this.s.setVisible(true);
                LineDisplayWindow.this.a(ticket);
            }
        }).start();
    }

    private void a(Ticket ticket) {
        String string = CurrencyUtil.getCurrencySymbol();
        this.G.setText(string + NumberUtil.formatNumber(ticket.getSubtotalAmount()));
        this.F.setText(string + NumberUtil.formatNumber(ticket.getTaxAmount()));
        this.D.setText(string + NumberUtil.formatNumber(ticket.getDiscountAmount()));
        this.E.setText(string + NumberUtil.formatNumber(ticket.getServiceCharge()));
        this.C.setText(string + NumberUtil.formatNumber(ticket.getGratuityAmount()));
        this.B.setText(string + NumberUtil.formatNumber(ticket.getTotalAmountWithTips()));
        this.M.setVisible(ticket.getServiceCharge() > 0.0);
        this.E.setVisible(ticket.getServiceCharge() > 0.0);
    }

    @Override
    public void itemRemoved(ITicketItem iTicketItem) {
    }

    @Override
    public void ticketEditingFinish(Ticket ticket) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (LineDisplayWindow.this.x != null && !LineDisplayWindow.this.x.isRunning()) {
                    LineDisplayWindow.this.x.restart();
                }
                LineDisplayWindow.this.J.setText("");
                LineDisplayWindow.this.s.setVisible(false);
                LineDisplayWindow.this.G.setText("");
                LineDisplayWindow.this.F.setText("");
                LineDisplayWindow.this.D.setText("");
                LineDisplayWindow.this.E.setText("");
                LineDisplayWindow.this.C.setText("");
                LineDisplayWindow.this.B.setText("");
                LineDisplayWindow.this.E.setVisible(false);
                LineDisplayWindow.this.M.setVisible(false);
            }
        }).start();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        OrderView.getInstance().getOrderController().removeTicketUpdateListener(this);
        this.e();
        this.setVisible(false);
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.setVisible(false);
        if (this.x != null) {
            this.x.stop();
        }
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void openFullScreen() {
        this.setBounds(GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds());
        this.setResizable(true);
        this.setVisible(true);
    }

    private void a(Image image) {
        if (image == null) {
            this.e.setIcon(null);
            return;
        }
        this.b(image);
        this.e.revalidate();
        this.e.repaint();
    }

    private void b(Image image) {
        if (image == null) {
            return;
        }
        int n = image.getHeight(null);
        int n2 = image.getWidth(null);
        int n3 = this.e.getWidth();
        int n4 = this.e.getHeight();
        if (n2 > n) {
            int n5 = n3;
            int n6 = n3 * n / n2;
            image = image.getScaledInstance(n5, n6, 4);
        } else {
            int n7 = n4;
            int n8 = n4 * n2 / n;
            image = image.getScaledInstance(n8, n7, 4);
        }
        if (image != null) {
            this.e.setIcon(new ImageIcon(image));
        }
    }

    class LineDisplayTableModel
    extends TicketViewerTableModel {
        public LineDisplayTableModel(TicketViewerTable ticketViewerTable) {
            super(ticketViewerTable);
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        protected void calculateRows() {
            if (this.ticket == null) {
                return;
            }
            List<TicketItem> list = this.ticket.getTicketItems();
            if (list != null) {
                int n = 0;
                this.tableRows.clear();
                for (int i = list.size() - 1; i >= 0; --i) {
                    this.tableRows.put(String.valueOf(n++), list.get(i));
                }
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ITicketItem iTicketItem = (ITicketItem)this.tableRows.get(String.valueOf(n));
            if (iTicketItem == null) {
                return null;
            }
            switch (n2) {
                case 0: {
                    return iTicketItem.getNameDisplay();
                }
                case 1: {
                    return NumberUtil.getCurrencyFormat(iTicketItem.getSubTotalAmountDisplay());
                }
            }
            return null;
        }
    }

    private class ImageUpdateTask
    implements ActionListener {
        private ImageUpdateTask() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                ImageResource imageResource;
                ImageIcon imageIcon;
                SlideShowImageDAO.getInstance().getImages(LineDisplayWindow.this.I);
                if (LineDisplayWindow.this.I.getRows() == null) {
                    if (LineDisplayWindow.this.x != null) {
                        LineDisplayWindow.this.x.stop();
                    }
                    return;
                }
                if (LineDisplayWindow.this.I.getRows().isEmpty()) {
                    LineDisplayWindow.this.I.setCurrentRowIndex(0);
                    SlideShowImageDAO.getInstance().getImages(LineDisplayWindow.this.I);
                }
                if ((imageIcon = IconFactory.getIconFromImageResource((imageResource = (ImageResource)LineDisplayWindow.this.I.getRowData(0)).getId())) != null) {
                    LineDisplayWindow.this.a(imageIcon.getImage());
                }
                if (!LineDisplayWindow.this.I.hasNext()) {
                    LineDisplayWindow.this.I.setCurrentRowIndex(0);
                } else {
                    LineDisplayWindow.this.I.setCurrentRowIndex(LineDisplayWindow.this.I.getCurrentRowIndex() + 1);
                }
                LineDisplayWindow.this.x.start();
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }
    }
}

