/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.setup.pages;

import com.floreantpos.POSConstants;
import com.floreantpos.config.ui.CardConfigurationView;
import com.floreantpos.config.ui.DrawerConfigurationView;
import com.floreantpos.main.Application;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.setup.PosWizardPage;
import com.github.cjwizard.WizardSettings;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;

public class PaymentTypeConfigPage
extends PosWizardPage {
    private DrawerConfigurationView a;
    private CardConfigurationView b;
    private JCheckBox c;
    private JCheckBox d;

    public PaymentTypeConfigPage() {
        super("Configure payments");
    }

    public boolean onNext(WizardSettings wizardSettings) {
        try {
            Terminal terminal = Application.getInstance().refreshAndGetTerminal();
            terminal.addProperty("hideCashPayment", String.valueOf(!this.c.isSelected()));
            terminal.addProperty("hideCardPayment", String.valueOf(!this.d.isSelected()));
            TerminalDAO.getInstance().update(terminal);
            return true;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
            return false;
        }
    }

    @Override
    public void initialize() throws Exception {
        this.setLayout((LayoutManager)new MigLayout("hidemode 3"));
        JLabel jLabel = new JLabel("Please select payment types");
        this.add(jLabel);
        this.c = new JCheckBox("Cash");
        this.d = new JCheckBox("Credit card");
        this.b = new CardConfigurationView();
        this.b.setBorder(BorderFactory.createTitledBorder("Configure credit card payment gateway"));
        this.b.setVisible(false);
        this.b.initialize();
        this.a = new DrawerConfigurationView();
        this.a.initialize();
        this.a.setVisible(false);
        this.add(this.c, "newline");
        this.add(this.a, "newline, growx");
        this.add(this.d, "newline");
        this.add(this.b, "newline, growx");
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PaymentTypeConfigPage.this.a.setVisible(PaymentTypeConfigPage.this.c.isSelected());
            }
        });
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PaymentTypeConfigPage.this.b.setVisible(PaymentTypeConfigPage.this.d.isSelected());
            }
        });
    }

    @Override
    public void finish() throws Exception {
    }
}

