/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.ComboItem;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.base.BaseMenuItem;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.base.BaseTicketItemModifier;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.AutomatedWeightInputDialog;
import com.floreantpos.ui.dialog.ComboTicketItemSelectionDialog;
import com.floreantpos.ui.dialog.ItemDetailDialog;
import com.floreantpos.ui.dialog.ItemQtySelectionDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.GroupView;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.TicketView;
import com.floreantpos.ui.views.order.actions.CategorySelectionListener;
import com.floreantpos.ui.views.order.actions.GroupSelectionListener;
import com.floreantpos.ui.views.order.actions.ItemSelectionListener;
import com.floreantpos.ui.views.order.actions.TicketEditListener;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionDialog;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionModel;
import com.floreantpos.ui.views.order.multipart.PizzaModifierSelectionDialog;
import com.floreantpos.ui.views.voidticket.VoidInfoInputDialog;
import com.floreantpos.webservice.CloudDataUploader;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Session;

public class OrderController
implements CategorySelectionListener,
GroupSelectionListener,
ItemSelectionListener {
    protected OrderView orderView;
    List<TicketEditListener> a;

    public OrderController(OrderView orderView) {
        this.orderView = orderView;
        orderView.getCategoryView().addCategorySelectionListener(this);
        orderView.getGroupView().addGroupSelectionListener(this);
        orderView.getItemView().addItemSelectionListener(this);
        this.a = new ArrayList<TicketEditListener>();
    }

    @Override
    public void categorySelected(MenuCategory menuCategory) {
        try {
            this.orderView.showView("GROUP_VIEW");
            this.orderView.getGroupView().setMenuCategory(menuCategory);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    @Override
    public void groupSelected(MenuGroup menuGroup) {
        try {
            this.orderView.showView("ITEM_VIEW");
            this.orderView.getItemView().setMenuGroup(menuGroup);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    @Override
    public void itemSelected(MenuItem menuItem) {
        try (Session session = MenuItemDAO.getInstance().createNewSession();){
            Iterator<TicketItem> iterator;
            Serializable serializable;
            Serializable serializable2;
            menuItem = MenuItemDAO.getInstance().get(menuItem.getId(), session);
            if (!this.a(menuItem, 1.0)) {
                return;
            }
            if (menuItem.isVariant().booleanValue()) {
                serializable2 = MenuItemDAO.getInstance().get(menuItem.getParentMenuItemId(), session);
                menuItem.setParentMenuItem((MenuItem)serializable2);
            } else if (menuItem.isHasVariant().booleanValue()) {
                this.orderView.getItemView().rendererVariants(menuItem);
                return;
            }
            serializable2 = this.orderView.getTicketView();
            Ticket ticket = this.orderView.getCurrentTicket();
            double d = 1.0;
            IUnit iUnit = null;
            double d2 = 0.0;
            DataProvider.get().refreshCurrentTerminal();
            Terminal terminal = DataProvider.get().getCurrentTerminal();
            if (terminal.isEnableItemDetailShowing() || menuItem.isFractionalUnit().booleanValue() || menuItem.isAllowUnitSelection() || menuItem.isEditablePrice().booleanValue()) {
                if (menuItem.isFractionalUnit().booleanValue() && TerminalConfig.getScaleActivationValue().equals("cas10")) {
                    d = AutomatedWeightInputDialog.takeDoubleInput(menuItem.getName(), 1.0);
                } else {
                    serializable = new ItemDetailDialog(ticket, menuItem);
                    ((Window)serializable).pack();
                    ((OkCancelOptionDialog)serializable).setOkButtonText(POSConstants.ADD_BUTTON_TEXT);
                    ((POSDialog)serializable).open();
                    if (((POSDialog)serializable).isCanceled()) {
                        return;
                    }
                    d = ((ItemDetailDialog)serializable).getWeightOrQuantity();
                    if (menuItem.isAllowUnitSelection()) {
                        iUnit = ((ItemDetailDialog)serializable).getSelectedUnit();
                    }
                    if (d == 0.0) {
                        POSMessageDialog.showError(Messages.getString("OrderController.3"));
                        return;
                    }
                    if (menuItem.isEditablePrice().booleanValue()) {
                        d2 = ((ItemDetailDialog)serializable).getPrice();
                        if (d2 <= -1.0) {
                            return;
                        }
                        menuItem.setPrice(d2 / d);
                    }
                }
            }
            serializable = menuItem.convertToTicketItem(ticket, d, iUnit);
            String string = null;
            boolean bl = false;
            double d3 = 0.0;
            if (this.orderView.isReturnMode()) {
                iterator = new VoidInfoInputDialog((TicketItem)serializable);
                ((Window)((Object)iterator)).setSize(PosUIManager.getSize(400, 600));
                ((POSDialog)((Object)iterator)).open();
                if (((POSDialog)((Object)iterator)).isCanceled()) {
                    return;
                }
                string = ((VoidInfoInputDialog)((Object)iterator)).getVoidReason();
                bl = ((VoidInfoInputDialog)((Object)iterator)).isItemWasted();
                d3 = ((VoidInfoInputDialog)((Object)iterator)).getVoidQuantity();
            }
            if (menuItem.isVariant().booleanValue()) {
                menuItem = menuItem.getParentMenuItem();
            }
            if (menuItem.isComboItem().booleanValue()) {
                if (this.orderView.isReturnMode() && d3 > 1.0) {
                    ((BaseTicketItem)serializable).setQuantity(d3);
                }
                if (!this.a(menuItem, (TicketItem)serializable)) {
                    return;
                }
                if (this.orderView.isReturnMode() && d3 > 1.0) {
                    for (TicketItem object2 : ((TicketItem)serializable).getComboItems()) {
                        object2.setQuantity(object2.getQuantity() * d3);
                    }
                }
            }
            if (this.orderView.isReturnMode()) {
                ((TicketItem)serializable).markVoided(string, bl, d3, true);
            }
            ((BaseTicketItem)serializable).setTicket(ticket);
            iterator = this.orderView.getSelectedSeatNumber();
            if (iterator instanceof Integer) {
                ((BaseTicketItem)serializable).setSeatNumber((Integer)((Object)iterator));
            } else if (iterator instanceof TicketItemSeat) {
                TicketItemSeat ticketItemSeat = (TicketItemSeat)((Object)iterator);
                ((BaseTicketItem)serializable).setSeat(ticketItemSeat);
                ((BaseTicketItem)serializable).setSeatNumber(ticketItemSeat.getSeatNumber());
            }
            if (menuItem.isPizzaType().booleanValue()) {
                PizzaModifierSelectionDialog pizzaModifierSelectionDialog = new PizzaModifierSelectionDialog(ticket, (TicketItem)serializable, menuItem, false);
                pizzaModifierSelectionDialog.setResizable(false);
                if (TerminalConfig.isKioskMode()) {
                    pizzaModifierSelectionDialog.openUndecoratedFullScreen();
                } else {
                    pizzaModifierSelectionDialog.openFullScreen();
                }
                if (pizzaModifierSelectionDialog.isCanceled()) {
                    return;
                }
                List<TicketItem> list = pizzaModifierSelectionDialog.getPizzzItemList();
                for (TicketItem ticketItem : list) {
                    ((TicketView)serializable2).addTicketItem(ticketItem);
                }
                this.fireTicketItemUpdated(ticket, (TicketItem)serializable);
            } else if (menuItem.hasMandatoryModifiers()) {
                ModifierSelectionModel modifierSelectionModel = new ModifierSelectionModel(ticket, (TicketItem)serializable, menuItem);
                ModifierSelectionDialog modifierSelectionDialog = new ModifierSelectionDialog(modifierSelectionModel);
                modifierSelectionDialog.open();
                if (!modifierSelectionDialog.isCanceled()) {
                    ((TicketView)serializable2).addTicketItem((TicketItem)serializable);
                    this.fireTicketItemUpdated(ticket, (TicketItem)serializable);
                }
            } else {
                ((TicketView)serializable2).addTicketItem((TicketItem)serializable);
                this.fireTicketItemUpdated(ticket, (TicketItem)serializable);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private boolean a(MenuItem menuItem, double d) {
        List<TicketItem> list;
        if (menuItem == null || !menuItem.isDisableWhenStockAmountIsZero().booleanValue() || menuItem.isHasVariant().booleanValue()) {
            return true;
        }
        Ticket ticket = this.orderView.getCurrentTicket();
        double d2 = 0.0;
        if (ticket != null && (list = ticket.getTicketItems()) != null) {
            for (TicketItem ticketItem : list) {
                if (!ticketItem.getMenuItemId().equals(menuItem.getId())) continue;
                d2 += ticketItem.getQuantity() - ticketItem.getInventoryAdjustQty();
            }
        }
        d2 += d;
        return !(menuItem.getAvailableUnit() < d2) || POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), Messages.getString("OrderController.6"), Messages.getString("CONFIRM"), Messages.getString("OrderController.8"), Messages.getString("OrderController.9")) == 0;
    }

    public void doEditTicketItemQuantity(Object object) {
        TicketItem ticketItem = (TicketItem)object;
        MenuItem menuItem = ticketItem.getMenuItem();
        IUnit iUnit = null;
        double d = 0.0;
        if (ticketItem.isFractionalUnit().booleanValue() || ticketItem.isAllowUnitSelection()) {
            ItemQtySelectionDialog itemQtySelectionDialog = ItemQtySelectionDialog.getQtyAndUnit(menuItem, DataProvider.get().getUnitByCode(ticketItem.getUnitName()), Messages.getString("OrderController.2"), ticketItem.getQuantity());
            itemQtySelectionDialog.pack();
            itemQtySelectionDialog.open();
            d = itemQtySelectionDialog.isCanceled() ? -1.0 : itemQtySelectionDialog.getValue();
            iUnit = itemQtySelectionDialog.getSelectedUnit();
        } else {
            d = NumberSelectionDialog2.takeIntInput(Messages.getString("OrderController.10"), Math.abs(ticketItem.getQuantity()));
        }
        if (d <= 0.0) {
            return;
        }
        if (d > ticketItem.getQuantity() && !this.a(menuItem, d - ticketItem.getQuantity())) {
            return;
        }
        if (this.orderView.isReturnMode()) {
            ticketItem.markVoided(Messages.getString("OrderController.12"), false, ticketItem.getQuantity(), true);
        } else {
            if (menuItem != null && menuItem.isComboItem().booleanValue()) {
                this.updateComboTicketItemQuantity(ticketItem, d);
            }
            ticketItem.setQuantity(d);
        }
        this.fireTicketItemUpdated(ticketItem.getTicket(), ticketItem);
    }

    public void updateComboTicketItemQuantity(TicketItem ticketItem, double d) {
        List<TicketItem> list = ticketItem.getComboItems();
        double d2 = ticketItem.getQuantity();
        double d3 = d - d2;
        if (list != null) {
            for (TicketItem ticketItem2 : list) {
                ticketItem2.setQuantity(ticketItem2.getQuantity() + d3 * ticketItem2.getQuantity() / d2);
            }
        }
    }

    private boolean a(MenuItem menuItem, TicketItem ticketItem) {
        ComboTicketItem comboTicketItem = (ComboTicketItem)ticketItem;
        Ticket ticket = this.orderView.getCurrentTicket();
        if (menuItem.getComboItems() != null && !menuItem.getComboItems().isEmpty()) {
            for (ComboItem comboItem : menuItem.getComboItems()) {
                POSDialog pOSDialog;
                MenuItemDAO menuItemDAO;
                MenuItem menuItem2;
                if (comboItem.getQuantity() == 0.0 || comboItem.getItemId() == null || (menuItem2 = (menuItemDAO = MenuItemDAO.getInstance()).get(comboItem.getItemId())) == null) continue;
                menuItemDAO.initialize(menuItem2);
                if (menuItem2.isVariant().booleanValue()) {
                    menuItemDAO.initialize(menuItem2.getParentMenuItem());
                }
                TicketItem ticketItem2 = menuItem2.convertToTicketItem(ticket, comboItem.getQuantity());
                ticketItem2.setMenuItem(menuItem2);
                if (menuItem2.hasMandatoryModifiers()) {
                    pOSDialog = new ModifierSelectionDialog(new ModifierSelectionModel(ticket, ticketItem2, menuItem2));
                    pOSDialog.open();
                    if (pOSDialog.isCanceled()) {
                        return false;
                    }
                } else if (menuItem.isPizzaType().booleanValue()) {
                    pOSDialog = new PizzaModifierSelectionDialog(ticket, ticketItem2, menuItem2, false);
                    pOSDialog.openFullScreen();
                    if (pOSDialog.isCanceled()) {
                        return false;
                    }
                }
                ticketItem2.setMenuItemId(menuItem2.getId());
                ticketItem2.setName(menuItem2.getName());
                ticketItem2.setQuantity(comboTicketItem.getQuantity() * comboItem.getQuantity());
                ticketItem2.setParentTicketItem(comboTicketItem);
                ticketItem2.setTicket(null);
                ticketItem2.setGroupId(null);
                comboTicketItem.addTocomboItems(ticketItem2);
            }
        }
        if (menuItem.getComboGroups() != null && !menuItem.getComboGroups().isEmpty()) {
            ComboTicketItemSelectionDialog comboTicketItemSelectionDialog = new ComboTicketItemSelectionDialog(menuItem, comboTicketItem);
            comboTicketItemSelectionDialog.setTitle(Messages.getString("OrderController.13"));
            comboTicketItemSelectionDialog.setSize(PosUIManager.getSize(1024, 700));
            comboTicketItemSelectionDialog.open();
            if (comboTicketItemSelectionDialog.isCanceled()) {
                return false;
            }
            if (menuItem.isModifiablePriceForComboItem()) {
                comboTicketItem.doCalculateComboItemPrice();
            }
        }
        return true;
    }

    public void itemSelectionFinished(MenuGroup menuGroup) {
        GroupView groupView;
        MenuCategory menuCategory = menuGroup.getParent();
        if (!menuCategory.equals((groupView = this.orderView.getGroupView()).getMenuCategory())) {
            groupView.setMenuCategory(menuCategory);
        }
        this.orderView.showView("GROUP_VIEW");
    }

    public static void openModifierDialog(ITicketItem iTicketItem) {
        try {
            ArrayList arrayList;
            List<TicketItemModifier> list;
            Comparable comparable;
            Ticket ticket = OrderView.getInstance().getCurrentTicket();
            TicketItem ticketItem = null;
            if (iTicketItem instanceof TicketItem) {
                ticketItem = (TicketItem)iTicketItem;
            } else if (iTicketItem instanceof TicketItemModifier && (ticketItem = ((BaseTicketItemModifier)(comparable = (TicketItemModifier)iTicketItem)).getTicketItem()) == null) {
                ticketItem = ((BaseTicketItemModifier)comparable).getTicketItem();
            }
            comparable = ticketItem.getMenuItem();
            MenuItemDAO.getInstance().initialize((MenuItem)comparable);
            if (((BaseMenuItem)comparable).isVariant().booleanValue()) {
                comparable = ((MenuItem)comparable).getParentMenuItem();
                MenuItemDAO.getInstance().initialize((MenuItem)comparable);
            }
            if ((list = ticketItem.getTicketItemModifiers()) == null) {
                list = new ArrayList<TicketItemModifier>();
            }
            TicketItem ticketItem2 = ticketItem.clone();
            boolean bl = ticketItem.isPizzaType();
            if (bl) {
                arrayList = new PizzaModifierSelectionDialog(ticket, ticketItem2, (MenuItem)comparable, true);
                ((POSDialog)((Object)arrayList)).openFullScreen();
                if (((POSDialog)((Object)arrayList)).isCanceled()) {
                    return;
                }
                TicketItemModifier ticketItemModifier = ticketItem2.getSizeModifier();
                ticketItemModifier.setTicketItem(ticketItem);
                ticketItem.setSizeModifier(ticketItemModifier);
                ticketItem.setQuantity(ticketItem2.getQuantity());
                ticketItem.setUnitPrice(ticketItem2.getUnitPrice());
            } else {
                arrayList = new ModifierSelectionDialog(new ModifierSelectionModel(ticket, ticketItem2, (MenuItem)comparable));
                ((POSDialog)((Object)arrayList)).open();
                if (((POSDialog)((Object)arrayList)).isCanceled()) {
                    return;
                }
            }
            arrayList = ticketItem2.getTicketItemModifiers();
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            list.clear();
            for (TicketItemModifier ticketItemModifier : arrayList) {
                ticketItemModifier.setTicketItem(ticketItem);
                ticketItem.addToticketItemModifiers(ticketItemModifier);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
        OrderView.getInstance().getTicketView().getTicketViewerTable().updateView();
    }

    public static synchronized void saveOrder(Ticket ticket) {
        if (ticket == null) {
            return;
        }
        TicketDAO.getInstance().saveOrUpdate(ticket);
    }

    public static synchronized void closeOrder(Ticket ticket) {
        ticket.setClosed(true);
        ticket.setClosingDate(StoreDAO.getServerTimestamp());
        TicketDAO.getInstance().saveOrUpdate(ticket);
        CloudDataUploader.get().uploadToCloudIfOnlineOrder(ticket);
    }

    public void addTicketUpdateListener(TicketEditListener ticketEditListener) {
        this.a.add(ticketEditListener);
    }

    public void removeTicketUpdateListener(TicketEditListener ticketEditListener) {
        this.a.remove(ticketEditListener);
    }

    public void fireTicketItemUpdated(Ticket ticket, TicketItem ticketItem) {
        for (TicketEditListener ticketEditListener : this.a) {
            ticketEditListener.itemAdded(ticket, ticketItem);
        }
    }

    public void fireTicketEditingStart(Ticket ticket) {
        for (TicketEditListener ticketEditListener : this.a) {
            ticketEditListener.ticketEditingStart(ticket);
        }
    }

    public void fireTicketEdited(Ticket ticket) {
        for (TicketEditListener ticketEditListener : this.a) {
            ticketEditListener.ticketEdited(ticket);
        }
    }

    public void fireTicketEditingFinish(Ticket ticket) {
        for (TicketEditListener ticketEditListener : this.a) {
            ticketEditListener.ticketEditingFinish(ticket);
        }
    }
}

