/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.config.CardConfig;
import com.floreantpos.extension.PaymentGatewayPlugin;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.payment.AuthorizationCodeDialog;
import com.floreantpos.ui.views.payment.BusyDialog;
import com.floreantpos.ui.views.payment.CardInputListener;
import com.floreantpos.ui.views.payment.CardInputProcessor;
import com.floreantpos.ui.views.payment.CardProcessor;
import com.floreantpos.ui.views.payment.ManualCardEntryDialog;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import com.floreantpos.ui.views.payment.SwipeCardDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Window;
import javax.swing.SwingWorker;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;

public class CreditCardInputListener
implements CardInputListener {
    private SettleTicketProcessor a;

    public CreditCardInputListener(SettleTicketProcessor settleTicketProcessor) {
        this.a = settleTicketProcessor;
    }

    @Override
    public void cardInputted(CardInputProcessor cardInputProcessor, PaymentType paymentType, String string) {
        Window window = POSUtil.getFocusedWindow();
        try {
            switch (paymentType) {
                case CREDIT_CARD: 
                case DEBIT_CARD: {
                    this.a(cardInputProcessor, paymentType, string);
                }
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(window, this.a.getRefreshableView());
        }
        catch (PosException posException) {
            POSMessageDialog.showError(window, posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(window, Messages.getString("SettleTicketProcessor.1"), exception);
        }
    }

    private void a(CardInputProcessor cardInputProcessor, PaymentType paymentType, String string) throws Exception {
        PosTransaction posTransaction = paymentType.createTransaction();
        posTransaction.setTicket(this.a.getTicket());
        PaymentGatewayPlugin paymentGatewayPlugin = CardConfig.getPaymentGateway();
        if (paymentGatewayPlugin == null) {
            throw new PosException(Messages.getString("SettleTicketProcessor.2"));
        }
        if (cardInputProcessor instanceof SwipeCardDialog) {
            SwipeCardDialog swipeCardDialog = (SwipeCardDialog)cardInputProcessor;
            String string2 = swipeCardDialog.getCardString();
            if (StringUtils.isEmpty((String)string2) || string2.length() < 16) {
                throw new PosException(Messages.getString("SettleTicketDialog.16"));
            }
            this.a(posTransaction, paymentGatewayPlugin, string2);
        } else if (cardInputProcessor instanceof ManualCardEntryDialog) {
            this.a(cardInputProcessor, posTransaction, paymentGatewayPlugin);
        } else if (cardInputProcessor instanceof AuthorizationCodeDialog) {
            this.b(cardInputProcessor, paymentType, string);
        }
    }

    private void a(final PosTransaction posTransaction, final PaymentGatewayPlugin paymentGatewayPlugin, final String string) {
        final BusyDialog busyDialog = new BusyDialog();
        SwingWorker<Double, Void> swingWorker = new SwingWorker<Double, Void>(){

            @Override
            protected Double doInBackground() throws Exception {
                Ticket ticket = CreditCardInputListener.this.a.getTicket();
                Double d = ticket.getDueAmount();
                CardProcessor cardProcessor = paymentGatewayPlugin.getProcessor();
                posTransaction.setCardTrack(string);
                posTransaction.setCaptured(false);
                posTransaction.setCardMerchantGateway(paymentGatewayPlugin.getProductName());
                posTransaction.setCardReader(CardReader.SWIPE.name());
                CreditCardInputListener.this.a.setTransactionAmounts(posTransaction);
                if (ticket.getOrderType().isPreAuthCreditCard().booleanValue()) {
                    cardProcessor.preAuth(posTransaction);
                } else {
                    cardProcessor.chargeAmount(posTransaction);
                }
                CreditCardInputListener.this.a.settleTicket(posTransaction, null, true, false);
                return d;
            }

            @Override
            protected void done() {
                try {
                    Double d = (Double)this.get();
                    busyDialog.dispose();
                    CreditCardInputListener.this.a.doAfterSettleTask(posTransaction, d, true);
                }
                catch (Exception exception) {
                    Throwable throwable = exception.getCause();
                    if (throwable instanceof PosException) {
                        POSMessageDialog.showError(throwable.getMessage());
                    } else if (throwable instanceof StaleStateException) {
                        POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), CreditCardInputListener.this.a.getRefreshableView());
                    } else {
                        POSMessageDialog.showError(throwable.getMessage(), throwable);
                    }
                }
                finally {
                    busyDialog.dispose();
                }
            }
        };
        swingWorker.execute();
        busyDialog.setVisible(true);
    }

    private void a(final CardInputProcessor cardInputProcessor, final PosTransaction posTransaction, final PaymentGatewayPlugin paymentGatewayPlugin) throws Exception {
        final BusyDialog busyDialog = new BusyDialog();
        SwingWorker<Double, Void> swingWorker = new SwingWorker<Double, Void>(){

            @Override
            protected Double doInBackground() throws Exception {
                Double d = CreditCardInputListener.this.a.getTicket().getDueAmount();
                CardProcessor cardProcessor = paymentGatewayPlugin.getProcessor();
                ManualCardEntryDialog manualCardEntryDialog = (ManualCardEntryDialog)cardInputProcessor;
                posTransaction.setCaptured(false);
                posTransaction.setCardMerchantGateway(paymentGatewayPlugin.getProductName());
                posTransaction.setCardReader(CardReader.MANUAL.name());
                posTransaction.setCardHolderName(manualCardEntryDialog.getCardHolderName());
                posTransaction.setCardNumber(manualCardEntryDialog.getCardNo());
                posTransaction.setCardExpMonth(manualCardEntryDialog.getExpMonth());
                posTransaction.setCardExpYear(manualCardEntryDialog.getExpYear());
                posTransaction.setCardCVV(manualCardEntryDialog.getCardCVV());
                CreditCardInputListener.this.a.setTransactionAmounts(posTransaction);
                if (CreditCardInputListener.this.a.getTicket().getOrderType().isPreAuthCreditCard().booleanValue()) {
                    cardProcessor.preAuth(posTransaction);
                } else {
                    cardProcessor.chargeAmount(posTransaction);
                }
                CreditCardInputListener.this.a.settleTicket(posTransaction, null, true, false);
                return d;
            }

            @Override
            protected void done() {
                try {
                    Double d = (Double)this.get();
                    busyDialog.dispose();
                    CreditCardInputListener.this.a.doAfterSettleTask(posTransaction, d, true);
                }
                catch (Exception exception) {
                    busyDialog.dispose();
                    Throwable throwable = exception.getCause();
                    if (throwable instanceof PosException) {
                        POSMessageDialog.showError(throwable.getMessage());
                    } else if (throwable instanceof StaleStateException) {
                        POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), CreditCardInputListener.this.a.getRefreshableView());
                    } else {
                        POSMessageDialog.showError(throwable.getMessage(), throwable);
                    }
                }
                finally {
                    busyDialog.dispose();
                }
            }
        };
        swingWorker.execute();
        busyDialog.setVisible(true);
    }

    private void b(final CardInputProcessor cardInputProcessor, final PaymentType paymentType, final String string) throws Exception {
        final BusyDialog busyDialog = new BusyDialog();
        SwingWorker<Double, Void> swingWorker = new SwingWorker<Double, Void>(){
            PosTransaction a = null;

            @Override
            protected Double doInBackground() throws Exception {
                Double d = CreditCardInputListener.this.a.getTicket().getDueAmount();
                this.a = paymentType.createTransaction();
                this.a.setTicket(CreditCardInputListener.this.a.getTicket());
                AuthorizationCodeDialog authorizationCodeDialog = (AuthorizationCodeDialog)cardInputProcessor;
                String string2 = authorizationCodeDialog.getAuthorizationCode();
                if (StringUtils.isEmpty((String)string2)) {
                    throw new PosException(Messages.getString("SettleTicketDialog.17"));
                }
                this.a.setCardType(string);
                this.a.setAuthorizable(false);
                this.a.setCardMerchantGateway(CardReader.EXTERNAL_TERMINAL.name());
                this.a.setCardReader(CardReader.EXTERNAL_TERMINAL.name());
                this.a.setCardAuthCode(string2);
                CreditCardInputListener.this.a.setTransactionAmounts(this.a);
                CreditCardInputListener.this.a.settleTicket(this.a, null, true, false);
                return d;
            }

            @Override
            protected void done() {
                try {
                    Double d = (Double)this.get();
                    busyDialog.dispose();
                    CreditCardInputListener.this.a.doAfterSettleTask(this.a, d, true);
                }
                catch (Exception exception) {
                    Throwable throwable = exception.getCause();
                    if (throwable instanceof PosException) {
                        POSMessageDialog.showError(throwable.getMessage());
                    } else if (throwable instanceof StaleStateException) {
                        POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), CreditCardInputListener.this.a.getRefreshableView());
                    } else {
                        POSMessageDialog.showError(throwable.getMessage(), throwable);
                    }
                }
                finally {
                    busyDialog.dispose();
                }
            }
        };
        swingWorker.execute();
        busyDialog.setVisible(true);
    }
}

