/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.model.Currency;
import com.floreantpos.model.util.DataProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class CurrencyUtil {
    public static Currency getMainCurrency() {
        return DataProvider.get().getMainCurrency();
    }

    public static List<Currency> getAllCurrency() {
        return DataProvider.get().getCurrencies();
    }

    public static String getCurrencyName() {
        return CurrencyUtil.getMainCurrency().getName();
    }

    public static String getCurrencySymbol() {
        Currency currency = CurrencyUtil.getMainCurrency();
        if (currency == null) {
            return "";
        }
        return currency.getSymbol();
    }

    public static String getCurrencySymbolWithBracket() {
        return " (" + CurrencyUtil.getCurrencySymbol() + ")";
    }

    public static List<Currency> getAllPreFillCurrencies() {
        Set set = com.ibm.icu.util.Currency.getAvailableCurrencies();
        ArrayList<Currency> arrayList = new ArrayList<Currency>();
        for (com.ibm.icu.util.Currency currency : set) {
            Currency currency2 = new Currency();
            currency2.setName(currency.getDisplayName());
            currency2.setCode(currency.getCurrencyCode());
            String string = currency.getSymbol();
            currency2.setSymbol(string);
            arrayList.add(currency2);
        }
        Collections.sort(arrayList, new Comparator<Currency>(){

            @Override
            public int compare(Currency currency, Currency currency2) {
                return currency.getName().compareTo(currency2.getName());
            }
        });
        return arrayList;
    }
}

