/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.actions.PosAction;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ShopSeat;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.base.BaseTicketItemSeat;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.floorplan.SeatSelectionDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.TicketView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SeatSelectionAction
extends PosAction {
    public SeatSelectionAction() {
        super(Messages.getString("OrderView.3"));
    }

    public void setSource(PosButton posButton) {
    }

    @Override
    public void execute() {
        this.doAddSeatNumber();
    }

    protected void doAddSeatNumber() {
        Ticket ticket = OrderView.getInstance().getCurrentTicket();
        SeatSelectionDialog seatSelectionDialog = new SeatSelectionDialog(ticket);
        seatSelectionDialog.setTitle(Messages.getString("SeatSelectionAction.2"));
        seatSelectionDialog.setSize(PosUIManager.getSize(900, 650));
        seatSelectionDialog.open();
        if (seatSelectionDialog.isCanceled()) {
            return;
        }
        ShopSeat shopSeat = seatSelectionDialog.getSeat();
        this.a(shopSeat, ticket, true);
    }

    private void a(ShopSeat shopSeat, Ticket ticket, boolean bl) {
        Serializable serializable;
        TicketItem ticketItem = this.a(ticket);
        boolean bl2 = true;
        if (ticketItem == null) {
            bl2 = false;
            ticketItem = new TicketItem();
        }
        if (shopSeat == null) {
            ticketItem.setName(Messages.getString("SeatSelectionAction.3"));
            ticketItem.setSeat(null);
        } else {
            ticketItem.setName(shopSeat.getSeatNumberWithTableName());
            serializable = this.a(shopSeat.getId(), ticket);
            if (serializable == null) {
                serializable = shopSeat.convertTicketItemSeat();
            }
            Customer customer = shopSeat.getMember();
            if (((BaseTicketItemSeat)serializable).getMemberId() == null && customer != null) {
                ((TicketItemSeat)serializable).setMember(customer);
            }
            ticketItem.setSeat((TicketItemSeat)serializable);
        }
        ticketItem.setShouldPrintToKitchen(true);
        ticketItem.setTreatAsSeat(true);
        ticketItem.setTicket(ticket);
        serializable = OrderView.getInstance().getTicketView();
        if (!bl2) {
            ((TicketView)serializable).addTicketItem(ticketItem);
        } else {
            ((TicketView)serializable).updateView();
        }
    }

    private TicketItemSeat a(String string, Ticket ticket) {
        TicketItemSeat ticketItemSeat = (TicketItemSeat)this.getLastSeat(ticket);
        if (ticketItemSeat != null && ticketItemSeat.getId() != null && ticketItemSeat.getId().equals(string)) {
            return ticketItemSeat;
        }
        return null;
    }

    private TicketItem a(Ticket ticket) {
        TicketItem ticketItem;
        List<TicketItem> list = ticket.getTicketItems();
        if (list != null && !list.isEmpty() && (ticketItem = list.get(list.size() - 1)).isTreatAsSeat().booleanValue()) {
            return ticketItem;
        }
        return null;
    }

    public Object getLastSeat(Ticket ticket) {
        TicketItem ticketItem;
        TicketItemSeat ticketItemSeat = null;
        List<TicketItem> list = ticket.getTicketItems();
        if (list != null && !list.isEmpty() && (ticketItem = list.get(list.size() - 1)).getSeat() != null) {
            ticketItemSeat = ticketItem.getSeat();
        }
        return ticketItemSeat;
    }

    public boolean updateSeatNumber(TicketItem ticketItem) {
        SeatSelectionDialog seatSelectionDialog = new SeatSelectionDialog(ticketItem.getTicket(), ticketItem.getSeat());
        seatSelectionDialog.setTitle(Messages.getString("SeatSelectionAction.5"));
        seatSelectionDialog.setSize(PosUIManager.getSize(900, 650));
        seatSelectionDialog.open();
        if (seatSelectionDialog.isCanceled()) {
            return false;
        }
        ShopSeat shopSeat = seatSelectionDialog.getSeat();
        if (shopSeat == null) {
            ticketItem.setName(Messages.getString("SeatSelectionAction.6"));
            ticketItem.setSeat(null);
        } else {
            ticketItem.setName(shopSeat.getSeatNumberWithTableName());
            TicketItemSeat ticketItemSeat = this.a(shopSeat.getId(), ticketItem.getTicket());
            if (ticketItemSeat == null) {
                ticketItemSeat = shopSeat.convertTicketItemSeat();
            }
            ticketItemSeat.setMember(shopSeat.getMember());
            ticketItem.setSeat(ticketItemSeat);
        }
        this.a(ticketItem);
        return true;
    }

    protected List<TicketItemSeat> getSeatNumbers(Ticket ticket) {
        ArrayList<TicketItemSeat> arrayList = new ArrayList<TicketItemSeat>();
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            if (!ticketItem.isTreatAsSeat().booleanValue() || arrayList.contains(ticketItem.getSeat())) continue;
            arrayList.add(ticketItem.getSeat());
        }
        return arrayList;
    }

    private void a(TicketItem ticketItem) {
        boolean bl = false;
        for (TicketItem ticketItem2 : ticketItem.getTicket().getTicketItems()) {
            if (ticketItem2 == ticketItem) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            if (ticketItem2.isTreatAsSeat().booleanValue()) break;
            ticketItem2.setSeat(ticketItem.getSeat());
        }
    }

    public Object getSelectedSeatNumber() {
        Ticket ticket = OrderView.getInstance().getCurrentTicket();
        List<TicketItem> list = ticket.getTicketItems();
        if (list != null && !list.isEmpty()) {
            TicketItem ticketItem = list.get(list.size() - 1);
            return ticketItem.getSeat();
        }
        return null;
    }
}

