/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.ForHereToGoAction;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.ui.views.payment.SettleTicketDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;

public class SettleTicketAction
extends PosAction {
    private Ticket a;
    private User b;

    public SettleTicketAction(Ticket ticket) {
        this.a = ticket;
        this.setRequiredPermission(UserPermission.SETTLE_TICKET);
    }

    public SettleTicketAction(Ticket ticket, User user) {
        this.a = ticket;
        this.b = user;
        this.setRequiredPermission(UserPermission.SETTLE_TICKET);
    }

    public SettleTicketAction(DataChangeListener dataChangeListener) {
        super(POSConstants.SETTLE_TICKET_BUTTON_TEXT, dataChangeListener);
        this.setRequiredPermission(UserPermission.SETTLE_TICKET);
    }

    @Override
    public void execute() {
        try {
            if (this.listener != null) {
                Object object = this.getSelectedObject();
                if (object == null) {
                    return;
                }
                if (object instanceof Ticket) {
                    this.a = (Ticket)object;
                }
            }
            if (!this.hasPermissionToAccessTicket(this.a)) {
                return;
            }
            this.performSettle();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public boolean performSettle() {
        Object object;
        Object object2;
        OrderType orderType;
        User user = this.b;
        if (user == null) {
            user = Application.getCurrentUser();
        }
        if ((orderType = this.a.getOrderType()) == null) {
            throw new PosException(Messages.getString("OrderTypeDAO.0"));
        }
        if (this.a.isVoided().booleanValue()) {
            POSMessageDialog.showMessage(Application.getPosWindow(), POSConstants.TICKET_IS_VOIDED);
            return false;
        }
        if (!POSUtil.checkDrawerAssignment(Application.getInstance().getTerminal(), user)) {
            return false;
        }
        TicketDAO.getInstance().loadFullTicket(this.a);
        if (this.a.isClosed().booleanValue()) {
            this.a.setClosed(false);
            this.a.setReOpened(true);
        }
        if (orderType.getHasForHereAndToGo().booleanValue() && (object2 = this.a.getSubOrderType()) == null) {
            object = new ForHereToGoAction(this.a);
            ((ForHereToGoAction)object).execute();
            if (!((ForHereToGoAction)object).isPerformed()) {
                return false;
            }
        }
        object2 = new SettleTicketDialog(this.a, user);
        ((Window)object2).setSize(Application.getPosWindow().getSize());
        ((JDialog)object2).setDefaultCloseOperation(2);
        if (orderType.isBarTab().booleanValue()) {
            this.a((SettleTicketDialog)object2);
        }
        ((POSDialog)object2).openUndecoratedFullScreen();
        object = RootView.getInstance().getCurrentView();
        if (object != null) {
            object.refresh();
        }
        if (((POSDialog)object2).isCanceled()) {
            return false;
        }
        if (this.listener != null) {
            this.listener.dataChanged(this.a);
        } else {
            this.a(this.a);
        }
        return true;
    }

    private void a(Ticket ticket) {
        try {
            OrderView.getInstance().getOrderController().fireTicketEditingFinish(ticket);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private void a(final SettleTicketDialog settleTicketDialog) {
        PosTransaction posTransaction = this.a.getBartabTransaction();
        if (posTransaction != null && !posTransaction.isCaptured().booleanValue() && !posTransaction.isVoided().booleanValue()) {
            settleTicketDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    try {
                        settleTicketDialog.settleBartab();
                    }
                    catch (Exception exception) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
                        settleTicketDialog.setCanceled(true);
                        settleTicketDialog.dispose();
                    }
                }
            });
        }
    }

    @Override
    protected User getCurrentUser() {
        if (this.b == null) {
            return Application.getCurrentUser();
        }
        return this.b;
    }

    public Ticket getTicket() {
        return this.a;
    }
}

