/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.report.ServerProductivityReportView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class ServerProductivityReportAction
extends AbstractAction {
    public ServerProductivityReportAction() {
        super(POSConstants.SERVER_PRODUCTIVITY_REPORT);
    }

    public ServerProductivityReportAction(String string) {
        super(string);
    }

    public ServerProductivityReportAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            ServerProductivityReportView serverProductivityReportView = null;
            int n = jTabbedPane.indexOfTab(POSConstants.SERVER_PRODUCTIVITY_REPORT);
            if (n == -1) {
                serverProductivityReportView = new ServerProductivityReportView();
                jTabbedPane.addTab(POSConstants.SERVER_PRODUCTIVITY_REPORT, serverProductivityReportView);
            } else {
                serverProductivityReportView = (ServerProductivityReportView)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(serverProductivityReportView);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

