/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.bo.ui.explorer.OutletEntryForm;
import com.floreantpos.config.AppProperties;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXTable;

public class OutletExplorer
extends TransparentPanel {
    private static final long a = 1L;
    private JXTable b;
    private BeanTableModel<Outlet> c = new BeanTableModel(Outlet.class);
    private JTextField d;
    private JComboBox e;

    public OutletExplorer() {
        this.c.addColumn(Messages.getString("OutletExplorer.0"), "id");
        this.c.addColumn(Messages.getString("OutletExplorer.2"), "name");
        this.c.addColumn(Messages.getString("OutletExplorer.4"), "description");
        this.c.addColumn(Messages.getString("OutletExplorer.1"), "address");
        this.c.addRows(OutletDAO.getInstance().findAll());
        this.b = new JXTable(this.c);
        this.b.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.b.setRowHeight(PosUIManager.getSize(30));
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.b));
        this.b.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    OutletExplorer.this.d();
                }
            }
        });
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.b));
        this.add((Component)this.a(), "South");
        this.add((Component)this.b(), "North");
    }

    private TransparentPanel a() {
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        JButton jButton = explorerButtonPanel.getEditButton();
        JButton jButton2 = explorerButtonPanel.getAddButton();
        JButton jButton3 = explorerButtonPanel.getDeleteButton();
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    OutletEntryForm outletEntryForm = new OutletEntryForm(new Outlet());
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)outletEntryForm);
                    beanEditorDialog.setSize(PosUIManager.getSize(500, 600));
                    beanEditorDialog.setTitle(AppProperties.getAppName());
                    beanEditorDialog.open();
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    Outlet outlet = (Outlet)outletEntryForm.getBean();
                    OutletExplorer.this.c.addRow(outlet);
                }
                catch (Throwable throwable) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutletExplorer.this.d();
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = OutletExplorer.this.b.getSelectedRow();
                    if (n < 0) {
                        return;
                    }
                    n = OutletExplorer.this.b.convertRowIndexToModel(n);
                    if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                        return;
                    }
                    Outlet outlet = (Outlet)OutletExplorer.this.c.getRow(n);
                    OutletDAO outletDAO = new OutletDAO();
                    outletDAO.delete(outlet);
                    OutletExplorer.this.c.removeRow(n);
                }
                catch (Throwable throwable) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton);
        transparentPanel.add(jButton3);
        return transparentPanel;
    }

    private JPanel b() {
        JPanel jPanel = new JPanel();
        return jPanel;
    }

    private void c() {
        String string = this.d.getText();
        Object object = this.e.getSelectedItem();
        Object var3_3 = null;
    }

    private void d() {
        try {
            int n = this.b.getSelectedRow();
            if (n < 0) {
                return;
            }
            n = this.b.convertRowIndexToModel(n);
            Outlet outlet = this.c.getRow(n);
            outlet = OutletDAO.getInstance().initialize(outlet);
            this.c.setRow(n, outlet);
            OutletEntryForm outletEntryForm = new OutletEntryForm(outlet);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)outletEntryForm);
            beanEditorDialog.setSize(PosUIManager.getSize(500, 600));
            beanEditorDialog.setTitle(AppProperties.getAppName());
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.b.repaint();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }
}

