/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.ModifierGroupForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;

public class PizzaModifierGroupExplorer
extends TransparentPanel {
    private List<ModifierGroup> a;
    private JXTable b;
    private ModifierGroupExplorerTableModel c;

    public PizzaModifierGroupExplorer() {
        ModifierGroupDAO modifierGroupDAO = new ModifierGroupDAO();
        modifierGroupDAO.updateModifierGroupBooleanPropertyValue(true);
        this.a = modifierGroupDAO.findPizzaModifierGroups();
        this.c = new ModifierGroupExplorerTableModel();
        this.b = new JXTable((TableModel)this.c);
        this.b.setSelectionMode(0);
        this.b.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.b.setRowHeight(PosUIManager.getSize(30));
        this.b.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    PizzaModifierGroupExplorer.this.b();
                }
            }
        });
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.b));
        TransparentPanel transparentPanel = new TransparentPanel();
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        JButton jButton = explorerButtonPanel.getEditButton();
        JButton jButton2 = explorerButtonPanel.getAddButton();
        JButton jButton3 = explorerButtonPanel.getDeleteButton();
        jButton.addActionListener(actionEvent -> this.b());
        jButton2.addActionListener(actionEvent -> this.a());
        jButton3.addActionListener(actionEvent -> this.c());
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton);
        transparentPanel.add(jButton3);
        this.add((Component)transparentPanel, "South");
    }

    private void a() {
        try {
            ModifierGroupForm modifierGroupForm = new ModifierGroupForm(new ModifierGroup(), (Boolean)true);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)modifierGroupForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            ModifierGroup modifierGroup = (ModifierGroup)modifierGroupForm.getBean();
            this.c.addModifierGroup(modifierGroup);
        }
        catch (Throwable throwable) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void b() {
        try {
            int n = this.b.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            n = this.b.convertRowIndexToModel(n);
            ModifierGroup modifierGroup = this.a.get(n);
            ModifierGroupForm modifierGroupForm = new ModifierGroupForm(modifierGroup, (Boolean)true);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)modifierGroupForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.b.repaint();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void c() {
        try {
            int n = this.b.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                return;
            }
            n = this.b.convertRowIndexToModel(n);
            if (ConfirmDeleteDialog.showMessage(this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            ModifierGroup modifierGroup = this.a.get(n);
            ModifierGroupDAO modifierGroupDAO = new ModifierGroupDAO();
            modifierGroupDAO.delete(modifierGroup);
            this.c.deleteModifierGroup(modifierGroup, n);
        }
        catch (PosException posException) {
            DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(posException.getMessage(), posException.getDetails());
            detailsInfoDialog.open();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    class ModifierGroupExplorerTableModel
    extends AbstractTableModel {
        String[] a = new String[]{POSConstants.NAME, POSConstants.TRANSLATED_NAME, POSConstants.MODIFIERS};

        ModifierGroupExplorerTableModel() {
        }

        @Override
        public int getRowCount() {
            if (PizzaModifierGroupExplorer.this.a == null) {
                return 0;
            }
            return PizzaModifierGroupExplorer.this.a.size();
        }

        @Override
        public int getColumnCount() {
            return this.a.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.a[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (PizzaModifierGroupExplorer.this.a == null) {
                return "";
            }
            ModifierGroup modifierGroup = (ModifierGroup)PizzaModifierGroupExplorer.this.a.get(n);
            switch (n2) {
                case 0: {
                    return modifierGroup.getName();
                }
                case 1: {
                    return modifierGroup.getTranslatedName();
                }
                case 2: {
                    return modifierGroup.getModifiers() == null ? "" : modifierGroup.getModifiers().toString();
                }
            }
            return null;
        }

        public void addModifierGroup(ModifierGroup modifierGroup) {
            int n = PizzaModifierGroupExplorer.this.a.size();
            PizzaModifierGroupExplorer.this.a.add(modifierGroup);
            this.fireTableRowsInserted(n, n);
        }

        public void deleteModifierGroup(ModifierGroup modifierGroup, int n) {
            PizzaModifierGroupExplorer.this.a.remove(modifierGroup);
            this.fireTableRowsDeleted(n, n);
        }
    }
}

