/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.explorer.BeanTableExplorerView;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.dao.PriceShiftDAO;
import com.floreantpos.model.dao.ShiftDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.model.PriceShiftForm;
import javax.swing.table.DefaultTableCellRenderer;

public class PriceShiftExplorer
extends BeanTableExplorerView<PriceShift> {
    public PriceShiftExplorer() {
        super(PriceShift.class);
    }

    @Override
    public DefaultTableCellRenderer geTableCellRenderer() {
        return new PosTableRenderer();
    }

    @Override
    public void initTableModel(BeanTableModel<PriceShift> beanTableModel) {
        beanTableModel.addColumn(POSConstants.NAME, PriceShift.PROP_NAME);
        beanTableModel.addColumn(POSConstants.DESCRIPTION, PriceShift.PROP_DESCRIPTION);
        beanTableModel.addColumn(Messages.getString("PriceShiftExplorer.0"), "dayOfWeekAsString");
        beanTableModel.addColumn(POSConstants.START_TIME, "formattedStartTime");
        beanTableModel.addColumn(POSConstants.END_TIME, "formattedEndTime");
        beanTableModel.addColumn(Messages.getString("PriceShiftExplorer.1"), PriceShift.PROP_PRIORITY);
        beanTableModel.addColumn(Messages.getString("PriceShiftExplorer.2"), "anyDay");
        beanTableModel.addColumn(Messages.getString("ACTIVE"), PriceShift.PROP_ENABLE);
    }

    @Override
    public void initData() {
        this.setRows(PriceShiftDAO.getInstance().findAll());
    }

    @Override
    public PriceShift createNew() {
        return this.openNewForm(new PriceShiftForm(), 520, 550);
    }

    @Override
    public PriceShift editSelectedRow(PriceShift priceShift) {
        PriceShiftDAO.getInstance().refresh(priceShift);
        this.checkDataValidation(priceShift.isDeleted(), priceShift.getName());
        return this.openEditForm(new PriceShiftForm(priceShift), 520, 550);
    }

    @Override
    public boolean delete(PriceShift priceShift) {
        PriceShiftDAO.getInstance().refresh(priceShift);
        this.checkDataValidation(priceShift.isDeleted(), priceShift.getName());
        ShiftDAO.getInstance().delete(priceShift);
        return true;
    }
}

