/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.extension.cronjob;

import com.floreantpos.PosLog;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.extension.cronjob.CronJobPlugin;
import com.floreantpos.licensing.LicenseCheckerJob;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.dao.CronJobDAO;
import java.util.List;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;

public class OroCronJobManager {
    private static OroCronJobManager a;
    private SchedulerFactory b;
    private Scheduler c;
    private boolean d;

    private OroCronJobManager() {
        try {
            this.b = new StdSchedulerFactory();
            this.c = this.b.getScheduler();
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    public static OroCronJobManager getInstance() {
        return a == null ? (a = new OroCronJobManager()) : a;
    }

    private CronTrigger a(CronJob cronJob, TriggerBuilder triggerBuilder) {
        if (triggerBuilder == null) {
            triggerBuilder = TriggerBuilder.newTrigger().withIdentity(cronJob.getId(), cronJob.getJobId());
        }
        if (cronJob.getFrequency().equalsIgnoreCase("DAILY")) {
            triggerBuilder = triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.dailyAtHourAndMinute((int)Integer.parseInt(cronJob.getExecutionTime().split(":")[0]), (int)Integer.parseInt(cronJob.getExecutionTime().split(":")[1])));
        } else if (cronJob.getFrequency().equalsIgnoreCase("WEEKLY")) {
            triggerBuilder = triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.weeklyOnDayAndHourAndMinute((int)1, (int)Integer.parseInt(cronJob.getExecutionTime().split(":")[0]), (int)Integer.parseInt(cronJob.getExecutionTime().split(":")[1])));
        } else if (cronJob.getFrequency().equalsIgnoreCase("MONTHLY")) {
            triggerBuilder = triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.monthlyOnDayAndHourAndMinute((int)1, (int)Integer.parseInt(cronJob.getExecutionTime().split(":")[0]), (int)Integer.parseInt(cronJob.getExecutionTime().split(":")[1])));
        } else if (cronJob.getFrequency().equalsIgnoreCase("EVERY")) {
            if (Integer.parseInt(cronJob.getExecutionTime().split(":")[0]) == -1) {
                triggerBuilder = triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)("0 0/" + Integer.parseInt(cronJob.getExecutionTime().split(":")[1]) + " * * * ?")));
            } else if (Integer.parseInt(cronJob.getExecutionTime().split(":")[1]) == -1) {
                triggerBuilder = triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)("0 0 0/" + Integer.parseInt(cronJob.getExecutionTime().split(":")[0]) + " * * ?")));
            }
        }
        return (CronTrigger)triggerBuilder.build();
    }

    public boolean scheduleJob(CronJob cronJob) {
        boolean bl = false;
        try {
            if (!this.d) {
                this.startScheduler();
            }
            if (cronJob.isActive().booleanValue() && cronJob.isExecutionTimeValid()) {
                this.c.scheduleJob(JobBuilder.newJob(cronJob.getClass()).withIdentity(cronJob.getId(), cronJob.getJobId()).build(), (Trigger)this.a(cronJob, (TriggerBuilder)null));
            }
            CronJobDAO.getInstance().saveOrUpdate(cronJob);
            bl = true;
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
        return bl;
    }

    public boolean reScheduleJob(CronJob cronJob) {
        boolean bl = false;
        try {
            if (!this.d) {
                this.startScheduler();
            }
            TriggerKey triggerKey = TriggerKey.triggerKey((String)cronJob.getId(), (String)cronJob.getJobId());
            if (cronJob.isActive().booleanValue()) {
                if (this.c.getTrigger(triggerKey) == null) {
                    this.c.scheduleJob(JobBuilder.newJob(cronJob.getClass()).withIdentity(cronJob.getId(), cronJob.getJobId()).build(), (Trigger)this.a(cronJob, (TriggerBuilder)null));
                } else {
                    this.c.rescheduleJob(triggerKey, (Trigger)this.a(cronJob, this.c.getTrigger(triggerKey).getTriggerBuilder().withIdentity(cronJob.getId(), cronJob.getJobId())));
                }
            } else if (this.c.getTrigger(triggerKey) != null) {
                this.c.deleteJob(JobKey.jobKey((String)cronJob.getId(), (String)cronJob.getJobId()));
            }
            CronJobDAO.getInstance().saveOrUpdate(cronJob);
            bl = true;
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
        return bl;
    }

    public boolean deleteJob(CronJob cronJob) {
        boolean bl = false;
        try {
            if (!this.d) {
                this.startScheduler();
            }
            this.c.deleteJob(JobKey.jobKey((String)cronJob.getId(), (String)cronJob.getJobId()));
            CronJobDAO.getInstance().delete(cronJob.getId());
            bl = true;
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
        return bl;
    }

    private void a() {
        try {
            List<CronJob> list = CronJobDAO.getInstance().findAllActive();
            List<FloreantPlugin> list2 = ExtensionManager.getPlugins(CronJobPlugin.class);
            if (list != null && list.size() > 0) {
                list.forEach(cronJob -> list2.forEach(floreantPlugin -> {
                    if (cronJob.getJobId().trim().equals(((CronJobPlugin)floreantPlugin).getId().trim())) {
                        try {
                            ((CronJobPlugin)floreantPlugin).setCronJob((CronJob)cronJob);
                            CronJob cronJob2 = ((CronJobPlugin)floreantPlugin).convertToActualCronJob();
                            if (cronJob2.isActive().booleanValue() && cronJob2.isExecutionTimeValid()) {
                                JobDetail jobDetail = JobBuilder.newJob(cronJob2.getClass()).withIdentity(cronJob2.getId(), cronJob2.getJobId()).build();
                                this.c.scheduleJob(jobDetail, (Trigger)this.a(cronJob2, (TriggerBuilder)null));
                            }
                        }
                        catch (Exception exception) {
                            PosLog.error(this.getClass(), exception);
                        }
                    }
                }));
                PosLog.info(OroCronJobManager.class, "All jobs are started successfully.");
            } else {
                PosLog.info(OroCronJobManager.class, "There have no scheduled job to start.");
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    public void startScheduler() {
        if (this.d) {
            return;
        }
        try {
            this.c.start();
            PosLog.info(OroCronJobManager.class, "Cron Job Manager Started Successfully.");
            this.a();
            this.d = true;
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    public void shutdownScheduler() {
        try {
            if (!this.d) {
                return;
            }
            this.c.shutdown();
            PosLog.info(OroCronJobManager.class, "Cron Job Manager Shutted Down Successfully.");
            this.d = false;
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    public void startLicenseCheckingJob() throws SchedulerException {
        JobBuilder jobBuilder = JobBuilder.newJob(LicenseCheckerJob.class);
        CronTrigger cronTrigger = this.a((CronJob)new LicenseCheckerJob(), (TriggerBuilder)null);
        StdSchedulerFactory stdSchedulerFactory = new StdSchedulerFactory();
        stdSchedulerFactory.getScheduler().scheduleJob(jobBuilder.build(), (Trigger)cronTrigger);
    }
}

